#include "global.h"
#include "battle_anim.h"
#include "constants/songs.h"
#include "rom_8077ABC.h"
#include "sound.h"
#include "trig.h"

extern s16 gBattleAnimArgs[8];
extern u8 gBattleAnimAttacker;
extern u8 gBattleAnimTarget;
extern u16 gBattleTypeFlags;
extern u8 gUnknown_0202F7D2;

void sub_80D5B0C(struct Sprite *sprite);
static void sub_80D5C5C(struct Sprite *);

// wisp_orb (animates the wisp orbs)
// Used in Will-O-Wisp

const union AnimCmd gSpriteAnim_83D9710[] =
{
    ANIMCMD_FRAME(0, 5),
    ANIMCMD_FRAME(4, 5),
    ANIMCMD_FRAME(8, 5),
    ANIMCMD_FRAME(12, 5),
    ANIMCMD_JUMP(0),
};

const union AnimCmd gSpriteAnim_83D9724[] =
{
    ANIMCMD_FRAME(16, 5),
    ANIMCMD_END,
};

const union AnimCmd gSpriteAnim_83D972C[] =
{
    ANIMCMD_FRAME(20, 5),
    ANIMCMD_END,
};

const union AnimCmd gSpriteAnim_83D9734[] =
{
    ANIMCMD_FRAME(20, 5),
    ANIMCMD_END,
};

const union AnimCmd *const gSpriteAnimTable_83D973C[] =
{
    gSpriteAnim_83D9710,
    gSpriteAnim_83D9724,
    gSpriteAnim_83D972C,
    gSpriteAnim_83D9734,
};

const struct SpriteTemplate gBattleAnimSpriteTemplate_83D974C =
{
    .tileTag = ANIM_TAG_WISP_ORB,
    .paletteTag = ANIM_TAG_WISP_ORB,
    .oam = &gOamData_837DF2C,
    .anims = gSpriteAnimTable_83D973C,
    .images = NULL,
    .affineAnims = gDummySpriteAffineAnimTable,
    .callback = sub_80D5B0C,
};

void sub_80D5B0C(struct Sprite *sprite)
{
    switch (sprite->data[0])
    {
    case 0:
        InitAnimSpritePos(sprite, 0);
        StartSpriteAnim(sprite, gBattleAnimArgs[2]);
        sprite->data[7] = gBattleAnimArgs[2];

        if (GetBattlerSide(gBattleAnimAttacker) != 0)
        {
            sprite->data[4] = 4;
        }
        else
        {
            sprite->data[4] = -4;
        }

        sprite->oam.priority = GetBattlerSpriteBGPriority(gBattleAnimTarget);
        sprite->data[0]++;
        break;
    case 1:
        sprite->data[1] += 192;
        if (GetBattlerSide(gBattleAnimAttacker) != 0)
        {
            sprite->y2 = -(sprite->data[1] >> 8);
        }
        else
        {
            sprite->y2 = sprite->data[1] >> 8;
        }

        sprite->x2 = Sin(sprite->data[2], sprite->data[4]);
        sprite->data[2] = (sprite->data[2] + 4) & 0xFF;

        if (++sprite->data[3] == 1)
        {
            sprite->data[3] = 0;
            sprite->data[0]++;
        }
        break;
    case 2:
        sprite->x2 = Sin(sprite->data[2], sprite->data[4]);
        sprite->data[2] = (sprite->data[2] + 4) & 0xFF;
        
        if (++sprite->data[3] == 31)
        {
            sprite->x += sprite->x2;
            sprite->y += sprite->y2;
            sprite->y2 = 0;
            sprite->x2 = 0;

            sprite->data[0] = 256;
            sprite->data[1] = sprite->x;
            sprite->data[2] = GetBattlerSpriteCoord(gBattleAnimTarget, 2);
            sprite->data[3] = sprite->y;
            sprite->data[4] = GetBattlerSpriteCoord(gBattleAnimTarget, 3);

            sub_8078BD4(sprite);
            sprite->callback = sub_80D5C5C;
        }
        break;
    }
}

static void sub_80D5C5C(struct Sprite *sprite)
{
    s16 initialData5;
    s16 newData5;

    if (!TranslateAnimLinear(sprite))
    {
        sprite->x2 += Sin(sprite->data[5], 16);
        initialData5 = sprite->data[5];
        sprite->data[5] = (sprite->data[5] + 4) & 0xFF;
        newData5 = sprite->data[5];

        if ((initialData5 == 0 || initialData5 > 196) && newData5 > 0 && sprite->data[7] == 0)
        {
            PlaySE12WithPanning(SE_M_FLAME_WHEEL, gUnknown_0202F7D2);
        }
    }
    else
    {
        DestroyAnimSprite(sprite);
    }
}
