#include "global.h"
#include "rom_8077ABC.h"
#include "trig.h"
#include "battle_anim.h"
#include "sound.h"

extern s16 gBattleAnimArgs[];
extern u8 gBattleAnimAttacker;
extern u8 gBattleAnimTarget;

void sub_80CE30C(struct Sprite* sprite);
static void sub_80CE354(struct Sprite* sprite);

// moon (shows a moon image.)
// Used in Moonlight.

const struct SpriteTemplate gBattleAnimSpriteTemplate_83D6FC8 =
{
    .tileTag = ANIM_TAG_MOON,
    .paletteTag = ANIM_TAG_MOON,
    .oam = &gOamData_837E05C,
    .anims = gDummySpriteAnimTable,
    .images = NULL,
    .affineAnims = gDummySpriteAffineAnimTable,
    .callback = sub_80CE30C,
};

void sub_80CE30C(struct Sprite* sprite)
{
    if (IsContest())
    {
        sprite->x = 0x30;
        sprite->y = 0x28;
    }
    else
    {
        sprite->x = gBattleAnimArgs[0];
        sprite->y = gBattleAnimArgs[1];
    }

    sprite->oam.shape = 0;
    sprite->oam.size = 3;
    sprite->data[0] = 0;
    sprite->callback = sub_80CE354;
}

static void sub_80CE354(struct Sprite* sprite)
{
    if (sprite->data[0])
        DestroyAnimSprite(sprite);
}
