#ifndef GUARD_POKENAV_H
#define GUARD_POKENAV_H

#include "main.h"
#include "region_map.h"
#include "mon_markings.h"

struct TrainersEyeStruct {
    /*0x0*/ u16 opponentId;
    /*0x2*/ u16 regionMapSectionId;
    /*0x4*/ u8 rematchTableIdx;
    /*0x5*/ u8 rematchNo;
};

struct UnkPokenavStruct_Sub1 {
    /*0x00*/ void (*unk0)(void);
    /*0x04*/ MainCallback callback;
    /*0x08*/ struct Pokeblock *pokeblock;
    /*0x0C*/ struct Pokemon *pokemon;
    /*0x10*/ u8 stringBuffer[0x40];
    /*0x50*/ u8 unk50;
    /*0x51*/ u8 unk51;
    /*0x52*/ u8 unk52;
    /*0x53*/ u8 unk53;
    /*0x54*/ u8 unk54;
    /*0x55*/ u8 unk55;
    /*0x56*/ u8 unk56;
    /*0x57*/ u8 unk57[5];
    /*0x5c*/ u8 unk5c[5];
    /*0x61*/ u8 unk61[5];
    /*0x66*/ s16 unk66[5];
};

struct UnkPokenavStruct_Sub3 {
    /*0x00*/s16 unk0;
};

struct UnkUsePokeblockSub {
    /*0x0*/ u8 unk0;
    /*0x1*/ u8 unk1;
    /*0x2*/ u16 partyIdx:5;
    /*0x2*/ u16 unk2_5:9;
    /*0x3*/ u16 unk3_14:1;
};

struct UnkPokenav11 {
    u16 unk0;
    u16 unk2;
};

struct UnknownStruct_Pokenav_8FF0 {
    /*0x000*/ u8 unk0[4][5];
    /*0x014*/ struct UnkPokenav11 unk14[4][5];
    /*0x064*/ struct UnkPokenav11 unk64[10][5];
    /*0x12C*/ struct UnkPokenav11 unk12C[5];
    /*0x140*/ u16 unk140[66][2];
    /*0x248*/ u16 unk248[66][2];
    /*0x350*/ u16 unk350;
    /*0x352*/ u16 unk352;
    /*0x354*/ u8 unk354;
    /*0x355*/ u8 unk355;
};

struct UnkPokenavStruct {
    /*0x0000*/ u16 unk0[6][0x40];
    /*0x0300*/ void (*unk300)(void);
    /*0x0304*/ u16 unk304;
    /*0x0306*/ u16 unk306;
    /*0x0306*/ int unk308;
    /*0x030C*/ s16 unk030C;
    /*0x030E*/ s8 unk30E;
    /*0x030F*/ u8 unk30F;
    /*0x0310*/ u8 filler0310[0x1];
    /*0x0311*/ u8 unk311;
    /*0x0312*/ u16 unk312;
    /*0x0314*/ u16 unk314[6];
    /*0x0320*/ struct Sprite *unk320[6][4];
    /*0x0380*/ struct SpriteSheet unk380;
    /*0x0388*/ u8 unk388[0x1400];
    /*0x1788*/ u8 unk1788[0xC00];
    /*0x2388*/ u8 unk2388[0x1800];
    /*0x3B88*/ struct Sprite *unk3B88[2];
    /*0x3B90*/ struct Sprite *unk3B90[2];
    /*0x3B98*/ u8 unk3B98[0x600];
    /*0x4198*/ u8 unk4198[0x600];
    /*0x4798*/ u8 unk4798[0x600];
    /*0x4D98*/ u8 unk4D98[0x600];
    /*0x5398*/ u8 unk5398[0xC00];
    /*0x5F98*/ u8 unk5F98[0x200];
    /*0x6198*/ u8 unk6198[0x200];
    /*0x6398*/ u8 unk6398[0x200];
    /*0x6598*/ u8 unk6598[0x200];
    /*0x6798*/ u8 unk6798[0x200];
    /*0x6998*/ u8 unk6998[0x200];
    /*0x6B98*/ u8 unk6B98[0x200];
    /*0x6D98*/ struct Sprite *unk6D98;
    /*0x6D9C*/ struct Sprite *unk6D9C;
    /*0x6DA0*/ u16 unk6DA0;
    /*0x6DA2*/ u16 unk6DA2;
    /*0x6DA4*/ u16 taskId6DA4;
    /*0x6DA6*/ u8 filler6DA6[0x5];
    /*0x6DAB*/ u8 unk6DAB;
    /*0x6DAC*/ u8 unk6DAC;
    /*0x6DAD*/ s8 unk6DAD;
    /*0x6DAE*/ s8 unk6DAE;
    /*0x6DAF*/ u8 filler6DAF[0x3];
    /*0x6DB2*/ u8 unk6DB2[0x2A];
    /*0x6DDC*/ s8 unk6DDC;
    /*0x6DDD*/ u8 filler6DDD[0x13];
    /*0x6DF0*/ s8 unk6DF0;
    /*0x6DF1*/ u8 filler6DF1[0x0B];
    /*0x6DFC*/ u8 unk6DFC;
    /*0x6DFD*/ u8 filler6DFD[0x17];
    /*0x6E14*/ u8 unk6E14;
    /*0x6E15*/ u8 unk6E15;
    /*0x6E16*/ u8 unk6E16;
    /*0x6E17*/ u8 unk6E17;
    /*0x6E18*/ struct RegionMap regionMap;
    /*0x7698*/ u16 unk7698;
    /*0x769A*/ u16 unk769A;
    /*0x769C*/ u8 unk769C;
    /*0x769D*/ u8 unk769D;
    /*0x769E*/ u8 unk769E;
    /*0x769F*/ u8 filler769F[0xB];
    /*0x76AA*/ u8 unk76AA;
    /*0x76AC*/ struct Sprite *unk76AC;
    /*0x76B0*/ struct PokemonMarkMenu unk76B0;
    /*0x8764*/ u16 unk8764;
    /*0x8766*/ s16 unk8766;
    /*0x8768*/ struct Sprite *unk8768;
    /*0x876C*/ s16 unk876C;
    /*0x876E*/ s16 unk876E;
    /*0x8770*/ s16 unk8770;
    /*0x8772*/ s16 unk8772;
    /*0x8774*/ s16 unk8774;
    /*0x8776*/ s16 unk8776;
    /*0x8778*/ u16 unk8778;
    /*0x877A*/ s16 unk877A;
    /*0x877C*/ s16 unk877C;
    /*0x877E*/ u16 unk877E;
    /*0x8780*/ u16 unk8780;
    /*0x8782*/ u16 unk8782;
    /*0x8784*/ u16 unk8784;
    /*0x8786*/ u16 unk8786;
    /*0x8788*/ u8 unk8788[0x40];
    /*0x87C8*/ u8 unk87C8;
    /*0x87C9*/ u8 unk87C9;
    /*0x87CA*/ u8 unk87CA;
    /*0x87CB*/ u8 unk87CB;
    /*0x87CC*/ struct Sprite *unk87CC;
    /*0x87D0*/ struct Sprite *unk87D0[2];
    /*0x87D8*/ u8 unk87D8;
    /*0x87DA*/ s16 unk87DA;
    /*0x87DC*/ s16 unk87DC;
    /*0x87DE*/ u8 unk87DE;
    /*0x87E0*/ bool8 (*unk87E0)(void);
    /*0x87E4*/ struct Sprite *unk87E4[7];
    /*0x8800*/ struct Sprite *unk8800[10];
    /*0x8828*/ u8 unk8828;
    /*0x8829*/ u8 unk8829[3][64];
    /*0x88E9*/ u8 unk88E9[3][24];
    /*0x8931*/ u8 unk8931[3];
    /*0x8934*/ u8 unk8934[3];
    /*0x8937*/ u8 unk8937[5];
    /*0x893C*/ struct UnkUsePokeblockSub unk893c[0x1AA];
    /*0x8FE4*/ u16 unk8FE4;
    /*0x8FE6*/ u8 unk8FE6;
    /*0x8FE7*/ u8 unk8FE7;
    /*0x8FE8*/ s8 unk8FE8;
    /*0x8fe9*/ s8 unk8fe9;
    /*0x8fea*/ s8 unk8FEA;
    /*0x8feb*/ s8 unk8FEB;
    /*0x8fec*/ s8 unk8FEC;
    /*0x8fee*/ u16 unk8FEE;

    // UnknownStruct_Pokenav_8FF0
    /*0x8ff0*/ u8 unk8ff0[4][5];
    /*0x9004*/ struct UnkPokenav11 unk9004[4][5];
    /*0x9054*/ struct UnkPokenav11 unk9054[10][5];
    /*0x911C*/ struct UnkPokenav11 unk911C[5];
    /*0x9130*/ u16 unk9130[66][2];
    /*0x9238*/ u16 unk9238[66][2];
    /*0x9340*/ u16 unk9340;
    /*0x9342*/ u16 unk9342;
    /*0x9344*/ u8 unk9344;
    /*0x9345*/ u8 unk9345;

    /*0x9348*/ struct Sprite *unk9348;
    /*0x934C*/ u16 unk934C[0x280];
    /*0x984C*/ u8 unk984C[0xC][0x100];
    /*0xA44C*/ u8 unkA44C[0xC][0x200];
    /*0xBC4C*/ u8 unkBC4C[0x42];
    /*0xBC8E*/ u8 unkBC8E;
    /*0xBC8F*/ u8 unkBC8F;
    /*0xBC90*/ u8 unkBC90;
    /*0xBC91*/ u8 unkBC91;
    /*0xBC92*/ u8 unkBC92;
    /*0xBC93*/ u8 unkBC93;
    /*0xBC94*/ u8 unkBC94;
    /*0xBC95*/ u8 unkBC95;
    /*0xBC96*/ u8 unkBC96[0x4];
    /*0xBC9A*/ u8 unkBC9A;
    /*0xBC9B*/ u8 unkBC9B;
    /*0xBC9C*/ u8 unkBC9C[22][200];
    /*0xCDCC*/ const u8 *unkCDCC[16][2];
    /*0xCE4C*/ u16 unkCE4C;
    /*0xCE4E*/ u16 unkCE4E;
    /*0xCE50*/ u16 unkCE50;
    /*0xCE52*/ u16 palettesCE52[30];
    /*0xCE8E*/ u16 palettesCE8E[0x21];
    /*0xCED0*/ struct Sprite *unkCED0;
    /*0xCED4*/ struct Sprite *unkCED4[5];
    /*0xCEE8*/ struct TrainersEyeStruct trainersEye[69];
    /*0xD110*/ const u8 *trainerEyeDescriptionLines[4];
    /*0xD120*/ u8 fillerD114[0x18];
    /*0xD138*/ u8 unkD138[0x20];
    /*0xD158*/ u16 unkD158;
    /*0xD15A*/ s16 unkD15A;
    /*0xD15C*/ u16 unkD15C;
    /*0xD15E*/ u8 unkD15E;
    /*0xD15F*/ u8 unkD15F;
    /*0xD160*/ u16 unkD160;
    /*0xD162*/ u8 unkD162;
    /*0xD164*/ struct UnkPokenavStruct_Sub1 unkD164;
    /*0xD1D4*/ u8 fillerD1D6[0x2];
    /*0xD1D6*/ u16 unkD1D6[3];
    /*0xD1DC*/ u16 unkD1DC;
    /*0xD1DE*/ u16 unkD1DE;
    /*0xD1E0*/ u8 *unkD1E0;
    /*0xD1E4*/ u8 unkD1E4[3][0x2000];
    /*0x131E4*/ u8 unk131E4[0x1000];
};

extern struct UnkPokenavStruct *const gPokenavStructPtr;

bool8 sub_80F170C(void);
bool8 sub_80F1778(void);
void sub_80F1934(void);
void sub_80F2C80(u8);
void sub_80F2688(void);
bool8 sub_80F26BC(void);
bool8 sub_80F2CBC(u8);
void sub_80F2E18(u8);
void sub_80F33A8(void);
void sub_80F3C94(void);
void sub_80F3D00(void);
void sub_80F4BD0(void);
void sub_80F556C(struct UnkPokenav11*);
void sub_80F55AC(u8 *a0, struct UnkPokenav11 a1[]);
void sub_80F567C(u8 *, struct UnkPokenav11 *);
void sub_80F5B38(void);
bool8 sub_80F5B50(void);
void sub_80F5CDC(u8);
void sub_80EBA5C(void);
void sub_80F5060(bool8);
void move_anim_execute(void);
bool8 gpu_sync_bg_show(void);
void sub_80F5550(struct UnkPokenav11*, struct UnkPokenav11*);
bool8 sub_80F555C(void);
void sub_80F7224(u8);
void sub_80F5BDC(void);
void sub_80F2F7C(u8 arg0);

bool8 sub_80F0D5C(void);
void LoadTrainerEyesDescriptionLines(void);
void sub_80F0FFC(u8);
void sub_80F105C(void);
void sub_80F43D4(u8 *);
void sub_80F063C(s16 arg0);
void sub_80F6074(s16 arg0);
void sub_80F6208(void);
bool8 sub_80F6250();

void sub_80EBCA8();
void sub_80EEE20();
bool8 sub_80EEE54();
void sub_80EEE08();
void sub_80EED2C(u8);
void sub_80EC268();
void sub_80EED1C();
void sub_80EE9C0(u8, u8, u8);
bool8 sub_80EEA0C();
bool8 sub_80EEC10();
void sub_80EED9C();
void sub_80EDB88();
void sub_80EC4A0();
void sub_80EC81C();
void sub_80EE96C();
void sub_80EE3D8();
bool8 sub_80EEF34();
void sub_80EED0C();
void sub_80EC67C();
void sub_80EC86C();
bool8 sub_80EEC90();
void sub_80ED620();
void sub_80EC960();
void sub_80ED01C();
void sub_80ECC08();
void sub_80ED31C();
void sub_80ED4D8();
void sub_80ED858();
void sub_80EDDBC();
void sub_80EDE70();
void sub_80EDEE4();
void sub_80EE06C();
void sub_80EE294();
void sub_80EE58C();
void sub_80EE658();
void sub_80EE8F4();
void sub_80EEDC4();
void ShowMapNamePopUpWindow(void);
void sub_80F0954(u16, u16, u16);
bool8 sub_80F098C(void);
u8 *sub_80F445C(u8*, u16);
void sub_80F081C(u8);
bool8 sub_80F0944(void);
u8 *sub_80F4428(u8*, u16, u8);
void sub_80F700C(u8*, u16);
void sub_80F0B24(void);
bool8 sub_80F0B44(void);
void sub_80F0C28(void);
bool8 sub_80F0C48(void);
void LoadTrainerEyesDescriptionLines(void);
bool8 sub_80F0D5C(void);
void sub_80F0EC0(void);
bool8 sub_80F0EF4(void);
void sub_80F0F64(void);
void sub_80F0FA0(void);
bool8 sub_80F0FEC(void);
bool8 sub_80F0718(void);
void sub_80F0FFC(u8);
void sub_80F19DC(u8*);
bool8 sub_80F1080(void);
void sub_80F1614(void);
void DrawMonRibbonIcons(void);
void sub_80F13FC(void);
void sub_80F1438(void);
void sub_80F1494(void);
bool8 sub_80F162C(u8);
void sub_80F01E0(u16);
void sub_80F19FC(void);
void sub_80F1A74(void);
void sub_80F1A80(void);
void sub_80F1A90(void);
bool8 sub_80F1AC4(void);
void sub_80F1B8C(u8);
bool8 sub_80F1BC8(u8);
void sub_80F2458(u8);
void sub_80F2514(u8);
void sub_80F1DF0(void);
void sub_80F2218(struct Sprite *sprite);
bool8 sub_80F1E50(void);
bool8 sub_80F22F8(void);
void sub_80F2108(void);
bool8 sub_80F1E6C(void);
void sub_80F1E84(void);
void sub_80F2148(void);
void sub_80F2240(struct Sprite *sprite);
bool8 sub_80F1F10(void);
bool8 sub_80F2360(void);
void sub_80F2170(void);
bool8 sub_80F23C8(void);
void sub_80F21F8(void);
void sub_80F1FF0(void);
void sub_80F208C(void);
void sub_80F22B0(struct Sprite *sprite);
void sub_80F240C(struct Sprite *sprite);
void sub_80F2598(void);
void sub_80F2620(void);
bool8 sub_80F26BC(void);
void sub_80F2C58(struct Sprite *sprite);
void sub_80F2D04(u8);
void sub_80F2D6C(u8);
void sub_80F2DD8(void);
void sub_80F2DF4(void);
void sub_80F2FEC(struct Sprite *sprite);
void sub_80F2FB0(void);
void sub_80F3008(u8);
void sub_80F3130(void);
void sub_80F3264(void);
void sub_80F3294(u8);
void sub_80F35B4(void);
void sub_80F363C(struct Sprite *sprite);
void SetMonMarkings(u16, u16, u8);
void sub_80F36F0(void);
bool8 sub_80F3724(void);
void sub_80F379C(void);
bool8 sub_80F37D0(void);
void sub_80F38B8(void);
bool8 sub_80F38EC(void);
void sub_80F3970(void);
bool8 sub_80F39A4(void);
void sub_80F3B00(void);
bool8 sub_80F3B58(void);
void sub_80F3B94(void);
bool8 sub_80F3BD4(void);
void sub_80F3C2C(void);
void sub_80F3F20(u8, u8);
void sub_80F3FAC(void);
void sub_80F3FF0(void);
bool8 sub_80F4024(void);
void sub_80F42C4(u8*);
void sub_80F4394(void);
u8 *sub_80F6514(u8*, u16, u8);
u8 *sub_80F443C(u8 *, u16);
void sub_80F55AC(u8*, struct UnkPokenav11 *);
void sub_80F4CF0(void);
void sub_80F4D44(void);
bool8 sub_80F4D88(void);
void sub_80F53EC(struct UnkPokenav11*, struct UnkPokenav11*);
bool8 sub_80F5504(void);
bool8 sub_80F5264(void);
bool8 sub_80F52F8(void);
bool8 sub_80F5364(void);

void sub_80F0900(void);
void sub_80F01A4(void);
void sub_80EFD3C(void);
void sub_8095C8C();
void sub_80EFDA0(void);
void sub_80EFD74(void);
bool8 sub_80EFC64(void);
void sub_80EFC3C(void);
void sub_80EF624(const u16 *, const u16 *, u8, u8, u16 *);
void sub_80EF7D4(void);
void sub_80EF54C(u8);
void sub_80EF58C(u8);
void sub_80F6FFC();
void sub_80F6FB8(bool8);
void sub_80F6DB8();
bool8 sub_80F6E9C();
bool8 sub_80F6ED4();
bool8 sub_80F70FC();
void sub_80F708C(s8);
void sub_80F6F10();
void sub_80F15A8(void);
void sub_80F6A4C(s8);
bool8 sub_80F6AF0();
u8 sub_80F68E8();
void sub_80F66E0();
void sub_80F638C();
bool8 sub_80F63D0();
void sub_80EFF34();
bool8 sub_80EFF68();
void sub_80F6134();
u8 sub_80F5DD4();
void sub_80F0264(u8);
bool8 sub_80F02A0();
void sub_80EF9F8(void);
bool8 sub_80EFBDC(bool8);
void sub_80EFBB0(void);
void sub_80EEFBC(u8);
void sub_80EF814(void);
void sub_80EF840(void);
bool8 sub_80EF874(void);
bool8 sub_80F6250();
void sub_80F6C20();
void sub_80EF248(u8);
bool8 sub_80EF284(u8);
void sub_80EF428(u8, u8);
bool8 sub_80EEF78();
void sub_80EBC10();
void sub_80EBDBC(void (*func)(void));
void sub_80EBBE8();
void sub_80EBDD8();
void sub_80EBD90();
void sub_80EBD18();
void sub_80FB260();
void sub_80EFE7C(void);
void sub_80F5BF0();
void sub_80F6F64();

#endif // GUARD_POKENAV_H
