#ifndef GUARD_BATTLE_TOWER_H
#define GUARD_BATTLE_TOWER_H

#define BATTLE_TOWER_EREADER_TRAINER_ID 200
#define BATTLE_TOWER_RECORD_MIXING_TRAINER_BASE_ID 100

enum
{
    F_EV_SPREAD_HP         = 1 << 0,
    F_EV_SPREAD_ATTACK     = 1 << 1,
    F_EV_SPREAD_DEFENSE    = 1 << 2,
    F_EV_SPREAD_SPEED      = 1 << 3,
    F_EV_SPREAD_SP_ATTACK  = 1 << 4,
    F_EV_SPREAD_SP_DEFENSE = 1 << 5,
};

enum
{
    BATTLE_TOWER_ITEM_NONE,
    BATTLE_TOWER_ITEM_KINGS_ROCK,
    BATTLE_TOWER_ITEM_SITRUS_BERRY,
    BATTLE_TOWER_ITEM_ORAN_BERRY,
    BATTLE_TOWER_ITEM_CHESTO_BERRY,
    BATTLE_TOWER_ITEM_HARD_STONE,
    BATTLE_TOWER_ITEM_FOCUS_BAND,
    BATTLE_TOWER_ITEM_PERSIM_BERRY,
    BATTLE_TOWER_ITEM_MIRACLE_SEED,
    BATTLE_TOWER_ITEM_BERRY_JUICE,
    BATTLE_TOWER_ITEM_MACHO_BRACE,
    BATTLE_TOWER_ITEM_SILVER_POWDER,
    BATTLE_TOWER_ITEM_CHERI_BERRY,
    BATTLE_TOWER_ITEM_BLACK_GLASSES,
    BATTLE_TOWER_ITEM_BLACK_BELT,
    BATTLE_TOWER_ITEM_SOUL_DEW,
    BATTLE_TOWER_ITEM_CHOICE_BAND,
    BATTLE_TOWER_ITEM_MAGNET,
    BATTLE_TOWER_ITEM_SILK_SCARF,
    BATTLE_TOWER_ITEM_WHITE_HERB,
    BATTLE_TOWER_ITEM_DEEP_SEA_SCALE,
    BATTLE_TOWER_ITEM_DEEP_SEA_TOOTH,
    BATTLE_TOWER_ITEM_MYSTIC_WATER,
    BATTLE_TOWER_ITEM_SHARP_BEAK,
    BATTLE_TOWER_ITEM_QUICK_CLAW,
    BATTLE_TOWER_ITEM_LEFTOVERS,
    BATTLE_TOWER_ITEM_RAWST_BERRY,
    BATTLE_TOWER_ITEM_LIGHT_BALL,
    BATTLE_TOWER_ITEM_POISON_BARB,
    BATTLE_TOWER_ITEM_NEVER_MELT_ICE,
    BATTLE_TOWER_ITEM_ASPEAR_BERRY,
    BATTLE_TOWER_ITEM_SPELL_TAG,
    BATTLE_TOWER_ITEM_BRIGHT_POWDER,
    BATTLE_TOWER_ITEM_LEPPA_BERRY,
    BATTLE_TOWER_ITEM_SCOPE_LENS,
    BATTLE_TOWER_ITEM_TWISTED_SPOON,
    BATTLE_TOWER_ITEM_METAL_COAT,
    BATTLE_TOWER_ITEM_MENTAL_HERB,
    BATTLE_TOWER_ITEM_CHARCOAL,
    BATTLE_TOWER_ITEM_PECHA_BERRY,
    BATTLE_TOWER_ITEM_SOFT_SAND,
    BATTLE_TOWER_ITEM_LUM_BERRY,
    BATTLE_TOWER_ITEM_DRAGON_SCALE,
    BATTLE_TOWER_ITEM_DRAGON_FANG,
    BATTLE_TOWER_ITEM_IAPAPA_BERRY,
    BATTLE_TOWER_ITEM_WIKI_BERRY,
    BATTLE_TOWER_ITEM_SEA_INCENSE,
    BATTLE_TOWER_ITEM_SHELL_BELL,
    BATTLE_TOWER_ITEM_SALAC_BERRY,
    BATTLE_TOWER_ITEM_LANSAT_BERRY,
    BATTLE_TOWER_ITEM_APICOT_BERRY,
    BATTLE_TOWER_ITEM_STARF_BERRY,
    BATTLE_TOWER_ITEM_LIECHI_BERRY,
    BATTLE_TOWER_ITEM_STICK,
    BATTLE_TOWER_ITEM_LAX_INCENSE,
    BATTLE_TOWER_ITEM_AGUAV_BERRY,
    BATTLE_TOWER_ITEM_FIGY_BERRY,
    BATTLE_TOWER_ITEM_THICK_CLUB,
    BATTLE_TOWER_ITEM_MAGO_BERRY,
    BATTLE_TOWER_ITEM_METAL_POWDER,
    BATTLE_TOWER_ITEM_PETAYA_BERRY,
    BATTLE_TOWER_ITEM_LUCKY_PUNCH,
    BATTLE_TOWER_ITEM_GANLON_BERRY,
};

struct BattleTowerPokemon
{
    /*0x00*/u16 species;
    /*0x02*/u8 heldItem; // entry in sBattleTowerHeldItems
    /*0x03*/u8 teamFlags;
    /*0x04*/u16 moves[4];
    /*0x0C*/u8 evSpread;
    /*0x0D*/u8 nature;
};

u16 GetCurrentBattleTowerWinStreak(u8);
void sub_8134AC0(struct BattleTowerRecord *);
u16 sub_8135D3C(u8);
void SetEReaderTrainerName(u8*);
u8 GetEReaderTrainerPicIndex(void);
u8 GetEReaderTrainerClassNameIndex(void);
void ValidateEReaderTrainer(void);
void SetEReaderTrainerChecksum(struct BattleTowerEReaderTrainer *ereaderTrainer);

#endif // GUARD_BATTLE_TOWER_H
