INCLUDE "constants.asm"


SECTION "home/audio.asm", ROM0

DisableAudio::
	push hl
	push de
	push bc
	push af
	ldh a, [hROMBank]
	push af
	ld a, BANK(_DisableAudio)
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	call _DisableAudio
	pop af
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	pop af
	pop bc
	pop de
	pop hl
	ret

UpdateSound::
	push hl
	push de
	push bc
	push af
	ldh a, [hROMBank]
	push af
	ld a, BANK(_UpdateSound)
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	call _UpdateSound
	pop af
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	pop af
	pop bc
	pop de
	pop hl
	ret

_LoadMusicByte::
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	ld a, [de]
	push af
	ld a, BANK(_UpdateSound)
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	pop af
	ret

PlayMusic::
	push hl
	push de
	push bc
	push af
	ldh a, [hROMBank]
	push af
	ld a, BANK(_PlayMusic)
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	call _PlayMusic
	pop af
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	pop af
	pop bc
	pop de
	pop hl
	ret

PlayCryHeader::
	push hl
	push de
	push bc
	push af
	ldh a, [hROMBank]
	push af

	ld a, BANK(PokemonCries)
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	ld hl, PokemonCries
rept 6
	add hl, de
endr
	ld e, [hl]
	inc hl
	ld d, [hl]
	inc hl
	ld a, [hli]
	ld [wCryPitch], a
	ld a, [hli]
	ld [wCryPitch + 1], a
	ld a, [hli]
	ld [wCryLength], a
	ld a, [hl]
	ld [wCryLength + 1], a

	ld a, BANK(_PlayCryHeader)
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	call _PlayCryHeader

	pop af
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	pop af
	pop bc
	pop de
	pop hl
	ret

PlaySFX::
	push hl
	push de
	push bc
	push af
	ldh a, [hROMBank]
	push af
	ld a, BANK(_PlaySFX)
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	call _PlaySFX
	pop af
	ld [MBC3RomBank], a ; Unsafe
	ldh [hROMBank], a
	pop af
	pop bc
	pop de
	pop hl
	ret

WaitPlaySFX::
	call WaitSFX
	call PlaySFX
	ret

WaitSFX::
	push hl
.loop
	ld hl, wChannel5Flags1
	bit 0, [hl]
	jr nz, .loop
	ld hl, wChannel6Flags1
	bit 0, [hl]
	jr nz, .loop
	ld hl, wChannel7Flags1
	bit 0, [hl]
	jr nz, .loop
	ld hl, wChannel8Flags1
	bit 0, [hl]
	jr nz, .loop
	pop hl
	ret

MaxVolume::
	ld a, $77
	ld [wVolume], a
	ret

LowVolume::
	ld a, $33
	ld [wVolume], a
	ret

VolumeOff::
	xor a
	ld [wVolume], a
	ret

UpdateSoundNTimes::
.loop
	and a
	ret z
	dec a
	call UpdateSound
	jr .loop

FadeToMapMusic::
	push hl
	push de
	push bc
	push af
	call GetMapMusic
	ld a, [wMapMusic]
	cp e
	jr z, .jump
	ld a, 8
	ld [wMusicFade], a
	ld a, e
	ld [wMusicFadeID], a
	ld a, d
	ld [wMusicFadeID+1], a
	ld a, e
	ld [wMapMusic], a
.jump
	pop af
	pop bc
	pop de
	pop hl
	ret

PlayMapMusic::
	push hl
	push de
	push bc
	push af
	call GetMapMusic
	ld a, [wMapMusic]
	cp e
	jr z, .jump
	push de
	ld de, MUSIC_NONE
	call PlayMusic
	call DelayFrame
	pop de
	ld a, e
	ld [wMapMusic], a
	call PlayMusic
.jump
	pop af
	pop bc
	pop de
	pop hl
	ret

SpecialMapMusic::
	ld a, [wPlayerState]
	and a
	jr z, .normal
	cp $02
	jr z, .state2
	ld de, MUSIC_BICYCLE
	scf
	ret

.state2
	ld de, MUSIC_NONE
	scf
	ret

.normal
	and a
	ret

GetMapMusic::
	call SpecialMapMusic
	ret c
	ld a, [wMapPermissions]
	cp TOWN
	jr z, .not_route
	cp INDOOR
	jr z, .not_route
	ld de, MUSIC_ROUTE_1
	ret

.not_route
	ld de, MUSIC_VIRIDIAN_CITY
	ret
