INCLUDE "constants.asm"

SECTION "data/pokemon/base_stats.asm", ROMX

MACRO tmhm
; used in data/pokemon/base_stats/*.asm
DEF tms1 = 0 ; TM01-TM24 (24)
DEF tms2 = 0 ; TM25-TM48 (24)
DEF tms3 = 0 ; TM49-TM50 + HM01-HM07 (9)
rept _NARG
	if 0 < \1 && \1 <= (NUM_TM_HM + 7) / 8 * 8
	if \1 < 24 + 1
DEF tms1 = tms1 | (1 << ((\1) - 1))
	elif \1 < 48 + 1
DEF tms2 = tms2 | (1 << ((\1) - 1 - 24))
	else
DEF tms3 = tms3 | (1 << ((\1) - 1 - 48))
	endc
	else
		fail "\1 is not a TM/HM number"
	endc
	shift
endr
rept 3 ; TM01-TM24 (24/24)
	db tms1 & $ff
DEF tms1 = tms1 >> 8
endr
rept 3 ; TM25-TM48 (24/24)
	db tms2 & $ff
DEF tms2 = tms2 >> 8
endr
rept 2 ; TM49-TM50 + HM01-HM07 (9/16)
	db tms3 & $ff
DEF tms3 = tms3 >> 8
endr
ENDM

BaseData::
INCLUDE "data/pokemon/base_stats/bulbasaur.inc"
.FirstEntryEnd::
INCLUDE "data/pokemon/base_stats/ivysaur.inc"
INCLUDE "data/pokemon/base_stats/venusaur.inc"
INCLUDE "data/pokemon/base_stats/charmander.inc"
INCLUDE "data/pokemon/base_stats/charmeleon.inc"
INCLUDE "data/pokemon/base_stats/charizard.inc"
INCLUDE "data/pokemon/base_stats/squirtle.inc"
INCLUDE "data/pokemon/base_stats/wartortle.inc"
INCLUDE "data/pokemon/base_stats/blastoise.inc"
INCLUDE "data/pokemon/base_stats/caterpie.inc"
INCLUDE "data/pokemon/base_stats/metapod.inc"
INCLUDE "data/pokemon/base_stats/butterfree.inc"
INCLUDE "data/pokemon/base_stats/weedle.inc"
INCLUDE "data/pokemon/base_stats/kakuna.inc"
INCLUDE "data/pokemon/base_stats/beedrill.inc"
INCLUDE "data/pokemon/base_stats/pidgey.inc"
INCLUDE "data/pokemon/base_stats/pidgeotto.inc"
INCLUDE "data/pokemon/base_stats/pidgeot.inc"
INCLUDE "data/pokemon/base_stats/rattata.inc"
INCLUDE "data/pokemon/base_stats/raticate.inc"
INCLUDE "data/pokemon/base_stats/spearow.inc"
INCLUDE "data/pokemon/base_stats/fearow.inc"
INCLUDE "data/pokemon/base_stats/ekans.inc"
INCLUDE "data/pokemon/base_stats/arbok.inc"
INCLUDE "data/pokemon/base_stats/pikachu.inc"
INCLUDE "data/pokemon/base_stats/raichu.inc"
INCLUDE "data/pokemon/base_stats/sandshrew.inc"
INCLUDE "data/pokemon/base_stats/sandslash.inc"
INCLUDE "data/pokemon/base_stats/nidoran_f.inc"
INCLUDE "data/pokemon/base_stats/nidorina.inc"
INCLUDE "data/pokemon/base_stats/nidoqueen.inc"
INCLUDE "data/pokemon/base_stats/nidoran_m.inc"
INCLUDE "data/pokemon/base_stats/nidorino.inc"
INCLUDE "data/pokemon/base_stats/nidoking.inc"
INCLUDE "data/pokemon/base_stats/clefairy.inc"
INCLUDE "data/pokemon/base_stats/clefable.inc"
INCLUDE "data/pokemon/base_stats/vulpix.inc"
INCLUDE "data/pokemon/base_stats/ninetales.inc"
INCLUDE "data/pokemon/base_stats/jigglypuff.inc"
INCLUDE "data/pokemon/base_stats/wigglytuff.inc"
INCLUDE "data/pokemon/base_stats/zubat.inc"
INCLUDE "data/pokemon/base_stats/golbat.inc"
INCLUDE "data/pokemon/base_stats/oddish.inc"
INCLUDE "data/pokemon/base_stats/gloom.inc"
INCLUDE "data/pokemon/base_stats/vileplume.inc"
INCLUDE "data/pokemon/base_stats/paras.inc"
INCLUDE "data/pokemon/base_stats/parasect.inc"
INCLUDE "data/pokemon/base_stats/venonat.inc"
INCLUDE "data/pokemon/base_stats/venomoth.inc"
INCLUDE "data/pokemon/base_stats/diglett.inc"
INCLUDE "data/pokemon/base_stats/dugtrio.inc"
INCLUDE "data/pokemon/base_stats/meowth.inc"
INCLUDE "data/pokemon/base_stats/persian.inc"
INCLUDE "data/pokemon/base_stats/psyduck.inc"
INCLUDE "data/pokemon/base_stats/golduck.inc"
INCLUDE "data/pokemon/base_stats/mankey.inc"
INCLUDE "data/pokemon/base_stats/primeape.inc"
INCLUDE "data/pokemon/base_stats/growlithe.inc"
INCLUDE "data/pokemon/base_stats/arcanine.inc"
INCLUDE "data/pokemon/base_stats/poliwag.inc"
INCLUDE "data/pokemon/base_stats/poliwhirl.inc"
INCLUDE "data/pokemon/base_stats/poliwrath.inc"
INCLUDE "data/pokemon/base_stats/abra.inc"
INCLUDE "data/pokemon/base_stats/kadabra.inc"
INCLUDE "data/pokemon/base_stats/alakazam.inc"
INCLUDE "data/pokemon/base_stats/machop.inc"
INCLUDE "data/pokemon/base_stats/machoke.inc"
INCLUDE "data/pokemon/base_stats/machamp.inc"
INCLUDE "data/pokemon/base_stats/bellsprout.inc"
INCLUDE "data/pokemon/base_stats/weepinbell.inc"
INCLUDE "data/pokemon/base_stats/victreebel.inc"
INCLUDE "data/pokemon/base_stats/tentacool.inc"
INCLUDE "data/pokemon/base_stats/tentacruel.inc"
INCLUDE "data/pokemon/base_stats/geodude.inc"
INCLUDE "data/pokemon/base_stats/graveler.inc"
INCLUDE "data/pokemon/base_stats/golem.inc"
INCLUDE "data/pokemon/base_stats/ponyta.inc"
INCLUDE "data/pokemon/base_stats/rapidash.inc"
INCLUDE "data/pokemon/base_stats/slowpoke.inc"
INCLUDE "data/pokemon/base_stats/slowbro.inc"
INCLUDE "data/pokemon/base_stats/magnemite.inc"
INCLUDE "data/pokemon/base_stats/magneton.inc"
INCLUDE "data/pokemon/base_stats/farfetchd.inc"
INCLUDE "data/pokemon/base_stats/doduo.inc"
INCLUDE "data/pokemon/base_stats/dodrio.inc"
INCLUDE "data/pokemon/base_stats/seel.inc"
INCLUDE "data/pokemon/base_stats/dewgong.inc"
INCLUDE "data/pokemon/base_stats/grimer.inc"
INCLUDE "data/pokemon/base_stats/muk.inc"
INCLUDE "data/pokemon/base_stats/shellder.inc"
INCLUDE "data/pokemon/base_stats/cloyster.inc"
INCLUDE "data/pokemon/base_stats/gastly.inc"
INCLUDE "data/pokemon/base_stats/haunter.inc"
INCLUDE "data/pokemon/base_stats/gengar.inc"
INCLUDE "data/pokemon/base_stats/onix.inc"
INCLUDE "data/pokemon/base_stats/drowzee.inc"
INCLUDE "data/pokemon/base_stats/hypno.inc"
INCLUDE "data/pokemon/base_stats/krabby.inc"
INCLUDE "data/pokemon/base_stats/kingler.inc"
INCLUDE "data/pokemon/base_stats/voltorb.inc"
INCLUDE "data/pokemon/base_stats/electrode.inc"
INCLUDE "data/pokemon/base_stats/exeggcute.inc"
INCLUDE "data/pokemon/base_stats/exeggutor.inc"
INCLUDE "data/pokemon/base_stats/cubone.inc"
INCLUDE "data/pokemon/base_stats/marowak.inc"
INCLUDE "data/pokemon/base_stats/hitmonlee.inc"
INCLUDE "data/pokemon/base_stats/hitmonchan.inc"
INCLUDE "data/pokemon/base_stats/lickitung.inc"
INCLUDE "data/pokemon/base_stats/koffing.inc"
INCLUDE "data/pokemon/base_stats/weezing.inc"
INCLUDE "data/pokemon/base_stats/rhyhorn.inc"
INCLUDE "data/pokemon/base_stats/rhydon.inc"
INCLUDE "data/pokemon/base_stats/chansey.inc"
INCLUDE "data/pokemon/base_stats/tangela.inc"
INCLUDE "data/pokemon/base_stats/kangaskhan.inc"
INCLUDE "data/pokemon/base_stats/horsea.inc"
INCLUDE "data/pokemon/base_stats/seadra.inc"
INCLUDE "data/pokemon/base_stats/goldeen.inc"
INCLUDE "data/pokemon/base_stats/seaking.inc"
INCLUDE "data/pokemon/base_stats/staryu.inc"
INCLUDE "data/pokemon/base_stats/starmie.inc"
INCLUDE "data/pokemon/base_stats/mrmime.inc"
INCLUDE "data/pokemon/base_stats/scyther.inc"
INCLUDE "data/pokemon/base_stats/jynx.inc"
INCLUDE "data/pokemon/base_stats/electabuzz.inc"
INCLUDE "data/pokemon/base_stats/magmar.inc"
INCLUDE "data/pokemon/base_stats/pinsir.inc"
INCLUDE "data/pokemon/base_stats/tauros.inc"
INCLUDE "data/pokemon/base_stats/magikarp.inc"
INCLUDE "data/pokemon/base_stats/gyarados.inc"
INCLUDE "data/pokemon/base_stats/lapras.inc"
INCLUDE "data/pokemon/base_stats/ditto.inc"
INCLUDE "data/pokemon/base_stats/eevee.inc"
INCLUDE "data/pokemon/base_stats/vaporeon.inc"
INCLUDE "data/pokemon/base_stats/jolteon.inc"
INCLUDE "data/pokemon/base_stats/flareon.inc"
INCLUDE "data/pokemon/base_stats/porygon.inc"
INCLUDE "data/pokemon/base_stats/omanyte.inc"
INCLUDE "data/pokemon/base_stats/omastar.inc"
INCLUDE "data/pokemon/base_stats/kabuto.inc"
INCLUDE "data/pokemon/base_stats/kabutops.inc"
INCLUDE "data/pokemon/base_stats/aerodactyl.inc"
INCLUDE "data/pokemon/base_stats/snorlax.inc"
INCLUDE "data/pokemon/base_stats/articuno.inc"
INCLUDE "data/pokemon/base_stats/zapdos.inc"
INCLUDE "data/pokemon/base_stats/moltres.inc"
INCLUDE "data/pokemon/base_stats/dratini.inc"
INCLUDE "data/pokemon/base_stats/dragonair.inc"
INCLUDE "data/pokemon/base_stats/dragonite.inc"
INCLUDE "data/pokemon/base_stats/mewtwo.inc"
INCLUDE "data/pokemon/base_stats/mew.inc"
INCLUDE "data/pokemon/base_stats/happa.inc"
INCLUDE "data/pokemon/base_stats/hanamogura.inc"
INCLUDE "data/pokemon/base_stats/hanaryu.inc"
INCLUDE "data/pokemon/base_stats/honoguma.inc"
INCLUDE "data/pokemon/base_stats/volbear.inc"
INCLUDE "data/pokemon/base_stats/dynabear.inc"
INCLUDE "data/pokemon/base_stats/kurusu.inc"
INCLUDE "data/pokemon/base_stats/aqua.inc"
INCLUDE "data/pokemon/base_stats/aquaria.inc"
INCLUDE "data/pokemon/base_stats/hoho.inc"
INCLUDE "data/pokemon/base_stats/bobo.inc"
INCLUDE "data/pokemon/base_stats/pachimee.inc"
INCLUDE "data/pokemon/base_stats/mokoko.inc"
INCLUDE "data/pokemon/base_stats/denryu.inc"
INCLUDE "data/pokemon/base_stats/mikon.inc"
INCLUDE "data/pokemon/base_stats/monja.inc"
INCLUDE "data/pokemon/base_stats/jaranra.inc"
INCLUDE "data/pokemon/base_stats/haneei.inc"
INCLUDE "data/pokemon/base_stats/puku.inc"
INCLUDE "data/pokemon/base_stats/shibirefugu.inc"
INCLUDE "data/pokemon/base_stats/pichu.inc"
INCLUDE "data/pokemon/base_stats/py.inc"
INCLUDE "data/pokemon/base_stats/pupurin.inc"
INCLUDE "data/pokemon/base_stats/mizuuo.inc"
INCLUDE "data/pokemon/base_stats/naty.inc"
INCLUDE "data/pokemon/base_stats/natio.inc"
INCLUDE "data/pokemon/base_stats/gyopin.inc"
INCLUDE "data/pokemon/base_stats/maril.inc"
INCLUDE "data/pokemon/base_stats/manbo1.inc"
INCLUDE "data/pokemon/base_stats/ikari.inc"
INCLUDE "data/pokemon/base_stats/grotess.inc"
INCLUDE "data/pokemon/base_stats/eksing.inc"
INCLUDE "data/pokemon/base_stats/para.inc"
INCLUDE "data/pokemon/base_stats/kokumo.inc"
INCLUDE "data/pokemon/base_stats/twohead.inc"
INCLUDE "data/pokemon/base_stats/yoroidori.inc"
INCLUDE "data/pokemon/base_stats/animon.inc"
INCLUDE "data/pokemon/base_stats/hinazu.inc"
INCLUDE "data/pokemon/base_stats/sunny.inc"
INCLUDE "data/pokemon/base_stats/paon.inc"
INCLUDE "data/pokemon/base_stats/donphan.inc"
INCLUDE "data/pokemon/base_stats/twinz.inc"
INCLUDE "data/pokemon/base_stats/kirinriki.inc"
INCLUDE "data/pokemon/base_stats/painter.inc"
INCLUDE "data/pokemon/base_stats/kounya.inc"
INCLUDE "data/pokemon/base_stats/rinrin.inc"
INCLUDE "data/pokemon/base_stats/berurun.inc"
INCLUDE "data/pokemon/base_stats/nyorotono.inc"
INCLUDE "data/pokemon/base_stats/yadoking.inc"
INCLUDE "data/pokemon/base_stats/annon.inc"
INCLUDE "data/pokemon/base_stats/rediba.inc"
INCLUDE "data/pokemon/base_stats/mitsuboshi.inc"
INCLUDE "data/pokemon/base_stats/puchicorn.inc"
INCLUDE "data/pokemon/base_stats/eifie.inc"
INCLUDE "data/pokemon/base_stats/blacky.inc"
INCLUDE "data/pokemon/base_stats/turban.inc"
INCLUDE "data/pokemon/base_stats/betbaby.inc"
INCLUDE "data/pokemon/base_stats/teppouo.inc"
INCLUDE "data/pokemon/base_stats/okutank.inc"
INCLUDE "data/pokemon/base_stats/gongu.inc"
INCLUDE "data/pokemon/base_stats/kapoerer.inc"
INCLUDE "data/pokemon/base_stats/pudie.inc"
INCLUDE "data/pokemon/base_stats/haneko.inc"
INCLUDE "data/pokemon/base_stats/poponeko.inc"
INCLUDE "data/pokemon/base_stats/wataneko.inc"
INCLUDE "data/pokemon/base_stats/baririna.inc"
INCLUDE "data/pokemon/base_stats/lip.inc"
INCLUDE "data/pokemon/base_stats/elebaby.inc"
INCLUDE "data/pokemon/base_stats/booby.inc"
INCLUDE "data/pokemon/base_stats/kireihana.inc"
INCLUDE "data/pokemon/base_stats/tsubomitto.inc"
INCLUDE "data/pokemon/base_stats/miltank.inc"
INCLUDE "data/pokemon/base_stats/bombseeker.inc"
INCLUDE "data/pokemon/base_stats/gift.inc"
INCLUDE "data/pokemon/base_stats/kotora.inc"
INCLUDE "data/pokemon/base_stats/raitora.inc"
INCLUDE "data/pokemon/base_stats/madame.inc"
INCLUDE "data/pokemon/base_stats/norowara.inc"
INCLUDE "data/pokemon/base_stats/kyonpan.inc"
INCLUDE "data/pokemon/base_stats/yamikarasu.inc"
INCLUDE "data/pokemon/base_stats/happi.inc"
INCLUDE "data/pokemon/base_stats/scissors.inc"
INCLUDE "data/pokemon/base_stats/purakkusu.inc"
INCLUDE "data/pokemon/base_stats/devil.inc"
INCLUDE "data/pokemon/base_stats/helgaa.inc"
INCLUDE "data/pokemon/base_stats/wolfman.inc"
INCLUDE "data/pokemon/base_stats/warwolf.inc"
INCLUDE "data/pokemon/base_stats/porygon2.inc"
INCLUDE "data/pokemon/base_stats/nameil.inc"
INCLUDE "data/pokemon/base_stats/haganeil.inc"
INCLUDE "data/pokemon/base_stats/kingdra.inc"
INCLUDE "data/pokemon/base_stats/rai.inc"
INCLUDE "data/pokemon/base_stats/en.inc"
INCLUDE "data/pokemon/base_stats/sui.inc"
INCLUDE "data/pokemon/base_stats/nyula.inc"
INCLUDE "data/pokemon/base_stats/houou.inc"
INCLUDE "data/pokemon/base_stats/togepy.inc"
INCLUDE "data/pokemon/base_stats/bulu.inc"
INCLUDE "data/pokemon/base_stats/tail.inc"
INCLUDE "data/pokemon/base_stats/leafy.inc"
