; collision IDs are built like this:
; 76543210
; \__/|\_/
;   | | \-- SubType
;   | \---- Flag
;   \------ Type
;
; What exactly flag means or if it
; means anything is up to Type.
; Old Types:
; ???
; New Types:
; 0 - Regular            8 - ???
; 1 - Trees, Grass etc.  9 - Special Talk Action
; 2 - Water              A - Jump Action
; 3 - Water 2            B - unused
; 4 - Land               C - unused
; 5 - Land 2             D - unused
; 6 - ???                E - unused
; 7 - Warps              F - unused

DEF COLLISION_TYPE_MASK          EQU $f0
DEF COLLISION_SUBTYPE_MASK       EQU $07
DEF COLLISION_WATER_SUBTYPE_MASK EQU $03

DEF COLLISION_FLAG EQU $08

; old collision constants

DEF OLD_COLLISION_TYPE_REGULAR EQU $00
DEF OLD_COLLISION_TYPE_SCENERY EQU $10
DEF OLD_COLLISION_TYPE_WATER   EQU $20
DEF OLD_COLLISION_TYPE_WATER2  EQU $40

DEF OLD_COLLISION_WALKABLE EQU $00
DEF OLD_COLLISION_SOLID    EQU $01
DEF OLD_COLLISION_FLOOR    EQU $03
DEF OLD_COLLISION_WALL     EQU $04

DEF OLD_COLLISION_LEDGE    EQU $11

DEF OLD_COLLISION_WATER2_S EQU $40

DEF OLD_COLLISION_ROCK EQU $51

DEF OLD_COLLISION_CARPED EQU $60
DEF OLD_COLLISION_DOOR   EQU $61

DEF OLD_COLLISION_SIGNPOST  EQU $70
DEF OLD_COLLISION_SHOP_SIGN EQU $71
DEF OLD_COLLISION_MART_ITEM EQU $72
DEF OLD_COLLISION_COUNTER   EQU $73

DEF OLD_COLLISION_CUT_TREE EQU $80
DEF OLD_COLLISION_GRASS    EQU $82

; new collision constants

DEF COLLISION_TYPE_REGULAR EQU $00
DEF COLLISION_TYPE_SCENERY EQU $10
DEF COLLISION_TYPE_WATER   EQU $20
DEF COLLISION_TYPE_WATER2  EQU $30
DEF COLLISION_TYPE_LAND    EQU $40
DEF COLLISION_TYPE_LAND2   EQU $50
DEF COLLISION_TYPE_UNK     EQU $60
DEF COLLISION_TYPE_WARPS   EQU $70
DEF COLLISION_TYPE_UNKN2   EQU $80
DEF COLLISION_TYPE_SPECIAL EQU $90
DEF COLLISION_TYPE_JUMP    EQU $A0

DEF COLLISION_WALKABLE EQU $00
DEF COLLISION_SOLID    EQU $07
DEF COLLISION_CUT_TREE EQU $12
DEF COLLISION_GRASS    EQU $18

; water collisions

DEF COLLISION_WATER       EQU $21
DEF COLLISION_WATERFALL   EQU $22
DEF COLLISION_WATER_SOLID EQU $27

; water collisions 2
DEF COLLISION_WATER2_E EQU $30
DEF COLLISION_WATER2_W EQU $31
DEF COLLISION_WATER2_N EQU $32
DEF COLLISION_WATER2_S EQU $33
; $34..$37 will behave like COLLISION_WATER2_E..COLLISION_WATER2_S

; land collisions
DEF COLLISION_LAND_SLOW EQU $40
DEF COLLISION_LAND_E    EQU $41
DEF COLLISION_LAND_W    EQU $42
DEF COLLISION_LAND_N    EQU $43
DEF COLLISION_LAND_S    EQU $44
; $45..$47 will behave like COLLISION_LAND_E

; land collisions 2
DEF COLLISION_LAND2_E EQU $50
DEF COLLISION_LAND2_W EQU $51
DEF COLLISION_LAND2_N EQU $52
DEF COLLISION_LAND2_S EQU $53
; $54..$57 will behave like COLLISION_LAND2_E


; warp collisions
DEF COLLISION_CARPET   EQU $70
DEF COLLISION_DOOR     EQU $71
DEF COLLISION_STEPS    EQU $72

; special collisions
DEF COLLISION_COUNTER           EQU $90
DEF COLLISION_BOOKCASE          EQU $91
DEF COLLISION_PC                EQU $93
DEF COLLISION_RADIO             EQU $94
DEF COLLISION_SIGNPOST          EQU $95
DEF COLLISION_STRAIGHT_SIGNPOST EQU $97

; jump collisions
; perform jump in marked direction, else
; regular walking
DEF COLLISION_JUMP_E  EQU $a0
DEF COLLISION_JUMP_W  EQU $a1
DEF COLLISION_JUMP_N  EQU $a2
DEF COLLISION_JUMP_S  EQU $a3
DEF COLLISION_JUMP_SE EQU $a4
DEF COLLISION_JUMP_SW EQU $a5
DEF COLLISION_JUMP_NE EQU $a6
DEF COLLISION_JUMP_NW EQU $a7

DEF NEVER_SOLID     EQU 0
DEF SOMETIMES_SOLID EQU 1
DEF ALWAYS_SOLID    EQU 15
