#include <string>
using std::string;

#include <map>
using std::map;

#include "dungeonjson.h"
#include "move_id_json.h"

static map<std::string, int> move_macro_ids;

int get_move_id(string move_macro) {
    if (move_macro_ids.size() == 0)
    {
        move_macro_ids["MOVE_IRON_TAIL"] = 0x1;
        move_macro_ids["MOVE_ICE_BALL"] = 0x2;
        move_macro_ids["MOVE_YAWN"] = 0x3;
        move_macro_ids["MOVE_LOVELY_KISS"] = 0x4;
        move_macro_ids["MOVE_NIGHTMARE"] = 0x5;
        move_macro_ids["MOVE_MORNING_SUN"] = 0x6;
        move_macro_ids["MOVE_VITAL_THROW"] = 0x7;
        move_macro_ids["MOVE_DIG"] = 0x8;
        move_macro_ids["MOVE_THRASH"] = 0x9;
        move_macro_ids["MOVE_SWEET_SCENT"] = 0xA;
        move_macro_ids["MOVE_CHARM"] = 0xB;
        move_macro_ids["MOVE_RAIN_DANCE"] = 0xC;
        move_macro_ids["MOVE_CONFUSE_RAY"] = 0xD;
        move_macro_ids["MOVE_HAIL"] = 0xE;
        move_macro_ids["MOVE_AROMATHERAPY"] = 0xF;
        move_macro_ids["MOVE_BUBBLE"] = 0x10;
        move_macro_ids["MOVE_ENCORE"] = 0x11;
        move_macro_ids["MOVE_CUT"] = 0x12;
        move_macro_ids["MOVE_RAGE"] = 0x13;
        move_macro_ids["MOVE_SUPER_FANG"] = 0x14;
        move_macro_ids["MOVE_PAIN_SPLIT"] = 0x15;
        move_macro_ids["MOVE_TORMENT"] = 0x16;
        move_macro_ids["MOVE_STRING_SHOT"] = 0x17;
        move_macro_ids["MOVE_SWAGGER"] = 0x18;
        move_macro_ids["MOVE_SNORE"] = 0x19;
        move_macro_ids["MOVE_HEAL_BELL"] = 0x1A;
        move_macro_ids["MOVE_SCREECH"] = 0x1B;
        move_macro_ids["MOVE_ROCK_THROW"] = 0x1C;
        move_macro_ids["MOVE_ROCK_SMASH"] = 0x1D;
        move_macro_ids["MOVE_ROCK_SLIDE"] = 0x1E;
        move_macro_ids["MOVE_WEATHER_BALL"] = 0x1F;
        move_macro_ids["MOVE_WHIRLPOOL"] = 0x20;
        move_macro_ids["MOVE_FAKE_TEARS"] = 0x21;
        move_macro_ids["MOVE_SING"] = 0x22;
        move_macro_ids["MOVE_SPITE"] = 0x23;
        move_macro_ids["MOVE_AIR_CUTTER"] = 0x24;
        move_macro_ids["MOVE_SMOKESCREEN"] = 0x25;
        move_macro_ids["MOVE_PURSUIT"] = 0x26;
        move_macro_ids["MOVE_DOUBLESLAP"] = 0x27;
        move_macro_ids["MOVE_MIRROR_MOVE"] = 0x28;
        move_macro_ids["MOVE_OVERHEAT"] = 0x29;
        move_macro_ids["MOVE_AURORA_BEAM"] = 0x2A;
        move_macro_ids["MOVE_MEMENTO"] = 0x2B;
        move_macro_ids["MOVE_OCTAZOOKA"] = 0x2C;
        move_macro_ids["MOVE_FLATTER"] = 0x2D;
        move_macro_ids["MOVE_ASTONISH"] = 0x2E;
        move_macro_ids["MOVE_WILL_O_WISP"] = 0x2F;
        move_macro_ids["MOVE_RETURN"] = 0x30;
        move_macro_ids["MOVE_GRUDGE"] = 0x31;
        move_macro_ids["MOVE_STRENGTH"] = 0x32;
        move_macro_ids["MOVE_COUNTER"] = 0x33;
        move_macro_ids["MOVE_FLAME_WHEEL"] = 0x34;
        move_macro_ids["MOVE_FLAMETHROWER"] = 0x35;
        move_macro_ids["MOVE_ODOR_SLEUTH"] = 0x36;
        move_macro_ids["MOVE_SHARPEN"] = 0x37;
        move_macro_ids["MOVE_DOUBLE_TEAM"] = 0x38;
        move_macro_ids["MOVE_GUST"] = 0x39;
        move_macro_ids["MOVE_HARDEN"] = 0x3A;
        move_macro_ids["MOVE_DISABLE"] = 0x3B;
        move_macro_ids["MOVE_RAZOR_WIND"] = 0x3C;
        move_macro_ids["MOVE_BIDE"] = 0x3D;
        move_macro_ids["MOVE_CRUNCH"] = 0x3E;
        move_macro_ids["MOVE_BITE"] = 0x3F;
        move_macro_ids["MOVE_THUNDER"] = 0x40;
        move_macro_ids["MOVE_THUNDERPUNCH"] = 0x41;
        move_macro_ids["MOVE_ENDEAVOR"] = 0x42;
        move_macro_ids["MOVE_FACADE"] = 0x43;
        move_macro_ids["MOVE_KARATE_CHOP"] = 0x44;
        move_macro_ids["MOVE_CLAMP"] = 0x45;
        move_macro_ids["MOVE_WITHDRAW"] = 0x46;
        move_macro_ids["MOVE_CONSTRICT"] = 0x47;
        move_macro_ids["MOVE_BRICK_BREAK"] = 0x48;
        move_macro_ids["MOVE_ROCK_TOMB"] = 0x49;
        move_macro_ids["MOVE_FOCUS_ENERGY"] = 0x4A;
        move_macro_ids["MOVE_FOCUS_PUNCH"] = 0x4B;
        move_macro_ids["MOVE_GIGA_DRAIN"] = 0x4C;
        move_macro_ids["MOVE_REVERSAL"] = 0x4D;
        move_macro_ids["MOVE_SMELLINGSALT"] = 0x4E;
        move_macro_ids["MOVE_SPORE"] = 0x4F;
        move_macro_ids["MOVE_LEECH_LIFE"] = 0x50;
        move_macro_ids["MOVE_SLASH"] = 0x51;
        move_macro_ids["MOVE_SILVER_WIND"] = 0x52;
        move_macro_ids["MOVE_METAL_SOUND"] = 0x53;
        move_macro_ids["MOVE_GRASSWHISTLE"] = 0x54;
        move_macro_ids["MOVE_TICKLE"] = 0x55;
        move_macro_ids["MOVE_SPIDER_WEB"] = 0x56;
        move_macro_ids["MOVE_CRABHAMMER"] = 0x57;
        move_macro_ids["MOVE_HAZE"] = 0x58;
        move_macro_ids["MOVE_MEAN_LOOK"] = 0x59;
        move_macro_ids["MOVE_CROSS_CHOP"] = 0x5A;
        move_macro_ids["MOVE_OUTRAGE"] = 0x5B;
        move_macro_ids["MOVE_LOW_KICK"] = 0x5C;
        move_macro_ids["MOVE_ANCIENTPOWER"] = 0x5D;
        move_macro_ids["MOVE_SYNTHESIS"] = 0x5E;
        move_macro_ids["MOVE_AGILITY"] = 0x5F;
        move_macro_ids["MOVE_RAPID_SPIN"] = 0x60;
        move_macro_ids["MOVE_ICY_WIND"] = 0x61;
        move_macro_ids["MOVE_MIND_READER"] = 0x62;
        move_macro_ids["MOVE_COSMIC_POWER"] = 0x63;
        move_macro_ids["MOVE_SKY_ATTACK"] = 0x64;
        move_macro_ids["MOVE_POWDER_SNOW"] = 0x65;
        move_macro_ids["MOVE_FOLLOW_ME"] = 0x66;
        move_macro_ids["MOVE_METEOR_MASH"] = 0x67;
        move_macro_ids["MOVE_ENDURE"] = 0x68;
        move_macro_ids["MOVE_ROLLOUT"] = 0x69;
        move_macro_ids["MOVE_SCARY_FACE"] = 0x6A;
        move_macro_ids["MOVE_PSYBEAM"] = 0x6B;
        move_macro_ids["MOVE_PSYWAVE"] = 0x6C;
        move_macro_ids["MOVE_PSYCHIC"] = 0x6D;
        move_macro_ids["MOVE_PSYCHO_BOOST"] = 0x6E;
        move_macro_ids["MOVE_HYPNOSIS"] = 0x6F;
        move_macro_ids["MOVE_UPROAR"] = 0x70;
        move_macro_ids["MOVE_WATER_SPOUT"] = 0x71;
        move_macro_ids["MOVE_SIGNAL_BEAM"] = 0x72;
        move_macro_ids["MOVE_PSYCH_UP"] = 0x73;
        move_macro_ids["MOVE_SUBMISSION"] = 0x74;
        move_macro_ids["MOVE_RECOVER"] = 0x75;
        move_macro_ids["MOVE_EARTHQUAKE"] = 0x76;
        move_macro_ids["MOVE_NATURE_POWER"] = 0x77;
        move_macro_ids["MOVE_LICK"] = 0x78;
        move_macro_ids["MOVE_FLAIL"] = 0x79;
        move_macro_ids["MOVE_TAIL_WHIP"] = 0x7A;
        move_macro_ids["MOVE_SELFDESTRUCT"] = 0x7B;
        move_macro_ids["MOVE_STUN_SPORE"] = 0x7C;
        move_macro_ids["MOVE_BIND"] = 0x7D;
        move_macro_ids["MOVE_SHADOW_PUNCH"] = 0x7E;
        move_macro_ids["MOVE_SHADOW_BALL"] = 0x7F;
        move_macro_ids["MOVE_CHARGE"] = 0x80;
        move_macro_ids["MOVE_THUNDERBOLT"] = 0x81;
        move_macro_ids["MOVE_MIST"] = 0x82;
        move_macro_ids["MOVE_FISSURE"] = 0x83;
        move_macro_ids["MOVE_EXTREMESPEED"] = 0x84;
        move_macro_ids["MOVE_EXTRASENSORY"] = 0x85;
        move_macro_ids["MOVE_SAFEGUARD"] = 0x86;
        move_macro_ids["MOVE_ABSORB"] = 0x87;
        move_macro_ids["MOVE_SKY_UPPERCUT"] = 0x88;
        move_macro_ids["MOVE_SKILL_SWAP"] = 0x89;
        move_macro_ids["MOVE_SKETCH"] = 0x8A;
        move_macro_ids["MOVE_HEADBUTT"] = 0x8B;
        move_macro_ids["MOVE_DOUBLE_EDGE"] = 0x8C;
        move_macro_ids["MOVE_SANDSTORM"] = 0x8D;
        move_macro_ids["MOVE_SAND_ATTACK"] = 0x8E;
        move_macro_ids["MOVE_SAND_TOMB"] = 0x8F;
        move_macro_ids["MOVE_SPARK"] = 0x90;
        move_macro_ids["MOVE_SWIFT"] = 0x91;
        move_macro_ids["MOVE_KINESIS"] = 0x92;
        move_macro_ids["MOVE_SMOG"] = 0x93;
        move_macro_ids["MOVE_GROWTH"] = 0x94;
        move_macro_ids["MOVE_SACRED_FIRE"] = 0x95;
        move_macro_ids["MOVE_SHEER_COLD"] = 0x96;
        move_macro_ids["MOVE_SOLARBEAM"] = 0x97;
        move_macro_ids["MOVE_SONICBOOM"] = 0x98;
        move_macro_ids["MOVE_FLY"] = 0x99;
        move_macro_ids["MOVE_TACKLE"] = 0x9A;
        move_macro_ids["MOVE_EXPLOSION"] = 0x9B;
        move_macro_ids["MOVE_DIVE"] = 0x9C;
        move_macro_ids["MOVE_FIRE_BLAST"] = 0x9D;
        move_macro_ids["MOVE_WATERFALL"] = 0x9E;
        move_macro_ids["MOVE_MUDDY_WATER"] = 0x9F;
        move_macro_ids["MOVE_STOCKPILE"] = 0xA0;
        move_macro_ids["MOVE_SLAM"] = 0xA1;
        move_macro_ids["MOVE_TWISTER"] = 0xA2;
        move_macro_ids["MOVE_BULLET_SEED"] = 0xA3;
        move_macro_ids["MOVE_TWINEEDLE"] = 0xA4;
        move_macro_ids["MOVE_SOFTBOILED"] = 0xA5;
        move_macro_ids["MOVE_EGG_BOMB"] = 0xA6;
        move_macro_ids["MOVE_FAINT_ATTACK"] = 0xA7;
        move_macro_ids["MOVE_BARRAGE"] = 0xA8;
        move_macro_ids["MOVE_MINIMIZE"] = 0xA9;
        move_macro_ids["MOVE_SEISMIC_TOSS"] = 0xAA;
        move_macro_ids["MOVE_SUPERSONIC"] = 0xAB;
        move_macro_ids["MOVE_TAUNT"] = 0xAC;
        move_macro_ids["MOVE_MOONLIGHT"] = 0xAD;
        move_macro_ids["MOVE_PECK"] = 0xAE;
        move_macro_ids["MOVE_ARM_THRUST"] = 0xAF;
        move_macro_ids["MOVE_HORN_ATTACK"] = 0xB0;
        move_macro_ids["MOVE_HORN_DRILL"] = 0xB1;
        move_macro_ids["MOVE_WING_ATTACK"] = 0xB2;
        move_macro_ids["MOVE_AERIAL_ACE"] = 0xB3;
        move_macro_ids["MOVE_ICICLE_SPEAR"] = 0xB4;
        move_macro_ids["MOVE_SWORDS_DANCE"] = 0xB5;
        move_macro_ids["MOVE_VINE_WHIP"] = 0xB6;
        move_macro_ids["MOVE_CONVERSION"] = 0xB7;
        move_macro_ids["MOVE_CONVERSION_2"] = 0xB8;
        move_macro_ids["MOVE_HELPING_HAND"] = 0xB9;
        move_macro_ids["MOVE_IRON_DEFENSE"] = 0xBA;
        move_macro_ids["MOVE_TELEPORT"] = 0xBB;
        move_macro_ids["MOVE_THUNDERSHOCK"] = 0xBC;
        move_macro_ids["MOVE_SHOCK_WAVE"] = 0xBD;
        move_macro_ids["MOVE_QUICK_ATTACK"] = 0xBE;
        move_macro_ids["MOVE_SWEET_KISS"] = 0xBF;
        move_macro_ids["MOVE_THUNDER_WAVE"] = 0xC0;
        move_macro_ids["MOVE_ZAP_CANNON"] = 0xC1;
        move_macro_ids["MOVE_BLOCK"] = 0xC2;
        move_macro_ids["MOVE_HOWL"] = 0xC3;
        move_macro_ids["MOVE_POISON_GAS"] = 0xC4;
        move_macro_ids["MOVE_TOXIC"] = 0xC5;
        move_macro_ids["MOVE_POISON_FANG"] = 0xC6;
        move_macro_ids["MOVE_POISONPOWDER"] = 0xC7;
        move_macro_ids["MOVE_POISON_STING"] = 0xC8;
        move_macro_ids["MOVE_SPIKE_CANNON"] = 0xC9;
        move_macro_ids["MOVE_ACID_ARMOR"] = 0xCA;
        move_macro_ids["MOVE_TAKE_DOWN"] = 0xCB;
        move_macro_ids["MOVE_JUMP_KICK"] = 0xCC;
        move_macro_ids["MOVE_BOUNCE"] = 0xCD;
        move_macro_ids["MOVE_HI_JUMP_KICK"] = 0xCE;
        move_macro_ids["MOVE_TRI_ATTACK"] = 0xCF;
        move_macro_ids["MOVE_DRAGON_CLAW"] = 0xD0;
        move_macro_ids["MOVE_TRICK"] = 0xD1;
        move_macro_ids["MOVE_TRIPLE_KICK"] = 0xD2;
        move_macro_ids["MOVE_DRILL_PECK"] = 0xD3;
        move_macro_ids["MOVE_MUD_SPORT"] = 0xD4;
        move_macro_ids["MOVE_MUD_SLAP"] = 0xD5;
        move_macro_ids["MOVE_THIEF"] = 0xD6;
        move_macro_ids["MOVE_AMNESIA"] = 0xD7;
        move_macro_ids["MOVE_NIGHT_SHADE"] = 0xD8;
        move_macro_ids["MOVE_GROWL"] = 0xD9;
        move_macro_ids["MOVE_SLACK_OFF"] = 0xDA;
        move_macro_ids["MOVE_SURF"] = 0xDB;
        move_macro_ids["MOVE_ROLE_PLAY"] = 0xDC;
        move_macro_ids["MOVE_NEEDLE_ARM"] = 0xDD;
        move_macro_ids["MOVE_DOUBLE_KICK"] = 0xDE;
        move_macro_ids["MOVE_SUNNY_DAY"] = 0xDF;
        move_macro_ids["MOVE_LEER"] = 0xE0;
        move_macro_ids["MOVE_WISH"] = 0xE1;
        move_macro_ids["MOVE_FAKE_OUT"] = 0xE2;
        move_macro_ids["MOVE_SLEEP_TALK"] = 0xE3;
        move_macro_ids["MOVE_PAY_DAY"] = 0xE4;
        move_macro_ids["MOVE_ASSIST"] = 0xE5;
        move_macro_ids["MOVE_HEAT_WAVE"] = 0xE6;
        move_macro_ids["MOVE_SLEEP_POWDER"] = 0xE7;
        move_macro_ids["MOVE_REST"] = 0xE8;
        move_macro_ids["MOVE_INGRAIN"] = 0xE9;
        move_macro_ids["MOVE_CONFUSION"] = 0xEA;
        move_macro_ids["MOVE_BODY_SLAM"] = 0xEB;
        move_macro_ids["MOVE_SWALLOW"] = 0xEC;
        move_macro_ids["MOVE_CURSE"] = 0xED;
        move_macro_ids["MOVE_FRENZY_PLANT"] = 0xEE;
        move_macro_ids["MOVE_HYDRO_CANNON"] = 0xEF;
        move_macro_ids["MOVE_HYDRO_PUMP"] = 0xF0;
        move_macro_ids["MOVE_HYPER_VOICE"] = 0xF1;
        move_macro_ids["MOVE_HYPER_BEAM"] = 0xF2;
        move_macro_ids["MOVE_SUPERPOWER"] = 0xF3;
        move_macro_ids["MOVE_STEEL_WING"] = 0xF4;
        move_macro_ids["MOVE_SPIT_UP"] = 0xF5;
        move_macro_ids["MOVE_DYNAMICPUNCH"] = 0xF6;
        move_macro_ids["MOVE_GUILLOTINE"] = 0xF7;
        move_macro_ids["MOVE_VICEGRIP"] = 0xF8;
        move_macro_ids["MOVE_KNOCK_OFF"] = 0xF9;
        move_macro_ids["MOVE_POUND"] = 0xFA;
        move_macro_ids["MOVE_RAZOR_LEAF"] = 0xFB;
        move_macro_ids["MOVE_BATON_PASS"] = 0xFC;
        move_macro_ids["MOVE_PETAL_DANCE"] = 0xFD;
        move_macro_ids["MOVE_SPLASH"] = 0xFE;
        move_macro_ids["MOVE_BUBBLEBEAM"] = 0xFF;
        move_macro_ids["MOVE_DOOM_DESIRE"] = 0x100;
        move_macro_ids["MOVE_BELLY_DRUM"] = 0x101;
        move_macro_ids["MOVE_BARRIER"] = 0x102;
        move_macro_ids["MOVE_LIGHT_SCREEN"] = 0x103;
        move_macro_ids["MOVE_SCRATCH"] = 0x104;
        move_macro_ids["MOVE_HYPER_FANG"] = 0x105;
        move_macro_ids["MOVE_EMBER"] = 0x106;
        move_macro_ids["MOVE_SECRET_POWER"] = 0x107;
        move_macro_ids["MOVE_DIZZY_PUNCH"] = 0x108;
        move_macro_ids["MOVE_BULK_UP"] = 0x109;
        move_macro_ids["MOVE_IMPRISON"] = 0x10A;
        move_macro_ids["MOVE_FEATHERDANCE"] = 0x10B;
        move_macro_ids["MOVE_WHIRLWIND"] = 0x10C;
        move_macro_ids["MOVE_BEAT_UP"] = 0x10D;
        move_macro_ids["MOVE_BLIZZARD"] = 0x10E;
        move_macro_ids["MOVE_STOMP"] = 0x10F;
        move_macro_ids["MOVE_BLAST_BURN"] = 0x110;
        move_macro_ids["MOVE_FLASH"] = 0x111;
        move_macro_ids["MOVE_TEETER_DANCE"] = 0x112;
        move_macro_ids["MOVE_CRUSH_CLAW"] = 0x113;
        move_macro_ids["MOVE_BLAZE_KICK"] = 0x114;
        move_macro_ids["MOVE_PRESENT"] = 0x115;
        move_macro_ids["MOVE_ERUPTION"] = 0x116;
        move_macro_ids["MOVE_SLUDGE"] = 0x117;
        move_macro_ids["MOVE_SLUDGE_BOMB"] = 0x118;
        move_macro_ids["MOVE_GLARE"] = 0x119;
        move_macro_ids["MOVE_TRANSFORM"] = 0x11A;
        move_macro_ids["MOVE_POISON_TAIL"] = 0x11B;
        move_macro_ids["MOVE_ROAR"] = 0x11C;
        move_macro_ids["MOVE_BONE_RUSH"] = 0x11D;
        move_macro_ids["MOVE_CAMOUFLAGE"] = 0x11E;
        move_macro_ids["MOVE_COVET"] = 0x11F;
        move_macro_ids["MOVE_TAIL_GLOW"] = 0x120;
        move_macro_ids["MOVE_BONE_CLUB"] = 0x121;
        move_macro_ids["MOVE_BONEMERANG"] = 0x122;
        move_macro_ids["MOVE_FIRE_SPIN"] = 0x123;
        move_macro_ids["MOVE_FIRE_PUNCH"] = 0x124;
        move_macro_ids["MOVE_PERISH_SONG"] = 0x125;
        move_macro_ids["MOVE_WRAP"] = 0x126;
        move_macro_ids["MOVE_SPIKES"] = 0x127;
        move_macro_ids["MOVE_MAGNITUDE"] = 0x128;
        move_macro_ids["MOVE_MAGICAL_LEAF"] = 0x129;
        move_macro_ids["MOVE_MAGIC_COAT"] = 0x12A;
        move_macro_ids["MOVE_MUD_SHOT"] = 0x12B;
        move_macro_ids["MOVE_MACH_PUNCH"] = 0x12C;
        move_macro_ids["MOVE_PROTECT"] = 0x12D;
        move_macro_ids["MOVE_DEFENSE_CURL"] = 0x12E;
        move_macro_ids["MOVE_ROLLING_KICK"] = 0x12F;
        move_macro_ids["MOVE_SUBSTITUTE"] = 0x130;
        move_macro_ids["MOVE_DETECT"] = 0x131;
        move_macro_ids["MOVE_PIN_MISSILE"] = 0x132;
        move_macro_ids["MOVE_WATER_SPORT"] = 0x133;
        move_macro_ids["MOVE_WATER_GUN"] = 0x134;
        move_macro_ids["MOVE_MIST_BALL"] = 0x135;
        move_macro_ids["MOVE_WATER_PULSE"] = 0x136;
        move_macro_ids["MOVE_FURY_ATTACK"] = 0x137;
        move_macro_ids["MOVE_FURY_SWIPES"] = 0x138;
        move_macro_ids["MOVE_DESTINY_BOND"] = 0x139;
        move_macro_ids["MOVE_FALSE_SWIPE"] = 0x13A;
        move_macro_ids["MOVE_FORESIGHT"] = 0x13B;
        move_macro_ids["MOVE_MIRROR_COAT"] = 0x13C;
        move_macro_ids["MOVE_FUTURE_SIGHT"] = 0x13D;
        move_macro_ids["MOVE_MILK_DRINK"] = 0x13E;
        move_macro_ids["MOVE_CALM_MIND"] = 0x13F;
        move_macro_ids["MOVE_MEGA_DRAIN"] = 0x140;
        move_macro_ids["MOVE_MEGA_KICK"] = 0x141;
        move_macro_ids["MOVE_MEGA_PUNCH"] = 0x142;
        move_macro_ids["MOVE_MEGAHORN"] = 0x143;
        move_macro_ids["MOVE_HIDDEN_POWER"] = 0x144;
        move_macro_ids["MOVE_METAL_CLAW"] = 0x145;
        move_macro_ids["MOVE_ATTRACT"] = 0x146;
        move_macro_ids["MOVE_MIMIC"] = 0x147;
        move_macro_ids["MOVE_FRUSTRATION"] = 0x148;
        move_macro_ids["MOVE_LEECH_SEED"] = 0x149;
        move_macro_ids["MOVE_METRONOME"] = 0x14A;
        move_macro_ids["MOVE_DREAM_EATER"] = 0x14B;
        move_macro_ids["MOVE_ACID"] = 0x14C;
        move_macro_ids["MOVE_MEDITATE"] = 0x14D;
        move_macro_ids["MOVE_SNATCH"] = 0x14E;
        move_macro_ids["MOVE_LUSTER_PURGE"] = 0x14F;
        move_macro_ids["MOVE_LEAF_BLADE"] = 0x150;
        move_macro_ids["MOVE_RECYCLE"] = 0x151;
        move_macro_ids["MOVE_REFLECT"] = 0x152;
        move_macro_ids["MOVE_REFRESH"] = 0x153;
        move_macro_ids["MOVE_REVENGE"] = 0x154;
        move_macro_ids["MOVE_DRAGON_RAGE"] = 0x155;
        move_macro_ids["MOVE_DRAGONBREATH"] = 0x156;
        move_macro_ids["MOVE_DRAGON_DANCE"] = 0x157;
        move_macro_ids["MOVE_ICE_PUNCH"] = 0x158;
        move_macro_ids["MOVE_ICE_BEAM"] = 0x159;
        move_macro_ids["MOVE_FURY_CUTTER"] = 0x15A;
        move_macro_ids["MOVE_COMET_PUNCH"] = 0x15B;
        move_macro_ids["MOVE_SKULL_BASH"] = 0x15C;
        move_macro_ids["MOVE_LOCK_ON"] = 0x15D;
        move_macro_ids["MOVE_ROCK_BLAST"] = 0x15E;
        move_macro_ids["MOVE_COTTON_SPORE"] = 0x15F;
        move_macro_ids["MOVE_STRUGGLE"] = 0x160;
        move_macro_ids["MOVE_AEROBLAST"] = 0x161;
        move_macro_ids["MOVE_VOLT_TACKLE"] = 0x162;
        move_macro_ids["MOVE_WIDE_SLASH"] = 0x168;
        move_macro_ids["MOVE_VACUUM_CUT"] = 0x18A;
    }
    if (move_macro_ids.count(move_macro))
    {
        return move_macro_ids.at(move_macro);
    }
    else
    {
        FATAL_ERROR("Unknown move %s when generating learnsets. Make sure the move is registered in tools/data/move_id_json.cpp.\n", move_macro.c_str());
    }
}