#include "global.h"
#include "globaldata.h"

struct SfxName
{
    const char *str;
    s32 unk4; // Seems to be always set to 1
};

struct SoundNamesStruct
{
    const char * const headerText;
    const char * const soundDataBankText;
    const char * const tableText;
    const struct SfxName *sfxNames;
};

// Forward declarations
static const char sText_Table[];
static const char sText_Header[];
static const char sText_PKDSoundData[];

const struct SoundNamesStruct gSoundNamesStruct;

const struct SfxName gSfxNames[];

// Actual data

UNUSED static const s32 sUnkValue = 2;
const struct SoundNamesStruct *const gSoundNamesStructPtr = &gSoundNamesStruct;

ALIGNED(4) UNUSED static const char sPksDir1[] = "pksdir0";

const struct SoundNamesStruct gSoundNamesStruct =
{
    .headerText = sText_Header,
    .soundDataBankText = sText_PKDSoundData,
    .tableText = sText_Table,
    .sfxNames = gSfxNames,
};

ALIGNED(4) static const char sText_Table[] = "TABLE";
ALIGNED(4) static const char sText_Header[] = "HEADER";
ALIGNED(4) UNUSED static const char sPksDir2[] = "pksdir0";
ALIGNED(4) static const char sText_PKDSoundData[] = "PKD Sound Data Bank";

const struct SfxName gSfxNames[] =
{
    {"DUMMY", 1},
    {"HABITAT_HOME01", 1},
    {"HABITAT_DARK_01", 1},
    {"HABITAT_MYSTIC_01", 1},
    {"EVENT_DREAM_01", 1},
    {"EVENT_DREAM_02", 1},
    {"EVENT_LEGEND_01", 1},
    {"HABITAT_HIROBA", 1},
    {"HABITAT_HOME_SHINKA", 1},
    {"EVENT_FEAR", 1},
    {"EVENT_KINPAKU", 1},
    {"BOSS01", 1},
    {"EVENT_YUME", 1},
    {"DUNGEON_GENERAL_01", 1},
    {"DUNGEON_DENJIHA_01", 1},
    {"DUNGEON_AYASHIIMORI_01", 1},
    {"HABITAT_CALMLY_02", 1},
    {"SYS_SHOP", 1},
    {"SYS_STEAL", 1},
    {"EVENT_DISASTER", 1},
    {"DUNGEON_KYOUKOKU_01", 1},
    {"DUNGEON_GENERAL_02", 1},
    {"DUNGEON_TENKUU_01", 1},
    {"DUNGEON_TENKUU_02", 1},
    {"EVENT_ESCAPE_01", 1},
    {"DUNGEON_HONOU_01", 1},
    {"DUNGEON_EVENTFLOOR_02", 1},
    {"HABITAT_ITADAKI_01", 1},
    {"HABITAT_NIJI_01", 1},
    {"EVENT_ENV_MYSTIC", 1},
    {"HABITAT_KAIRYU_01", 1},
    {"HABITAT_KAITEI_01", 1},
    {"BOSS02", 1},
    {"DUNGEON_HONOU_02", 1},
    {"HABITAT_DAICHI_01", 1},
    {"HABITAT_NAZO_01", 1},
    {"EVENT_ESCAPE_02", 1},
    {"EVENT_ENV_SOUL", 1},
    {"EVENT_ENV_HONOU", 1},
    {"DUNGEON_JUHYOU_02", 1},
    {"SYS_TITLE_01", 1},
    {"EVENT_SEPARATION_01", 1},
    {"EVENT_SEPARATION_02", 1},
    {"SYS_TITLE_02", 1},
    {"SYS_ENDING_01", 1},
    {"SYS_ENDING_02", 1},
    {"SYS_TITLE_03", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"SAVE_01", 1},
    {"GAMEOVER", 1},
    {"GAMECLEAR", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"EVENT_ZUKKOKE", 1},
    {"EVENT_CALMLY", 1},
    {"DUNGEON_GUNJYOU_01", 1},
    {"EVENT_CLEARD", 1},
    {"DUNGEON_JUHYOU_01", 1},
    {"HABITAT_CALMLY_01", 1},
    {"HABITAT_MYSTIC_02", 1},
    {"HABITAT_CALMLY_03", 1},
    {"DUNGEON_CHITEI_01", 1},
    {"SYS_TRAINING", 1},
    {"DUNGEON_TUTORIAL_01", 1},
    {"DUNGEON_RAIMEI_01", 1},
    {"HABITAT_MYSTIC_06", 1},
    {"DUNGEON_CHINMOKU_01", 1},
    {"DUNGEON_EVENTFLOOR_01", 1},
    {"DUNGEON_REIHOU_01", 1},
    {"HABITAT_MYSTIC_03", 1},
    {"HABITAT_DENSETSU_01", 1},
    {"HABITAT_MINAMI_01", 1},
    {"HABITAT_TOZASARETA_01", 1},
    {"DUNGEON_HAGANE_01", 1},
    {"HABITAT_MYSTIC_04", 1},
    {"HABITAT_SAIGO_01", 1},
    {"DUNGEON_REIHOU_02", 1},
    {"DUNGEON_CHITEI_02", 1},
    {"DUNGEON_CHIISANAMORI_01", 1},
    {"DUNGEON_RAIMEI_02", 1},
    {"HABITAT_IYASHI_01", 1},
    {"SYS_MONSTER", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"LEVELUP", 1},
    {"RANKUP", 1},
    {"SEEYOU", 1},
    {"REWARD", 1},
    {"PARTY", 1},
    {"DUNGEON_OPEN", 1},
    {"AREA_OPEN", 1},
    {"INFORMATION", 1},
    {"FANFARE", 1},
    {NULL, 1},
    {"EVOLUTION", 1},
    {"EVOLUTION_02", 1},
    {"ITEM_IMPORTANT", 1},
    {"NEWS", 1},
    {"MUSICBOX", 1},
    {"EFF_ORUGORU", 1},
    {"WIND_S", 1},
    {"WIND_M", 1},
    {"WAVE_S", 1},
    {"WAVE_M", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"SYS_01", 1},
    {"SYS_02", 1},
    {"SYS_03", 1},
    {"SYS_04", 1},
    {"SYS_05", 1},
    {"SYS_06", 1},
    {"SYS_07", 1},
    {"SYS_08", 1},
    {"SYS_09", 1},
    {"SYS_10", 1},
    {"DS_SYS_01", 1},
    {"WAZA", 1},
    {"WAZA_CLEAR", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"ITEM_M", 1},
    {"ITEM_M_03", 1},
    {"MOTION_MONEY", 1},
    {"MOTION_ITEM", 1},
    {NULL, 1},
    {"MOTION_EAT", 1},
    {"MOTION_THROW", 1},
    {"MOTION_THROW_02", 1},
    {"MOTION_THROW_03", 1},
    {"MOTION_HUNGRY", 1},
    {"MOTION_STAIRS_UP", 1},
    {"MOTION_STAIRS_DOWN", 1},
    {"MISS_PLAYER_M", 1},
    {"MISS_ENEMY_M", 1},
    {"TAIATARI_M", 1},
    {"MOTION_BREAK", 1},
    {"MOTION_DOOR_GENERAL", 1},
    {"MOTION_DOOR_BIG", 1},
    {"MOTION_SWITCH", 1},
    {NULL, 1},
    {NULL, 1},
    {"EFF_ANIM_2", 1},
    {"EFF_ANIM_8", 1},
    {"EFF_ANIM_9", 1},
    {"EFF_ANIM_10", 1},
    {"EFF_ANIM_11", 1},
    {"EFF_ANIM_12", 1},
    {"EFF_ANIM_4_SCRATCH", 1},
    {"EFF_ANIM_4_LICK", 1},
    {"EFF_ANIM_4_GORE", 1},
    {"EFF_ANIM_4_ATTACK", 1},
    {"EFF_ANIM_4_HEEL_DOWN", 1},
    {"EFF_ANIM_4_WAG_TAIL", 1},
    {"EFF_ANIM_4_PAWUP", 1},
    {"EFF_ANIM_4_ELECTRICITY", 1},
    {"EFF_ANIM_4_WING_S", 1},
    {"EFF_ANIM_4_WING_M", 1},
    {"EFF_ANIM_4_WING_L", 1},
    {"EFF_ANIM_4_SHAKE", 1},
    {"EFF_ANIM_4_JUMP", 1},
    {"EFF_ANIM_4_ATTACK_LIGHT", 1},
    {"MOTION_WIND_LARGE", 1},
    {"MOTION_WAVE_LARGE", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"THUNDER_M", 1},
    {"WIND_M", 1},
    {"ESP_M", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"TRAP_TUMBLE", 1},
    {"TRAP_SCISSOR", 1},
    {"TRAP_BETOBETA", 1},
    {"TRAP_SIREN", 1},
    {"TRAP_SUMMON", 1},
    {"TRAP_HOLE", 1},
    {"TRAP_TURNTABLE", 1},
    {"TRAP_SLEEP", 1},
    {"TRAP_SEAL", 1},
    {"TRAP_MINE", 1},
    {"TRAP_BIGMINE", 1},
    {"STATE_SHIELD", 1},
    {"STATE_QUESTION", 1},
    {"STATE_SWING", 1},
    {"STATE_STIFF", 1},
    {"STATE_INVISIBLE", 1},
    {"STATE_BLIND_EYE", 1},
    {"STATE_DRY_UP", 1},
    {"STATE_PULL", 1},
    {"STATE_THROW", 1},
    {"STATE_QUAKE", 1},
    {"STATE_JUMP", 1},
    {"STATE_LV_DOWN", 1},
    {"STATE_REVIVE", 1},
    {"STATE_ESCAPE", 1},
    {"WEATHER_CLOUDY", 1},
    {"WEATHER_FOG", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"EVENT_FLY_01_L", 1},
    {"EVENT_FLY_02_L", 1},
    {"EVENT_FLY_03", 1},
    {"EVENT_EARTHQUAKE_01_L", 1},
    {"EVENT_MOTION_APPEAR_01", 1},
    {"EVENT_MOTION_JUMP_01", 1},
    {"EVENT_MOTION_JUMP_05", 1},
    {"EVENT_MOTION_JUMP_02", 1},
    {"EVENT_MOTION_JUMP_04", 1},
    {"EVENT_FLYAWAY_01", 1},
    {"EVENT_FLY_FIRE_01", 1},
    {"EVENT_SIGN_LAUGH_01", 1},
    {"EVENT_SIGN_LAUGH_01_L", 1},
    {"EVENT_SIGN_NOTICE_01", 1},
    {"EVENT_SIGN_NOTICE_02", 1},
    {"EVENT_SIGN_NOTICE_04", 1},
    {"EVENT_SIGN_NOTICE_03", 1},
    {"EVENT_SIGN_HATENA_01", 1},
    {"EVENT_SIGN_HATENA_02", 1},
    {"EVENT_SIGN_HATENA_03", 1},
    {"EVENT_SIGN_ASE_01", 1},
    {"EVENT_SIGN_ANGER_01", 1},
    {"EVENT_SIGN_ANGER_02", 1},
    {"EVENT_SIGN_SHOCK_01", 1},
    {"EVENT_MOTION_QUACK_01", 1},
    {"EVENT_MOTION_FEATHER_01", 1},
    {"EVENT_EFF_DIZZINESS_01", 1},
    {"EVENT_APPEAR_02", 1},
    {"EVENT_MOTION_JUMP_03", 1},
    {"EVENT_FLASH_02", 1},
    {"EVENT_SNEEZE", 1},
    {"EVENT_LIGHT_02", 1},
    {"EVENT_SIGN_SHOCK_02", 1},
    {"EVENT_FALL_01", 1},
    {"EVENT_LIGHT_03_L", 1},
    {"EVENT_INTERFERE_01", 1},
    {"EVENT_MOTION_HOLEUP_01", 1},
    {"EVENT_WHITEOUT_03", 1},
    {"EVENT_SHOOTINGSTAR", 1},
    {"EVENT_KESSYOU", 1},
    {"EVENT_FLY_09", 1},
    {"EVENT_FLASH_02_L", 1},
    {"EVENT_FLASH_03", 1},
    {"EVENT_FLASH_06", 1},
    {"EVENT_FLASH_04", 1},
    {"EVENT_FREEZE", 1},
    {NULL, 1},
    {"EVENT_DAMAGE_01", 1},
    {"EVENT_EARTHQUAKE_02", 1},
    {"EVENT_APPEAR_03", 1},
    {"EVENT_TELEPORT", 1},
    {"EVENT_POST", 1},
    {"EVENT_FLASH_01", 1},
    {"EVENT_FOOTSTEP_01", 1},
    {"EVENT_FLY_04", 1},
    {"EVENT_FOOTSTEP_02", 1},
    {"EVENT_WHITEOUT", 1},
    {"EVENT_WHITEOUT_04", 1},
    {"EVENT_SHOOTING_L", 1},
    {"EVENT_FALL_02", 1},
    {"EVENT_BOUND", 1},
    {"EVENT_LIGHTBALL_01", 1},
    {"EVENT_EARTHQUAKE_03_L", 1},
    {"EVENT_HAKAIKOUSEN", 1},
    {"EVENT_LIGHTBALL_02", 1},
    {"EVENT_MOTION_HARAHERI", 1},
    {"EVENT_MOTION_EAT_L", 1},
    {"EVENT_EXPLOSION_01", 1},
    {"EVENT_EFF_RAIN", 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {NULL, 1},
    {"SLEEP", 1},
    {"DIVE", 1},
    {"DIG", 1},
    {"EFF_LIGHT_WALL", 1},
    {"EFF_SURELY_HIT", 1},
    {"EFF_STRENGTH_UP", 1},
    {"HITPOINT_RECOVER", 1},
    {"SMALL_DAMAGE", 1},
    {"MIDDLE_DAMAGE", 1},
    {"DAMAGE_ENEMY_M", 1},
    {"EXTRA_LARGE_DAMAGE", 1},
    {"EFF_SWEET", 1},
    {"KAIHI_UP", 1},
    {"KAIHI_DOWN", 1},
    {"EFF_HEART", 1},
    {"EFF_RAIN", 1},
    {"EFF_RAY_1", 1},
    {"EFF_FLOWER_UP", 1},
    {"EFF_FLOWER_DOWN", 1},
    {"EFF_ICE_1", 1},
    {"EFF_INVOKE", 1},
    {"EFF_INVOKE_1", 1},
    {"EFF_ICE_BALL", 1},
    {"EFF_ICE_BREAK", 1},
    {"EFF_YAWN", 1},
    {"EFF_KISS", 1},
    {"EFF_SUN", 1},
    {"EFF_BUBLE", 1},
    {"EFF_BUBLE_BRK", 1},
    {"EFF_ENCORE", 1},
    {"EFF_ENCORE_2", 1},
    {"EFF_IAIGIRI", 1},
    {"EFF_SMOKE", 1},
    {"EFF_SMOKE_1", 1},
    {"EFF_SMOKE_2", 1},
    {"EFF_SMOKE_3", 1},
    {"EFF_SMOKE_4", 1},
    {"EFF_SMOKE_5", 1},
    {"EFF_SMOKE_7", 1},
    {"EFF_SMOKE_8", 1},
    {"EFF_SMOKE_9", 1},
    {"EFF_SMOKE_10", 1},
    {"EFF_ITYAMON", 1},
    {"EFF_WEB", 1},
    {"EFF_WEB_2", 1},
    {"EFF_PAIN", 1},
    {"EFF_PAIN1", 1},
    {"EFF_FANG", 1},
    {"EFF_BELL", 1},
    {"EFF_SNORE", 1},
    {"EFF_NOISE", 1},
    {"EFF_STONE", 1},
    {"EFF_STONE_2", 1},
    {"EFF_STONE_1", 1},
    {"EFF_WEATHER_1", 1},
    {"EFF_WEATHER_2", 1},
    {"EFF_WEATHER_3", 1},
    {"EFF_WHIRL", 1},
    {"EFF_SING", 1},
    {"EFF_CRY", 1},
    {"EFF_GRUDGEN", 1},
    {"EFF_AIR_CUT", 1},
    {"EFF_OVER", 1},
    {"EFF_OVER_2", 1},
    {"EFF_AURORA", 1},
    {"EFF_OKUTAN", 1},
    {"EFF_INSTIGATE", 1},
    {"EFF_SURPRISE", 1},
    {"EFF_SURPRISE_2", 1},
    {"EFF_FIRE_DAMAGE", 1},
    {"EFF_DEEP_GRUDGE", 1},
    {"EFF_BURN", 1},
    {"EFF_FIRE_3", 1},
    {"EFF_FIRE_4", 1},
    {"EFF_FIRE_5", 1},
    {"EFF_DETECT", 1},
    {"EFF_DETECT_2", 1},
    {"EFF_CORNER", 1},
    {"EFF_WIND", 1},
    {"EFF_TOUGH", 1},
    {"EFF_FIX", 1},
    {"EFF_WIND_1", 1},
    {"EFF_PATIENT", 1},
    {"EFF_CHEW", 1},
    {"EFF_BITE", 1},
    {"EFF_THUNDER", 1},
    {"EFF_THUNDER_D", 1},
    {"EFF_BIND_STONE", 1},
    {"EFF_CHOP", 1},
    {"EFF_SHELL_PLACES", 1},
    {"EFF_DRESSING", 1},
    {"EFF_MIDARE", 1},
    {"EFF_MITIZURE", 1},
    {"EFF_MIYABURU", 1},
    {"EFF_REBENJI", 1},
    {"EFF_RYUNOMAI", 1},
    {"EFF_WATABOUSI", 1},
    {"EFF_TWINES", 1},
    {"EFF_PUNCH", 1},
    {"EFF_GIGA_DRAIN", 1},
    {"EFF_MIRACULOUS", 1},
    {"EFF_POWER", 1},
    {"EFF_POWER_PUNCH", 1},
    {"EFF_BLASTBURN", 1},
    {"EFF_FEATHERDANCE", 1},
    {"EFF_FLASHU", 1},
    {"EFF_HITKAKU", 1},
    {"EFF_LEAFBLD", 1},
    {"EFF_MAMORU", 1},
    {"EFF_MARUKUNARU", 1},
    {"EFF_BOONRASH_HIT", 1},
    {"EFF_INVOKE_2", 1},
    {"EFF_BAKAJIKARA", 1},
    {"EFF_HAKIDASU", 1},
    {"EFF_HAMETUNONEGAI", 1},
    {"EFF_HASAMIGIROTIN", 1},
    {"EFF_HATAKIOTOSU", 1},
    {"EFF_MIZUASOBI", 1},
    {"EFF_NEGAIGOTO", 1},
    {"EFF_NOMIKOMU", 1},
    {"EFF_TOBIGERI", 1},
    {"EFF_TOSENBO", 1},
    {"EFF_TRYATTACK", 1},
    {"EFF_HASAMU", 1},
    {"EFF_SPORE", 1},
    {"EFF_SUCKING_BLOOD", 1},
    {"EFF_KIRISAKU", 1},
    {"EFF_CYOUHATU", 1},
    {"EFF_CYOUHATU_1", 1},
    {"EFF_DENGEKIHA", 1},
    {"EFF_DENGEKIHA_TAMA", 1},
    {"EFF_DENZIHOU", 1},
    {"EFF_DOROASOBI", 1},
    {"EFF_DOROASOBI_1", 1},
    {"EFF_DOROASOBI_2", 1},
    {"EFF_NEEDLEARM", 1},
    {"EFF_NEGOTO", 1},
    {"EFF_NEKONOTE", 1},
    {"EFF_NEOHARU", 1},
    {"EFF_NEOHARU_1", 1},
    {"EFF_SONICKBOOM", 1},
    {"EFF_TANEMASINGAN", 1},
    {"EFF_TUNODETUKU", 1},
    {"EFF_TURARABARI", 1},
    {"EFF_TURUGINOMAI", 1},
    {"EFF_TURUNOMUTI", 1},
    {"EFF_KUSABUE", 1},
    {"EFF_KUSUGURU", 1},
    {"EFF_HUMMER", 1},
    {"EFF_M_POWER", 1},
    {"EFF_WANA_DEL", 1},
    {"EFF_BLACK_FOG", 1},
    {"EFF_GENSI_POWER", 1},
    {"EFF_VOLTEKKA", 1},
    {"EFF_DAKURYUU", 1},
    {"EFF_NAMINORI", 1},
    {"EFF_JIKOANJI", 1},
    {"EFF_KONOYUBITOMARE", 1},
    {"EFF_YUBIWOFURU", 1},
    {"EFF_KOWAIKAO", 1},
    {"EFF_SIGNALBEAM", 1},
    {"EFF_SIROIKIRI", 1},
    {"EFF_SITADENAMERU", 1},
    {"EFF_SUKAIAPPA", 1},
    {"EFF_SUKETTI", 1},
    {"EFF_SUNAKAKE", 1},
    {"EFF_COSMO", 1},
    {"EFF_SAIKE", 1},
    {"EFF_KYUUSYUU", 1},
    {"EFF_SAIKE_BG", 1},
    {"EFF_SNOW", 1},
    {"EFF_PSYCHO_WAVE", 1},
    {"EFF_SAIMIN", 1},
    {"EFF_BOOST", 1},
    {"EFF_THUNDER_1", 1},
    {"EFF_STONE_3", 1},
    {"EFF_GURAD_S", 1},
    {"EFF_SAND", 1},
    {"EFF_CLOSS_CHOP", 1},
    {"EFF_SAND_HELL", 1},
    {"EFF_SMOG", 1},
    {"EFF_SAINT_FIRE", 1},
    {"EFF_SAINT_FIRE_D", 1},
    {"EFF_ICE_OBJ", 1},
    {"EFF_SOLAR", 1},
    {"EFF_SOLAR_1", 1},
    {"EFF_BOMB", 1},
    {"EFF_BIG_BOMB", 1},
    {"EFF_GODBARD", 1},
    {"EFF_KINZOKUON", 1},
    {"EFF_KOGOERUKAZE", 1},
    {"EFF_KOMELTUTOPANCHI", 1},
    {"EFF_KUROIMANAZASI", 1},
    {"EFF_SAWAGU", 1},
    {"EFF_SHADOWBOAL", 1},
    {"EFF_SIBIREGONA", 1},
    {"EFF_DOKUNOKONA", 1},
    {"EFF_NEMURIGONA", 1},
    {"EFF_SIOFUKI_UP", 1},
    {"EFF_SIOFUKI_DOWN", 1},
    {"EFF_SUPUNMAGE", 1},
    {"EFF_FIRE_3_BULLET", 1},
    {"EFF_FIRE_3_HIT", 1},
    {"EFF_TAKINOBORI", 1},
    {"EFF_G_THUNDER_02", 1},
    {"EFF_TAKUWAERU", 1},
    {NULL, 1},
    {"EFF_TANE_BULLET", 1},
    {"EFF_HATUGA", 1},
    {"EFF_KOUGOUSEI", 1},
    {"EFF_MOONLIGHT", 1},
    {"EFF_KAIFUKU", 1},
    {"EFF_TOBOE", 1},
    {"EFF_FUMITUKE", 1},
    {"EFF_MISTBALL", 1},
    {"EFF_SECRET_POWER", 1},
    {"EFF_HEDOROBAKUDAN", 1},
    {"EFF_HEDORO_AT", 1},
    {"EFF_BAKURETUPANCH", 1},
    {"EFF_BRAKECROW", 1},
    {"EFF_GINIRONOKAZE", 1},
    {"EFF_DAMASI", 1},
    {"EFF_TEXTURE2", 1},
    {"EFF_TEXTURE", 1},
    {"EFF_STARES", 1},
    {"EFF_PAPPACUTER", 1},
    {"EFF_HOTARUBI", 1},
    {"EFF_SMOKE_UP", 1},
    {"EFF_FUBUKI", 1},
    {"EFF_FUBUKI_BRK", 1},
    {"EFF_TYAKUSUI", 1},
    {"EFF_SMALL_BOMB", 1},
    {"EFF_LEEF_CUTER", 1},
    {"EFF_EGG", 1},
    {"EFF_ANGEL_KISS", 1},
    {"EFF_BIRUDOUP", 1},
    {"EFF_MAGICAL_LEEF", 1},
    {"EFF_MAGICAL_LEEF_BULLET", 1},
    {"EFF_WATER_WAVE", 1},
    {"EFF_MINEUTI", 1},
    {"EFF_MEISOU", 1},
    {"EFF_MEGAKICK", 1},
    {"EFF_TORNADO", 1},
    {"EFF_TSUPPARI", 1},
    {"EFF_TEDASUKE", 1},
    {"EFF_BARRIA", 1},
    {"EFF_POISON_BUBBLE", 1},
    {"EFF_TRYATTACK_HIT", 1},
    {"EFF_FIRE_STORM", 1},
    {"EFF_SMALL_FIRE_DAMAGE", 1},
    {"EFF_BARRIA_1", 1},
    {"EFF_BARRIA_2", 1},
    {"EFF_BARRIA_3", 1},
    {"EFF_BARRIA_4", 1},
    {"EFF_DORIRU", 1},
    {"EFF_QUESTION", 1},
    {"EFF_NIGHTHEAD", 1},
    {"EFF_BEAUTIFUL_W", 1},
    {"EFF_NEPUU", 1},
    {"EFF_WATER_BULLET", 1},
    {"EFF_WATER_BREAK", 1},
    {"EFF_BULLET_1", 1},
    {"EFF_BULLET_2", 1},
    {"EFF_BULLET_3", 1},
    {"EFF_BULLET_4", 1},
    {"EFF_BULLET_5", 1},
    {"EFF_BULLET_6", 1},
    {"EFF_HYPER_VOICE", 1},
    {"EFF_DANCING_FLOWER", 1},
    {"EFF_BELLY", 1},
    {"EFF_HISSATUMAE", 1},
    {"EFF_PIYOPIYO", 1},
    {"EFF_FURAFURA", 1},
    {"EFF_BREIZEKICK", 1},
    {"EFF_DEATH_SONG", 1},
    {"EFF_MILK", 1},
    {"EFF_YOUKAIEKI", 1},
    {"EFF_RASTAPARGE", 1},
    {"EFF_ROCKBLAST", 1},
    {"EFF_THREE_WAY", 1},
    {"EFF_EIGHT_WAY", 1},
    {"EFF_LOOK_TRAP", 1},
    {"EFF_STAFF_BULLET", 1},
    {"EFF_STAFF_BULLET2", 1},
    {"EFF_WARP", 1},
    {"EFF_STAN", 1},
    {"EFF_DRY", 1},
    {"EFF_CALL", 1},
    {"EFF_TOUMEI", 1},
    {"EFF_SINKUU", 1},
    {"EFF_ENTOU", 1},
    {"EFF_NOROI", 1},
    {"EFF_NOROI1", 1},
    {"EFF_MUD_TRAP", 1},
    {"EFF_CALL_TRAP", 1},
    {"EFF_MUD_TRAP_1", 1},
    {"EFF_WIND_TRAP", 1},
    {"EFF_TURN", 1},
    {"EFF_SLEEP_TRAP", 1},
    {"EFF_POISON_NEEDLE_TRAP", 1},
    {"EFF_MALON_TRAP", 1},
    {"EFF_SPEED_DOWN", 1},
    {"EFF_SPEED_UP", 1},
    {"EFF_HITS_UP", 1},
    {"EFF_HITS_DOWN", 1},
    {"EFF_DEFENCE_UP", 1},
    {"EFF_DEFENCE_DOWN", 1},
    {"EFF_SPDEFE_UP", 1},
    {"EFF_SPDEFE_DOWN", 1},
    {"EFF_SPAT_UP", 1},
    {"EFF_SPAT_DOWN", 1},
    {"EFF_AT_DOWN", 1},
    {"EFF_EAT_FOOD", 1},
    {"EFF_EAT_GUMI", 1},
    {"EFF_EAT_FRUIT", 1},
    {"EFF_DRINK", 1},
    {"EFF_EQUIP", 1},
    {"EFF_EQUIP_OUT", 1},
    {"EFF_USE_MACHINE", 1},
    {"EFF_USE_SECRET_MACHINE", 1},
    {"EFF_USE_KEY", 1},
    {"EFF_USE_KEY_AFTER", 1},
    {"EFF_BRK_STONE", 1},
    {"EFF_BOMB_FRUIT", 1},
    {"EFF_BOMB_2", 1},
    {"EFF_THUNDER_3", 1},
    {"EFF_HIRAISINN", 1},
    {"EFF_PARRIZE", 1},
    {"EFF_SMOKE_11", 1},
    {"EFF_AT_UP", 1},
    {"EFF_ATSPEED_DOWN", 1},
    {"EFF_ATSPEED_UP", 1},
    {"EFF_PAIN_2", 1},
    {"EFF_EXCLAMATION2", 1},
    {"EFF_SENRIGAN", 1},
    {"EFF_JIGOKUMIMI", 1},
    {"EFF_TRICK_DOWN", 1},
    {"EFF_TRICK_UP", 1},
    {"EFF_ICE_ON", 1},
    {"EFF_MUD_TRAP_2", 1},
};
