










static const struct ScriptCommand s_gs220_g0_s0_station_sref_script[] = { /* 0x826aa0c */
    DEBUGINFO,
    SELECT_MAP(220),
    BGM_STOP,
    JUMP_SCRIPT(COMMON_ENTER),
};

static const struct ScriptRef s_gs220_g0_s0_station_sref = { 404, 1, NULL /* ENTER_CONTROL */, s_gs220_g0_s0_station_sref_script }; /* 0x826aa78 */

static const struct ScriptCommand s_gs220_g1_s0_station_sref_script[] = { /* 0x826aa84 */
    DEBUGINFO,
    SELECT_MAP(220),
    SELECT_ENTITIES(-1, 0),
    BGM_SWITCH(114),
    { 0x22, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    BGM_FADEOUT(90),
    { 0x23, 0x01,  0x005a,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    RET,
};

static const struct ScriptRef s_gs220_g1_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs220_g1_s0_station_sref_script }; /* 0x826ab24 */

static const struct ScriptCommand s_gs220_g1_s0_eff0_script[] = { /* 0x826ab30 */
    DEBUGINFO,
    { 0x99, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x98, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x48,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    END_DELETE,
};

static const struct ScriptCommand s_gs220_g1_s0_lives0_dlg0[] = { /* 0x826abb0 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0003,  0x00000052,  0x00000000, NULL },
    { 0xdf, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x78,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x03,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Kekeh!\nWe're here at last!") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" This is it?\nThis is the deepest floor of the\n{COLOR YELLOW_D}Murky Cave{RESET}?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    FANFARE_PLAY2(465),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0002,  0x00000041,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Oh, look!{WAIT_PRESS}\nThere's a dais!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x6b, 0x00,  0x0100,  0x00000000,  0x00000000, NULL },
    WAIT(15),
    { 0x2e, 0x15,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" There's a hollow spot.\nI guess that stone goes in there.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY2(348),
    { 0x32, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}{NAME_2} placed the {COLOR GREEN_I}9-Tail Crest{RESET}\n{CENTER_ALIGN}in the hollow spot.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    BGM_STOP,
    FANFARE_PLAY2(502),
    { 0x28, 0x01,  0x0005,  0x00000004,  0x00ffffff, NULL },
    WAIT(4),
    { 0x27, 0x00,  0x0005,  0x00000004,  0x00ffffff, NULL },
    WAIT(20),
    FANFARE_PLAY2(502),
    { 0x28, 0x01,  0x0005,  0x00000004,  0x00ffffff, NULL },
    WAIT(4),
    { 0x27, 0x00,  0x0005,  0x00000004,  0x00ffffff, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(45),
    FANFARE_PLAY2(506),
    { 0x28, 0x01,  0x0005,  0x0000001e,  0x00ffffff, NULL },
    WAIT(60),
    { 0x27, 0x00,  0x0005,  0x0000001e,  0x00ffffff, NULL },
    WAIT(120),
    { 0x2e, 0x15,  0x0002,  0x00000044,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" ............") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" ........................") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" ....................................") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Kekeh!\nWhat's this about?\nNothing's happening?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    FANFARE_PLAY2(463),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" ............?{WAIT_PRESS}\nHuh? I thought I heard something...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Kekeh!\nDid you just say something?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    FANFARE_PLAY2(468),
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    WAIT(5),
    FANFARE_PLAY2(468),
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0002,  0x00000044,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" That's odd...\nI could've sworn I heard something...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}...Wel...co...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}...W...e...lc...ome...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(45),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}Welcome to\n{CENTER_ALIGN}the Murky Cave!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY2(469),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x08,  0x0001,  0x00000002,  0x00000000, NULL },
    WAIT(10),
    FANFARE_PLAY2(469),
    { 0x91, 0x08,  0x0002,  0x00000006,  0x00000000, NULL },
    WAIT(10),
    { 0x91, 0x08,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" What? What?!\nWhere is that voice coming from?") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Who are you?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    BGM_SWITCH(6),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}I am the\n{CENTER_ALIGN}judge of darkness.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}You have nothing to fear from me.\n{CENTER_ALIGN}I mean you no harm.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}Just now, a key was\n{CENTER_ALIGN}inserted to break a curse.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}The curse...\n{CENTER_ALIGN}It is the one on {NAME_3}?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2e, 0x15,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Kekeh! Exactly!{WAIT_PRESS}\nPlease lift the curse now!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}I cannot allow that right away.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}I must first know if you\n{CENTER_ALIGN}have earned the right.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}I must evaluate you.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}You must bare your\n{CENTER_ALIGN}true feelings to me.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Kekeh? What?{WAIT_PRESS}\nYou're going to test me?") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" What, I have to fight some\nboss creature?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}Oh, no.\n{CENTER_ALIGN}Nothing so barbaric.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}All that I need is for some\n{CENTER_ALIGN}questions to be answered.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}However...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    FANFARE_PLAY2(502),
    { 0x28, 0x01,  0x0005,  0x00000004,  0x00ffffff, NULL },
    WAIT(4),
    { 0x27, 0x00,  0x0005,  0x00000004,  0x00ffffff, NULL },
    WAIT(20),
    FANFARE_PLAY2(502),
    { 0x28, 0x01,  0x0005,  0x00000004,  0x00ffffff, NULL },
    WAIT(4),
    { 0x27, 0x00,  0x0005,  0x00000004,  0x00ffffff, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0002,  0x00000046,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Gegeh?! What the...?!{WAIT_PRESS}\nI can't move!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}{NAME_2}, you will not\n{CENTER_ALIGN}be doing the answering...") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}{NAME_0}.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    FANFARE_PLAY2(465),
    CALL_SCRIPT(NOTICE_FUNC),
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    WAIT(30),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}{NAME_0}.\n{CENTER_ALIGN}You will answer.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x6b, 0x00,  0x0080,  0x00000001,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY2(473),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Gegegeh!\nWhat are you saying?!") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Why is someone else\nspeaking for me?!") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Let me do it!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}{NAME_2}.{WAIT_PRESS}\n{CENTER_ALIGN}Your heart is interwoven\n{CENTER_ALIGN}with conflicting emotions.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}You will probably never show\n{CENTER_ALIGN}the truth within your heart.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Kekeh?!\nWhat?!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}{NAME_0} will enter\n{CENTER_ALIGN}{NAME_2}'s heart.") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}Please navigate carefully\n{CENTER_ALIGN}through {NAME_2}'s emotions.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
};

















static const struct ScriptCommand s_gs220_g1_s0_lives1_dlg0[] = { /* 0x826be2c */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x70,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x18,  0x0080,  0x00000004,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x6b, 0x00,  0x0100,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x08,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x62, 0x00,  0x0100,  0x00000000,  0x00000010, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    CALL_SCRIPT(LOOK_AROUND_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(LOOK_AROUND_FUNC),
    { 0x62, 0x00,  0x0100,  0x00000000,  0x00000018, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY2(623),
    { 0x56, 0x00,  0x0000,  0x000001a2,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(20),
    FANFARE_PLAY2(465),
    CALL_SCRIPT(SHOCK_FUNC),
    { 0x54, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SHOCK_FUNC),
    { 0x54, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(15),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    WAIT(20),
    { 0x54, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs220_g2_s0_station_sref_script[] = { /* 0x826c1ac */
    DEBUGINFO,
    SELECT_MAP(220),
    SELECT_ENTITIES(-1, 0),
    { 0x27, 0x01,  0x0005,  0x0000005a,  0x00ffffff, NULL },
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x23, 0x01,  0x0078,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    RET,
};

static const struct ScriptRef s_gs220_g2_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs220_g2_s0_station_sref_script }; /* 0x826c22c */

static const struct ScriptCommand s_gs220_g2_s0_eff0_script[] = { /* 0x826c238 */
    DEBUGINFO,
    { 0x98, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs220_g2_s0_lives0_dlg0[] = { /* 0x826c278 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0004,  0x00000021,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0003,  0x00000052,  0x00000000, NULL },
    { 0xdf, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(80),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}{NAME_2}.\n{CENTER_ALIGN}Whether you have the right\n{CENTER_ALIGN}to break the curse or not...") },
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}I will now render\n{CENTER_ALIGN}my judgment.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}The curse...{WAIT_PRESS}\n{CENTER_ALIGN}could not be lifted.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x03,  0x0002,  0x00000043,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" W-wait...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}It is most regrettable, but\n{CENTER_ALIGN}the curse on {NAME_3}\n{CENTER_ALIGN}will last all eternity...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Wait!\nWait a minute!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    FANFARE_PLAY2(666),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(120),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x6a, 0x00,  0x0100, -0x00000018,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    WAIT(20),
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Let me...{WAIT_PRESS}\nLet me say something!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    BGM_FADEIN(60, 24),
    WAIT(60),
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" It's true.\nI abandoned {NAME_3} and ran.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" I was afraid that the curse\nwould fall on me.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" I had to get away, no matter\nwhat...{WAIT_PRESS}\nThat's what I thought.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" It didn't take long for me\nto forget about the curse and about\n{NAME_3}.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x2e, 0x15,  0x0002,  0x00000044,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Many long years passed...") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" But {NAME_3}...{WAIT_PRESS}\nShe never forgot about me.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" One night...{WAIT_PRESS}\nIn {NAME_4}'s dream, {NAME_3}\nsaid this...") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" That she considered me an\nirreplaceable friend, and that she still\nbelieved we would meet again...") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" {NAME_3} kept thinking\nabout someone like me.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x2e, 0x15,  0x0002,  0x00000045,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" But I...\nHow selfish I was.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" I lived carefree all this\ntime...{WAIT_PRESS}\nI realize now how selfish I was.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" It's not just {NAME_3}.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" {COLOR CYAN}Team {TEAM_NAME}{RESET} put up\nwith my selfishness and brought me here.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" I finally know what I was\nmissing.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" What I lacked...{WAIT_PRESS}\nIt was something for the others...{WAIT_PRESS}\nA sense of gratitude.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(120),
    BGM_STOP,
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY2(686),
    WAIT(15),
    FANFARE_PLAY2(686),
    WAIT(15),
    FANFARE_PLAY2(686),
    WAIT(15),
    FANFARE_PLAY2(686),
    WAIT(15),
    FANFARE_PLAY2(686),
    WAIT(15),
    FANFARE_PLAY2(686),
    WAIT(15),
    FANFARE_PLAY2(686),
    WAIT(15),
    FANFARE_PLAY2(686),
    WAIT(15),
    FANFARE_PLAY2(631),
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(LOOK_AROUND_FUNC),
    WAIT(15),
    { 0x33, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}The lock bearing the curse...{WAIT_PRESS}\n{CENTER_ALIGN}It has opened.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    FANFARE_PLAY2(506),
    { 0x28, 0x01,  0x0005,  0x0000001e,  0x00ffffff, NULL },
    WAIT(90),
    SELECT_ENTITIES(-1, 1),
    { 0x27, 0x01,  0x0005,  0x0000001e,  0x00ffffff, NULL },
    WAIT(30),
    FANFARE_PLAY2(465),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0002,  0x00000046,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Ga-{NAME_3}!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    BGM_FADEIN(60, 5),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" It worked, {NAME_2}!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0002,  0x00000044,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" N-{NAME_5}!") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" ...But...\nI don't know what you're saying...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" The curse has been broken.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" I cast my curse, enraged at\nyour twisted heart.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" When your heart gained\nwhat it had been missing...\nThe curse was shattered.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" The final key to break the\ncurse...{WAIT_PRESS}\nwas your sense of gratitude.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Then, Gardevoir...?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" You may be reassured.\n{NAME_3} has returned.{WAIT_PRESS}\nShe will soon awaken.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" However...{WAIT_PRESS}\nThat you were her partner in the past...") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" {NAME_3} will have no\nrecollection of that.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" ............{WAIT_PRESS}That doesn't matter.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" {NAME_3} is back.{WAIT_PRESS}\nThat's enough for me...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
};












static const struct ScriptCommand s_gs220_g2_s0_lives1_dlg0[] = { /* 0x826d210 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(15),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    WAIT(20),
    { 0x54, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000001a2,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000001a3,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(45),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x20,  0x0080,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(12),
    CALL_SCRIPT(LOOK_AROUND_FUNC),
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x10,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY2(465),
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs220_g2_s0_eff1_script[] = { /* 0x826d470 */
    DEBUGINFO,
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000001a4,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    END_DELETE,
};

static const struct ScriptCommand s_gs220_g2_s1_lives0_dlg0[] = { /* 0x826d4d0 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0016,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs220_g2_s1_lives1_dlg0[] = { /* 0x826d510 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0x6b, 0x00,  0x00b3,  0x00000002,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct GroundLivesData s_gs220_g1_s0_lives[] = { /* 0x826d590 */
    /*  0 */ {   0,   4,   0,   0, {  23,  47, 0, CPOS_HALFTILE }, {
        [0] = s_gs220_g1_s0_lives0_dlg0,
    } },
    /*  1 */ {  91,   4,   0,   0, {  29,  45, 0, CPOS_HALFTILE }, {
        [0] = s_gs220_g1_s0_lives1_dlg0,
    } },
};

static const struct GroundLivesData s_gs220_g2_s0_lives[] = { /* 0x826d5c0 */
    /*  0 */ {   0,   4,   0,   0, {  25,  19, CPOS_HALFTILE, CPOS_HALFTILE }, {
        [0] = s_gs220_g2_s0_lives0_dlg0,
    } },
    /*  1 */ {  91,   4,   0,   0, {  25,  23, CPOS_HALFTILE, CPOS_HALFTILE }, {
        [0] = s_gs220_g2_s0_lives1_dlg0,
    } },
};

static const struct GroundLivesData s_gs220_g2_s1_lives[] = { /* 0x826d5f0 */
    /*  0 */ {  82,   0,   0,   0, {  25,  16, CPOS_HALFTILE, CPOS_HALFTILE }, {
        [0] = s_gs220_g2_s1_lives0_dlg0,
    } },
    /*  1 */ {  99,   7,   0,   0, {  25,  35, CPOS_HALFTILE, CPOS_HALFTILE }, {
        [0] = s_gs220_g2_s1_lives1_dlg0,
    } },
};

static const struct GroundEffectData s_gs220_g1_s0_effs[] = { /* 0x826d620 */
    /*  0 */ {   0,   0,   1,   1, {  25,  30, CPOS_HALFTILE, CPOS_HALFTILE }, s_gs220_g1_s0_eff0_script },
};

static const struct GroundEffectData s_gs220_g2_s0_effs[] = { /* 0x826d62c */
    /*  0 */ {   0,   0,   1,   1, {  25,  21, CPOS_HALFTILE, CPOS_HALFTILE }, s_gs220_g2_s0_eff0_script },
    /*  1 */ {   4,   0,   1,   1, {  26,  21, 0, CPOS_HALFTILE }, s_gs220_g2_s0_eff1_script },
};

static const struct ScriptRef * const (sStationScripts[]) = { /* 0x826d644 */
    &s_gs220_g0_s0_station_sref,
    &s_gs220_g1_s0_station_sref,
    &s_gs220_g2_s0_station_sref,
};

static const struct GroundScriptSector s_gs220_g0_sectors[] = { /* 0x826d650 */
    { 0,NULL, 0,NULL, 0,NULL, 0,NULL, 1,&sStationScripts[0], },
};

static const struct GroundScriptSector s_gs220_g1_sectors[] = { /* 0x826d678 */
    { LPARRAY(s_gs220_g1_s0_lives), 0,NULL, LPARRAY(s_gs220_g1_s0_effs), 0,NULL, 1,&sStationScripts[1], },
};

static const struct GroundScriptSector s_gs220_g2_sectors[] = { /* 0x826d6a0 */
    { LPARRAY(s_gs220_g2_s0_lives), 0,NULL, LPARRAY(s_gs220_g2_s0_effs), 0,NULL, 1,&sStationScripts[2], },
    { LPARRAY(s_gs220_g2_s1_lives), 0,NULL, 0,NULL, 0,NULL, 0,NULL, },
};

static const struct GroundScriptGroup s_gs220_groups[] = { /* 0x826d6f0 */
    { LPARRAY(s_gs220_g0_sectors) },
    { LPARRAY(s_gs220_g1_sectors) },
    { LPARRAY(s_gs220_g2_sectors) },
};

static const struct GroundLink s_gs220_links[] = { /* 0x826d708 */
    /* link   0 */ { { /*x*/  23, /*y*/  22, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   1 */ { { /*x*/  25, /*y*/  19, /*flags*/ CPOS_HALFTILE, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   2 */ { { /*x*/  25, /*y*/  24, /*flags*/ CPOS_HALFTILE, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
};

/*extern*/ const struct GroundScriptHeader gGroundScript_gs220 = { LPARRAY(s_gs220_groups), s_gs220_links }; /* 0x826d720 */
