


















static const struct ScriptCommand s_gs171_g0_s0_station_sref_script[] = { /* 0x821f9bc */
    DEBUGINFO,
    SELECT_MAP(171),
    BGM_STOP,
    JUMP_SCRIPT(COMMON_ENTER),
};

static const struct ScriptRef s_gs171_g0_s0_station_sref = { 404, 1, NULL /* ENTER_CONTROL */, s_gs171_g0_s0_station_sref_script }; /* 0x821fa28 */

static const struct ScriptCommand s_gs171_g1_s0_station_sref_script[] = { /* 0x821fa34 */
    DEBUGINFO,
    SELECT_MAP(171),
    SELECT_ENTITIES(-1, 0),
    BGM_SWITCH(19),
    { 0x27, 0x00,  0x0005,  0x00000020,  0x00ffffff, NULL },
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x23, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    RET,
};

static const struct ScriptRef s_gs171_g1_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs171_g1_s0_station_sref_script }; /* 0x821fab4 */

static const struct ScriptCommand s_gs171_g1_s0_eff0_script[] = { /* 0x821fac0 */
    DEBUGINFO,
    { 0x99, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x98, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x89, 0xa0,  0x0180,  0x00000004,  0x00000000, NULL },
    { 0x3b, 0x38,  0x0000,  0x00000001,  0x00000000, NULL },
    WAIT(60),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g1_s0_lives0_dlg0[] = { /* 0x821fb60 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x3b, 0x38,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xdf, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x34, 0x00,  0x0000,  0x00000000,  0x00000000, _(" From the sky!\nComes a star!") },
    { 0x34, 0x00,  0x0000,  0x00000000,  0x00000000, _(" ...It is huge...{WAIT_PRESS}\nA giant of a star!") },
    { 0x34, 0x00,  0x0000,  0x00000000,  0x00000000, _(" The star, it falls.\nIt falls straight to us.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
};


static const struct ScriptCommand s_gs171_g2_s0_station_sref_script[] = { /* 0x821fcb8 */
    DEBUGINFO,
    SELECT_MAP(171),
    SELECT_ENTITIES(-1, 0),
    BGM_SWITCH(19),
    { 0x22, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x28, 0x01,  0x0005,  0x00000020,  0x00ffffff, NULL },
    RET,
};

static const struct ScriptRef s_gs171_g2_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs171_g2_s0_station_sref_script }; /* 0x821fd38 */

static const struct ScriptCommand s_gs171_g2_s0_eff0_script[] = { /* 0x821fd44 */
    DEBUGINFO,
    { 0x59, 0x00,  0x0000, -0x000000e0,  0x00000000, NULL },
    { 0x98, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x70,  0x0200,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    END_DELETE,
};

static const struct ScriptCommand s_gs171_g2_s0_lives0_dlg0[] = { /* 0x821fdc4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xdf, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x2e, 0x00,  0x0000, -0x00000002,  0x00000000, NULL },
    { 0x34, 0x00,  0x0000,  0x00000000,  0x00000000, _(" Disasters in nature...\nThere were many...") },
    { 0x34, 0x00,  0x0000,  0x00000000,  0x00000000, _(" The balance of the world,\nit has been upset...") },
    { 0x34, 0x00,  0x0000,  0x00000000,  0x00000000, _(" All because of the star.\nThe star that slowly comes closer.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x2e, 0x02,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0000,  0x00000000,  0x00000000, _(" ...If it keeps coming...\nIt will crash into this world.{WAIT_PRESS}\nIt shall be terrible.") },
    { 0x34, 0x00,  0x0000,  0x00000000,  0x00000000, _(" Something must be done...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
};


static const struct ScriptCommand s_gs171_g3_s0_station_sref_script[] = { /* 0x8220004 */
    DEBUGINFO,
    BGM_FADEOUT(30),
    WAIT(60),
    SELECT_MAP(171),
    SELECT_ENTITIES(-1, 0),
    BGM_SWITCH(19),
    { 0x22, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x23, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    RET,
};

static const struct ScriptRef s_gs171_g3_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs171_g3_s0_station_sref_script }; /* 0x82200a4 */

static const struct ScriptCommand s_gs171_g3_s0_lives0_dlg0[] = { /* 0x82200b0 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xdf, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x68,  0x0100,  0x00000004,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0e,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0002,  0x00000000,  0x00000002, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Ah, good of you to come.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" Kwaaaaaaaaaah!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY2(465),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    WAIT(30),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0x2e, 0x02,  0x0001,  0x0000000c,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Wh-{WAIT_PRESS}what's going on?{WAIT_PRESS}\nWhat is {NAME_3} doing?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" It is almost ready.{WAIT_PRESS}\nThe {COLOR GREEN}Teleport Gem{RESET}...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Teleport Gem?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" Kwaaaaaaaaaah!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    FANFARE_PLAY2(489),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" .........{WAIT_PRESS}It is made.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" This...\nThis is the {COLOR GREEN}Teleport Gem{RESET}.") },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" This will deliver you\nto the world of the sky.") },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" Now, {NAME_0}.{WAIT_PRESS}\nAccept!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x84, 0x00,  0x0100, -0x00000018, -0x00000018, NULL },
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY(212),
    { 0x32, 0x00, -0x0001,  0x00000000,  0x00000000, _("{CENTER_ALIGN}{NAME_0}'s team received\n{CENTER_ALIGN}the {COLOR GREEN}Teleport Gem{RESET}.") },
    { 0xe1, 0x00,  0x00d4,  0x00000000,  0x00000000, NULL },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x84, 0x00,  0x0100,  0x00000018,  0x00000018, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    WAIT(30),
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" That was made using\nthe powers of psychics.") },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" By me, {NAME_2},\nand...{WAIT_PRESS}\nOh?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" A Ghost-type Pokémon.\nWe received help from it.") },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" ...Gone away, it seems...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x93, 0x04,  0x000a,  0x00000022,  0x00000000, NULL },
    WAIT(30),
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Who could it be?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0002,  0x00000042,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Hahaha! It must be bashful.\nLet it be.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Now...{WAIT_PRESS}\nI must ask you this one last time.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" This journey will be fraught\nwith considerable danger.{WAIT_PRESS}\nWill you still go?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2e, 0x15,  0x0001,  0x00000000,  0x00000000, NULL },
    MSG_VAR(2, PARTNER_TALK_KIND, 1),
    VARIANT(/* == */  1, _(" You bet we will!")),
    VARIANT(/* == */  1, _(" We need to see Rayquaza\nand ask it to blow up that falling\nstar, right?")),
    VARIANT(/* == */  1, _(" If that's what's going to\nbring back peace, I'm not going to think\ntwice about giving up my life!")),
    VARIANT(/* == */  1, _(" That's what I want to\nmake happen.")),
    VARIANT(/* == */  3, _(" Of course!")),
    VARIANT(/* == */  3, _(" We have to persuade\nRayquaza to destroy that falling star.")),
    VARIANT(/* == */  3, _(" If that will bring peace,\nI'm willing to give up my life.")),
    VARIANT(/* == */  3, _(" That's my wish.")),
    VARIANT_DEFAULT(_(" Of course we will!")),
    VARIANT_DEFAULT(_(" We have to get Rayquaza\nto destroy that falling star, right?")),
    VARIANT_DEFAULT(_(" If that will bring peace,\nI'll gladly give my life for it!")),
    VARIANT_DEFAULT(_(" That's my wish.")),
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2e, 0x03,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(...Yes...{WAIT_PRESS}\nAnd when that wish comes true...)") },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(Gardevoir said...)") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
};












static const struct ScriptCommand s_gs171_g3_s0_lives1_dlg0[] = { /* 0x8220df0 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0001,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x68,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_SURPRISE_FUNC),
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x93, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g3_s0_lives2_dlg0[] = { /* 0x8220f50 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x0a,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g3_s0_lives3_dlg0[] = { /* 0x8221070 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x08,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(LOOK_AROUND_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g3_s0_lives4_dlg0[] = { /* 0x8221180 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x60,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g3_s0_eff1_script[] = { /* 0x82211e0 */
    DEBUGINFO,
    { 0x59, 0x00, -0x0001,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x00000069,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x0000006a,  0x00000000, NULL },
    WAIT(120),
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x0000006b,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x0000006c,  0x00000000, NULL },
    WAIT(60),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x70,  0x0033,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g4_s0_station_sref_script[] = { /* 0x8221360 */
    DEBUGINFO,
    SELECT_MAP(171),
    SELECT_ENTITIES(-1, 0),
    BGM_SWITCH(19),
    { 0x22, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x23, 0x01,  0x003c,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    RET,
};

static const struct ScriptRef s_gs171_g4_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs171_g4_s0_station_sref_script }; /* 0x82213f0 */

static const struct ScriptCommand s_gs171_g4_s0_lives0_dlg0[] = { /* 0x82213fc */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xdf, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x2e, 0x03,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(............)") },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(This will be my last adventure...{WAIT_PRESS}\nWith {NAME_1}...)") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000006,  0x00000000, NULL },
    MSG_VAR(2, PARTNER_TALK_KIND, 1),
    VARIANT(/* == */  1, _(" {NAME_0}!\nLet's do this right!")),
    VARIANT_DEFAULT(_(" {NAME_0}!\nLet's get this done!")),
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x54, 0x00,  0x002f,  0x00000000,  0x00000000, NULL },
    { 0xdd, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0e,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0002,  0x00000000,  0x00000002, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" We're counting on you!\n{NAME_1}! {NAME_0}!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    FANFARE_PLAY2(500),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    CJUMP_UNK_C6(10),
    COND_EQUAL(0, /* to label */ 3),
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
  LABEL(3), /* = 0x03 */
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x59, 0x00,  0x0000, -0x000000c8,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    BGM_FADEOUT(90),
    WAIT(30),
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
};




static const struct ScriptCommand s_gs171_g4_s0_lives1_dlg0[] = { /* 0x8221794 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0001,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x93, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    WAIT(120),
    { 0x89, 0x10,  0x0100,  0x00000002,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x59, 0x00,  0x0000, -0x000000c8,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g4_s0_lives2_dlg0[] = { /* 0x8221864 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g4_s0_lives3_dlg0[] = { /* 0x8221904 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g4_s0_lives4_dlg0[] = { /* 0x8221944 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x52, 0x00,  0x0000,  0x00010000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(120),
    { 0x89, 0x10,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0x89, 0x08,  0x0100,  0x00000002,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0x59, 0x00,  0x0000, -0x000000c8,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g4_s0_eff1_script[] = { /* 0x8221a04 */
    DEBUGINFO,
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x52, 0x00,  0x0000,  0x00020000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000000a5,  0x00000000, NULL },
    WAIT(180),
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x000000a6,  0x00000000, NULL },
    WAIT(120),
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g4_s0_eff2_script[] = { /* 0x8221ad4 */
    DEBUGINFO,
    { 0x59, 0x00,  0x0000, -0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000000a0,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000000a1,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x000000a4,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g4_s0_eff3_script[] = { /* 0x8221bc4 */
    DEBUGINFO,
    { 0x59, 0x00,  0x0000, -0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000000a0,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000000a1,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x000000a4,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g4_s0_eff4_script[] = { /* 0x8221cb4 */
    DEBUGINFO,
    { 0x59, 0x00,  0x0000, -0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000000a0,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000000a1,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x000000a4,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_station_sref_script[] = { /* 0x8221da4 */
    DEBUGINFO,
    { 0x3b, 0x39,  0x0001,  0x00000000,  0x00000000, NULL },
    SELECT_MAP(171),
    SELECT_ENTITIES(5, 0),
    BGM_STOP,
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    BGM_SWITCH(41),
    { 0x23, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    RET,
};

static const struct ScriptRef s_gs171_g5_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs171_g5_s0_station_sref_script }; /* 0x8221e34 */

static const struct ScriptCommand s_gs171_g5_s0_eff0_script[] = { /* 0x8221e40 */
    DEBUGINFO,
    { 0x99, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x98, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x24,  0x0200,  0x00000004,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x40,  0x0100,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    END_DELETE,
};

static const struct ScriptCommand s_gs171_g5_s0_lives0_dlg0[] = { /* 0x8221f00 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0034,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0001,  0x00000007,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0002,  0x00000058,  0x00000000, NULL },
    WAIT(30),
    { 0x34, 0x00, -0x0001,  0x00000000,  0x00000000, _(" .........Hey.") },
    { 0x34, 0x00, -0x0001,  0x00000000,  0x00000000, _(" ...Hey, can you hear...") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Snap out of it!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x27, 0x01,  0x0005,  0x0000003c,  0x00ffffff, NULL },
    WAIT(60),
    { 0x2e, 0x02,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(...{WAIT_PRESS}Huh...?{WAIT_PRESS} This place...)") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x3b, 0x39,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    FANFARE_PLAY2(465),
    CALL_LABEL(3),
    WAIT(30),
    { 0x2e, 0x03,  0x0001,  0x00000002,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _("............Urgggh......") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _("...Regained consciousness!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00, -0x0001,  0x00000000,  0x00000000, _(" Oooooooohhhhh!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(WAKEUP_FUNC),
    WAIT(15),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(...{WAIT_PRESS}I'm sure of it...)") },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(I'm sure... Back there...{WAIT_PRESS}\nGengar saved me...)") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x93, 0x04,  0x000a,  0x00000022,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" ...Maybe...{WAIT_PRESS}\nDid Gengar save {NAME_0} too?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    CALL_LABEL(3),
    WAIT(30),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0e,  0x0004,  0x00000042,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0004, -0x00000003,  0x00000000, NULL },
    { 0x34, 0x00,  0x0004,  0x00000000,  0x00000000, _(" Awesome, you're alive!{WAIT_PRESS}\nYou really had all of us worried!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2e, 0x0c,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0008,  0x00000000,  0x00000000, _(" You were incredible!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x02,  0x0006,  0x00000042,  0x00000000, NULL },
    { 0x34, 0x00,  0x0006,  0x00000000,  0x00000000, _(" Snivel...\nI'm so glad you're safe!{WAIT_PRESS}\nIt's fantastic!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x0000000b,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Everyone... Thank you.{WAIT_PRESS}\nBut...") },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x0000000c,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" What about the star?!{WAIT_PRESS}\nWhat happened to it?!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    FANFARE_PLAY2(474),
    { 0x36, 0x00, -0x0001,  0x00000000,  0x00000000, _(" Kwaaaaaaaaah!") },
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_LABEL(3),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x31, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" Fear not!\nThe star is no more.") },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" Though it will not be\nright away...{WAIT_PRESS}\nThe disasters shall soon be calmed.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    CJUMP_UNK_C6(10),
    COND_EQUAL(0, /* to label */ 10),
    WAIT(30),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    CJUMP_UNK_C6(11),
    COND_EQUAL(0, /* to label */ 12),
    JUMP_LABEL(13),
  LABEL(12), /* = 0x0c */
    { 0x2d, 0x09,  0x0008,  0x0000000a,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" What about our team\nmember?\nWhere's {NAME_8}?!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" Be calm.\n{NAME_8} is safe.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    JUMP_LABEL(10),
  LABEL(13), /* = 0x0d */
    { 0x2d, 0x09,  0x0008,  0x0000000a,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0009,  0x0000000b,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" What about our team\nmembers? Where are {NAME_8} and\n{NAME_9}?!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" Be calm.\nBoth are unharmed.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
  LABEL(10), /* = 0x0a */
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x0000000b,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Really!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x93, 0x04,  0x000a,  0x00000022,  0x00000000, NULL },
    CALL_LABEL(3),
    { 0x2e, 0x15,  0x0001,  0x00000001,  0x00000000, NULL },
    MSG_VAR(2, PARTNER_TALK_KIND, 1),
    VARIANT(/* == */  1, _(" We did it, {NAME_0}!{WAIT_PRESS}\nWe got it done!")),
    VARIANT(/* == */  1, _(" We've won peace!")),
    VARIANT_DEFAULT(_(" We did it, {NAME_0}!{WAIT_PRESS}\nEverything worked!")),
    VARIANT_DEFAULT(_(" We've won peace!")),
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
  LABEL(3), /* = 0x03 */
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    RET_DIRECT,
    HALT,
};












static const struct ScriptCommand s_gs171_g5_s0_lives1_dlg0[] = { /* 0x8222c44 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0034,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0001,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(WAKEUP_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(LOOK_AROUND_RIGHT_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x93, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x06,  0x000a,  0x00000004,  0x00000000, NULL },
    WAIT(20),
    { 0x91, 0x06,  0x000a,  0x00000000,  0x00000000, NULL },
    WAIT(20),
    { 0x91, 0x06,  0x000a,  0x00000006,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_ANGRY_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CJUMP_UNK_C6(10),
    COND_EQUAL(0, /* to label */ 0),
    FANFARE_PLAY2(465),
    CALL_SCRIPT(NOTICE_FUNC),
    CALL_SCRIPT(LOOK_AROUND_FUNC),
    WAIT(20),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
  LABEL(0), /* = 0x00 */
    CALL_SCRIPT(JUMP_HAPPY_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x93, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives2_dlg0[] = { /* 0x8222ec4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives3_dlg0[] = { /* 0x8222fb4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x91, 0x0a,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives4_dlg0[] = { /* 0x8223084 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_HAPPY_FUNC),
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x89, 0x08,  0x0100,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_ANGRY_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives5_dlg0[] = { /* 0x82231b4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_HAPPY_FUNC),
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x89, 0x08,  0x0100,  0x00000003,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_ANGRY_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives6_dlg0[] = { /* 0x82232e4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(8),
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x89, 0x08,  0x0100,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives7_dlg0[] = { /* 0x82233f4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(8),
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(8),
    { 0x89, 0x08,  0x0100,  0x00000002,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x91, 0x04,  0x000a,  0x00000002,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives8_dlg0[] = { /* 0x8223504 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x89, 0x08,  0x0100,  0x00000006,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(8),
    { 0x91, 0x04,  0x000a,  0x00000006,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives9_dlg0[] = { /* 0x8223604 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(4),
    { 0x89, 0x08,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(11),
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives10_dlg0[] = { /* 0x82236e4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x89, 0x08,  0x0100,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(4),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives11_dlg0[] = { /* 0x82237e4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(8),
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x89, 0x08,  0x0100,  0x00000003,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(4),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(12),
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives12_dlg0[] = { /* 0x82238e4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x89, 0x08,  0x0100,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(4),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(9),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives13_dlg0[] = { /* 0x82239c4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x89, 0x08,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(9),
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g5_s0_lives14_dlg0[] = { /* 0x8223ac4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_HAPPY_FUNC),
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x89, 0x08,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x91, 0x01,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_station_sref_script[] = { /* 0x8223bb4 */
    DEBUGINFO,
    SELECT_MAP(171),
    SELECT_ENTITIES(-1, 0),
    BGM_SWITCH(41),
    { 0x22, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x23, 0x01,  0x003c,  0x00000000,  0x00000000, NULL },
    RET,
};

static const struct ScriptRef s_gs171_g6_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs171_g6_s0_station_sref_script }; /* 0x8223c34 */

static const struct ScriptCommand s_gs171_g6_s0_eff0_script[] = { /* 0x8223c40 */
    DEBUGINFO,
    { 0x99, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x98, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x50,  0x0080,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x28,  0x0080,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x89, 0x18,  0x0099,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x89, 0xa0,  0x004c,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    END_DELETE,
};

static const struct ScriptCommand s_gs171_g6_s0_lives0_dlg0[] = { /* 0x8223d40 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0001,  0x00000007,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0002,  0x00000058,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0007,  0x00000003,  0x00000000, NULL },
    { 0x34, 0x00,  0x0007,  0x00000000,  0x00000000, _(" Yippee!\nThis is the greatest!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2d, 0x09,  0x0009,  0x00000059,  0x00000000, NULL },
    { 0x2e, 0x0d,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" This calls for a celebration!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2d, 0x09,  0x0009,  0x00000068,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2e, 0x03,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" Let me shoot my Hydro\nPump to kick it off!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0e,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0004, -0x00000003,  0x00000000, NULL },
    { 0x34, 0x00,  0x0004,  0x00000000,  0x00000000, _(" Whoa, hold on there!\nDon't you point those things at me!{WAIT_PRESS}\nFace the other way! The other way!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2d, 0x09,  0x0009,  0x00000055,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x05,  0x0009,  0x00000042,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" No, no!\nLet it loose! Hahaha!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    CALL_LABEL(2),
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(80),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0004,  0x00000000,  0x00000000, _(" Y-you've gotta be kidding\nme!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    CALL_LABEL(2),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    WAIT(120),
    { 0x2e, 0x0c,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0008,  0x00000000,  0x00000000, _(" I'll secure him so he can't\nget away.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0009,  0x00000059,  0x00000000, NULL },
    { 0x2e, 0x0d,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" Oh?{WAIT_PRESS} Not bad!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    CALL_LABEL(2),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CLEAR_ARRAY(EVENT_LOCAL),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(150),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    UPDATE_VARINT(CALC_SET, EVENT_LOCAL, 1),
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0c,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0004,  0x00000000,  0x00000000, _(" What, you're serious?!\nNooooo! Don't!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    CALL_LABEL(2),
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00, -0x0001,  0x00000000,  0x00000000, _(" Ahahahahaha!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x34, 0x00, -0x0001,  0x00000000,  0x00000000, _(" {NAME_0}...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    BGM_FADEOUT(180),
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    CLEAR_ARRAY(EVENT_LOCAL),
    CALL_LABEL(2),
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(LOOK_AROUND_RIGHT_FUNC),
    WAIT(60),
    FANFARE_PLAY2(477),
    SELECT_LIVES(-1, 1),
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(............{WAIT_PRESS}\n{NAME_5}...)") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    BGM_SWITCH(42),
    { 0x2e, 0x03,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" We owe everything to you,\n{NAME_0}, and your friends.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" Peace has returned to\nour world.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" Thank you for everything.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" And now...{WAIT_PRESS}\n{NAME_0}, your role here has ended.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" Soon, you must return to\nyour own world.") },
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" It is time to bid farewell.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2e, 0x02,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("(It's finally come...{WAIT_PRESS}\nThis time has finally arrived...)") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    WAIT(120),
    { 0x34, 0x00,  0x0005,  0x00000000,  0x00000000, _(" {NAME_0}...{WAIT_PRESS}\nI am so sorry for this...{WAIT_PRESS}\nTo everyone...{WAIT_PRESS} Please bid farewell...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    UPDATE_VARINT(CALC_SET, EVENT_LOCAL, 1),
    WAIT(120),
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0c,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0006,  0x00000000,  0x00000000, _(" Oh? {NAME_0}?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    CALL_LABEL(2),
    WAIT(45),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0001,  0x0000000c,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0001,  0x00000000,  0x00000003, NULL },
    MSG_VAR(2, PARTNER_TALK_KIND, 1),
    VARIANT(/* == */  1, _(" ...!{WAIT_PRESS} {NAME_0}...!{WAIT_PRESS}\nYour body...{WAIT_PRESS} What's happening?")),
    VARIANT_DEFAULT(_(" ...!{WAIT_PRESS} {NAME_0}...!{WAIT_PRESS}\nYour body...{WAIT_PRESS} What's happening to you?")),
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x0a,  0x000a,  0x00000004,  0x00000000, NULL },
    WAIT(30),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("{NAME_1}...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x0a,  0x000a,  0x00000005,  0x00000000, NULL },
    WAIT(30),
    { 0x91, 0x0a,  0x000a,  0x00000003,  0x00000000, NULL },
    WAIT(30),
    { 0x91, 0x0a,  0x000a,  0x00000004,  0x00000000, NULL },
    WAIT(30),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("And, everyone...{WAIT_PRESS} I'm sorry.{WAIT_PRESS}\nBut I have to leave.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    FANFARE_PLAY2(465),
    CALL_LABEL(2),
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0007,  0x00000041,  0x00000000, NULL },
    { 0x34, 0x00,  0x0007,  0x00000000,  0x00000000, _(" What?!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0009,  0x0000004f,  0x00000000, NULL },
    { 0x2e, 0x0d,  0x0009,  0x00000041,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" Wh-what are you saying?!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("Everyone...{WAIT_PRESS}\nThank you for everything all this time.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" ...Huh?") },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" ...{WAIT_PRESS}Leave...?{WAIT_PRESS}\nWhat do you mean, leave?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("My role as a Pokémon has ended.") },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("I have to return to the human world.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Unbelievable!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2d, 0x09,  0x0009,  0x0000005a,  0x00000000, NULL },
    { 0x2e, 0x0c,  0x0009,  0x00000041,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" Go back...{WAIT_PRESS}\nTo the human world?!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x0000000c,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Huh? W-why...?{WAIT_PRESS}\nWhy?!") },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" I don't understand!\nWhy do you have to leave?!") },
    { 0x2e, 0x15,  0x0001,  0x00000002,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Didn't we...{WAIT_PRESS}\nAren't we friends?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("Yes.{WAIT_PRESS}\nYou will always be my friend,\n{NAME_1}.") },
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("I will never forget you.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x00000008,  0x00000000, NULL },
    MSG_VAR(2, PARTNER_TALK_KIND, 1),
    VARIANT(/* == */  1, _(" Wait, {NAME_0}......")),
    VARIANT_DEFAULT(_(" Don't go, {NAME_0}......")),
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("I'm blessed to have met you.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    MSG_VAR(2, PARTNER_TALK_KIND, 1),
    VARIANT(/* == */  1, _(" I...\nWhat am I going to do when you're\ngone, {NAME_0}?")),
    VARIANT(/* == */  3, _(" I...\nWhat am I going to do when you're\ngone, {NAME_0}?")),
    VARIANT_DEFAULT(_(" I...\nWhat am I going to do when you're\ngone, {NAME_0}?")),
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x33, 0x00,  0x0000,  0x00000000,  0x00000000, _("I'm so very sorry.\nThis is good-bye...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    CALL_LABEL(2),
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x2b, 0x00,  0x0000,  0x0000003c,  0x0000003c, NULL },
    { 0x2d, 0x09,  0x0009,  0x0000004e,  0x00000000, NULL },
    { 0x2e, 0x0c,  0x0009,  0x00000041,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" {NAME_0}!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0009,  0x00000059,  0x00000000, NULL },
    { 0x2e, 0x0d,  0x0009,  0x00000041,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" {NAME_0}!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0009,  0x0000004f,  0x00000000, NULL },
    { 0x2e, 0x0d,  0x0009,  0x00000041,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0009, -0x00000003,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" {NAME_0}!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0e,  0x0006,  0x00000042,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0006, -0x00000001,  0x00000002, NULL },
    { 0x34, 0x00,  0x0006,  0x00000000,  0x00000000, _(" {NAME_0}...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x59, 0x00,  0x0000, -0x000000c8,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2b, 0x00,  0x0000,  0x000000b4,  0x000000b4, NULL },
    { 0x2e, 0x03,  0x0001,  0x00000006,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" {NAME_0}!!! Nooooo!!!") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
  LABEL(2), /* = 0x02 */
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    RET_DIRECT,
    HALT,
};



















static const struct ScriptCommand s_gs171_g6_s0_lives1_dlg0[] = { /* 0x8225528 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0001,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    WAIT(15),
    { 0x6b, 0x00,  0x00b3,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_SURPRISE_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x6a, 0x00,  0x0080,  0x00000000,  0x00000008, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_ANGRY_FUNC),
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x6a, 0x00,  0x0033,  0x00000000,  0x0000000a, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    WAIT(110),
    { 0x91, 0x0c,  0x000a,  0x00000004,  0x00000000, NULL },
    WAIT(40),
    { 0x89, 0x50,  0x004c,  0x00000004,  0x00000000, NULL },
    WAIT(10),
    { 0x89, 0x28,  0x0100,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives2_dlg0[] = { /* 0x8225728 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x6b, 0x00,  0x00b3,  0x00000001,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000006,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(30),
  LABEL(0), /* = 0x00 */
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(90),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    CALL_SCRIPT(SMILE_END_FUNC),
    WAIT(90),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    JUMP_LABEL(0),
  LABEL(1), /* = 0x01 */
    WAIT(1),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x00000008, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT(170),
    { 0x91, 0x0c,  0x000a,  0x00000004,  0x00000000, NULL },
    WAIT(25),
    { 0x6a, 0x00,  0x0080,  0x00000010, -0x00000010, NULL },
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives3_dlg0[] = { /* 0x8225a58 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x6a, 0x00,  0x0080,  0x00000000,  0x0000000c, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    WAIT(260),
    { 0x91, 0x0c,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives4_dlg0[] = { /* 0x8225b08 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_SURPRISE_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x00000047,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0x7e, 0x00,  0x004c,  0x00000000, -0x00000028, NULL },
    CALL_SCRIPT(JUMP_SURPRISE_FUNC),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    WAIT(15),
    { 0x91, 0x04,  0x0002,  0x00000001,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x00000047,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_SURPRISE_FUNC),
  LABEL(0), /* = 0x00 */
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    WAIT(10),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    JUMP_LABEL(0),
  LABEL(1), /* = 0x01 */
    WAIT(30),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_SURPRISE_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    CALL_SCRIPT(JUMP_SURPRISE_FUNC),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    WAIT(30),
  LABEL(2), /* = 0x02 */
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    WAIT(30),
    { 0x91, 0x04,  0x0002,  0x00000002,  0x00000000, NULL },
    WAIT(60),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 3),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    WAIT(50),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    WAIT(50),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 3),
    JUMP_LABEL(2),
  LABEL(3), /* = 0x03 */
    WAIT(1),
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(4),
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x0000000a, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(170),
    { 0x91, 0x0c,  0x0002,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x6a, 0x00,  0x00b3,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives5_dlg0[] = { /* 0x8225f38 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0x6b, 0x00,  0x00b3,  0x00000002,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0x91, 0x0a,  0x000a,  0x00000001,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x6a, 0x00,  0x00cc,  0x00000000,  0x0000000a, NULL },
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    WAIT(120),
    { 0x91, 0x0c,  0x0002,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x6a, 0x00,  0x00b3,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives6_dlg0[] = { /* 0x8226168 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_ANGRY_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(4),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x6b, 0x00,  0x00b3,  0x00000004,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_SURPRISE_FUNC),
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(8),
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x00000008, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT(190),
    { 0x91, 0x0c,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0x6a, 0x00,  0x004c,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives7_dlg0[] = { /* 0x82263c8 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(35),
    { 0x6a, 0x00,  0x0100,  0x00000000, -0x00000040, NULL },
    { 0x6a, 0x00,  0x0100,  0x00000010,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0x54, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0xdd, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    WAIT(15),
  LABEL(0), /* = 0x00 */
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    CALL_SCRIPT(SMILE_END_FUNC),
    WAIT(60),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    JUMP_LABEL(0),
  LABEL(1), /* = 0x01 */
    WAIT(1),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x6a, 0x00,  0x00b3,  0x00000000,  0x00000006, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(200),
    { 0x91, 0x0c,  0x0002,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x6a, 0x00,  0x004c,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives8_dlg0[] = { /* 0x82266e8 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(40),
    { 0x6b, 0x00,  0x00b3,  0x00000006,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000006,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(45),
  LABEL(0), /* = 0x00 */
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(90),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    CALL_SCRIPT(SMILE_END_FUNC),
    WAIT(90),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    JUMP_LABEL(0),
  LABEL(1), /* = 0x01 */
    WAIT(1),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x00000008, NULL },
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(170),
    { 0x91, 0x0c,  0x0001,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT(40),
    { 0x6a, 0x00,  0x00b3,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives9_dlg0[] = { /* 0x8226a08 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(40),
    { 0x6b, 0x00,  0x00b3,  0x00000007,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(3),
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x00000008, NULL },
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(120),
    { 0x91, 0x0c,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT(40),
    { 0x6a, 0x00,  0x00b3,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives10_dlg0[] = { /* 0x8226c68 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(8),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(40),
    { 0x6b, 0x00,  0x00b3,  0x0000000a,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x00000008, NULL },
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(90),
    { 0x91, 0x0c,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT(55),
    { 0x6a, 0x00,  0x0066,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives11_dlg0[] = { /* 0x8226e68 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x6b, 0x00,  0x00b3,  0x00000003,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000002,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SHOCK_FUNC),
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x00000008, NULL },
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(170),
    { 0x91, 0x0c,  0x0002,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT(40),
    { 0x6a, 0x00,  0x0080,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives12_dlg0[] = { /* 0x8227098 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(4),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(35),
    { 0x6b, 0x00,  0x00b3,  0x00000005,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(JUMP_ANGRY_FUNC),
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x6a, 0x00,  0x00b3,  0x00000000,  0x00000006, NULL },
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(210),
    { 0x91, 0x0c,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT(25),
    { 0x6a, 0x00,  0x00b3,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives13_dlg0[] = { /* 0x82272c8 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(45),
    { 0x6b, 0x00,  0x00b3,  0x00000008,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_END_FUNC),
    WAIT(20),
  LABEL(0), /* = 0x00 */
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(90),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    CALL_SCRIPT(SMILE_END_FUNC),
    WAIT(90),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    JUMP_LABEL(0),
  LABEL(1), /* = 0x01 */
    WAIT(1),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(NOTICE_FUNC),
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x0000000c, NULL },
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(120),
    { 0x91, 0x0c,  0x0002,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(50),
    { 0x6a, 0x00,  0x0066,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_lives14_dlg0[] = { /* 0x82275c8 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(60),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(5),
    { 0x91, 0x04,  0x000a,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(40),
    { 0x6b, 0x00,  0x00b3,  0x00000009,  0x00000000, NULL },
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_START_FUNC),
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    CALL_SCRIPT(SMILE_END_FUNC),
    WAIT(20),
  LABEL(0), /* = 0x00 */
    CALL_SCRIPT(SMILE_START_FUNC),
    WAIT(90),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    CALL_SCRIPT(SMILE_END_FUNC),
    WAIT(90),
    CJUMP_VAR(EVENT_LOCAL),
    COND_EQUAL(1, /* to label */ 1),
    JUMP_LABEL(0),
  LABEL(1), /* = 0x01 */
    WAIT(1),
    CALL_SCRIPT(SMILE_END_FUNC),
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(7),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x6a, 0x00,  0x0100,  0x00000000,  0x00000008, NULL },
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(130),
    { 0x91, 0x0c,  0x0001,  0x00000004,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0x6a, 0x00,  0x00b3,  0x00000000, -0x00000010, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s0_eff1_script[] = { /* 0x82278c8 */
    DEBUGINFO,
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x000000a7,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x000000a8,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x000000a9,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0000,  0x000000aa,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    FANFARE_PLAY2(511),
    { 0x56, 0x00,  0x0003,  0x0000016c,  0x00000000, NULL },
    { 0x59, 0x00,  0x0000,  0x00000003,  0x00000000, NULL },
    WAIT(20),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xde, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x56, 0x00,  0x0003,  0x0000016d,  0x00000000, NULL },
    WAIT(120),
    { 0xe4, 0x00,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    { 0x6a, 0x00,  0x0066,  0x00000000, -0x00000080, NULL },
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT(160),
    { 0x56, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0003,  0x0000016e,  0x00000000, NULL },
    FANFARE_PLAY2(514),
    WAIT(160),
    { 0x56, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x56, 0x00,  0x0003,  0x0000016f,  0x00000000, NULL },
    WAIT(60),
    { 0x89, 0x90,  0x0099,  0x00000004,  0x00000000, NULL },
    FANFARE_FADEOUT2(180, 514),
    { 0x56, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0014,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g6_s1_lives0_dlg0[] = { /* 0x8227d08 */
    DEBUGINFO,
    { 0x53, 0x00,  0x0000,  0x01000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x53, 0x00,  0x0000,  0x0000001f,  0x00000000, NULL },
    { 0x54, 0x00,  0x0017,  0x00000000,  0x00000000, NULL },
    { 0xdd, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x54, 0x00,  0x0017,  0x00000000,  0x00000000, NULL },
    { 0xdd, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(6),
    { 0x54, 0x00,  0x0017,  0x00000000,  0x00000000, NULL },
    { 0xdd, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x54, 0x00,  0x0017,  0x00000000,  0x00000000, NULL },
    { 0xdd, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x54, 0x00,  0x0017,  0x00000000,  0x00000000, NULL },
    { 0xdd, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(2),
    { 0x54, 0x00,  0x001f,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0018,  0x00000000,  0x00000000, NULL },
    { 0xdd, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    END_DELETE,
};

static const struct ScriptCommand s_gs171_g7_s0_station_sref_script[] = { /* 0x8227eb8 */
    DEBUGINFO,
    BGM_FADEOUT(240),
    WAIT(180),
    SELECT_MAP(171),
    SELECT_ENTITIES(-1, 0),
    { 0x22, 0x01,  0x001e,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x23, 0x01,  0x003c,  0x00000000,  0x00000000, NULL },
    RET,
};

static const struct ScriptRef s_gs171_g7_s0_station_sref = { 400, 7, NULL /* EVENT_CONTROL */, s_gs171_g7_s0_station_sref_script }; /* 0x8227f48 */

static const struct ScriptCommand s_gs171_g7_s0_lives0_dlg0[] = { /* 0x8227f54 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0000,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0001,  0x00000007,  0x00000000, NULL },
    { 0x2d, 0x09,  0x0002,  0x00000058,  0x00000000, NULL },
    WAIT(90),
    { 0xdf, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(90),
    { 0x2b, 0x00,  0x0000, -0x00000001, -0x00000001, NULL },
    { 0x2e, 0x02,  0x0006,  0x00000042,  0x00000000, NULL },
    { 0x34, 0x00,  0x0006,  0x00000000,  0x00000000, _(" Snivel... {NAME_0}...{WAIT_PRESS}\nWhy...{WAIT_PRESS} I don't understand...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2d, 0x09,  0x0009,  0x00000059,  0x00000000, NULL },
    { 0x2e, 0x0d,  0x0009,  0x00000044,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" Why?{WAIT_PRESS}\nWhy was it necessary to leave us...?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2d, 0x09,  0x0009,  0x00000055,  0x00000000, NULL },
    { 0x2e, 0x0c,  0x0009,  0x00000043,  0x00000000, NULL },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" {NAME_0} saved my\nlife...") },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" But I hadn't done anything\nto show my thanks...") },
    { 0x34, 0x00,  0x0009,  0x00000000,  0x00000000, _(" Left...{WAIT_PRESS}\nBefore I could even say thanks...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0x2e, 0x0e,  0x0004,  0x00000043,  0x00000000, NULL },
    { 0x2f, 0x00,  0x0004, -0x00000002,  0x00000000, NULL },
    { 0x34, 0x00,  0x0004,  0x00000000,  0x00000000, _(" You're right...") },
    { 0x34, 0x00,  0x0004,  0x00000000,  0x00000000, _(" Just upped and went like\nthat...") },
    { 0x34, 0x00,  0x0004,  0x00000000,  0x00000000, _(" Why now?\nWhy when the world's been saved?") },
    { 0x34, 0x00,  0x0004,  0x00000000,  0x00000000, _(" Just when things were\ngoing to get better...{WAIT_PRESS} Sob...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x0f,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" This was coming...{WAIT_PRESS}\nOur world, it was saved by {NAME_0}.") },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" I look back now...{WAIT_PRESS}\nWhen bound for the sky, {NAME_0}\nseemed...") },
    { 0x34, 0x00,  0x0003,  0x00000000,  0x00000000, _(" As if resigned.\nResigned to accept what was to come.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2e, 0x02,  0x0001,  0x00000005,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" ............{WAIT_PRESS}\nI think I know...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    CALL_LABEL(1),
    WAIT(60),
    MSG_VAR(2, PARTNER_TALK_KIND, 1),
    VARIANT(/* == */  1, _(" I think I understand now...")),
    VARIANT(/* == */  1, _(" {NAME_0} became\na Pokémon to save us...")),
    VARIANT(/* == */  3, _(" {NAME_0} must have...")),
    VARIANT(/* == */  3, _(" {NAME_0} must have\nbecome a Pokémon to save us.")),
    VARIANT_DEFAULT(_(" {NAME_0} must have...")),
    VARIANT_DEFAULT(_(" {NAME_0} must have\nbecome a Pokémon to save us.")),
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" And when...{WAIT_PRESS}\nWhen the star was destroyed...") },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" {NAME_0} knew that\nwould be the time to leave...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(60),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x2e, 0x15,  0x0001,  0x00000008,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Why...{WAIT_PRESS}\nWhy didn't {NAME_0} tell me earlier...?") },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" If this was coming...{WAIT_PRESS}\nWhy didn't {NAME_0} tell me?") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0x2e, 0x0f,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Those words couldn't be\nspoken.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" As much as you are heart-\nbroken now...") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" {NAME_0} must have felt\nthe same pain of leaving.") },
    { 0x34, 0x00,  0x0002,  0x00000000,  0x00000000, _(" Try to understand,\n{NAME_1}.") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(10),
    { 0xe4, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0x34, 0x00,  0x0001,  0x00000000,  0x00000000, _(" Sob...{WAIT_PRESS}\n{NAME_0}...") },
    { 0x30, 0x00,  0x0000,  0x00000000,  0x00000000, NULL },
    WAIT(30),
    { 0xe4, 0x00,  0x0003,  0x00000000,  0x00000000, NULL },
    HALT,
  LABEL(1), /* = 0x01 */
    { 0xe4, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    RET_DIRECT,
    HALT,
};




static const struct ScriptCommand s_gs171_g7_s0_lives1_dlg0[] = { /* 0x8228974 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0001,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0x54, 0x00,  0x002d,  0x00000000,  0x00000000, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0006,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives2_dlg0[] = { /* 0x8228a14 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    WAIT(1),
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0007,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives3_dlg0[] = { /* 0x8228ab4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0003,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0x6a, 0x00,  0x0080,  0x00000000,  0x00000008, NULL },
    { 0xe4, 0x00,  0x0005,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0008,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives4_dlg0[] = { /* 0x8228b64 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0004,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0009,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives5_dlg0[] = { /* 0x8228be4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0006,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000b,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives6_dlg0[] = { /* 0x8228c64 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0007,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000c,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives7_dlg0[] = { /* 0x8228ce4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0x2d, 0x07,  0x0008,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000002,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000d,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives8_dlg0[] = { /* 0x8228d64 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000007,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0010,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives9_dlg0[] = { /* 0x8228dd4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000003,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000e,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives10_dlg0[] = { /* 0x8228e44 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x000f,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives11_dlg0[] = { /* 0x8228eb4 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000005,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0011,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives12_dlg0[] = { /* 0x8228f24 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000006,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0012,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives13_dlg0[] = { /* 0x8228f94 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct ScriptCommand s_gs171_g7_s0_lives14_dlg0[] = { /* 0x8229004 */
    DEBUGINFO,
    { 0x54, 0x00,  0x0002,  0x00000000,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    WAIT_RANDOM(0, 15),
    { 0x91, 0x04,  0x000a,  0x00000001,  0x00000000, NULL },
    { 0xe3, 0x00,  0x0013,  0x00000000,  0x00000000, NULL },
    HALT,
};

static const struct GroundLivesData s_gs171_g1_s0_lives[] = { /* 0x8229074 */
    /*  0 */ {  97,   4,   0,   0, {  20,  36, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g1_s0_lives0_dlg0,
    } },
};

static const struct GroundLivesData s_gs171_g2_s0_lives[] = { /* 0x822908c */
    /*  0 */ {  97,   4,   0,   0, {  20,  36, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g2_s0_lives0_dlg0,
    } },
};

static const struct GroundLivesData s_gs171_g3_s0_lives[] = { /* 0x82290a4 */
    /*  0 */ {   0,   4,   0,   0, {  23,  51, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g3_s0_lives0_dlg0,
    } },
    /*  1 */ {  34,   4,   0,   0, {  17,  51, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g3_s0_lives1_dlg0,
    } },
    /*  2 */ {  88,   4,   0,   0, {  17,  35, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g3_s0_lives2_dlg0,
    } },
    /*  3 */ {  97,   4,   0,   0, {  20,  33, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g3_s0_lives3_dlg0,
    } },
    /*  4 */ {  10,   4,   0,   0, {  20,  55, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g3_s0_lives4_dlg0,
    } },
};

static const struct GroundLivesData s_gs171_g4_s0_lives[] = { /* 0x822911c */
    /*  0 */ {   0,   5,   0,   0, {  23,  38, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g4_s0_lives0_dlg0,
    } },
    /*  1 */ {  34,   4,   0,   0, {  17,  38, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g4_s0_lives1_dlg0,
    } },
    /*  2 */ {  88,   0,   0,   0, {  17,  35, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g4_s0_lives2_dlg0,
    } },
    /*  3 */ {  97,   0,   0,   0, {  20,  33, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g4_s0_lives3_dlg0,
    } },
    /*  4 */ {  10,   4,   0,   0, {  20,  42, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g4_s0_lives4_dlg0,
    } },
};

static const struct GroundLivesData s_gs171_g5_s0_lives[] = { /* 0x8229194 */
    /*  0 */ {   0,   4,   0,   0, {  18,  44, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives0_dlg0,
    } },
    /*  1 */ {  34,   4,   0,   0, {  22,  44, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives1_dlg0,
    } },
    /*  2 */ {  88,   0,   0,   0, {  20,  41, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives2_dlg0,
    } },
    /*  3 */ {  97,   4,   0,   0, {  20,  33, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives3_dlg0,
    } },
    /*  4 */ {  77,   1,   0,   0, {  15,  41, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives4_dlg0,
    } },
    /*  5 */ {  54,   3,   0,   0, {  14,  46, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives5_dlg0,
    } },
    /*  6 */ {  80,   7,   0,   0, {  25,  41, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives6_dlg0,
    } },
    /*  7 */ { 105,   2,   0,   0, {  12,  43, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives7_dlg0,
    } },
    /*  8 */ {  89,   6,   0,   0, {  28,  44, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives8_dlg0,
    } },
    /*  9 */ {  85,   4,   0,   0, {  20,  48, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives9_dlg0,
    } },
    /* 10 */ { 104,   5,   0,   0, {  26,  47, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives10_dlg0,
    } },
    /* 11 */ {  90,   3,   0,   0, {  12,  47, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives11_dlg0,
    } },
    /* 12 */ {  79,   7,   0,   0, {  28,  40, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g5_s0_lives12_dlg0,
    } },
    /* 13 */ {  78,   4,   0,   0, {  17,  49, 0, 0 }, {
        [0] = s_gs171_g5_s0_lives13_dlg0,
    } },
    /* 14 */ {  95,   4,   0,   0, {  23,  49, 0, 0 }, {
        [0] = s_gs171_g5_s0_lives14_dlg0,
    } },
};

static const struct GroundLivesData s_gs171_g6_s0_lives[] = { /* 0x82292fc */
    /*  0 */ {   0,   2,   0,   0, {  18,  44, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives0_dlg0,
    } },
    /*  1 */ {  34,   6,   0,   0, {  22,  44, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives1_dlg0,
    } },
    /*  2 */ {  88,   0,   0,   0, {  20,  41, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives2_dlg0,
    } },
    /*  3 */ {  97,   0,   0,   0, {  20,  33, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives3_dlg0,
    } },
    /*  4 */ {  77,   1,   0,   0, {  16,  42, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives4_dlg0,
    } },
    /*  5 */ {  54,   3,   0,   0, {  15,  45, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives5_dlg0,
    } },
    /*  6 */ {  80,   7,   0,   0, {  24,  42, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives6_dlg0,
    } },
    /*  7 */ { 105,   2,   0,   0, {  13,  43, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives7_dlg0,
    } },
    /*  8 */ {  89,   6,   0,   0, {  27,  44, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives8_dlg0,
    } },
    /*  9 */ { 104,   5,   0,   0, {  25,  46, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives9_dlg0,
    } },
    /* 10 */ {  85,   4,   0,   0, {  20,  47, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives10_dlg0,
    } },
    /* 11 */ {  90,   3,   0,   0, {  13,  46, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives11_dlg0,
    } },
    /* 12 */ {  79,   7,   0,   0, {  27,  41, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s0_lives12_dlg0,
    } },
    /* 13 */ {  78,   4,   0,   0, {  17,  48, 0, 0 }, {
        [0] = s_gs171_g6_s0_lives13_dlg0,
    } },
    /* 14 */ {  95,   4,   0,   0, {  23,  48, 0, 0 }, {
        [0] = s_gs171_g6_s0_lives14_dlg0,
    } },
};

static const struct GroundLivesData s_gs171_g6_s1_lives[] = { /* 0x8229464 */
    /*  0 */ {  82,   6,   0,   0, {  22,  44, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g6_s1_lives0_dlg0,
    } },
};

static const struct GroundLivesData s_gs171_g7_s0_lives[] = { /* 0x822947c */
    /*  0 */ {   0,   4,   0,   0, {  20,   5, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives0_dlg0,
    } },
    /*  1 */ {  34,   4,   0,   0, {  20,  44, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives1_dlg0,
    } },
    /*  2 */ {  88,   0,   0,   0, {  23,  40, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives2_dlg0,
    } },
    /*  3 */ {  97,   0,   0,   0, {  20,  34, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives3_dlg0,
    } },
    /*  4 */ {  77,   1,   0,   0, {  16,  39, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives4_dlg0,
    } },
    /*  5 */ {  54,   3,   0,   0, {  14,  41, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives5_dlg0,
    } },
    /*  6 */ {  80,   1,   0,   0, {  28,  38, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives6_dlg0,
    } },
    /*  7 */ { 105,   6,   0,   0, {  10,  43, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives7_dlg0,
    } },
    /*  8 */ {  89,   6,   0,   0, {  25,  35, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives8_dlg0,
    } },
    /*  9 */ { 104,   5,   0,   0, {  15,  45, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives9_dlg0,
    } },
    /* 10 */ {  85,   4,   0,   0, {  15,  35, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives10_dlg0,
    } },
    /* 11 */ {  90,   3,   0,   0, {  24,  45, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives11_dlg0,
    } },
    /* 12 */ {  79,   7,   0,   0, {  29,  43, 0, CPOS_HALFTILE }, {
        [0] = s_gs171_g7_s0_lives12_dlg0,
    } },
    /* 13 */ {  78,   3,   0,   0, {  10,  39, 0, 0 }, {
        [0] = s_gs171_g7_s0_lives13_dlg0,
    } },
    /* 14 */ {  95,   7,   0,   0, {  12,  37, 0, 0 }, {
        [0] = s_gs171_g7_s0_lives14_dlg0,
    } },
};

static const struct GroundEffectData s_gs171_g1_s0_effs[] = { /* 0x82295e4 */
    /*  0 */ {   0,   0,   1,   1, {  20,  34, CPOS_HALFTILE, CPOS_HALFTILE }, s_gs171_g1_s0_eff0_script },
};

static const struct GroundEffectData s_gs171_g2_s0_effs[] = { /* 0x82295f0 */
    /*  0 */ {   0,   0,   1,   1, {  20,  34, CPOS_HALFTILE, CPOS_HALFTILE }, s_gs171_g2_s0_eff0_script },
};

static const struct GroundEffectData s_gs171_g3_s0_effs[] = { /* 0x82295fc */
    /*  0 */ {   0,   0,   1,   1, {  20,  35, CPOS_HALFTILE, CPOS_HALFTILE }, NULL },
    /*  1 */ {   4,   0,   1,   1, {  20,  30, 0, 0 }, s_gs171_g3_s0_eff1_script },
};

static const struct GroundEffectData s_gs171_g4_s0_effs[] = { /* 0x8229614 */
    /*  0 */ {   0,   0,   1,   1, {  20,  35, CPOS_HALFTILE, CPOS_HALFTILE }, NULL },
    /*  1 */ {   5,   0,   1,   1, {  21,  38, 0, 0 }, s_gs171_g4_s0_eff1_script },
    /*  2 */ {   4,   0,   1,   1, {  23,  38, 0, CPOS_HALFTILE }, s_gs171_g4_s0_eff2_script },
    /*  3 */ {   4,   0,   1,   1, {  19,  38, 0, CPOS_HALFTILE }, s_gs171_g4_s0_eff3_script },
    /*  4 */ {   4,   0,   1,   1, {  21,  40, 0, CPOS_HALFTILE }, s_gs171_g4_s0_eff4_script },
};

static const struct GroundEffectData s_gs171_g5_s0_effs[] = { /* 0x8229650 */
    /*  0 */ {   0,   0,   1,   1, {  20,  47, CPOS_HALFTILE, CPOS_HALFTILE }, s_gs171_g5_s0_eff0_script },
};

static const struct GroundEffectData s_gs171_g6_s0_effs[] = { /* 0x822965c */
    /*  0 */ {   0,   0,   1,   1, {  20,  46, CPOS_HALFTILE, 0 }, s_gs171_g6_s0_eff0_script },
    /*  1 */ {   4,   0,   1,   1, {  18,  44, 0, CPOS_HALFTILE }, s_gs171_g6_s0_eff1_script },
};

static const struct GroundEffectData s_gs171_g7_s0_effs[] = { /* 0x8229674 */
    /*  0 */ {   0,   0,   1,   1, {  20,  42, CPOS_HALFTILE, CPOS_HALFTILE }, NULL },
};

static const struct ScriptRef * const (sStationScripts[]) = { /* 0x8229680 */
    &s_gs171_g0_s0_station_sref,
    &s_gs171_g1_s0_station_sref,
    &s_gs171_g2_s0_station_sref,
    &s_gs171_g3_s0_station_sref,
    &s_gs171_g4_s0_station_sref,
    &s_gs171_g5_s0_station_sref,
    &s_gs171_g6_s0_station_sref,
    &s_gs171_g7_s0_station_sref,
};

static const struct GroundScriptSector s_gs171_g0_sectors[] = { /* 0x82296a0 */
    { 0,NULL, 0,NULL, 0,NULL, 0,NULL, 1,&sStationScripts[0], },
};

static const struct GroundScriptSector s_gs171_g1_sectors[] = { /* 0x82296c8 */
    { LPARRAY(s_gs171_g1_s0_lives), 0,NULL, LPARRAY(s_gs171_g1_s0_effs), 0,NULL, 1,&sStationScripts[1], },
};

static const struct GroundScriptSector s_gs171_g2_sectors[] = { /* 0x82296f0 */
    { LPARRAY(s_gs171_g2_s0_lives), 0,NULL, LPARRAY(s_gs171_g2_s0_effs), 0,NULL, 1,&sStationScripts[2], },
};

static const struct GroundScriptSector s_gs171_g3_sectors[] = { /* 0x8229718 */
    { LPARRAY(s_gs171_g3_s0_lives), 0,NULL, LPARRAY(s_gs171_g3_s0_effs), 0,NULL, 1,&sStationScripts[3], },
};

static const struct GroundScriptSector s_gs171_g4_sectors[] = { /* 0x8229740 */
    { LPARRAY(s_gs171_g4_s0_lives), 0,NULL, LPARRAY(s_gs171_g4_s0_effs), 0,NULL, 1,&sStationScripts[4], },
};

static const struct GroundScriptSector s_gs171_g5_sectors[] = { /* 0x8229768 */
    { LPARRAY(s_gs171_g5_s0_lives), 0,NULL, LPARRAY(s_gs171_g5_s0_effs), 0,NULL, 1,&sStationScripts[5], },
};

static const struct GroundScriptSector s_gs171_g6_sectors[] = { /* 0x8229790 */
    { LPARRAY(s_gs171_g6_s0_lives), 0,NULL, LPARRAY(s_gs171_g6_s0_effs), 0,NULL, 1,&sStationScripts[6], },
    { LPARRAY(s_gs171_g6_s1_lives), 0,NULL, 0,NULL, 0,NULL, 0,NULL, },
};

static const struct GroundScriptSector s_gs171_g7_sectors[] = { /* 0x82297e0 */
    { LPARRAY(s_gs171_g7_s0_lives), 0,NULL, LPARRAY(s_gs171_g7_s0_effs), 0,NULL, 1,&sStationScripts[7], },
};

static const struct GroundScriptGroup s_gs171_groups[] = { /* 0x8229808 */
    { LPARRAY(s_gs171_g0_sectors) },
    { LPARRAY(s_gs171_g1_sectors) },
    { LPARRAY(s_gs171_g2_sectors) },
    { LPARRAY(s_gs171_g3_sectors) },
    { LPARRAY(s_gs171_g4_sectors) },
    { LPARRAY(s_gs171_g5_sectors) },
    { LPARRAY(s_gs171_g6_sectors) },
    { LPARRAY(s_gs171_g7_sectors) },
};

static const struct GroundLink s_gs171_links[] = { /* 0x8229848 */
    /* link   0 */ { { /*x*/  18, /*y*/  39, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   1 */ { { /*x*/  18, /*y*/  37, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   2 */ { { /*x*/  15, /*y*/  39, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   3 */ { { /*x*/  13, /*y*/  37, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   4 */ { { /*x*/  20, /*y*/  36, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   5 */ { { /*x*/  22, /*y*/  35, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   6 */ { { /*x*/  22, /*y*/  37, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   7 */ { { /*x*/  21, /*y*/  39, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   8 */ { { /*x*/  13, /*y*/  39, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link   9 */ { { /*x*/  24, /*y*/  38, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
    /* link  10 */ { { /*x*/  22, /*y*/  40, /*flags*/ 0, CPOS_HALFTILE }, /*w*/  1, /*h*/  1, /*ret*/ 1, /*?*/ 0 },
};

/*extern*/ const struct GroundScriptHeader gGroundScript_gs171 = { LPARRAY(s_gs171_groups), s_gs171_links }; /* 0x82298a0 */
