#include "global.h"
#include "globaldata.h"
#include "common_strings.h"

// The structure of this file seems to be completely different in the EU version.
// Not sure about the JP version though - Kermalis

#define REGION_USA TRUE // For now

#if REGION_USA

#include "data/locale/felicity_bank_usa.h"
#include "data/locale/gulpin_shop_usa.h"
#include "data/locale/hints_usa.h"
#include "data/locale/kangaskhan_storage_usa.h"
#include "data/locale/kecleon_bros_usa.h"
#include "data/locale/makuhita_dojo_usa.h"
#include "data/locale/wigglytuff_shop_usa.h"

#endif

ALIGNED(4) static const u8 sYes0[] = _("Yes");
ALIGNED(4) const u8* const gCommonYes[] = { sYes0 };

ALIGNED(4) static const u8 sNo0[] = _("No");
ALIGNED(4) const u8* const gCommonNo[] = { sNo0 };

ALIGNED(4) static const u8 sCancel0[] = _("Cancel");
ALIGNED(4) const u8* const gCommonCancel[] = { sCancel0 };

ALIGNED(4) static const u8 sTrash0[] = _("Trash ");
ALIGNED(4) const u8* const gCommonTrash[] = { sTrash0 };

ALIGNED(4) static const u8 sDelete0[] = _("Delete");
ALIGNED(4) const u8* const gCommonDelete[] = { sDelete0 };

ALIGNED(4) static const u8 sStore0[] = _("Store");
ALIGNED(4) const u8* const gCommonStore[] = { sStore0 };

ALIGNED(4) static const u8 sTake0[] = _("Take");
ALIGNED(4) const u8* const gCommonTake[] = { sTake0 };

ALIGNED(4) static const u8 sInfo0[] = _("Info");
ALIGNED(4) const u8* const gCommonInfo[] = { sInfo0 };

ALIGNED(4) static const u8 sBuy0[] = _("Buy");
ALIGNED(4) const u8* const gCommonBuy[] = { sBuy0 };

ALIGNED(4) static const u8 sSell0[] = _("Sell ");
ALIGNED(4) const u8* const gCommonSell[] = { sSell0 };

ALIGNED(4) static const u8 sAccept0[] = _("Accept");
ALIGNED(4) const u8* const gCommonAccept[] = { sAccept0 };

ALIGNED(4) static const u8 sCheck0[] = _("Check");
ALIGNED(4) const u8* const gCommonCheck[] = { sCheck0 };

ALIGNED(4) static const u8 sFriend0[] = _("Friend");
ALIGNED(4) const u8* const gCommonFriend[] = { sFriend0 };

ALIGNED(4) static const u8 sExit0[] = _("Exit");
ALIGNED(4) const u8* const gCommonExit[] = { sExit0 };

ALIGNED(4) static const u8 sTripleQuestionMark0[] = _("???");
ALIGNED(4) const u8* const gCommonTripleQuestionMark[] = { sTripleQuestionMark0 };

ALIGNED(4) static const u8 sDepositPrompt0[] = _("Deposit?");
ALIGNED(4) const u8* const gCommonDepositPrompt[] = { sDepositPrompt0 };

ALIGNED(4) static const u8 sWithdrawPrompt0[] = _("Withdraw?");
ALIGNED(4) const u8* const gCommonWithdrawPrompt[] = { sWithdrawPrompt0 };



ALIGNED(4) const u8* const gCommonFelicity[FEL_MODE_COUNT][FEL_DLG_MAX] =
{
    [FEL_MODE_AWAKE] = {
        [FEL_DLG_WELCOME] = FEL_AWAKE_WELCOME,
        [FEL_DLG_HOW_MAY_I_SERVE__NO_MONEY] = FEL_AWAKE_HOW_MAY_I_SERVE__NO_MONEY,
        [FEL_DLG_HOW_MAY_I_SERVE__HAS_MONEY] = FEL_AWAKE_HOW_MAY_I_SERVE__HAS_MONEY,
        [FEL_DLG_VERY_WELL] = FEL_AWAKE_VERY_WELL,
        [FEL_DLG_BYE__NO_MONEY] = FEL_AWAKE_BYE__NO_MONEY,
        [FEL_DLG_BYE__HAS_MONEY] = FEL_AWAKE_BYE__HAS_MONEY,
        [FEL_DLG_DEPOSIT__HOW_MUCH] = FEL_AWAKE_DEPOSIT__HOW_MUCH,
        [FEL_DLG_DEPOSIT__NO_MONEY] = FEL_AWAKE_DEPOSIT__NO_MONEY,
        [FEL_DLG_DEPOSIT__BANK_FULL] = FEL_AWAKE_DEPOSIT__BANK_FULL,
        [FEL_DLG_DEPOSIT__RECEIPT] = FEL_AWAKE_DEPOSIT__RECEIPT,
        [FEL_DLG_WITHDRAW__HOW_MUCH] = FEL_AWAKE_WITHDRAW__HOW_MUCH,
        [FEL_DLG_WITHDRAW__NO_MONEY] = FEL_AWAKE_WITHDRAW__NO_MONEY,
        [FEL_DLG_WITHDRAW__WALLET_FULL] = FEL_AWAKE_WITHDRAW__WALLET_FULL,
        [FEL_DLG_WITHDRAW__RECEIPT] = FEL_AWAKE_WITHDRAW__RECEIPT,
        [FEL_DLG_HOW_IT_WORKS] = FEL_AWAKE_HOW_IT_WORKS
    },
    [FEL_MODE_ASLEEP] = {
        [FEL_DLG_WELCOME] = FEL_ASLEEP_WELCOME,
        [FEL_DLG_HOW_MAY_I_SERVE__NO_MONEY] = FEL_ASLEEP_HOW_MAY_I_SERVE__NO_MONEY,
        [FEL_DLG_HOW_MAY_I_SERVE__HAS_MONEY] = FEL_ASLEEP_HOW_MAY_I_SERVE__HAS_MONEY,
        [FEL_DLG_VERY_WELL] = FEL_ASLEEP_VERY_WELL,
        [FEL_DLG_BYE__NO_MONEY] = FEL_ASLEEP_BYE__NO_MONEY,
        [FEL_DLG_BYE__HAS_MONEY] = FEL_ASLEP_BYE__HAS_MONEY,
        [FEL_DLG_DEPOSIT__HOW_MUCH] = FEL_ASLEEP_DEPOSIT__HOW_MUCH,
        [FEL_DLG_DEPOSIT__NO_MONEY] = FEL_ASLEEP_DEPOSIT__NO_MONEY,
        [FEL_DLG_DEPOSIT__BANK_FULL] = FEL_ASLEEP_DEPOSIT__BANK_FULL,
        [FEL_DLG_DEPOSIT__RECEIPT] = FEL_ASLEEP_DEPOSIT__RECEIPT,
        [FEL_DLG_WITHDRAW__HOW_MUCH] = FEL_ASLEEP_WITHDRAW__HOW_MUCH,
        [FEL_DLG_WITHDRAW__NO_MONEY] = FEL_ASLEEP_WITHDRAW__NO_MONEY,
        [FEL_DLG_WITHDRAW__WALLET_FULL] = FEL_ASLEEP_WITHDRAW__WALLET_FULL,
        [FEL_DLG_WITHDRAW__RECEIPT] = FEL_ASLEEP_WITHDRAW__RECEIPT,
        [FEL_DLG_HOW_IT_WORKS] = FEL_ASLEEP_HOW_IT_WORKS
    }
};

ALIGNED(4) const u8* const gCommonKangStorage[KANG_MODE_COUNT][KANG_DLG_MAX] =
{
    [KANG_MODE_AWAKE] = {
        [KANG_DLG_WELCOME] = KANG_AWAKE_WELCOME,
        [KANG_DLG_ANYTHING_ELSE] = KANG_AWAKE_ANYTHING_ELSE,
        [KANG_DLG_BYE] = KANG_AWAKE_BYE,
        [KANG_DLG_STORE_WHAT] = KANG_AWAKE_STORE_WHAT,
        [KANG_DLG_STORE_MORE] = KANG_AWAKE_STORE_MORE,
        [KANG_DLG_DEPOSIT_ONE_PROMPT] = KANG_AWAKE_DEPOSIT_ONE_PROMPT,
        [KANG_DLG_DEPOSIT_MANY_PROMPT] = KANG_AWAKE_DEPOSIT_MANY_PROMPT,
        [KANG_DLG_DEPOSIT_CONFIRMATION] = KANG_AWAKE_DEPOSIT_CONFIRMATION,
        [KANG_DLG_TAKE_WHAT] = KANG_AWAKE_TAKE_WHAT,
        [KANG_DLG_TAKE_MORE] = KANG_AWAKE_TAKE_MORE,
        [KANG_DLG_WITHDRAW_ONE_PROMPT] = KANG_AWAKE_WITHDRAW_ONE_PROMPT,
        [KANG_DLG_WITHDRAW_MANY_PROMPT] = KANG_AWAKE_WITHDRAW_MANY_PROMPT,
        [KANG_DLG_WITHDRAW_CONFIRMATION] = KANG_AWAKE_WITHDRAW_CONFIRMATION,
        [KANG_DLG_YOU_HAVE_NOTHING] = KANG_AWAKE_YOU_HAVE_NOTHING,
        [KANG_DLG_YOU_ARE_FULL] = KANG_AWAKE_YOU_ARE_FULL,
        [KANG_DLG_STORAGE_EMPTY] = KANG_AWAKE_STORAGE_HAS_NOTHING,
        [KANG_DLG_DEPOSIT_INVALID_ITEM] = KANG_AWAKE_DEPOSIT_INVALID_ITEM,
        [KANG_DLG_DEPOSIT_TOO_MANY_OF_ITEM] = KANG_AWAKE_DEPOSIT_TOO_MANY_OF_ITEM,
        [KANG_DLG_STORAGE_FULL] = KANG_AWAKE_STORAGE_FULL,
        [KANG_DLG_HOW_IT_WORKS] = KANG_AWAKE_HOW_IT_WORKS
    },
    [KANG_MODE_ASLEEP] = {
        [KANG_DLG_WELCOME] = KANG_ASLEEP_WELCOME,
        [KANG_DLG_ANYTHING_ELSE] = KANG_ASLEEP_ANYTHING_ELSE,
        [KANG_DLG_BYE] = KANG_ASLEEP_BYE,
        [KANG_DLG_STORE_WHAT] = KANG_ASLEEP_STORE_WHAT,
        [KANG_DLG_STORE_MORE] = KANG_ASLEEP_STORE_MORE,
        [KANG_DLG_DEPOSIT_ONE_PROMPT] = KANG_ASLEEP_DEPOSIT_ONE_PROMPT,
        [KANG_DLG_DEPOSIT_MANY_PROMPT] = KANG_ASLEEP_DEPOSIT_MANY_PROMPT,
        [KANG_DLG_DEPOSIT_CONFIRMATION] = KANG_ASLEEP_DEPOSIT_CONFIRMATION,
        [KANG_DLG_TAKE_WHAT] = KANG_ASLEEP_TAKE_WHAT,
        [KANG_DLG_TAKE_MORE] = KANG_ASLEEP_TAKE_MORE,
        [KANG_DLG_WITHDRAW_ONE_PROMPT] = KANG_ASLEEP_WITHDRAW_ONE_PROMPT,
        [KANG_DLG_WITHDRAW_MANY_PROMPT] = KANG_ASLEEP_WITHDRAW_MANY_PROMPT,
        [KANG_DLG_WITHDRAW_CONFIRMATION] = KANG_ASLEEP_WITHDRAW_CONFIRMATION,
        [KANG_DLG_YOU_HAVE_NOTHING] = KANG_ASLEEP_YOU_HAVE_NOTHING,
        [KANG_DLG_YOU_ARE_FULL] = KANG_ASLEEP_YOU_ARE_FULL,
        [KANG_DLG_STORAGE_EMPTY] = KANG_ASLEEP_STORAGE_EMPTY,
        [KANG_DLG_DEPOSIT_INVALID_ITEM] = KANG_ASLEEP_DEPOSIT_INVALID_ITEM,
        [KANG_DLG_DEPOSIT_TOO_MANY_OF_ITEM] = KANG_ASLEEP_DEPOSIT_TOO_MANY_OF_ITEM,
        [KANG_DLG_STORAGE_FULL] = KANG_ASLEEP_STORAGE_FULL,
        [KANG_DLG_HOW_IT_WORKS] = KANG_ASLEEP_HOW_IT_WORKS
    }
};

ALIGNED(4) const u8* const gCommonKecleonBros[KECLEON_BROS_MODE_COUNT][KECLEON_DLG_MAX] =
{
    [KECLEON_BROS_MODE_ITEMS_AWAKE] = {
        [KECLEON_DLG_00] = KEC_ITEMS_AWAKE_DLG_00,
        [KECLEON_DLG_01] = KEC_ITEMS_AWAKE_DLG_01,
        [KECLEON_DLG_02] = KEC_ITEMS_AWAKE_DLG_02,
        [KECLEON_DLG_03] = KEC_ITEMS_AWAKE_DLG_03,
        [KECLEON_DLG_04] = KEC_ITEMS_AWAKE_DLG_04,
        [KECLEON_DLG_05] = KEC_ITEMS_AWAKE_DLG_05,
        [KECLEON_DLG_06] = KEC_ITEMS_AWAKE_DLG_06,
        [KECLEON_DLG_07] = KEC_ITEMS_AWAKE_DLG_07,
        [KECLEON_DLG_08] = KEC_ITEMS_AWAKE_DLG_08,
        [KECLEON_DLG_09] = KEC_ITEMS_AWAKE_DLG_09,
        [KECLEON_DLG_10] = KEC_ITEMS_AWAKE_DLG_10,
        [KECLEON_DLG_11] = KEC_ITEMS_AWAKE_DLG_11,
        [KECLEON_DLG_12] = KEC_ITEMS_AWAKE_DLG_12,
        [KECLEON_DLG_13] = KEC_ITEMS_AWAKE_DLG_13,
        [KECLEON_DLG_14] = KEC_ITEMS_AWAKE_DLG_14,
        [KECLEON_DLG_15] = KEC_ITEMS_AWAKE_DLG_15,
        [KECLEON_DLG_16] = KEC_ITEMS_AWAKE_DLG_16,
        [KECLEON_DLG_17] = KEC_ITEMS_AWAKE_DLG_17,
        [KECLEON_DLG_18] = KEC_ITEMS_AWAKE_DLG_18,
        [KECLEON_DLG_19] = KEC_ITEMS_AWAKE_DLG_19,
        [KECLEON_DLG_20] = KEC_ITEMS_AWAKE_DLG_20,
        [KECLEON_DLG_21] = KEC_ITEMS_AWAKE_DLG_21,
        [KECLEON_DLG_22] = KEC_ITEMS_AWAKE_DLG_22
    },
    [KECLEON_BROS_MODE_ITEMS_ASLEEP] = {
        [KECLEON_DLG_00] = KEC_ITEMS_ASLEEP_DLG_00,
        [KECLEON_DLG_01] = KEC_ITEMS_ASLEEP_DLG_01,
        [KECLEON_DLG_02] = KEC_ITEMS_ASLEEP_DLG_02,
        [KECLEON_DLG_03] = KEC_ITEMS_ASLEEP_DLG_03,
        [KECLEON_DLG_04] = KEC_ITEMS_ASLEEP_DLG_04,
        [KECLEON_DLG_05] = KEC_ITEMS_ASLEEP_DLG_05,
        [KECLEON_DLG_06] = KEC_ITEMS_ASLEEP_DLG_06,
        [KECLEON_DLG_07] = KEC_ITEMS_ASLEEP_DLG_07,
        [KECLEON_DLG_08] = KEC_ITEMS_ASLEEP_DLG_08,
        [KECLEON_DLG_09] = KEC_ITEMS_ASLEEP_DLG_09,
        [KECLEON_DLG_10] = KEC_ITEMS_ASLEEP_DLG_10,
        [KECLEON_DLG_11] = KEC_ITEMS_ASLEEP_DLG_11,
        [KECLEON_DLG_12] = KEC_ITEMS_ASLEEP_DLG_12,
        [KECLEON_DLG_13] = KEC_ITEMS_ASLEEP_DLG_13,
        [KECLEON_DLG_14] = KEC_ITEMS_ASLEEP_DLG_14,
        [KECLEON_DLG_15] = KEC_ITEMS_ASLEEP_DLG_15,
        [KECLEON_DLG_16] = KEC_ITEMS_ASLEEP_DLG_16,
        [KECLEON_DLG_17] = KEC_ITEMS_ASLEEP_DLG_17,
        [KECLEON_DLG_18] = KEC_ITEMS_ASLEEP_DLG_18,
        [KECLEON_DLG_19] = KEC_ITEMS_ASLEEP_DLG_19,
        [KECLEON_DLG_20] = KEC_ITEMS_ASLEEP_DLG_20,
        [KECLEON_DLG_21] = KEC_ITEMS_ASLEEP_DLG_21,
        [KECLEON_DLG_22] = KEC_ITEMS_ASLEEP_DLG_22
    },
    [KECLEON_BROS_MODE_WARES_AWAKE] = {
        [KECLEON_DLG_00] = KEC_WARES_AWAKE_DLG_00,
        [KECLEON_DLG_01] = KEC_WARES_AWAKE_DLG_01,
        [KECLEON_DLG_02] = KEC_WARES_AWAKE_DLG_02,
        [KECLEON_DLG_03] = KEC_WARES_AWAKE_DLG_03,
        [KECLEON_DLG_04] = KEC_WARES_AWAKE_DLG_04,
        [KECLEON_DLG_05] = KEC_WARES_AWAKE_DLG_05,
        [KECLEON_DLG_06] = KEC_WARES_AWAKE_DLG_06,
        [KECLEON_DLG_07] = KEC_WARES_AWAKE_DLG_07,
        [KECLEON_DLG_08] = KEC_WARES_AWAKE_DLG_08,
        [KECLEON_DLG_09] = KEC_WARES_AWAKE_DLG_09,
        [KECLEON_DLG_10] = KEC_WARES_AWAKE_DLG_10,
        [KECLEON_DLG_11] = KEC_WARES_AWAKE_DLG_11,
        [KECLEON_DLG_12] = KEC_WARES_AWAKE_DLG_12,
        [KECLEON_DLG_13] = KEC_WARES_AWAKE_DLG_13,
        [KECLEON_DLG_14] = KEC_WARES_AWAKE_DLG_14,
        [KECLEON_DLG_15] = KEC_WARES_AWAKE_DLG_15,
        [KECLEON_DLG_16] = KEC_WARES_AWAKE_DLG_16,
        [KECLEON_DLG_17] = KEC_WARES_AWAKE_DLG_17,
        [KECLEON_DLG_18] = KEC_WARES_AWAKE_DLG_18,
        [KECLEON_DLG_19] = KEC_WARES_AWAKE_DLG_19,
        [KECLEON_DLG_20] = KEC_WARES_AWAKE_DLG_20,
        [KECLEON_DLG_21] = KEC_WARES_AWAKE_DLG_21,
        [KECLEON_DLG_22] = KEC_WARES_AWAKE_DLG_22
    },
    [KECLEON_BROS_MODE_WARES_ASLEEP] = {
        [KECLEON_DLG_00] = KEC_WARES_ASLEEP_DLG_00,
        [KECLEON_DLG_01] = KEC_WARES_ASLEEP_DLG_01,
        [KECLEON_DLG_02] = KEC_WARES_ASLEEP_DLG_02,
        [KECLEON_DLG_03] = KEC_WARES_ASLEEP_DLG_03,
        [KECLEON_DLG_04] = KEC_WARES_ASLEEP_DLG_04,
        [KECLEON_DLG_05] = KEC_WARES_ASLEEP_DLG_05,
        [KECLEON_DLG_06] = KEC_WARES_ASLEEP_DLG_06,
        [KECLEON_DLG_07] = KEC_WARES_ASLEEP_DLG_07,
        [KECLEON_DLG_08] = KEC_WARES_ASLEEP_DLG_08,
        [KECLEON_DLG_09] = KEC_WARES_ASLEEP_DLG_09,
        [KECLEON_DLG_10] = KEC_WARES_ASLEEP_DLG_10,
        [KECLEON_DLG_11] = KEC_WARES_ASLEEP_DLG_11,
        [KECLEON_DLG_12] = KEC_WARES_ASLEEP_DLG_12,
        [KECLEON_DLG_13] = KEC_WARES_ASLEEP_DLG_13,
        [KECLEON_DLG_14] = KEC_WARES_ASLEEP_DLG_14,
        [KECLEON_DLG_15] = KEC_WARES_ASLEEP_DLG_15,
        [KECLEON_DLG_16] = KEC_WARES_ASLEEP_DLG_16,
        [KECLEON_DLG_17] = KEC_WARES_ASLEEP_DLG_17,
        [KECLEON_DLG_18] = KEC_WARES_ASLEEP_DLG_18,
        [KECLEON_DLG_19] = KEC_WARES_ASLEEP_DLG_19,
        [KECLEON_DLG_20] = KEC_WARES_ASLEEP_DLG_20,
        [KECLEON_DLG_21] = KEC_WARES_ASLEEP_DLG_21,
        [KECLEON_DLG_22] = KEC_WARES_ASLEEP_DLG_22
    }
};

ALIGNED(4) const u8* const gCommonWigglytuff[WIGGLYTUFF_SHOP_MODE_COUNT][WIGGLY_DLG_MAX] =
{
    [WIGGLYTUFF_SHOP_MODE_AWAKE] = {
        [WIGGLY_DLG_00] = WIGGLY_AWAKE_DLG_00,
        [WIGGLY_DLG_01] = WIGGLY_AWAKE_DLG_01,
        [WIGGLY_DLG_02] = WIGGLY_AWAKE_DLG_02,
        [WIGGLY_DLG_03] = WIGGLY_AWAKE_DLG_03,
        [WIGGLY_DLG_04] = WIGGLY_AWAKE_DLG_04,
        [WIGGLY_DLG_05] = WIGGLY_AWAKE_DLG_05,
        [WIGGLY_DLG_06] = WIGGLY_AWAKE_DLG_06,
        [WIGGLY_DLG_07] = WIGGLY_AWAKE_DLG_07,
        [WIGGLY_DLG_08] = WIGGLY_AWAKE_DLG_08,
        [WIGGLY_DLG_09] = WIGGLY_AWAKE_DLG_09,
        [WIGGLY_DLG_10] = WIGGLY_AWAKE_DLG_10,
        [WIGGLY_DLG_11] = WIGGLY_AWAKE_DLG_11,
        [WIGGLY_DLG_12] = WIGGLY_AWAKE_DLG_12,
        [WIGGLY_DLG_13] = WIGGLY_AWAKE_DLG_13,
        [WIGGLY_DLG_14] = WIGGLY_AWAKE_DLG_14,
        [WIGGLY_DLG_15] = WIGGLY_AWAKE_DLG_15,
        [WIGGLY_DLG_16] = WIGGLY_AWAKE_DLG_16,
        [WIGGLY_DLG_17] = WIGGLY_AWAKE_DLG_17,
        [WIGGLY_DLG_18] = WIGGLY_AWAKE_DLG_18,
        [WIGGLY_DLG_19] = WIGGLY_AWAKE_DLG_19
    },
    [WIGGLYTUFF_SHOP_MODE_ASLEEP] = {
        [WIGGLY_DLG_00] = WIGGLY_ASLEEP_DLG_00,
        [WIGGLY_DLG_01] = WIGGLY_ASLEEP_DLG_01,
        [WIGGLY_DLG_02] = WIGGLY_ASLEEP_DLG_02,
        [WIGGLY_DLG_03] = WIGGLY_ASLEEP_DLG_03,
        [WIGGLY_DLG_04] = WIGGLY_ASLEEP_DLG_04,
        [WIGGLY_DLG_05] = WIGGLY_ASLEEP_DLG_05,
        [WIGGLY_DLG_06] = WIGGLY_ASLEEP_DLG_06,
        [WIGGLY_DLG_07] = WIGGLY_ASLEEP_DLG_07,
        [WIGGLY_DLG_08] = WIGGLY_ASLEEP_DLG_08,
        [WIGGLY_DLG_09] = WIGGLY_ASLEEP_DLG_09,
        [WIGGLY_DLG_10] = WIGGLY_ASLEEP_DLG_10,
        [WIGGLY_DLG_11] = WIGGLY_ASLEEP_DLG_11,
        [WIGGLY_DLG_12] = WIGGLY_ASLEEP_DLG_12,
        [WIGGLY_DLG_13] = WIGGLY_ASLEEP_DLG_13,
        [WIGGLY_DLG_14] = WIGGLY_ASLEEP_DLG_14,
        [WIGGLY_DLG_15] = WIGGLY_ASLEEP_DLG_15,
        [WIGGLY_DLG_16] = WIGGLY_ASLEEP_DLG_16,
        [WIGGLY_DLG_17] = WIGGLY_ASLEEP_DLG_17,
        [WIGGLY_DLG_18] = WIGGLY_ASLEEP_DLG_18,
        [WIGGLY_DLG_19] = WIGGLY_ASLEEP_DLG_19
    }
};

ALIGNED(4) const u8* const gCommonGulpin[GULPIN_SHOP_MODE_DIALOGUE_COUNT][GULPIN_DLG_MAX] =
{
    [GULPIN_SHOP_MODE_AWAKE] = {
        [GULPIN_DLG_00] = GULP_AWAKE_DLG_00,
        [GULPIN_DLG_01] = GULP_AWAKE_DLG_01,
        [GULPIN_DLG_02] = GULP_AWAKE_DLG_02,
        [GULPIN_DLG_03] = GULP_AWAKE_DLG_03,
        [GULPIN_DLG_04] = GULP_AWAKE_DLG_04,
        [GULPIN_DLG_05] = GULP_AWAKE_DLG_05,
        [GULPIN_DLG_06] = GULP_AWAKE_DLG_06,
        [GULPIN_DLG_07] = GULP_AWAKE_DLG_07,
        [GULPIN_DLG_08] = GULP_AWAKE_DLG_08,
        [GULPIN_DLG_09] = GULP_AWAKE_DLG_09,
        [GULPIN_DLG_10] = GULP_AWAKE_DLG_10,
        [GULPIN_DLG_11] = GULP_AWAKE_DLG_11,
        [GULPIN_DLG_12] = GULP_AWAKE_DLG_12,
        [GULPIN_DLG_13] = GULP_AWAKE_DLG_13,
        [GULPIN_DLG_14] = GULP_AWAKE_DLG_14,
        [GULPIN_DLG_15] = GULP_AWAKE_DLG_15,
        [GULPIN_DLG_16] = GULP_AWAKE_DLG_16,
        [GULPIN_DLG_17] = GULP_AWAKE_DLG_17,
        [GULPIN_DLG_18] = GULP_AWAKE_DLG_18,
        [GULPIN_DLG_19] = GULP_AWAKE_DLG_19,
        [GULPIN_DLG_20] = GULP_AWAKE_DLG_20,
        [GULPIN_DLG_21] = GULP_AWAKE_DLG_21,
        [GULPIN_DLG_22] = GULP_AWAKE_DLG_22,
        [GULPIN_DLG_23] = GULP_AWAKE_DLG_23,
        [GULPIN_DLG_24] = GULP_AWAKE_DLG_24
    },
    [GULPIN_SHOP_MODE_ASLEEP] = {
        [GULPIN_DLG_00] = GULP_ASLEEP_DLG_00,
        [GULPIN_DLG_01] = GULP_ASLEEP_DLG_01,
        [GULPIN_DLG_02] = GULP_ASLEEP_DLG_02,
        [GULPIN_DLG_03] = GULP_ASLEEP_DLG_03,
        [GULPIN_DLG_04] = GULP_ASLEEP_DLG_04,
        [GULPIN_DLG_05] = GULP_ASLEEP_DLG_05,
        [GULPIN_DLG_06] = GULP_ASLEEP_DLG_06,
        [GULPIN_DLG_07] = GULP_ASLEEP_DLG_07,
        [GULPIN_DLG_08] = GULP_ASLEEP_DLG_08,
        [GULPIN_DLG_09] = GULP_ASLEEP_DLG_09,
        [GULPIN_DLG_10] = GULP_ASLEEP_DLG_10,
        [GULPIN_DLG_11] = GULP_ASLEEP_DLG_11,
        [GULPIN_DLG_12] = GULP_ASLEEP_DLG_12,
        [GULPIN_DLG_13] = GULP_ASLEEP_DLG_13,
        [GULPIN_DLG_14] = GULP_ASLEEP_DLG_14,
        [GULPIN_DLG_15] = GULP_ASLEEP_DLG_15,
        [GULPIN_DLG_16] = GULP_ASLEEP_DLG_16,
        [GULPIN_DLG_17] = GULP_ASLEEP_DLG_17,
        [GULPIN_DLG_18] = GULP_ASLEEP_DLG_18,
        [GULPIN_DLG_19] = GULP_ASLEEP_DLG_19,
        [GULPIN_DLG_20] = GULP_ASLEEP_DLG_20,
        [GULPIN_DLG_21] = GULP_ASLEEP_DLG_21,
        [GULPIN_DLG_22] = GULP_ASLEEP_DLG_22,
        [GULPIN_DLG_23] = GULP_ASLEEP_DLG_23,
        [GULPIN_DLG_24] = GULP_ASLEEP_DLG_24
    }
};

ALIGNED(4) const u8* const gCommonMakuhita[MAKUHITA_DOJO_MODE_COUNT][MAKUHITA_DLG_MAX] =
{
    [MAKUHITA_DOJO_MODE_AWAKE] = {
        [MAKUHITA_DLG_0] = MAKU_AWAKE_DLG_0,
        [MAKUHITA_DLG_1] = MAKU_AWAKE_DLG_1,
        [MAKUHITA_DLG_2] = MAKU_AWAKE_DLG_2,
        [MAKUHITA_DLG_3] = MAKU_AWAKE_DLG_3,
        [MAKUHITA_DLG_4] = MAKU_AWAKE_DLG_4,
        [MAKUHITA_DLG_5] = MAKU_AWAKE_DLG_5,
        [MAKUHITA_DLG_6] = MAKU_AWAKE_DLG_6,
        [MAKUHITA_DLG_7] = MAKU_AWAKE_DLG_7,
        [MAKUHITA_DLG_8] = MAKU_AWAKE_DLG_8,
        [MAKUHITA_DLG_9] = MAKU_AWAKE_DLG_9
    },
    [MAKUHITA_DOJO_MODE_ASLEEP] = {
        [MAKUHITA_DLG_0] = MAKU_ASLEEP_DLG_0,
        [MAKUHITA_DLG_1] = MAKU_ASLEEP_DLG_1,
        [MAKUHITA_DLG_2] = MAKU_ASLEEP_DLG_2,
        [MAKUHITA_DLG_3] = MAKU_ASLEEP_DLG_3,
        [MAKUHITA_DLG_4] = MAKU_ASLEEP_DLG_4,
        [MAKUHITA_DLG_5] = MAKU_ASLEEP_DLG_5,
        [MAKUHITA_DLG_6] = MAKU_ASLEEP_DLG_6,
        [MAKUHITA_DLG_7] = MAKU_ASLEEP_DLG_7,
        [MAKUHITA_DLG_8] = MAKU_ASLEEP_DLG_8,
        [MAKUHITA_DLG_9] = MAKU_ASLEEP_DLG_9
    }
};

ALIGNED(4) const Hints gCommonHints[HINT_MAX] =
{
    [HINT_TOWN_CONTROLS_1] = {HINTHEADING_TOWN_CONTROLS_1, HINTBODY_TOWN_CONTROLS_1},
    [HINT_TOWN_CONTROLS_2] = {HINTHEADING_TOWN_CONTROLS_2, HINTBODY_TOWN_CONTROLS_2},
    [HINT_SAVING] = {HINTHEADING_SAVING, HINTBODY_SAVING},
    [HINT_ADVENTURES_WITH_FRIENDS] = {HINTHEADING_ADVENTURES_WITH_FRIENDS, HINTBODY_ADVENTURES_WITH_FRIENDS},
    [HINT_BUILDING_A_TEAM] = {HINTHEADING_BUILDING_A_TEAM, HINTBODY_BUILDING_A_TEAM}
};