#include "global.h"
#include "globaldata.h"
#include "constants/dungeon.h"
#include "dungeon.h"
#include "event_flag.h"
#include "code_80A26CC.h"
#include "code_80972F4.h"

ALIGNED(4) const char gMeetNinetalesText[] =  "Meet Ninetales.";
ALIGNED(4) const char gAvoidCaptureText[] = "Avoid capture.";
ALIGNED(4) const char gFinalScenarioText[] = _("Defeat the final Pokémon.");

bool8 sub_8097504(s16 mazeIndex)
{
    s32 uVar3;
    s32 mazeIndex_ = Self_s16(mazeIndex); // Needed to match
    if (mazeIndex < 17) {
        switch (mazeIndex) {
            case 2:
            case 10:
            case 11:
            case 12:
                uVar3 = 14;
                break;
            case 0:
            case 1:
            case 5:
            case 7:
            case 9:
            case 14:
                uVar3 = 15;
                break;
            case 3:
            case 4:
            case 6:
            case 8:
                return TRUE;
            case 13:
                uVar3 = 6;
                break;
            default:
                return TRUE;
        }
    }
    else {
        if (mazeIndex_ > 22)  return FALSE;
        if (mazeIndex_ == 22) return FALSE;
        if (mazeIndex_ == 21) return FALSE;
        uVar3 = 6;
    }

    if (!sub_80023E4(uVar3)) {
        return FALSE;
    }
    else {
        return TRUE;
    }
}

bool8 IsMazeCompleted(s16 mazeIndex)
{
    return (GetScriptVarArrayValue(NULL, TRAINING_CONQUEST_LIST, mazeIndex) != 0);
}

void sub_80975A8(s16 param_1,u8 param_2)
{
    u16 param_1_u16 = param_1;
    SetScriptVarArrayValue(NULL,TRAINING_CONQUEST_LIST,param_1_u16,param_2);
}

const u8 *sub_80975C4(s16 index)
{
    return GetDungeonName1(sub_80A2728(index));
}

const u8 *sub_80975DC(s16 r0)
{
    if(r0 == 23 || r0 == 24) {
        if(ScriptVarScenarioEqual(SCENARIO_MAIN, 0xE, -1))
            return gMeetNinetalesText;
        else
            return gAvoidCaptureText;
    }
    else
        return gFinalScenarioText;
}

bool8 HasCompletedAllMazes(void)
{
    s32 index;
    for(index = 0; index < NUM_BASIC_DUNGEON_MAZE; index++)
    {
        if(!(bool8)IsMazeCompleted(index))
            return FALSE;
    }
    return TRUE;
}

bool8 sub_8097640(void)
{
    if(GetScriptVarArrayValue(NULL, TRAINING_CONQUEST_LIST, 0x1F) == 0 && HasCompletedAllMazes())
    {
        SetScriptVarArrayValue(NULL, TRAINING_CONQUEST_LIST, 0x1F, 1);
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

