#ifndef GUARD_CONSTANTS_STATUS_H
#define GUARD_CONSTANTS_STATUS_H

// Sleep class statuses
#define STATUS_NONE 0
#define STATUS_SLEEP 1
#define STATUS_SLEEPLESS 2
#define STATUS_NIGHTMARE 3
#define STATUS_YAWNING 4
#define STATUS_NAPPING 5

// Burn class statuses
#define STATUS_BURN 1
#define STATUS_POISONED 2
#define STATUS_BADLY_POISONED 3
#define STATUS_PARALYSIS 4

// Frozen class statuses
#define STATUS_FROZEN 1
#define STATUS_SHADOW_HOLD 2
#define STATUS_WRAP 3
#define STATUS_WRAPPED 4
#define STATUS_INGRAIN 5
#define STATUS_PETRIFIED 6
#define STATUS_CONSTRICTION 7

// Cringe class statuses
#define STATUS_CRINGE 1
#define STATUS_CONFUSED 2
#define STATUS_PAUSED 3
#define STATUS_COWERING 4
#define STATUS_TAUNTED 5
#define STATUS_ENCORE 6
#define STATUS_INFATUATED 7

// Bide class statuses
#define STATUS_BIDE 1
#define STATUS_SOLARBEAM 2
#define STATUS_SKY_ATTACK 3
#define STATUS_RAZOR_WIND 4
#define STATUS_FOCUS_PUNCH 5
#define STATUS_SKULL_BASH 6
#define STATUS_FLYING 7
#define STATUS_BOUNCING 8
#define STATUS_DIVING 9
#define STATUS_DIGGING 10
#define STATUS_CHARGING 11
#define STATUS_ENRAGED 12

// ReflectClassStatus statuses
#define STATUS_REFLECT 1
#define STATUS_SAFEGUARD 2
#define STATUS_LIGHT_SCREEN 3
#define STATUS_COUNTER 4
#define STATUS_MAGIC_COAT 5
#define STATUS_WISH 6
#define STATUS_PROTECT 7
#define STATUS_MIRROR_COAT 8
#define STATUS_ENDURING 9
#define STATUS_MINI_COUNTER 10
#define STATUS_MIRROR_MOVE 11
#define STATUS_CONVERSION2 12
#define STATUS_VITAL_THROW 13
#define STATUS_MIST 14

// Curse class statuses
#define STATUS_CURSED 1
#define STATUS_DECOY 2
#define STATUS_SNATCH 3

// Leech Seed class statuses
#define STATUS_LEECH_SEED 1
#define STATUS_DESTINY_BOND 2

// Sure Shot class statuses
#define STATUS_SURE_SHOT 1
#define STATUS_WHIFFER 2
#define STATUS_SET_DAMAGE 3
#define STATUS_FOCUS_ENERGY 4

// Long Toss class statuses
#define STATUS_LONG_TOSS 1
#define STATUS_PIERCE 2

// Invisible class statuses
#define STATUS_INVISIBLE 1
#define STATUS_TRANSFORMED 2
#define STATUS_MOBILE 3

// Blinker class statuses
#define STATUS_BLINKER 1
#define STATUS_CROSS_EYED 2
#define STATUS_EYEDROPS 3

#define STATUS_SPRITE_SLEEPLESS (1 << 0)
#define STATUS_SPRITE_BURNED (1 << 1)
#define STATUS_SPRITE_POISONED (1 << 2)
#define STATUS_SPRITE_BADLY_POISONED (1 << 3)
#define STATUS_SPRITE_CONFUSED (1 << 4)
#define STATUS_SPRITE_COWERING (1 << 5)
#define STATUS_SPRITE_TAUNTED (1 << 6)
#define STATUS_SPRITE_ENCORE (1 << 7)
#define STATUS_SPRITE_SHIELD_BLUE (1 << 8) // REFLECT, COUNTER, MINI_COUNTER, MIST
#define STATUS_SPRITE_SHIELD_RED (1 << 9) // SAFEGUARD, MIRROR_COAT
#define STATUS_SPRITE_SHIELD_YELLOW (1 << 10) // LIGHT_SCREEN, MAGIC_COAT
#define STATUS_SPRITE_SHIELD_GREEN (1 << 11) // PROTECT, MIRRO_MOVE, VITAL_THROW
#define STATUS_SPRITE_ENDURE (1 << 12)
#define STATUS_SPRITE_LOWHP (1 << 13)
#define STATUS_SPRITE_CURSED (1 << 14)
#define STATUS_SPRITE_SNATCH (1 << 15)
#define STATUS_SPRITE_SURE_SHOT (1 << 16)
#define STATUS_SPRITE_WHIFFER (1 << 17)
#define STATUS_SPRITE_SET_DAMAGE (1 << 18)
#define STATUS_SPRITE_FOCUS_ENERGY (1 << 19)
#define STATUS_SPRITE_BLINKER (1 << 20)
#define STATUS_SPRITE_CROSS_EYED (1 << 21)
#define STATUS_SPRITE_EYEDROPS (1 << 22)
#define STATUS_SPRITE_MUZZLED (1 << 23)
#define STATUS_SPRITE_GRUDGE (1 << 24)
#define STATUS_SPRITE_EXPOSED (1 << 25)
#define STATUS_SPRITE_SLEEP (1 << 26)
#define STATUS_SPRITE_STAT_DOWN (1 << 27)
#define STATUS_SPRITE_FROZEN (1 << 28)

#endif
