#ifndef GUARD_CONSTANTS_MOVE_ID_H
#define GUARD_CONSTANTS_MOVE_ID_H

// These IDs should be kept in sync with tools/dungeonjson/move_id_json.cpp for any moves that Pokémon can learn normally.

#define MOVE_NOTHING 0x0
#define MOVE_IRON_TAIL 0x1
#define MOVE_ICE_BALL 0x2
#define MOVE_YAWN 0x3
#define MOVE_LOVELY_KISS 0x4
#define MOVE_NIGHTMARE 0x5
#define MOVE_MORNING_SUN 0x6
#define MOVE_VITAL_THROW 0x7
#define MOVE_DIG 0x8
#define MOVE_THRASH 0x9
#define MOVE_SWEET_SCENT 0xA
#define MOVE_CHARM 0xB
#define MOVE_RAIN_DANCE 0xC
#define MOVE_CONFUSE_RAY 0xD
#define MOVE_HAIL 0xE
#define MOVE_AROMATHERAPY 0xF
#define MOVE_BUBBLE 0x10
#define MOVE_ENCORE 0x11
#define MOVE_CUT 0x12
#define MOVE_RAGE 0x13
#define MOVE_SUPER_FANG 0x14
#define MOVE_PAIN_SPLIT 0x15
#define MOVE_TORMENT 0x16
#define MOVE_STRING_SHOT 0x17
#define MOVE_SWAGGER 0x18
#define MOVE_SNORE 0x19
#define MOVE_HEAL_BELL 0x1A
#define MOVE_SCREECH 0x1B
#define MOVE_ROCK_THROW 0x1C
#define MOVE_ROCK_SMASH 0x1D
#define MOVE_ROCK_SLIDE 0x1E
#define MOVE_WEATHER_BALL 0x1F
#define MOVE_WHIRLPOOL 0x20
#define MOVE_FAKE_TEARS 0x21
#define MOVE_SING 0x22
#define MOVE_SPITE 0x23
#define MOVE_AIR_CUTTER 0x24
#define MOVE_SMOKESCREEN 0x25
#define MOVE_PURSUIT 0x26
#define MOVE_DOUBLESLAP 0x27
#define MOVE_MIRROR_MOVE 0x28
#define MOVE_OVERHEAT 0x29
#define MOVE_AURORA_BEAM 0x2A
#define MOVE_MEMENTO 0x2B
#define MOVE_OCTAZOOKA 0x2C
#define MOVE_FLATTER 0x2D
#define MOVE_ASTONISH 0x2E
#define MOVE_WILL_O_WISP 0x2F
#define MOVE_RETURN 0x30
#define MOVE_GRUDGE 0x31
#define MOVE_STRENGTH 0x32
#define MOVE_COUNTER 0x33
#define MOVE_FLAME_WHEEL 0x34
#define MOVE_FLAMETHROWER 0x35
#define MOVE_ODOR_SLEUTH 0x36
#define MOVE_SHARPEN 0x37
#define MOVE_DOUBLE_TEAM 0x38
#define MOVE_GUST 0x39
#define MOVE_HARDEN 0x3A
#define MOVE_DISABLE 0x3B
#define MOVE_RAZOR_WIND 0x3C
#define MOVE_BIDE 0x3D
#define MOVE_CRUNCH 0x3E
#define MOVE_BITE 0x3F
#define MOVE_THUNDER 0x40
#define MOVE_THUNDERPUNCH 0x41
#define MOVE_ENDEAVOR 0x42
#define MOVE_FACADE 0x43
#define MOVE_KARATE_CHOP 0x44
#define MOVE_CLAMP 0x45
#define MOVE_WITHDRAW 0x46
#define MOVE_CONSTRICT 0x47
#define MOVE_BRICK_BREAK 0x48
#define MOVE_ROCK_TOMB 0x49
#define MOVE_FOCUS_ENERGY 0x4A
#define MOVE_FOCUS_PUNCH 0x4B
#define MOVE_GIGA_DRAIN 0x4C
#define MOVE_REVERSAL 0x4D
#define MOVE_SMELLINGSALT 0x4E
#define MOVE_SPORE 0x4F
#define MOVE_LEECH_LIFE 0x50
#define MOVE_SLASH 0x51
#define MOVE_SILVER_WIND 0x52
#define MOVE_METAL_SOUND 0x53
#define MOVE_GRASSWHISTLE 0x54
#define MOVE_TICKLE 0x55
#define MOVE_SPIDER_WEB 0x56
#define MOVE_CRABHAMMER 0x57
#define MOVE_HAZE 0x58
#define MOVE_MEAN_LOOK 0x59
#define MOVE_CROSS_CHOP 0x5A
#define MOVE_OUTRAGE 0x5B
#define MOVE_LOW_KICK 0x5C
#define MOVE_ANCIENTPOWER 0x5D
#define MOVE_SYNTHESIS 0x5E
#define MOVE_AGILITY 0x5F
#define MOVE_RAPID_SPIN 0x60
#define MOVE_ICY_WIND 0x61
#define MOVE_MIND_READER 0x62
#define MOVE_COSMIC_POWER 0x63
#define MOVE_SKY_ATTACK 0x64
#define MOVE_POWDER_SNOW 0x65
#define MOVE_FOLLOW_ME 0x66
#define MOVE_METEOR_MASH 0x67
#define MOVE_ENDURE 0x68
#define MOVE_ROLLOUT 0x69
#define MOVE_SCARY_FACE 0x6A
#define MOVE_PSYBEAM 0x6B
#define MOVE_PSYWAVE 0x6C
#define MOVE_PSYCHIC 0x6D
#define MOVE_PSYCHO_BOOST 0x6E
#define MOVE_HYPNOSIS 0x6F
#define MOVE_UPROAR 0x70
#define MOVE_WATER_SPOUT 0x71
#define MOVE_SIGNAL_BEAM 0x72
#define MOVE_PSYCH_UP 0x73
#define MOVE_SUBMISSION 0x74
#define MOVE_RECOVER 0x75
#define MOVE_EARTHQUAKE 0x76
#define MOVE_NATURE_POWER 0x77
#define MOVE_LICK 0x78
#define MOVE_FLAIL 0x79
#define MOVE_TAIL_WHIP 0x7A
#define MOVE_SELFDESTRUCT 0x7B
#define MOVE_STUN_SPORE 0x7C
#define MOVE_BIND 0x7D
#define MOVE_SHADOW_PUNCH 0x7E
#define MOVE_SHADOW_BALL 0x7F
#define MOVE_CHARGE 0x80
#define MOVE_THUNDERBOLT 0x81
#define MOVE_MIST 0x82
#define MOVE_FISSURE 0x83
#define MOVE_EXTREMESPEED 0x84
#define MOVE_EXTRASENSORY 0x85
#define MOVE_SAFEGUARD 0x86
#define MOVE_ABSORB 0x87
#define MOVE_SKY_UPPERCUT 0x88
#define MOVE_SKILL_SWAP 0x89
#define MOVE_SKETCH 0x8A
#define MOVE_HEADBUTT 0x8B
#define MOVE_DOUBLE_EDGE 0x8C
#define MOVE_SANDSTORM 0x8D
#define MOVE_SAND_ATTACK 0x8E
#define MOVE_SAND_TOMB 0x8F
#define MOVE_SPARK 0x90
#define MOVE_SWIFT 0x91
#define MOVE_KINESIS 0x92
#define MOVE_SMOG 0x93
#define MOVE_GROWTH 0x94
#define MOVE_SACRED_FIRE 0x95
#define MOVE_SHEER_COLD 0x96
#define MOVE_SOLARBEAM 0x97
#define MOVE_SONICBOOM 0x98
#define MOVE_FLY 0x99
#define MOVE_TACKLE 0x9A
#define MOVE_EXPLOSION 0x9B
#define MOVE_DIVE 0x9C
#define MOVE_FIRE_BLAST 0x9D
#define MOVE_WATERFALL 0x9E
#define MOVE_MUDDY_WATER 0x9F
#define MOVE_STOCKPILE 0xA0
#define MOVE_SLAM 0xA1
#define MOVE_TWISTER 0xA2
#define MOVE_BULLET_SEED 0xA3
#define MOVE_TWINEEDLE 0xA4
#define MOVE_SOFTBOILED 0xA5
#define MOVE_EGG_BOMB 0xA6
#define MOVE_FAINT_ATTACK 0xA7
#define MOVE_BARRAGE 0xA8
#define MOVE_MINIMIZE 0xA9
#define MOVE_SEISMIC_TOSS 0xAA
#define MOVE_SUPERSONIC 0xAB
#define MOVE_TAUNT 0xAC
#define MOVE_MOONLIGHT 0xAD
#define MOVE_PECK 0xAE
#define MOVE_ARM_THRUST 0xAF
#define MOVE_HORN_ATTACK 0xB0
#define MOVE_HORN_DRILL 0xB1
#define MOVE_WING_ATTACK 0xB2
#define MOVE_AERIAL_ACE 0xB3
#define MOVE_ICICLE_SPEAR 0xB4
#define MOVE_SWORDS_DANCE 0xB5
#define MOVE_VINE_WHIP 0xB6
#define MOVE_CONVERSION 0xB7
#define MOVE_CONVERSION_2 0xB8
#define MOVE_HELPING_HAND 0xB9
#define MOVE_IRON_DEFENSE 0xBA
#define MOVE_TELEPORT 0xBB
#define MOVE_THUNDERSHOCK 0xBC
#define MOVE_SHOCK_WAVE 0xBD
#define MOVE_QUICK_ATTACK 0xBE
#define MOVE_SWEET_KISS 0xBF
#define MOVE_THUNDER_WAVE 0xC0
#define MOVE_ZAP_CANNON 0xC1
#define MOVE_BLOCK 0xC2
#define MOVE_HOWL 0xC3
#define MOVE_POISON_GAS 0xC4
#define MOVE_TOXIC 0xC5
#define MOVE_POISON_FANG 0xC6
#define MOVE_POISONPOWDER 0xC7
#define MOVE_POISON_STING 0xC8
#define MOVE_SPIKE_CANNON 0xC9
#define MOVE_ACID_ARMOR 0xCA
#define MOVE_TAKE_DOWN 0xCB
#define MOVE_JUMP_KICK 0xCC
#define MOVE_BOUNCE 0xCD
#define MOVE_HI_JUMP_KICK 0xCE
#define MOVE_TRI_ATTACK 0xCF
#define MOVE_DRAGON_CLAW 0xD0
#define MOVE_TRICK 0xD1
#define MOVE_TRIPLE_KICK 0xD2
#define MOVE_DRILL_PECK 0xD3
#define MOVE_MUD_SPORT 0xD4
#define MOVE_MUD_SLAP 0xD5
#define MOVE_THIEF 0xD6
#define MOVE_AMNESIA 0xD7
#define MOVE_NIGHT_SHADE 0xD8
#define MOVE_GROWL 0xD9
#define MOVE_SLACK_OFF 0xDA
#define MOVE_SURF 0xDB
#define MOVE_ROLE_PLAY 0xDC
#define MOVE_NEEDLE_ARM 0xDD
#define MOVE_DOUBLE_KICK 0xDE
#define MOVE_SUNNY_DAY 0xDF
#define MOVE_LEER 0xE0
#define MOVE_WISH 0xE1
#define MOVE_FAKE_OUT 0xE2
#define MOVE_SLEEP_TALK 0xE3
#define MOVE_PAY_DAY 0xE4
#define MOVE_ASSIST 0xE5
#define MOVE_HEAT_WAVE 0xE6
#define MOVE_SLEEP_POWDER 0xE7
#define MOVE_REST 0xE8
#define MOVE_INGRAIN 0xE9
#define MOVE_CONFUSION 0xEA
#define MOVE_BODY_SLAM 0xEB
#define MOVE_SWALLOW 0xEC
#define MOVE_CURSE 0xED
#define MOVE_FRENZY_PLANT 0xEE
#define MOVE_HYDRO_CANNON 0xEF
#define MOVE_HYDRO_PUMP 0xF0
#define MOVE_HYPER_VOICE 0xF1
#define MOVE_HYPER_BEAM 0xF2
#define MOVE_SUPERPOWER 0xF3
#define MOVE_STEEL_WING 0xF4
#define MOVE_SPIT_UP 0xF5
#define MOVE_DYNAMICPUNCH 0xF6
#define MOVE_GUILLOTINE 0xF7
#define MOVE_VICEGRIP 0xF8
#define MOVE_KNOCK_OFF 0xF9
#define MOVE_POUND 0xFA
#define MOVE_RAZOR_LEAF 0xFB
#define MOVE_BATON_PASS 0xFC
#define MOVE_PETAL_DANCE 0xFD
#define MOVE_SPLASH 0xFE
#define MOVE_BUBBLEBEAM 0xFF
#define MOVE_DOOM_DESIRE 0x100
#define MOVE_BELLY_DRUM 0x101
#define MOVE_BARRIER 0x102
#define MOVE_LIGHT_SCREEN 0x103
#define MOVE_SCRATCH 0x104
#define MOVE_HYPER_FANG 0x105
#define MOVE_EMBER 0x106
#define MOVE_SECRET_POWER 0x107
#define MOVE_DIZZY_PUNCH 0x108
#define MOVE_BULK_UP 0x109
#define MOVE_IMPRISON 0x10A
#define MOVE_FEATHERDANCE 0x10B
#define MOVE_WHIRLWIND 0x10C
#define MOVE_BEAT_UP 0x10D
#define MOVE_BLIZZARD 0x10E
#define MOVE_STOMP 0x10F
#define MOVE_BLAST_BURN 0x110
#define MOVE_FLASH 0x111
#define MOVE_TEETER_DANCE 0x112
#define MOVE_CRUSH_CLAW 0x113
#define MOVE_BLAZE_KICK 0x114
#define MOVE_PRESENT 0x115
#define MOVE_ERUPTION 0x116
#define MOVE_SLUDGE 0x117
#define MOVE_SLUDGE_BOMB 0x118
#define MOVE_GLARE 0x119
#define MOVE_TRANSFORM 0x11A
#define MOVE_POISON_TAIL 0x11B
#define MOVE_ROAR 0x11C
#define MOVE_BONE_RUSH 0x11D
#define MOVE_CAMOUFLAGE 0x11E
#define MOVE_COVET 0x11F
#define MOVE_TAIL_GLOW 0x120
#define MOVE_BONE_CLUB 0x121
#define MOVE_BONEMERANG 0x122
#define MOVE_FIRE_SPIN 0x123
#define MOVE_FIRE_PUNCH 0x124
#define MOVE_PERISH_SONG 0x125
#define MOVE_WRAP 0x126
#define MOVE_SPIKES 0x127
#define MOVE_MAGNITUDE 0x128
#define MOVE_MAGICAL_LEAF 0x129
#define MOVE_MAGIC_COAT 0x12A
#define MOVE_MUD_SHOT 0x12B
#define MOVE_MACH_PUNCH 0x12C
#define MOVE_PROTECT 0x12D
#define MOVE_DEFENSE_CURL 0x12E
#define MOVE_ROLLING_KICK 0x12F
#define MOVE_SUBSTITUTE 0x130
#define MOVE_DETECT 0x131
#define MOVE_PIN_MISSILE 0x132
#define MOVE_WATER_SPORT 0x133
#define MOVE_WATER_GUN 0x134
#define MOVE_MIST_BALL 0x135
#define MOVE_WATER_PULSE 0x136
#define MOVE_FURY_ATTACK 0x137
#define MOVE_FURY_SWIPES 0x138
#define MOVE_DESTINY_BOND 0x139
#define MOVE_FALSE_SWIPE 0x13A
#define MOVE_FORESIGHT 0x13B
#define MOVE_MIRROR_COAT 0x13C
#define MOVE_FUTURE_SIGHT 0x13D
#define MOVE_MILK_DRINK 0x13E
#define MOVE_CALM_MIND 0x13F
#define MOVE_MEGA_DRAIN 0x140
#define MOVE_MEGA_KICK 0x141
#define MOVE_MEGA_PUNCH 0x142
#define MOVE_MEGAHORN 0x143
#define MOVE_HIDDEN_POWER 0x144
#define MOVE_METAL_CLAW 0x145
#define MOVE_ATTRACT 0x146
#define MOVE_MIMIC 0x147
#define MOVE_FRUSTRATION 0x148
#define MOVE_LEECH_SEED 0x149
#define MOVE_METRONOME 0x14A
#define MOVE_DREAM_EATER 0x14B
#define MOVE_ACID 0x14C
#define MOVE_MEDITATE 0x14D
#define MOVE_SNATCH 0x14E
#define MOVE_LUSTER_PURGE 0x14F
#define MOVE_LEAF_BLADE 0x150
#define MOVE_RECYCLE 0x151
#define MOVE_REFLECT 0x152
#define MOVE_REFRESH 0x153
#define MOVE_REVENGE 0x154
#define MOVE_DRAGON_RAGE 0x155
#define MOVE_DRAGONBREATH 0x156
#define MOVE_DRAGON_DANCE 0x157
#define MOVE_ICE_PUNCH 0x158
#define MOVE_ICE_BEAM 0x159
#define MOVE_FURY_CUTTER 0x15A
#define MOVE_COMET_PUNCH 0x15B
#define MOVE_SKULL_BASH 0x15C
#define MOVE_LOCK_ON 0x15D
#define MOVE_ROCK_BLAST 0x15E
#define MOVE_COTTON_SPORE 0x15F
#define MOVE_STRUGGLE 0x160
#define MOVE_AEROBLAST 0x161
#define MOVE_VOLT_TACKLE 0x162
#define MOVE_REGULAR_ATTACK 0x163
#define MOVE_IS_WATCHING 0x164
#define MOVE_BIDE_2 0x165 // Unused
#define MOVE_DOLLAR_1 0x166 // Unused
#define MOVE_DOLLAR_2 0x167 // Unused
#define MOVE_WIDE_SLASH 0x168
#define MOVE_EXCAVATE 0x169 // Unused
#define MOVE_SPIN_SLASH 0x16A // Unused
// Orb effects
#define MOVE_SEE_TRAP 0x16B
#define MOVE_TAKEAWAY 0x16C
#define MOVE_REBOUND 0x16D
#define MOVE_BLOOP_SLASH 0x16E
#define MOVE_SWITCHER 0x16F
#define MOVE_BLOWBACK 0x170
#define MOVE_WARP 0x171
#define MOVE_TRANSFER 0x172
#define MOVE_SLOW_DOWN 0x173
#define MOVE_SPEED_BOOST 0x174
#define MOVE_SEARCHLIGHT 0x175
#define MOVE_PETRIFY 0x176
#define MOVE_STAY_AWAY 0x177
#define MOVE_POUNCE 0x178
#define MOVE_TRAWL 0x179
#define MOVE_CLEANSE 0x17A
#define MOVE_OBSERVER 0x17B
#define MOVE_DECOY_MAKER 0x17C
#define MOVE_SIESTA 0x17D
#define MOVE_TOTTER 0x17E
#define MOVE_TWO_EDGE 0x17F
#define MOVE_NO_MOVE 0x180
#define MOVE_ESCAPE 0x181
#define MOVE_SCAN 0x182
#define MOVE_POWER_EARS 0x183
#define MOVE_DROUGHT 0x184
#define MOVE_TRAP_BUSTER 0x185
#define MOVE_WILD_CALL 0x186
#define MOVE_INVISIFY 0x187
#define MOVE_ONE_SHOT 0x188
#define MOVE_HP_GAUGE 0x189
#define MOVE_VACUUM_CUT 0x18A
#define MOVE_REVIVER 0x18B
#define MOVE_SHOCKER 0x18C
#define MOVE_ECHO 0x18D
#define MOVE_FAMISH 0x18E
#define MOVE_ONE_ROOM 0x18F
#define MOVE_FILL_IN 0x190
#define MOVE_TRAPPER 0x191
#define MOVE_POSSESS 0x192
#define MOVE_ITEMIZE 0x193
#define MOVE_MD1 0x194 // Unused
#define MOVE_PROJECTILE 0x195
#define MOVE_HURL 0x196
#define MOVE_MOBILE 0x197
#define MOVE_ITEM_TOSS 0x198
#define MOVE_SEE_STAIRS 0x199
#define MOVE_LONG_TOSS 0x19A
#define MOVE_MD1_2 0x19B // Unused
#define MOVE_PIERCE 0x19C

#define NUM_MOVE_IDS (MOVE_PIERCE + 1)

#endif
