#ifndef GUARD_CONSTANTS_ITEM_H
#define GUARD_CONSTANTS_ITEM_H

// Cannot include enums in this file since it's used by the data_item and data_monster assemblers

#define MAX_KECLEON_ITEM_SHOP_ITEMS 8
#define MAX_KECLEON_WARE_SHOP_ITEMS 4

#define MAX_TEAM_MONEY 99999
#define MAX_TEAM_SAVINGS 9999999

#define CATEGORY_THROWN_LINE 0
#define CATEGORY_THROWN_ARC 1
#define CATEGORY_BERRIES_SEEDS_VITAMINS 2
#define CATEGORY_FOOD_GUMMIES 3
#define CATEGORY_HELD_ITEMS 4
#define CATEGORY_TMS_HMS 5
#define CATEGORY_POKE 6
#define CATEGORY_OTHER 8
#define CATEGORY_ORBS 9
#define CATEGORY_LINK_BOX 10
#define CATEGORY_USED_TM 11
#define NUM_ITEM_CATEGORIES 12

#define ITEM_ACTION_TYPE_NOTHING 0
#define ITEM_ACTION_TYPE_THROWABLE 1
#define ITEM_ACTION_TYPE_ROCKS 2
#define ITEM_ACTION_TYPE_RIBBONS 3
#define ITEM_ACTION_TYPE_FOOD 4
#define ITEM_ACTION_TYPE_HEALING 5
#define ITEM_ACTION_TYPE_CHESTNUT 6
#define ITEM_ACTION_TYPE_MONEY_WISH_STONE 7
#define ITEM_ACTION_TYPE_MISC 8
#define ITEM_ACTION_TYPE_TM 9
#define ITEM_ACTION_TYPE_LINK_BOX 10
#define ITEM_ACTION_TYPE_SPECS 11
#define ITEM_ACTION_TYPE_SCARFS 12
#define ITEM_ACTION_TYPE_ORBS 13

// see https://bulbapedia.bulbagarden.net/wiki/List_of_items_by_index_number_(Rescue_Team)
#define ITEM_NOTHING 0
#define ITEM_STICK 1
#define ITEM_IRON_THORN 2
#define ITEM_SILVER_SPIKE 3
#define ITEM_GOLD_FANG 4
#define ITEM_CACNEA_SPIKE 5
#define ITEM_CORSOLA_TWIG 6
#define ITEM_GRAVELEROCK 7
#define ITEM_GEO_PEBBLE 8
#define ITEM_MOBILE_SCARF 9
#define ITEM_HEAL_RIBBON 10
#define ITEM_TWIST_BAND 11
#define ITEM_SCOPE_LENS 12
#define ITEM_PATSY_BAND 13
#define ITEM_NOSTICK_CAP 14
#define ITEM_PIERCE_BAND 15
#define ITEM_JOY_RIBBON 16
#define ITEM_X_RAY_SPECS 17
#define ITEM_PERSIM_BAND 18
#define ITEM_POWER_BAND 19
#define ITEM_PECHA_SCARF 20
#define ITEM_INSOMNISCOPE 21
#define ITEM_WARP_SCARF 22
#define ITEM_TIGHT_BELT 23
#define ITEM_SNEAK_SCARF 24
#define ITEM_GOLD_RIBBON 25
#define ITEM_GOGGLE_SPECS 26
#define ITEM_DIET_RIBBON 27
#define ITEM_TRAP_SCARF 28
#define ITEM_RACKET_BAND 29
#define ITEM_DEF_SCARF 30
#define ITEM_STAMINA_BAND 31
#define ITEM_PLAIN_RIBBON 32
#define ITEM_SPECIAL_BAND 33
#define ITEM_ZINC_BAND 34
#define ITEM_DETECT_BAND 35
#define ITEM_ALERT_SPECS 36
#define ITEM_DODGE_SCARF 37
#define ITEM_BOUNCE_BAND 38
#define ITEM_CURVE_BAND 39
#define ITEM_WHIFF_SPECS 40
#define ITEM_NO_AIM_SCOPE 41
#define ITEM_LOCKON_SPECS 42
#define ITEM_MUNCH_BELT 43
#define ITEM_PASS_SCARF 44
#define ITEM_WEATHER_BAND 45
#define ITEM_FRIEND_BOW 46
#define ITEM_BEAUTY_SCARF 47
#define ITEM_SUN_RIBBON 48
#define ITEM_LUNAR_RIBBON 49
#define ITEM_RING_D 50
#define ITEM_RING_E 51
#define ITEM_RING_F 52
#define ITEM_HEAL_SEED 53
#define ITEM_WISH_STONE 54
#define ITEM_ORAN_BERRY 55
#define ITEM_SITRUS_BERRY 56
#define ITEM_EYEDROP_SEED 57
#define ITEM_REVIVER_SEED 58
#define ITEM_BLINKER_SEED 59
#define ITEM_DOOM_SEED 60
#define ITEM_ALLURE_SEED 61
#define ITEM_LIFE_SEED 62
#define ITEM_RAWST_BERRY 63
#define ITEM_HUNGER_SEED 64
#define ITEM_QUICK_SEED 65
#define ITEM_PECHA_BERRY 66
#define ITEM_CHERI_BERRY 67
#define ITEM_TOTTER_SEED 68
#define ITEM_SLEEP_SEED 69
#define ITEM_PLAIN_SEED 70
#define ITEM_WARP_SEED 71
#define ITEM_BLAST_SEED 72
#define ITEM_GINSENG 73
#define ITEM_JOY_SEED 74
#define ITEM_CHESTO_BERRY 75
#define ITEM_STUN_SEED 76
#define ITEM_MAX_ELIXIR 77
#define ITEM_PROTEIN 78
#define ITEM_CALCIUM 79
#define ITEM_IRON 80
#define ITEM_ZINC 81
#define ITEM_APPLE 82
#define ITEM_BIG_APPLE 83
#define ITEM_GRIMY_FOOD 84
#define ITEM_HUGE_APPLE 85
#define ITEM_WHITE_GUMMI 86
#define ITEM_RED_GUMMI 87
#define ITEM_BLUE_GUMMI 88
#define ITEM_GRASS_GUMMI 89
#define ITEM_YELLOW_GUMMI 90
#define ITEM_CLEAR_GUMMI 91
#define ITEM_ORANGE_GUMMI 92
#define ITEM_PINK_GUMMI 93
#define ITEM_BROWN_GUMMI 94
#define ITEM_SKY_GUMMI 95
#define ITEM_GOLD_GUMMI 96
#define ITEM_GREEN_GUMMI 97
#define ITEM_GRAY_GUMMI 98
#define ITEM_PURPLE_GUMMI 99
#define ITEM_ROYAL_GUMMI 100
#define ITEM_BLACK_GUMMI 101
#define ITEM_SILVER_GUMMI 102
#define ITEM_BANANA 103
#define ITEM_CHESTNUT 104
#define ITEM_POKE 105
#define ITEM_UPGRADE 106
#define ITEM_KINGS_ROCK 107
#define ITEM_THUNDERSTONE 108
#define ITEM_DEEPSEASCALE 109
#define ITEM_DEEPSEATOOTH 110
#define ITEM_SUN_STONE 111
#define ITEM_MOON_STONE 112
#define ITEM_FIRE_STONE 113
#define ITEM_WATER_STONE 114
#define ITEM_METAL_COAT 115
#define ITEM_LEAF_STONE 116
#define ITEM_DRAGON_SCALE 117
#define ITEM_LINK_CABLE 118
#define ITEM_ICE_PART 119
#define ITEM_STEEL_PART 120
#define ITEM_ROCK_PART 121
#define ITEM_MUSIC_BOX 122
#define ITEM_KEY 123
#define ITEM_TM_USED_TM 124
#define ITEM_TM_FOCUS_PUNCH 125
#define ITEM_TM_DRAGON_CLAW 126
#define ITEM_TM_WATER_PULSE 127
#define ITEM_TM_CALM_MIND 128
#define ITEM_TM_ROAR 129
#define ITEM_TM_TOXIC 130
#define ITEM_TM_HAIL 131
#define ITEM_TM_BULK_UP 132
#define ITEM_TM_BULLET_SEED 133
#define ITEM_TM_HIDDEN_POWER 134
#define ITEM_TM_SUNNY_DAY 135
#define ITEM_TM_TAUNT 136
#define ITEM_TM_ICE_BEAM 137
#define ITEM_TM_BLIZZARD 138
#define ITEM_TM_HYPER_BEAM 139
#define ITEM_TM_LIGHT_SCREEN 140
#define ITEM_TM_PROTECT 141
#define ITEM_TM_RAIN_DANCE 142
#define ITEM_TM_GIGA_DRAIN 143
#define ITEM_TM_SAFEGUARD 144
#define ITEM_TM_FRUSTRATION 145
#define ITEM_TM_SOLARBEAM 146
#define ITEM_TM_IRON_TAIL 147
#define ITEM_TM_THUNDERBOLT 148
#define ITEM_TM_THUNDER 149
#define ITEM_TM_EARTHQUAKE 150
#define ITEM_TM_RETURN 151
#define ITEM_TM_DIG 152
#define ITEM_TM_PSYCHIC 153
#define ITEM_TM_SHADOW_BALL 154
#define ITEM_TM_BRICK_BREAK 155
#define ITEM_TM_DOUBLE_TEAM 156
#define ITEM_TM_REFLECT 157
#define ITEM_TM_SHOCK_WAVE 158
#define ITEM_TM_FLAMETHROWER 159
#define ITEM_TM_SLUDGE_BOMB 160
#define ITEM_TM_SANDSTORM 161
#define ITEM_TM_FIRE_BLAST 162
#define ITEM_TM_ROCK_TOMB 163
#define ITEM_TM_AERIAL_ACE 164
#define ITEM_TM_TORMENT 165
#define ITEM_TM_FACADE 166
#define ITEM_TM_SECRET_POWER 167
#define ITEM_TM_REST 168
#define ITEM_TM_ATTRACT 169
#define ITEM_TM_THIEF 170
#define ITEM_TM_STEEL_WING 171
#define ITEM_TM_SKILL_SWAP 172
#define ITEM_TM_SNATCH 173
#define ITEM_TM_OVERHEAT 174
#define ITEM_TM_WIDE_SLASH 175
#define ITEM_TM_EXCAVATE 176
#define ITEM_TM_SPIN_SLASH 177
#define ITEM_SEE_TRAP_ORB 178
#define ITEM_MUG_ORB 179
#define ITEM_REBOUND_ORB 180
#define ITEM_LOB_ORB 181
#define ITEM_SWITCHER_ORB 182
#define ITEM_BLOWBACK_ORB 183
#define ITEM_WARP_ORB 184
#define ITEM_TRANSFER_ORB 185
#define ITEM_SLOW_ORB 186
#define ITEM_QUICK_ORB 187
#define ITEM_LUMINOUS_ORB 188
#define ITEM_PETRIFY_ORB 189
#define ITEM_STAYAWAY_ORB 190
#define ITEM_POUNCE_ORB 191
#define ITEM_TRAWL_ORB 192
#define ITEM_CLEANSE_ORB 193
#define ITEM_OBSERVER_ORB 194
#define ITEM_DECOY_ORB 195
#define ITEM_SLUMBER_ORB 196
#define ITEM_TOTTER_ORB 197
#define ITEM_TWO_EDGE_ORB 198
#define ITEM_SILENCE_ORB 199
#define ITEM_ESCAPE_ORB 200
#define ITEM_SCANNER_ORB 201
#define ITEM_RADAR_ORB 202
#define ITEM_DROUGHT_ORB 203
#define ITEM_TRAPBUST_ORB 204
#define ITEM_ROLLCALL_ORB 205
#define ITEM_INVISIFY_ORB 206
#define ITEM_ONE_SHOT_ORB 207
#define ITEM_IDENTIFY_ORB 208
#define ITEM_VACUUM_CUT 209
#define ITEM_REVIVER_ORB 210
#define ITEM_SHOCKER_ORB 211
#define ITEM_SIZEBUST_ORB 212
#define ITEM_ONE_ROOM_ORB 213
#define ITEM_FILL_IN_ORB 214
#define ITEM_TRAPPER_ORB 215
#define ITEM_POSSESS_ORB 216
#define ITEM_ITEMIZER_ORB 217
#define ITEM_HURL_ORB 218
#define ITEM_MOBILE_ORB 219
#define ITEM_TOSS_ORB 220
#define ITEM_STAIRS_ORB 221
#define ITEM_LONGTOSS_ORB 222
#define ITEM_PIERCE_ORB 223
#define ITEM_HM_CUT 224
#define ITEM_HM_FLY 225
#define ITEM_HM_SURF 226
#define ITEM_HM_STRENGTH 227
#define ITEM_HM_FLASH 228
#define ITEM_HM_ROCK_SMASH 229
#define ITEM_HM_WATERFALL 230
#define ITEM_HM_DIVE 231
#define ITEM_LINK_BOX 232
#define ITEM_SWITCH_BOX 233
#define ITEM_WEAVILE_FIG 234
#define ITEM_MIME_JR_FIG 235
#define ITEM_BEATUP_ORB 236
#define ITEM_G_MACHINE_6 237
#define ITEM_G_MACHINE_7 238
#define ITEM_G_MACHINE_8 239

#define NUMBER_OF_ITEM_IDS (ITEM_G_MACHINE_8 + 1)

#define NUMBER_OF_GUMMIS 18
#define INVENTORY_SIZE 20
#define STORAGE_SIZE NUMBER_OF_ITEM_IDS

#define MIN_SPAWN_AMOUNT 0
#define MAX_SPAWN_AMOUNT 1

#endif // GUARD_CONSTANTS_ITEM_H
