# Contributing
algo-education is an educational venture to create a one stop destination for various algorithms, starting for beginners and aiming for expertise. The repository gathers
code for different algorithms with proper explanation through comments.

## Getting Started
- Fork the repository on GitHub.
- If you find any bug/typo in our existing codes, please create a pull request as per following guidelines.

## Guidelines
This is a rough outline of what steps you need to follow:

- Create a separate branch to base your work.
- Make commits of logical units.
- Make sure your commit messages are in the proper format (see below).
- Push your changes in your fork of the repository.
- Make sure to proofread the code before submitting.
- Submit a pull request to the original repository.

### Commit Messages
Please follow the below format while writing commit messages:

```
  title: One line description about your change
  <Blank Line>
  description: An optional description of your changes.
```

Thanks for your contribution.

## What we are looking for

- A clean code with proper indentation.
- The code should mention all the libraries required to run it.
- The code should be properly explained through comments.
- Creating separate function (or method) for algorithm will be appreciated.
- The file should be named as "algorithm-name_language".

Please note we have a code of conduct, which you shall follow in all your interactions with the project.

## Code of Conduct

### Our Pledge

In the interest of educating budding coders, I as a contributer pledge to make the contribution process unbiased, responsible and intelligible. I shall report the 
spam requests, and unaccept improper requests.

### Our Responsibilities

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not
aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or 
harmful.
