const SvgComponent = props => (
  <svg
    viewBox="0 0 512 512"
    xmlSpace="preserve"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.148}
    >
      <path
        clipRule="evenodd"
        d="M-807.803-1571.144c88.705 5.973 79.16 346.885 58.384 418.989-5.572 19.29-9.773 37.952-24.748 49.155-20.262-25.521-58.699-22.806-73.216 0-15.003-11.203-18.347-30.15-24.749-49.155-22.433-66.502-23.719-424.905 64.329-418.989h0z"
        fill="#F5D8B3"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="M-807.803-1559.57v374.521M-807.803-1154.898v-.23M-871.045-1468.004c3.515 93.452 145.432 101.167 130.257 264.122-54.355-160.125-146.232-100.997-130.257-264.122h0z"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="m-368.283-1409.821-.229 17.318 312.382.057c-4.686 24.949-55.813 75.59-87.791 90.022-13.945-1.172-28.406-3.229-43.408-6.173-54.24-13.289-103.366-14.404-146.061-.286-45.639 12.031-82.589 14.232-106.566 1.715-4.629-2.344-9.23-4.201-13.86-5.63-43.752-41.467 18.033-97.08 85.533-97.023h0z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="M-76.533-1357.98h-318.155M-38.01-1312.569c-42.752 13.231-92.105 15.261-149.318 3.973-54.24-13.289-103.366-14.404-146.061-.286-45.639 12.031-82.589 14.232-106.566 1.715-24.348-12.46-48.696-10.975-73.044-3.229M-94.564-1258.242c-36.266 3.602-75.275 7.06-115.426-12.745-31.693-12.118-62.9-20.634-102.537-.258-68.93 26.778-112.682 9.803-126.685 5.83-14.003-4.001-32.807-19.319-56.098-6.459M-68.531-1262.786l13.603-2.829"
      />
      <path
        clipRule="evenodd"
        fill="#DCF2FF"
        fillRule="evenodd"
        d="m-316.757-1439-.343 46.526 134.258.142-77.217-46.583z"
      />
      <path
        fill="none"
        d="m-280.149-1438.943.086 46.726M-426.467-1359.781h-38.265"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="M-1367.051-1512.464v353.915c-1.714 50.813-78.103 62.358-100.622 0l-79.274-333.282c-3.573-71.189 175.41-83.963 179.896-20.633h0z"
        fill="#B0F0A8"
        fillRule="evenodd"
      />
      <path
        d="M-1507.31-1325.189c40.237-39.724 86.619-48.612 140.259-21.234M-1487.22-1240.683c37.637-62.645 78.074-58.015 120.169-13.317M-1509.596-1492.345l25.148 105.655M-1457.099-1510.149l11.231 118.429M-1406.631-1467.167l1.001 70.417M-1407.288-1500.032v-.258"
        fill="none"
      />
      <path
        clipRule="evenodd"
        d="M-1305.237-1512.464v353.915c1.715 50.813 78.103 62.358 100.622 0l79.274-333.282c3.573-71.189-175.409-83.963-179.896-20.633h0z"
        fill="#B0F0A8"
        fillRule="evenodd"
      />
      <path
        d="M-1164.978-1325.189c-40.237-39.724-86.619-48.612-140.259-21.234M-1185.068-1240.683c-37.637-62.645-78.074-58.015-120.169-13.317M-1162.692-1492.345l-25.148 105.655M-1215.189-1510.149l-11.23 118.429M-1265.657-1467.167l-1 70.417M-1265-1500.032v-.258"
        fill="none"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.148}
    >
      <path
        clipRule="evenodd"
        d="m23.743-1366.039 105.452-35.151 40.18 22.605h263.658c67.5.657 90.162 79.477 20.89 89.45v-.942c0-22.206-17.976-40.182-40.151-40.182-22.205 0-40.181 17.976-40.181 40.182 0 .628 0 1.257.029 1.886H154.914c.029-.629.029-1.258.029-1.886 0-22.206-17.976-40.182-40.18-40.182-22.177 0-40.181 17.976-40.181 40.182 0 .171 0 .314.028.485L23-1306.11l.743-59.929z"
        fill="#FDB7CA"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        fill="#DCF2FF"
        fillRule="evenodd"
        d="m264.167-1442 59.013 63.416H169.375l-40.18-22.606z"
      />
      <path
        clipRule="evenodd"
        d="M114.764-1249.896c22.146 0 40.18-18.062 40.18-40.181 0-22.12-18.033-40.182-40.18-40.182-22.119 0-40.181 18.062-40.181 40.182 0 22.119 18.062 40.181 40.181 40.181h0zM413.771-1249.896c22.119 0 40.151-18.062 40.151-40.181 0-22.12-18.032-40.182-40.151-40.182-22.147 0-40.181 18.062-40.181 40.182.001 22.119 18.034 40.181 40.181 40.181h0z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="M175.033-1337.203h126.8M462.554-1341.546l31.063.457M53.235-1330.258l-22.577-.286-7.344-.085M219.186-1428.397l27.091 49.813M342.385-1335.602v-.258M413.771-1289.848v-.229M114.764-1289.848v-.229"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="M619.998-1427.584c-26.377 33.266-35.837 74.99-36.351 121.173v76.934h11.574c7.858 0 14.26 6.43 14.26 14.26v.887h29.264c.657-21.52 18.289-38.753 39.98-38.753 21.662 0 39.322 17.233 39.951 38.753h132.687c.629-21.52 18.289-38.753 39.951-38.753 21.69 0 39.323 17.233 39.98 38.753h36.036v-.887c0-7.83 6.431-14.26 14.261-14.26h11.574v-78.134c2.143-39.981-6.173-79.991-26.635-119.973H619.998z"
        fill="#DBBEB9"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M706.017-1459.077h307.754c-11.889-18.891-31.722-31.179-63.015-33.923H767.802c-26.663 2.201-48.039 12.317-61.785 33.923h0z"
        fill="#F5D8B3"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M638.573-1368.541H691.1c7.458 0 13.546 6.116 13.546 13.575v21.348c0 7.459-6.088 13.547-13.546 13.547h-52.526c-7.486 0-13.574-6.088-13.574-13.547v-21.348c-.001-7.459 6.087-13.575 13.573-13.575h0zM889.143-1368.541h52.526c7.458 0 13.546 6.116 13.546 13.575v21.348c0 7.459-6.088 13.547-13.546 13.547h-52.526c-7.487 0-13.574-6.088-13.574-13.547v-21.348c-.001-7.459 6.086-13.575 13.574-13.575h0zM767.63-1368.541h52.526c7.487 0 13.574 6.116 13.574 13.575v21.348c0 7.459-6.087 13.547-13.574 13.547H767.63c-7.458 0-13.545-6.088-13.545-13.547v-21.348c0-7.459 6.087-13.575 13.545-13.575h0z"
        fill="#DCF2FF"
        fillRule="evenodd"
      />
      <path fill="none" d="M601.251-1396.062h310.383M870.796-1281.862h19.376" />
      <path
        clipRule="evenodd"
        d="M1004.769-1229.478h-23.177c-7.83 0-14.261 6.43-14.261 14.26v1.772c0 7.859 6.431 14.261 14.261 14.261h23.177c7.83 0 14.231-6.401 14.231-14.261v-1.772c0-7.83-6.401-14.26-14.231-14.26h0zM595.222-1229.478h-23.148c-7.859 0-14.26 6.43-14.26 14.26v1.772c0 7.859 6.4 14.261 14.26 14.261h23.148c7.858 0 14.26-6.401 14.26-14.261v-1.772c-.001-7.83-6.402-14.26-14.26-14.26h0z"
        fill="#F5D8B3"
        fillRule="evenodd"
      />
      <path
        d="M986.507-1312.47c2.115 0 4.144.429 6.059 1.2v46.068c-1.915.771-3.943 1.2-6.059 1.2-10.717 0-19.376-10.859-19.376-24.234s8.659-24.234 19.376-24.234h0z"
        fill="none"
      />
      <path
        clipRule="evenodd"
        d="M678.726-1173.121c22.004 0 39.98-17.976 39.98-39.981 0-22.034-17.977-39.981-39.98-39.981-22.033 0-39.98 17.947-39.98 39.981-.001 22.005 17.946 39.981 39.98 39.981h0zM891.314-1173.121c22.033 0 39.98-17.976 39.98-39.981 0-22.034-17.947-39.981-39.98-39.981-22.005 0-39.979 17.947-39.979 39.981 0 22.005 17.975 39.981 39.979 39.981h0z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="M678.726-1213.103v-.256M891.314-1212.874v-.229M790.836-1484.512v56.928M926.522-1486.941v59.357"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        fill="#F9E5D3"
        fillRule="evenodd"
        d="M-1250.93-845.926h72.93v37.266h-64.813v-22.691h-8.117z"
      />
      <path
        clipRule="evenodd"
        d="M-1501.214-831.351h258.4v63.987c-19.147 22.691-44.324 31.322-76.417 23.777l-51.583-55.356-55.068 60.758c-28.321.743-53.469-8.059-75.332-26.749v-66.417z"
        fill="#DCF2FF"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        fill="#FDB7CA"
        fillRule="evenodd"
        d="m-1371.613-721.981 41.466-33.323-40.666-43.639-43.782 48.326z"
      />
      <path
        d="M-1413.737-695.661c-.943 17.919 3.229 29.607 25.12 30.379h34.007c18.805-.914 23.063-10.459 23.092-27.549"
        fill="none"
      />
      <path
        clipRule="evenodd"
        fill="#FDB7CA"
        fillRule="evenodd"
        d="M-1220.952-1029h31.607v184.274h-31.607zM-1192.603-653.937V-808.66h-30.778v157.153c-14.546 27.063-35.122 42.039-64.786 38.866-39.266-2.571-61.728-19.833-66.443-52.642h-34.007c8.03 49.184 51.211 85.907 102.08 83.964 48.753-1.885 85.818-23.034 93.934-72.618h0zM-1456.261-892.109h182.269c6.888 0 12.546 5.658 12.546 12.574h0c0 6.888-5.658 12.546-12.546 12.546h-182.269c-6.916 0-12.545-5.658-12.545-12.546h0c0-6.916 5.629-12.574 12.545-12.574h0z"
      />
      <path
        d="M-1494.726-831.351c-5.173-14.861-.286-27.578 24.805-35.98l4.315-3.858M-1189.345-970.671h-31.607"
        fill="none"
      />
    </g>
    <path
      d="M-1043.131-745.329c19.118-10.174 35.351-10.831 47.667 1.686 18.375 18.405 42.324 22.491 76.587 0 21.091-12.031 51.012-16.347 69.816 0 28.663 22.463 51.039 22.949 80.018 0 22.262-16.918 47.81-13.432 68.071 3.401 28.378 18.547 56.756 18.376 85.133-1.687 6.088-8.773 21.119-7.116 40.838 0M-959.713-695.974c40.294-5.858 76.846-38.695 114.911-3.4 20.434 11.517 45.639 12.603 77.445-.857 30.436-14.946 56.955-17.09 78.303-2.544 18.919 14.89 46.354 14.061 69.815 1.715M-902.7-671.282c17.461-7.345 34.064-8.23 47.668 2.543 24.862 11.975 50.354 16.147 77.474.857 20.062-5.572 37.494-9.717 61.271-.857"
      fill="none"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    />
    <path
      clipRule="evenodd"
      d="M-719.089-847.154c-20.318-22.434-49.668-36.495-82.304-36.495-58.499 0-106.423 45.183-110.767 102.568-.229 2.973-1.543 8.145 1.086 8.145l216.133-.313c-5.801-37.153-10.001-54.929-24.148-73.905z"
      fill="#F5D8B3"
      fillRule="evenodd"
    />
    <path
      fill="none"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
      d="M-807.365-970.898v51.926M-674.564-913.027l-38.324 37.466M-742.665-926.63l-12.774 17.861M-872.036-927.488l11.916 18.947M-955.454-842.381l22.119 12.774M-997.178-780.223h56.183M-670.735-835.979l17.661-3.63"
    />
    <path
      clipRule="evenodd"
      d="M-1018.897-878.962h119.169c26.377-52.784-60.214-63.444-68.102-28.95-30.377-19.719-62.127-1.571-51.067 28.95h0zM-772.758-783.709h118.312c3.287-26.55-13.889-32.208-49.354-28.093-44.952-27.436-75.93-2.944-68.958 28.093h0z"
      fill="#DCF2FF"
      fillRule="evenodd"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    />
    <path
      d="M-719.089-847.154c-20.318-22.434-49.668-36.495-82.304-36.495-58.499 0-106.423 45.183-110.767 102.568"
      fill="none"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    />
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.148}
    >
      <path fill="none" d="m-380.931-917.197-17.461 35.551 39.18 20.234z" />
      <path
        clipRule="evenodd"
        d="M-180.03-859.897C-100.384-848.58-45-823.574-45-794.51c0 39.667-103.138 71.817-230.365 71.817-127.199 0-230.336-32.15-230.336-71.817 0-21.063 29.092-40.01 75.444-53.156l54.299 12.174 16.746-25.921c-8.916 20.063-14.289 43.325-14.975 68.274 65.614 38.952 135.658 33.322 208.503 0-.658-24.319-5.801-47.068-14.346-66.758h0z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M-269.936-930c56.298 0 102.165 60.786 104.252 136.862-72.845 33.322-142.889 38.952-208.503 0C-372.101-869.214-326.233-930-269.936-930h0z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="m-416.624-891.048-13.633 43.382 54.299 12.175 16.746-25.921zM-217.838-812.886c-57.527 20.834-104.595 13.632-150.062-13.403M-191.004-821.717v-.228"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="M106.418-677.728c6.887-85.021 93.277-120.544 171.58-113.514l-.486.457-2.229 2.058-.486.457c-.8.715-1.601 1.43-2.4 2.173l-.457.428-2.4 2.144-.458.429c-.886.771-1.771 1.572-2.657 2.372l-.086.086-.028.028-.086.058c-.914.8-1.829 1.629-2.771 2.458l-.258.229c-1 .886-1.972 1.743-2.972 2.629h-.028 0c-1.029.914-2.087 1.857-3.173 2.772l33.208 19.348a398.222 398.222 0 0 1 3.172-3.744l.2-.229.085-.086c1.029-1.229 2.029-2.4 3.029-3.601l.343-.4c.887-1.028 1.744-2.058 2.63-3.087l.8-.972c.715-.856 1.429-1.686 2.115-2.543l1.2-1.4a56.133 56.133 0 0 1 1.657-2c.515-.629 1.058-1.286 1.571-1.915l.943-1.144.372-.457c.657-.771 1.285-1.543 1.914-2.314l.372-.458.171-.199c.687-.857 1.372-1.715 2.058-2.544l.343-.457.372-.429c.714-.915 1.429-1.801 2.144-2.687l.343-.429c52.926 15.175 94.049 51.984 90.22 107.855-36.608 26.892-61.07 30.578-95.964 8.459-47.382-34.694-85.677-12.261-122.484-.058-30.494 10.118-55.3 16.349-81.419-9.773h0zM397.796-984.746c20.719 0 38.693 11.717 47.695 28.893H350.07c9.002-17.176 27.006-28.893 47.726-28.893h0zM314.948-1008.752c14.403 7.773 22.491 22.691 22.291 37.981l-66.3-35.866c12.689-8.545 29.607-9.917 44.009-2.115h0zM370.104-1008.752c-14.403 7.773-22.49 22.691-22.29 37.981l66.3-35.866c-12.689-8.545-29.607-9.917-44.01-2.115h0z"
        fill="#B0F0A8"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M295.287-984.746c20.719 0 38.723 11.717 47.696 28.893h-95.392c8.973-17.176 26.977-28.893 47.696-28.893h0zM295.116-938.735c12.06-11.66 29.092-14.975 43.98-10.06l-55.44 53.67c-4.429-15.031-.571-31.95 11.46-43.61h0zM402.739-938.735c-12.06-11.66-29.092-14.975-43.98-10.06l55.44 53.67c4.43-15.031.572-31.95-11.46-43.61h0z"
        fill="#B0F0A8"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M257.021-772.465c68.358-59.615 88.819-87.822 91.335-190.133 20.032 107.055 15.26 123.602-58.127 209.48l-33.208-19.347z"
        fill="#F5D8B3"
        fillRule="evenodd"
      />
      <path
        d="M26-678.328c26.977-5.372 36.493-5.029 55.897 18.319 18.861 23.863 43.152 33.408 74.188 34.094 39.122.114 54.525-26.949 92.963-27.121 39.951 1.601 51.383 23.635 90.477 32.037 29.007 7.23 55.498-14.146 89.963-34.866 34.922-20.891 41.98-17.947 60.585-4.087M80.926-615.598c24.834 21.434 49.84 27.235 72.873 28.178 39.952.715 59.984-30.836 93.535-28.407 55.498 11.432 84.476 57.071 150.404 16.204M433.832-619.284l27.349-15.29"
        fill="none"
      />
      <path
        clipRule="evenodd"
        d="M65.723-952.481c-33.551-10.688-14.889-58.271 21.233-37.667-11.146-44.64 67.129-48.641 55.955 1.086 28.006-31.951 68.358 16.861 32.292 36.581H65.723zM155.229-884.75c-29.521-11.231 10.287-67.216 48.953-23.206 20.461-23.292 46.067 14.089 20.49 23.206h-69.443z"
        fill="#DCF2FF"
        fillRule="evenodd"
      />
      <path fill="none" d="M60.893-635.889v-.2" />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.148}
    >
      <path
        clipRule="evenodd"
        fill="#F9E5D3"
        fillRule="evenodd"
        d="M744.108-877.125h102.165l4.773 108.742H833.5v28.807h-27.178v-28.493l-29.635.029-.171 28.578-25.206.229v-29.15l-18.776-.2zM583.645-604.657l8.516-155.867h28.149l5.23-75.99h70.758v72.046l24.863 1.315.571 158.582zM996.621-603.485l-5.601-158.354-22.291-1.314v-70.732h-74.645v68.103l-27.52 1.314-1.315 161.125z"
      />
      <path
        clipRule="evenodd"
        fill="#F9E5D3"
        fillRule="evenodd"
        d="m751.31-768.383-30.149-.344.571 164.156 143.517 1.228 1.001-165.04H833.5v28.807h-27.178v-28.493l-29.635.029-.171 28.578-25.206.229zM765.228-935.882h60.242l6.229 58.757h-73.673z"
      />
      <path fill="none" d="M792.063-1002.698v66.816" />
      <path
        clipRule="evenodd"
        fill="#B0F0A8"
        fillRule="evenodd"
        d="m839.559-982.722-47.496 23.235v-43.211z"
      />
      <path fill="none" d="M656.661-902.331v65.817" />
      <path
        clipRule="evenodd"
        fill="#B0F0A8"
        fillRule="evenodd"
        d="m698.585-881.697-41.924 21.291v-41.925z"
      />
      <path fill="none" d="M927.806-903.959v70.074" />
      <path
        clipRule="evenodd"
        fill="#B0F0A8"
        fillRule="evenodd"
        d="m971.701-883.012-43.895 22.263v-43.21z"
      />
      <path
        clipRule="evenodd"
        d="M793.377-815.709c8.659 0 15.718-7.059 15.718-15.718s-7.059-15.718-15.718-15.718-15.718 7.059-15.718 15.718 7.059 15.718 15.718 15.718h0zM656.946-696.623c8.66 0 15.719-7.059 15.719-15.718 0-8.631-7.059-15.718-15.719-15.718-8.658 0-15.717 7.087-15.717 15.718 0 8.659 7.059 15.718 15.717 15.718h0zM930.949-694.68c8.659 0 15.718-7.059 15.718-15.718s-7.059-15.718-15.718-15.718c-8.658 0-15.718 7.059-15.718 15.718s7.06 15.718 15.718 15.718h0zM786.118-685.42h12.231c13.488 0 24.49 11.003 24.49 24.491v57.157h-61.213v-57.157c.001-13.488 11.004-24.491 24.492-24.491h0z"
        fill="#DBBEB9"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="M640.629-760.524H620.31M952.04-762.496h27.835M926.034-761.667v-.2M664.663-760.839v-.171M550.238-603H1029"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.148}
    >
      <path
        clipRule="evenodd"
        d="M780.983-447.458h8.46c6.973 0 12.688 5.716 12.688 12.689v13.804l-16.918-3.916-16.947 3.772v-13.661c.001-6.972 5.716-12.688 12.717-12.688h0z"
        fill="#F4B1C3"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="m646.812-394.13 138.402-30.75 133.915 31.093c12.06 3.487 22.033 7.23 26.806 19.776l31.178 163.612 31.521 57.157c19.262 34.923 12.488 23.806-27.12 16.918-127.257-22.091-254.513-24.377-381.77-1.571-40.466 7.259-52.726 21.319-32.406-14.575l34.436-60.758 28.092-160.783c1.171-10.632 7.172-17.004 16.946-20.119h0z"
        fill="#DCF2FF"
        fillRule="evenodd"
      />
      <path
        d="M601.773-213.229c131.086-30.865 255.542-26.521 375.339 2.829"
        fill="none"
      />
      <path
        clipRule="evenodd"
        d="M780.069-335.287c-72.273-70.846-101.594 45.84-9.174 20.833-52.84 50.841 16.519 61.215 22.52 12.432 50.697 69.074 72.33-41.182 9.917-26.006 64.757-45.698-38.095-76.333-23.263-7.259h0z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="M56.305-257.244c2.858-30.036 16.49-44.497 38.608-46.668h117.455c26.177 8.316 32.807 29.264 22.52 61.158-23.463 113.456-178.153 110.941-178.583 50.67v-65.16zM461.308-257.244c-2.829-30.036-16.46-44.497-38.608-46.668H305.273c-26.205 8.316-32.807 29.264-22.547 61.158 23.462 113.456 178.182 110.941 178.581 50.67v-65.16z"
        fill="#929FC5"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="m77.624-394.392-51.468 49.87v94.108h30.149M439.503-394.392 491-344.522v94.108h-30.178M212.368-303.912h92.905M239.03-260.702h39.581M149.211-268.904l-57.099 65.959M178.018-247.012l-22.205 26.977M362.887-268.904l57.097 65.959M334.08-247.012l22.233 26.977"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="M-263.203-501.2c113.939 4.944 205.873 94.88 213.904 208.022a14.73 14.73 0 0 0-4.486-.686H-86.25c-8.174-91.937-82.646-164.812-175.324-170.442v-29.921c0-2.515-.6-4.887-1.629-6.973h0zm214.076 238.002C-56.043-149.456-147.635-58.605-261.66-52.89c.057-.6.086-1.2.086-1.8v-32.408c0-.886-.057-1.772-.199-2.63C-168.267-95.3-93.195-169.375-86.05-262.484h32.266a14.97 14.97 0 0 0 4.657-.714h0zm-243.826-200.421c-88.791 9.316-159.121 80.591-167.065 169.785-.286 0-.6-.028-.886-.028h-32.407c-1.257 0-2.458.143-3.629.428 7.945-110.17 95.478-198.306 205.388-207.251a15.77 15.77 0 0 0-1.4 6.459v30.607zm-167.236 201.136c6.916 90.394 77.875 162.868 167.58 172.099a15.623 15.623 0 0 0-.343 3.287v32.408c0 .399.028.8.057 1.229-110.053-9.631-197.329-98.653-204.187-209.48 1.2.314 2.458.458 3.772.458h32.407l.714-.001h0z"
        fill="#F5D8B3"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M-261.574-463.276c92.105 5.63 166.15 78.048 174.324 169.471-8.145.543-14.633 7.373-14.633 15.632h0c0 8.345 6.574 15.232 14.832 15.661-7.145 92.623-81.875 166.298-174.953 171.785-1.629-6.887-7.857-12.06-15.259-12.06h0c-7.145 0-13.203 4.829-15.09 11.402-89.305-9.116-159.949-81.248-166.836-171.185 7.83-.857 13.975-7.545 13.975-15.604h0c0-7.974-6.059-14.604-13.775-15.575 7.859-88.679 77.789-159.525 166.037-168.842v.771c0 8.631 7.059 15.69 15.689 15.69h0c8.63 0 15.689-7.059 15.689-15.69v-1.456zm-11.545 101.653c46.725 0 84.59 37.895 84.59 84.592 0 46.726-37.865 84.621-84.59 84.621s-84.59-37.896-84.59-84.621c0-46.697 37.865-84.592 84.59-84.592h0z"
        fill="#FDB7CA"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="m-128.174-394.574-85.133 57.729M-420.552-394.574l85.104 57.729M-420.552-159.173l85.104-57.757M-128.174-159.173l-85.133-57.757"
      />
      <path
        clipRule="evenodd"
        d="M-277.263-102.787h0c8.63 0 15.689 7.059 15.689 15.689v32.408c0 8.63-7.059 15.689-15.689 15.689h0c-8.631 0-15.689-7.06-15.689-15.689v-32.408c-.001-8.631 7.058-15.689 15.689-15.689h0zM-277.263-509.916h0c8.63 0 15.689 7.059 15.689 15.689v32.408c0 8.631-7.059 15.69-15.689 15.69h0c-8.631 0-15.689-7.059-15.689-15.69v-32.408c-.001-8.63 7.058-15.689 15.689-15.689h0zM-509-278.173h0c0-8.631 7.059-15.689 15.689-15.689h32.407c8.63 0 15.689 7.059 15.689 15.689h0c0 8.63-7.059 15.69-15.689 15.69h-32.407c-8.63 0-15.689-7.06-15.689-15.69h0zM-101.883-278.173h0c0-8.631 7.059-15.689 15.689-15.689h32.408c8.629 0 15.688 7.059 15.688 15.689h0c0 8.63-7.059 15.69-15.688 15.69h-32.408c-8.63 0-15.689-7.06-15.689-15.69h0z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="M-826.467-48c-8.316-51.299-34.15-85.05-78.56-100.225v-130.032c-61.985-8.659-60.757-108.141-10.831-121.916l2.457.028V-500.77h27.264c8.116 93.994-29.578 144.064 69.873 156.267 100.735-6.744 79.702-80.706 81.132-156.267h27.263v103.311h.601c51.325 24.806 45.724 105.34-1.372 119.201l-1.343 127.317c-49.355 16.12-78.447 50.67-88.048 102.941h-28.436z"
        fill="#FDB7CA"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="M-878.793-278.6h-29.463M-709.841-277.256h-29.464M-854.416-276.856v-.229"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.148}
    >
      <path
        clipRule="evenodd"
        d="M-1340.072-44c24.891-34.666 53.097-43.611 75.302-60.673 46.582-35.809 79.646-65.559 95.05-122.944l25.462 17.233-8.43-106.198-64.357 66.245 20.833 17.062c-16.261 31.551-82.161 119.743-113.567 58.672l-9.859-175.015h59.07v-35.98h-61.1l-2.114-37.752c16.889-5.315 29.12-21.091 29.12-39.724 0-23.005-18.633-41.639-41.638-41.639s-41.637 18.633-41.637 41.639c0 15.861 8.858 29.636 21.89 36.667l-2.028 40.81h-55.813v35.98h54.04l-8.602 173.128c-41.466 59.301-84.533-25.32-114.511-59.644l19.861-25.549-62.471-49.212-6.43 105.997 20.633-21.776c20.689 54.585 62.1 95.538 99.393 124.059 21.12 14.46 47.927 25.834 71.903 58.614h0z"
        fill="#929FC5"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="M-1339.129-106.473v50.156M-1339.129-143.368v-.285M-1337.214-465.161v-.286"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="M806.926 227.935c31.636 6.087 54.813 25.921 54.813 49.44 0 8.603-3.059 16.747-8.573 23.863-7.802 10.031-15.032 26.378-3.744 37.238C866.11 354.48 884 378.801 884 405.807c0 46.783-40.266 85.021-91.22 87.993v.2c-1.058 0-2.115-.028-3.173-.057-1.085.028-2.144.057-3.2.057v-.2c-50.926-2.972-91.221-41.21-91.221-87.993 0-27.006 17.891-51.326 34.58-67.33 11.287-10.86 4.058-27.207-3.715-37.238-5.516-7.116-8.603-15.261-8.603-23.863 0-24.92 26.006-45.668 60.499-50.383v114.142a32.14 32.14 0 0 1 13.688-3.058c5.516 0 10.745 1.4 15.289 3.858v-114z"
        fill="#DBBEB9"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M777.948 87.5h28.978v254.435a32.103 32.103 0 0 0-15.289-3.858 32.123 32.123 0 0 0-13.688 3.058V87.5z"
        fill="#DBBEB9"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M791.637 402.492c17.719 0 32.179-14.461 32.179-32.208 0-17.719-14.46-32.208-32.179-32.208-17.747 0-32.207 14.489-32.207 32.208 0 17.747 14.46 32.208 32.207 32.208h0z"
        fill="#DBBEB9"
        fillRule="evenodd"
      />
      <path fill="none" d="M761.03 425.812h64.414" />
      <path
        clipRule="evenodd"
        d="M780.349 22.57h26.577c5.744 0 10.46 4.715 10.46 10.46v41.867c0 5.744-4.716 10.46-10.46 10.46h-26.577c-5.744 0-10.459-4.716-10.459-10.46V33.03c0-5.745 4.714-10.46 10.459-10.46h0z"
        fill="#DBBEB9"
        fillRule="evenodd"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    >
      <path
        clipRule="evenodd"
        d="M288.473 346.879v110.342c0 18.318-15.004 33.322-33.351 33.322h0c-18.318 0-33.321-15.004-33.321-33.322V346.879h66.672z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M255.951 26h0c60.527 0 110.024 49.498 110.024 109.999v191.276c.514 14.403-7.059 20.747-22.091 19.604H166.389c-15.976 0-21.119-5.001-20.433-18.776V135.999C145.956 75.498 195.452 26 255.951 26h0z"
        fill="#F4B1C3"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M214.171 113.993h0c9.945 0 18.09 8.117 18.09 18.062v150.551c0 9.917-8.145 18.062-18.09 18.062h0c-9.917 0-18.062-8.145-18.062-18.062V132.055c0-9.946 8.145-18.062 18.062-18.062h0zM297.761 113.993h0c9.916 0 18.061 8.117 18.061 18.062v150.551c0 9.917-8.145 18.062-18.061 18.062h0c-9.945 0-18.09-8.145-18.09-18.062V132.055c0-9.946 8.144-18.062 18.09-18.062h0z"
        fill="#F5D8B3"
        fillRule="evenodd"
      />
      <path
        d="M188.422 88.729s15.003-41.667 65.843-34.18M286.815 65.181v-.2"
        fill="none"
      />
    </g>
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.148}
    >
      <path
        clipRule="evenodd"
        d="M-299.071 240.053-465.25 115.736c-9.802-7.345-11.917-21.263-4.658-30.979h0c7.23-9.688 21.205-11.603 31.036-4.23l139.801 104.569v54.957zM-60.618 253.913v190.476c0 26.206-18.633 47.611-41.409 47.611H-456.59c-22.777 0-41.41-21.405-41.41-47.611V253.913h198.929v42.039c-7.858 5.916-12.945 15.289-12.945 25.892 0 17.862 14.489 32.352 32.35 32.352 17.891 0 32.351-14.489 32.351-32.352 0-10.603-5.059-19.976-12.917-25.892v-42.039h199.614z"
        fill="#F5D8B3"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M-279.667 19.027h0c10.688 0 19.434 8.745 19.434 19.405v257.521c7.858 5.916 12.917 15.289 12.917 25.892 0 17.862-14.46 32.352-32.351 32.352-17.86 0-32.35-14.489-32.35-32.352 0-10.603 5.087-19.976 12.945-25.892V38.432c.001-10.661 8.747-19.405 19.405-19.405h0z"
        fill="#F9E5D3"
        fillRule="evenodd"
      />
      <path
        clipRule="evenodd"
        d="M-255.146 208.616h189.298c10.746 0 19.519 9.888 19.519 21.977h0c0 12.117-8.772 22.005-19.519 22.005h-189.298v-43.982z"
        fill="#F5D8B3"
        fillRule="evenodd"
      />
      <path
        fill="none"
        d="M-260.233 290.122h200.272M-429.413 290.122h126.17M-468.879 292.294v-.229"
      />
    </g>
    <path
      clipRule="evenodd"
      d="M-698.527 189.697v102.196c0 38.152-46.01 69.36-102.251 69.36h-18.861c-56.241 0-102.251-31.208-102.251-69.36V189.697h223.363z"
      fill="#F5D8B3"
      fillRule="evenodd"
    />
    <path
      clipRule="evenodd"
      d="M-698.527 49.748c32.321 0 58.527 26.207 58.527 58.529s-26.206 58.528-58.527 58.528v-58.528h-58.527c-.001-32.322 26.205-58.529 58.527-58.529h0z"
      fill="#F9E5D3"
      fillRule="evenodd"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    />
    <path
      clipRule="evenodd"
      d="M-795.463 450.333c46.096 1.485 81.246 9.23 81.246 18.576 0 10.402-43.58 18.833-97.335 18.833s-97.336-8.431-97.336-18.833c0-9.603 37.151-17.548 85.161-18.69v-89.051c1.344.058 2.715.086 4.087.086h18.861c1.771 0 3.544-.058 5.315-.144v89.223z"
      fill="#FFF"
      fillRule="evenodd"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    />
    <path
      d="M-698.527 108.277V259c0 56.242-46.01 102.254-102.251 102.254h-18.861c-56.241 0-102.251-46.012-102.251-102.254V108.277h223.363zM-697.67 49.833v58.444M-697.384 108.563h52.097M-697.498 105.248l40.352 41.609M-653.374 71.039l-41.095 35.58M-736.879 63.923l40.381 41.61M-921.891 189.697h223.364"
      fill="none"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    />
    <path
      clipRule="evenodd"
      d="M-808.951 335.561c8.858 0 16.089-7.23 16.089-16.118 0-8.859-7.23-16.09-16.089-16.09-8.859 0-16.09 7.23-16.09 16.09 0 8.888 7.23 16.118 16.09 16.118h0zM-755.054 294.637c8.459 0 15.346-6.888 15.346-15.347 0-8.46-6.887-15.347-15.346-15.347s-15.347 6.887-15.347 15.347c.001 8.46 6.888 15.347 15.347 15.347h0zM-780.345 244.596c6.858 0 12.46-5.601 12.46-12.46s-5.602-12.46-12.46-12.46c-6.888 0-12.46 5.602-12.46 12.46s5.573 12.46 12.46 12.46h0z"
      fill="#B0F0A8"
      fillRule="evenodd"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
    />
    <path
      fill="none"
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.176}
      d="m-995.707 29 115.025 10.717 24.95 147.751"
    />
    <g
      stroke="#6C6CAA"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeMiterlimit={10}
      strokeWidth={20.148}
    >
      <path
        d="M-1485.308 135.484c.886-72.847 100.993-69.76 98.422 0v237.201M-1323.015 135.484c.857-72.847 100.993-69.76 98.422 0v237.201"
        fill="none"
      />
      <path
        clipRule="evenodd"
        fill="#F5D8B3"
        fillRule="evenodd"
        d="M-1386.886 182.353h162.293v32.379h-162.293zM-1386.886 279.719h162.293v32.38h-162.293z"
      />
      <path
        d="M-1555.208 361.053c21.69-15.432 42.209-23.548 68.3-8.83 26.807 17.261 61.985 33.779 100.022 20.462 37.78-18.176 55.354-25.692 77.674-9.06 24.034 17.376 51.954 21.034 84.619 9.06 38.465-17.147 71.387-28.264 99.593 1.058M-1499.367 410.437c40.294 5.858 76.845 38.724 114.882 3.401 20.462-11.518 45.667-12.575 77.475.857 30.435 14.975 56.927 17.118 78.303 2.571 18.918-14.889 46.353-14.061 69.786-1.714M-1534.689 397.548v-.228"
        fill="none"
      />
    </g>
  </svg>
);

export default SvgComponent;
