import { useEffect, useState } from 'react';
import { Section } from '../../../lib/components';
import { DemoWidget } from '../../common/demo-widget';
import useMedia from '../../common/useMedia';
import { Default, LargeSized, MediumSized, RTL } from './widgets-variants';

function Widgets() {
  const media = useMedia();
  const [width, setWidth] = useState(0);

  useEffect(() => {
    if (!media) {
      return;
    }

    if (media.isExtraLargeScreen) {
      setWidth(600);
    } else if (media.isBigScreen) {
      setWidth(450);
    } else if (media.isDesktop) {
      setWidth(450);
    } else if (media.isTablet) {
      setWidth(450);
    } else if (media.isMobile) {
      setWidth(320);
    }
  }, [media]);

  return width > 0 ? (
    <div style={{ minHeight: '1200px' }} className="rc-demo-widgets">
      <Section size="md" title="Default">
        <DemoWidget width={width} name="Read More" showCodeByDefault>
          {Default}
        </DemoWidget>
      </Section>
      <Section size="md" title="RTL">
        <DemoWidget width={width} name="Read More" showCodeByDefault>
          {RTL}
        </DemoWidget>
      </Section>
      <Section size="md" title="Custom sizes">
        <DemoWidget width={width} name="Read More" showCodeByDefault>
          {MediumSized}
        </DemoWidget>
        <DemoWidget width={width} name="Read More" showCodeByDefault>
          {LargeSized}
        </DemoWidget>
      </Section>
    </div>
  ) : null;
}

export { Widgets };
