# Copyright (c) ppy Pty Ltd <contact@ppy.sh>. Licensed under the GNU Affero General Public License v3.0.
# See the LICENCE file in the repository root for full licence text.

import { route } from 'laroute'
import { trans } from 'utils/lang'
import { toggleCart } from 'utils/store-cart'

preventUsernameSubmission = ->
  toggleCart(false)
  $('#username-check-price').text ''

checkUsernameValidity = ->
  $status = $('#username-check-status')
  requestedUsername = $('.js-username-change-input').val()

  $.post route('users.check-username-availability'), username: requestedUsername
  .done (data) ->
    return unless data.username == $('.js-username-change-input').val()

    if data.available
      toggleCart(true)
      $('#username-check-price').text data.costString
      $('#username-form-price').val data.cost
    else
      preventUsernameSubmission()

    $status.html data.message
    $status.toggleClass 'green-dark', data.available
    $status.toggleClass 'pink-dark', !data.available
  .fail (xhr, status) ->
    $('.js-username-change-input')
      .trigger 'ajax:error', [xhr, status]
      .one 'click', checkUsernameValidity

debouncedCheckUsernameValidity = _.debounce checkUsernameValidity, 300

$(document).on 'input', '.js-username-change-input', (e) ->
  input = e.currentTarget
  $status = $('#username-check-status')
  requestedUsername = input.value

  $status.removeClass 'green-dark'
  $status.removeClass 'pink-dark'
  preventUsernameSubmission()

  if requestedUsername.length == 0
    $status.text trans('store.username_change.check')
  else
    $status.text trans('store.username_change.checking', username: requestedUsername)
    debouncedCheckUsernameValidity()

$(document).on 'turbo:load', ->
  return if $('.js-username-change-input').length == 0
  preventUsernameSubmission()
