// Copyright (c) ppy Pty Ltd <contact@ppy.sh>. Licensed under the GNU Affero General Public License v3.0.
// See the LICENCE file in the repository root for full licence text.

import FlagCountry from 'components/flag-country';
import FriendButton from 'components/friend-button';
import SupporterIcon from 'components/supporter-icon';
import UserGroupBadges from 'components/user-group-badges';
import UserJson from 'interfaces/user-json';
import { route } from 'laroute';
import * as React from 'react';
import { classWithModifiers, urlPresence } from 'utils/css';

export default function User({ user, modifiers = [] }: { modifiers?: string[]; user: UserJson }) {
  const url = route('users.show', { user: user.id });

  return (
    <div className={classWithModifiers('user-search-card', modifiers)}>
      <a className='user-search-card__background-container' href={url} />
      <div className='user-search-card__container'>
        <a className='user-search-card__avatar-container' href={url}>
          <div className='avatar avatar--full' style={{ backgroundImage: urlPresence(user.avatar_url) }} />
        </a>

        <div className='user-search-card__details'>
          <div className='user-search-card__col user-search-card__col--flag'>
            <FlagCountry country={user.country} />
          </div>

          <a className='user-search-card__col user-search-card__col--username' href={url}>
            {user.username}
          </a>

          {user.is_supporter
            ? (
              <div className='user-search-card__col user-search-card__col--icon u-hidden-narrow'>
                <SupporterIcon level={user.support_level} modifiers='quick-search' />
              </div>
            ) : null}

          <UserGroupBadges groups={user.groups} short wrapper='user-search-card__col user-search-card__col--icon' />

          <div className='user-search-card__col user-search-card__col--icon'>
            <FriendButton modifiers='quick-search' userId={user.id} />
          </div>
        </div>
      </div>
    </div>
  );
}
