<?php

// Copyright (c) ppy Pty Ltd <contact@ppy.sh>. Licensed under the GNU Affero General Public License v3.0.
// See the LICENCE file in the repository root for full licence text.

namespace App\Libraries\Markdown\StyleBlock;

use League\CommonMark\Node\Block\AbstractBlock;
use League\CommonMark\Parser\Block\AbstractBlockContinueParser;
use League\CommonMark\Parser\Block\BlockContinue;
use League\CommonMark\Parser\Block\BlockContinueParserInterface;
use League\CommonMark\Parser\Cursor;

class Parser extends AbstractBlockContinueParser
{
    private Element $block;

    public function __construct(string $className)
    {
        $this->block = new Element($className);
    }

    public function getBlock(): AbstractBlock
    {
        return $this->block;
    }

    public function isContainer(): bool
    {
        return true;
    }

    public function canContain(AbstractBlock $childBlock): bool
    {
        return true;
    }

    public function tryContinue(Cursor $cursor, BlockContinueParserInterface $activeBlockParser): ?BlockContinue
    {
        $currentLine = $cursor->getLine();

        // TODO: closing block length is supposed to match opening block length which can be > 3;
        // what's supposed to happen when they don't match currently is undefined.
        if ($currentLine === ':::') {
            return BlockContinue::finished();
        }

        return BlockContinue::at($cursor);
    }
}
