/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.utils;

import com.ibm.safe.utils.IDirectoryWalkVisitor;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

public final class DirectoryWalk {
    public static void walk(File file, IDirectoryWalkVisitor visitor) {
        DirectoryWalk.walk(file, new AlwaysTrueFileFilter(), visitor);
    }

    public static void walk(File file, FileFilter fileFilter, IDirectoryWalkVisitor visitor) {
        DirectoryWalk.notifyVisitor(file, visitor);
        File[] files = file.listFiles(fileFilter);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    visitor.visitDirectory(files[i]);
                    DirectoryWalk.walk(files[i], fileFilter, visitor);
                } else {
                    visitor.visitFile(files[i]);
                }
                ++i;
            }
        }
    }

    public static void walk(File file, FilenameFilter fileFilter, IDirectoryWalkVisitor visitor) {
        DirectoryWalk.notifyVisitor(file, visitor);
        File[] files = file.listFiles(fileFilter);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    visitor.visitDirectory(files[i]);
                    DirectoryWalk.walk(files[i], fileFilter, visitor);
                } else {
                    visitor.visitFile(files[i]);
                }
                ++i;
            }
        }
    }

    private static void notifyVisitor(File file, IDirectoryWalkVisitor visitor) {
        if (file.isDirectory()) {
            visitor.visitDirectory(file);
        } else {
            visitor.visitFile(file);
        }
    }

    private DirectoryWalk() {
    }

    private static class AlwaysTrueFileFilter
    implements FileFilter {
        private AlwaysTrueFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return true;
        }
    }
}

