/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.rules;

import com.ibm.safe.rules.BasicXMLFilter;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.IRulesReader;
import com.ibm.safe.rules.LightweightRuleParser;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.safe.rules.TypestateRuleParser;
import com.ibm.safe.rules.XMIFileVisitor;
import com.ibm.safe.utils.DirectoryWalk;
import com.ibm.safe.utils.IDirectoryWalkVisitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AbstractRulesReader
implements IRulesReader {
    private static final String ROOT_NOT_DIRECTORY = "Rules location is not a directory: ";
    private final Collection<IRule> rules = new Stack<IRule>();

    AbstractRulesReader() {
    }

    @Override
    public final IRule[] getRules() {
        return this.rules.toArray(new IRule[this.rules.size()]);
    }

    protected final void preDirectoryTraversal(File rootDirectory) throws IOException {
        if (!rootDirectory.isDirectory()) {
            throw new IOException("Rules location is not a directory:  " + rootDirectory.getPath());
        }
        this.collectRules(rootDirectory);
    }

    protected final void loadResources(String ruleFile) throws IOException {
        List<IRule> rules = this.loadRulesFromFile(ruleFile);
        this.rules.addAll(rules);
    }

    private List<IRule> loadRulesFromFile(String ruleFile) {
        try {
            ArrayList<IRule> ruleList = new ArrayList<IRule>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(ruleFile);
            doc.getDocumentElement().normalize();
            NodeList typestateRules = doc.getElementsByTagName("typestateRule");
            int i = 0;
            while (i < typestateRules.getLength()) {
                TypestateRule curr = this.parseTypestateRule(typestateRules.item(i));
                if (curr != null) {
                    curr.setFileName(ruleFile);
                    ruleList.add(curr);
                    assert (!ruleList.isEmpty()) : "rule not added";
                }
                ++i;
            }
            NodeList structRules = doc.getElementsByTagName("structuralRule");
            int i2 = 0;
            while (i2 < structRules.getLength()) {
                IRule curr = this.parseStructuralRule(structRules.item(i2));
                if (curr != null) {
                    curr.setFileName(ruleFile);
                    ruleList.add(curr);
                }
                ++i2;
            }
            assert (!ruleList.isEmpty()) : "rule set is empty!";
            return ruleList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private IRule parseStructuralRule(Node node) {
        return LightweightRuleParser.parseRule(node);
    }

    private TypestateRule parseTypestateRule(Node node) {
        return TypestateRuleParser.parseRule(node);
    }

    protected void collectRules(File directory) throws IOException {
        XMIFileVisitor visitor = new XMIFileVisitor();
        DirectoryWalk.walk(directory, new BasicXMLFilter(), (IDirectoryWalkVisitor)visitor);
        File[] xmlFiles = visitor.getXMIFiles();
        int i = 0;
        while (i < xmlFiles.length) {
            this.loadResources(xmlFiles[i].getAbsolutePath());
            ++i;
        }
    }
}

