/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.reporting.message;

import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.reporting.message.SignatureUtils;

public class ClassLocation
extends Location {
    private final String className;
    private final int lineNumber;

    protected ClassLocation(String className, int lineNumber) {
        this.className = className;
        this.lineNumber = lineNumber;
    }

    @Override
    public String getLocationClass() {
        return this.className;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ClassLocation)) {
            return false;
        }
        ClassLocation otherClassLocation = (ClassLocation)other;
        return this.className.equals(otherClassLocation.className);
    }

    @Override
    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public String getByteCodeLocation() {
        return this.className;
    }

    @Override
    public String getSourceLocation() {
        return SignatureUtils.getClassName(this);
    }

    @Override
    public int getLocationLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getByteCodeIndex() {
        return -1;
    }

    @Override
    public Object getAdditionalInformation() {
        return null;
    }

    @Override
    public boolean isFieldMember() {
        return false;
    }

    @Override
    public boolean isMethodMember() {
        return false;
    }

    public String toString() {
        return "ClassLocation: " + this.className + ":" + this.lineNumber;
    }
}

