/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.options;

import com.ibm.safe.callgraph.CallGraphEngine;
import com.ibm.safe.internal.entrypoints.EntryPointDefinition;
import com.ibm.safe.internal.entrypoints.MainClassesEntryPointsReader;
import com.ibm.safe.internal.entrypoints.StringEntryPointsReader;
import com.ibm.safe.internal.entrypoints.XMLEntryPointsReader;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.options.CommonOptions;
import com.ibm.safe.options.WholeProgramProperties;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.utils.SafeHome;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class WholeProgramOptions
extends CommonOptions {
    public WholeProgramOptions(WholeProgramOptions wpo) {
        super(wpo);
    }

    public WholeProgramOptions(PropertiesManager propertiesManager) {
        super(propertiesManager);
    }

    public boolean isContradictionAnalysis() throws PropertiesException {
        return this.getBooleanValue(WholeProgramProperties.Props.CONTRADICTION_ANALYSIS);
    }

    public CallGraphEngine.CallGraphKind getCallGraphKind() throws PropertiesException {
        String cgKindName = this.getStringValue(WholeProgramProperties.Props.CG_KIND);
        CallGraphEngine.CallGraphKind cgKind = Enum.valueOf(CallGraphEngine.CallGraphKind.class, cgKindName);
        if (cgKind == null) {
            throw new PropertiesException("Bad call graph kind " + cgKindName);
        }
        return cgKind;
    }

    public String getPointsToDotFile() throws PropertiesException {
        return this.getStringValue(WholeProgramProperties.Props.POINTS_TO_GRAPH);
    }

    public boolean shouldDumpCallGraph() throws PropertiesException {
        return this.getBooleanValue(WholeProgramProperties.Props.REPORT_CALL_GRAPH);
    }

    public boolean shouldCollectStatistics() throws PropertiesException {
        return this.getBooleanValue(CommonProperties.Props.COLLECT_STATISTICS);
    }

    public boolean shouldCreatePointsToDotFile() throws PropertiesException {
        return this.getPointsToDotFile() != null;
    }

    public boolean shouldSliceSupergraph() throws PropertiesException {
        return this.getBooleanValue(WholeProgramProperties.Props.SLICE_SUPERGRAPH);
    }

    public boolean shouldGenerateWitness() throws PropertiesException {
        return this.getBooleanValue(WholeProgramProperties.Props.GENERATE_WITNESS);
    }

    public boolean shouldUseLiveAnalysis() throws PropertiesException {
        return this.getBooleanValue(WholeProgramProperties.Props.LIVE_ANALYSIS);
    }

    public final Pattern[] getMainClassesSelector() throws PropertiesException {
        String option = this.getStringValue(WholeProgramProperties.Props.SELECT_MAIN_CLASSES);
        if (option == null) {
            return new Pattern[0];
        }
        String[] regExpressions = this.getStringValue(WholeProgramProperties.Props.SELECT_MAIN_CLASSES).split("[,;]\\s*");
        Pattern[] selector = new Pattern[regExpressions.length];
        int i = 0;
        while (i < selector.length) {
            selector[i] = Pattern.compile(regExpressions[i]);
            ++i;
        }
        return selector;
    }

    public EntryPointDefinition[] getEntryPointDefinitions() throws PropertiesException, SetUpException {
        ArrayList<EntryPointDefinition> entryPoints = new ArrayList<EntryPointDefinition>(10);
        String[] mainClasses = this.getMainClasses();
        String entryPointsFile = this.getStringValue(WholeProgramProperties.Props.ENTRY_POINTS_FILE);
        String entryPointsOption = this.getStringValue(WholeProgramProperties.Props.ENTRY_POINTS);
        if (mainClasses != null) {
            entryPoints.addAll(Arrays.asList(new MainClassesEntryPointsReader(mainClasses).getEntryPointDefinitions()));
        }
        if (entryPointsFile != null && entryPointsOption != null) {
            throw new PropertiesException("Options 'entry_points' and 'entry_points_file' can't be used together.");
        }
        if (entryPointsOption != null) {
            entryPoints.addAll(Arrays.asList(new StringEntryPointsReader(entryPointsOption).getEntryPointDefinitions()));
        } else if (entryPointsFile != null) {
            try {
                entryPoints.addAll(Arrays.asList(new XMLEntryPointsReader(this.getXMLFile(entryPointsFile)).getEntryPointDefinitions()));
            }
            catch (Exception except) {
                throw new PropertiesException("Unable to read valid entry points in " + entryPointsFile, except);
            }
        }
        System.out.println("Entry point definitions:");
        for (EntryPointDefinition entryPoint : entryPoints) {
            System.out.println(entryPoint);
        }
        return entryPoints.toArray(new EntryPointDefinition[entryPoints.size()]);
    }

    protected File getXMLFile(String fileName) throws PropertiesException {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            URL url = this.getClass().getClassLoader().getResource(fileName);
            file = url == null ? new File(SafeHome.getSafeHomeDir(this.getClass().getClassLoader()), fileName) : new File(url.getFile());
        }
        if (!file.exists()) {
            throw new PropertiesException("Cannot find xml file " + file.getPath());
        }
        return file;
    }

    public boolean allMainClassesEntrypoints() throws PropertiesException {
        return this.getBooleanValue(WholeProgramProperties.Props.ALL_MAIN_CLASSES_ENTRY_POINT);
    }

    public final boolean isJ2SEOptionsActivated() throws PropertiesException {
        return this.getStringValue(CommonProperties.Props.MAIN_CLASSES) != null || this.allMainClassesEntrypoints();
    }
}

