/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.internal.reporting;

import com.ibm.safe.internal.reporting.FindingComparator;
import com.ibm.safe.internal.runners.AbstractSolverRunner;
import com.ibm.safe.io.ZipUtils;
import com.ibm.safe.metrics.IMetrics;
import com.ibm.safe.metrics.ProgramStatistics;
import com.ibm.safe.perf.NamedTimer;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.perf.SolverPerfTracker;
import com.ibm.safe.perf.TimeoutStopwatch;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.reporting.message.MethodLocation;
import com.ibm.safe.reporting.message.SignatureUtils;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.utils.SafeEclipseUtils;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.wala.classLoader.IClass;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class XMLReporter
implements IReporter {
    private final Document document;
    private final String xmlFileName;
    private TreeSet<Message> findings = new TreeSet<Message>(new FindingComparator());
    private static final String STYLESHEET_FILENAME = "main_page.xsl";
    private static final String SCRIPTS_ZIP_FILENAME = "scripts.zip";

    public XMLReporter(String anXMLFileName) throws ParserConfigurationException {
        this.xmlFileName = anXMLFileName;
        this.document = this.createDocument();
        Element analysisResults = this.document.createElement("analysis-results");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        analysisResults.setAttribute("date", dateFormat.format(new Date()));
        this.document.appendChild(analysisResults);
        this.document.insertBefore(this.createProcessingInstruction(), analysisResults);
    }

    @Override
    public void process(IClass clazz) {
    }

    @Override
    public void produceFinalReport() throws Exception {
        if (this.document.getDocumentElement() != null) {
            File xmlFile;
            for (Message finding : this.findings) {
                Element messageTag = this.createMessageTag(finding);
                this.addMessageTag(messageTag, finding);
            }
            if (this.getRulesActivatedTag() != null) {
                this.addRulesInformation();
            }
            if (!(xmlFile = new File(this.xmlFileName)).exists()) {
                if (!xmlFile.getParentFile().exists()) {
                    xmlFile.getParentFile().mkdirs();
                }
                xmlFile.createNewFile();
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, new StreamResult(xmlFile));
            this.copyRequiredFiles(xmlFile.getParent());
            System.out.println("XML results have been created at " + this.xmlFileName);
        }
    }

    @Override
    public void reportException(Throwable exception) {
        Element excptElement = this.document.createElement("exception");
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        excptElement.appendChild(this.document.createCDATASection(strWriter.toString()));
        this.document.getDocumentElement().appendChild(excptElement);
    }

    @Override
    public void reportMessage(Message message) {
        this.findings.add(message);
    }

    @Override
    public void reportNumberOfFindings(int numberOfFindings) {
    }

    @Override
    public void reportNumberOfRulesActivated(int numberOfRules) {
    }

    @Override
    public void reportRuleLoading(IRule rule) {
        Node rulesActivatedTag = this.getRulesActivatedTag();
        if (rulesActivatedTag == null) {
            rulesActivatedTag = this.document.createElement("rules-activated");
            this.document.getDocumentElement().appendChild(rulesActivatedTag);
        }
        Element ruleActivatedTag = this.document.createElement("rule-activated");
        ruleActivatedTag.appendChild(this.document.createTextNode(rule.getName()));
        rulesActivatedTag.appendChild(ruleActivatedTag);
    }

    @Override
    public void reportRuleInstances(IRule rule, int instances) {
    }

    @Override
    public void reportStatistics(ProgramStatistics programStat) {
        Element statistics = this.document.createElement("statistics");
        statistics.setAttribute("solver-kind", "structural");
        this.addStatisticsEntry(statistics, programStat.getName(0), String.valueOf(programStat.getEntry(0)));
        this.addStatisticsEntry(statistics, programStat.getName(4), String.valueOf(programStat.getEntry(4)));
        this.addStatisticsEntry(statistics, programStat.getName(3), String.valueOf(programStat.getEntry(3)));
        this.document.getDocumentElement().appendChild(statistics);
    }

    @Override
    public void reportStatistics(IMetrics typeStateMetrics) {
    }

    @Override
    public void reportPerformanceTracking(PerformanceTracker perfoTracker) {
        NamedTimer[] timers = perfoTracker.getTimers();
        if (timers.length == 0) {
            return;
        }
        Element timersElement = this.document.createElement("timers");
        timersElement.setAttribute("name", perfoTracker.getTrackerKind().toString());
        long totalTime = 0L;
        if (perfoTracker instanceof SolverPerfTracker) {
            SolverPerfTracker spt = (SolverPerfTracker)perfoTracker;
            int i = 0;
            while (i < timers.length) {
                totalTime += timers[i].getElapsedMillis();
                int total = spt.getTotalInstances(timers[i].getName());
                int processed = spt.getProcessedInstances(timers[i].getName());
                this.addTimer(timersElement, timers[i], processed, total);
                ++i;
            }
        } else {
            int i = 0;
            while (i < timers.length) {
                this.addTimer(timersElement, timers[i]);
                totalTime += timers[i].getElapsedMillis();
                ++i;
            }
        }
        Element totalTimeElement = this.document.createElement("total-time");
        totalTimeElement.appendChild(this.document.createTextNode(String.valueOf(totalTime)));
        timersElement.appendChild(totalTimeElement);
        this.document.getDocumentElement().appendChild(timersElement);
    }

    @Override
    public void startAnalysis(AbstractSolverRunner.AnalysisKind nature) {
        Element start = this.document.createElement("start-analysis");
        start.setAttribute("nature", nature.toString());
        start.appendChild(this.document.createTextNode(String.valueOf(System.currentTimeMillis())));
        this.document.getDocumentElement().appendChild(start);
    }

    @Override
    public void stopAnalysis(AbstractSolverRunner.AnalysisKind nature) {
        Element stop = this.document.createElement("stop-analysis");
        stop.setAttribute("nature", nature.toString());
        stop.appendChild(this.document.createTextNode(String.valueOf(System.currentTimeMillis())));
        this.document.getDocumentElement().appendChild(stop);
    }

    @Override
    public void reportAnalysisStatus(AbstractSolverRunner.AnalysisStatus status) {
        Element statusElement = this.document.createElement("analysis-status");
        statusElement.setAttribute("status", status.toString());
        this.document.getDocumentElement().appendChild(statusElement);
    }

    @Override
    public void version(String versionNumber) {
        Element version = this.document.createElement("version");
        version.appendChild(this.document.createTextNode(versionNumber));
        this.document.getDocumentElement().appendChild(version);
    }

    private void addMessageTag(Element messageTag, Message message) {
        Element rootNode = this.document.getDocumentElement();
        NodeList messagesTags = rootNode.getChildNodes();
        int i = messagesTags.getLength();
        while (--i >= 0) {
            Node ithNode = messagesTags.item(i);
            Node attrNode = ithNode.getAttributes().getNamedItem("type");
            if (attrNode == null || !attrNode.getNodeValue().equals(message.getMessageType())) continue;
            ithNode.appendChild(messageTag);
            return;
        }
        rootNode.appendChild(this.createMessagesTag(message, messageTag));
    }

    private ProcessingInstruction createProcessingInstruction() {
        StringBuffer dataBuf = new StringBuffer(" href=\"");
        dataBuf.append(STYLESHEET_FILENAME).append("\" type=\"text/xsl\"");
        return this.document.createProcessingInstruction("xml-stylesheet", dataBuf.toString());
    }

    private void addRulesInformation() {
        Element rulesMatchedTag = this.document.createElement("rules-matched");
        HashSet<IRule> rules = new HashSet<IRule>(this.findings.size());
        Iterator<Message> iter = this.findings.iterator();
        while (iter.hasNext()) {
            IRule rule = iter.next().getRule();
            if (rules.contains(rule)) continue;
            rules.add(rule);
            rulesMatchedTag.appendChild(this.createRuleTag(rule));
        }
        this.document.getDocumentElement().appendChild(rulesMatchedTag);
    }

    private void addStatisticsEntry(Element parentNode, String statName, String value) {
        Element entry = this.document.createElement("stat");
        Element name = this.document.createElement("name");
        name.appendChild(this.document.createTextNode(statName));
        entry.appendChild(name);
        Element statValue = this.document.createElement("value");
        statValue.appendChild(this.document.createTextNode(value));
        entry.appendChild(statValue);
        parentNode.appendChild(entry);
    }

    private void addTimer(Element parentNode, NamedTimer namedTimer, int processed, int total) {
        Element timer = this.createTimerElement(parentNode, namedTimer);
        Element totalInstances = this.document.createElement("total-instances");
        totalInstances.appendChild(this.document.createTextNode(String.valueOf(total)));
        timer.appendChild(totalInstances);
        Element processedInstances = this.document.createElement("processed-instances");
        processedInstances.appendChild(this.document.createTextNode(String.valueOf(processed)));
        timer.appendChild(processedInstances);
        parentNode.appendChild(timer);
    }

    private void addTimer(Element parentNode, NamedTimer namedTimer) {
        Element timer = this.createTimerElement(parentNode, namedTimer);
        parentNode.appendChild(timer);
    }

    private Element createTimerElement(Element parentNode, NamedTimer namedTimer) {
        Element timer = this.document.createElement("timer");
        Element name = this.document.createElement("name");
        name.appendChild(this.document.createTextNode(namedTimer.getName()));
        timer.appendChild(name);
        Element timerValue = this.document.createElement("value");
        timerValue.appendChild(this.document.createTextNode(String.valueOf(namedTimer.getElapsedMillis())));
        timer.appendChild(timerValue);
        if (namedTimer instanceof TimeoutStopwatch) {
            TimeoutStopwatch timeoutTracker = (TimeoutStopwatch)namedTimer;
            Element timerTimedout = this.document.createElement("timeout");
            timerTimedout.appendChild(this.document.createTextNode(Boolean.toString(timeoutTracker.timedOut())));
            timer.appendChild(timerTimedout);
        }
        return timer;
    }

    private void copyRequiredFiles(String outputDir) {
        URL url = this.getClass().getClassLoader().getResource(SCRIPTS_ZIP_FILENAME);
        if (url != null) {
            try {
                ZipUtils.uncompress(SafeEclipseUtils.getFileFromURL(url), outputDir);
            }
            catch (IOException except) {
                SafeLogger.severe("Unzipping of scripts.zip failed.", except);
            }
        }
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    private Element createMessageTag(Message message) {
        boolean messageHasRule;
        Element messageTag = this.document.createElement("message");
        boolean bl = messageHasRule = message.getRule() != null;
        if (messageHasRule) {
            Element severity = this.document.createElement("severity");
            severity.appendChild(this.document.createTextNode(message.getRule().getSeverity().toString()));
            messageTag.appendChild(severity);
        }
        Element messageText = this.document.createElement("text");
        messageText.appendChild(this.document.createTextNode(message.getText()));
        messageTag.appendChild(messageText);
        Element clazz = this.document.createElement("class");
        clazz.appendChild(this.document.createTextNode(SignatureUtils.getClassName(message.getLocation())));
        clazz.setAttribute("jvm-sig", message.getLocation().getLocationClass());
        messageTag.appendChild(clazz);
        if (message.getLocation().isFieldMember()) {
            Element field = this.document.createElement("field");
            field.appendChild(this.document.createTextNode(message.getLocation().getSourceLocation()));
            messageTag.appendChild(field);
        } else if (message.getLocation().isMethodMember()) {
            Element method = this.document.createElement("method");
            MethodLocation methodLoc = (MethodLocation)message.getLocation();
            method.appendChild(this.document.createTextNode(SignatureUtils.getMethodSignature(methodLoc, true)));
            method.setAttribute("jvm-sig", methodLoc.getByteCodeLocation());
            messageTag.appendChild(method);
        }
        Element line = this.document.createElement("line");
        line.appendChild(this.document.createTextNode(String.valueOf(message.getLocation().getLocationLineNumber())));
        messageTag.appendChild(line);
        if (message.getLocation().getByteCodeIndex() != -1) {
            Element bcIndex = this.document.createElement("bc-index");
            bcIndex.appendChild(this.document.createTextNode(String.valueOf(message.getLocation().getByteCodeIndex())));
            messageTag.appendChild(bcIndex);
        }
        if (message.getLocation().getAdditionalInformation() != null) {
            Element addInfo = this.document.createElement("info");
            addInfo.appendChild(this.document.createTextNode(message.getLocation().getAdditionalInformation().toString()));
            messageTag.appendChild(addInfo);
        }
        return messageTag;
    }

    private Element createMessagesTag(Message message, Element messageTag) {
        Element messagesTag = this.document.createElement("messages");
        messagesTag.setAttribute("type", message.getMessageType());
        messagesTag.appendChild(messageTag);
        return messagesTag;
    }

    private Element createRuleTag(IRule rule) {
        Element ruleTag = this.document.createElement("rule");
        ruleTag.setAttribute("name", rule.getName());
        Element severity = this.document.createElement("severity");
        severity.appendChild(this.document.createTextNode(rule.getSeverity().toString()));
        ruleTag.appendChild(severity);
        Element level = this.document.createElement("level");
        level.appendChild(this.document.createTextNode(rule.getLevel().toString()));
        ruleTag.appendChild(level);
        Element desc = this.document.createElement("description");
        String ruleDesc = rule.getDescription();
        if (ruleDesc != null) {
            desc.appendChild(this.document.createCDATASection(this.formatProcess(ruleDesc)));
            ruleTag.appendChild(desc);
        }
        Element example = this.document.createElement("example");
        String exampleString = rule.getExample();
        if (exampleString != null) {
            example.appendChild(this.document.createCDATASection(this.formatProcess(exampleString)));
            ruleTag.appendChild(example);
        }
        Element action = this.document.createElement("action");
        String actionString = rule.getAction();
        if (actionString != null) {
            action.appendChild(this.document.createCDATASection(this.formatProcess(actionString)));
            ruleTag.appendChild(action);
        }
        return ruleTag;
    }

    private String formatProcess(String content) {
        assert (content != null);
        return content.trim();
    }

    private Node getRulesActivatedTag() {
        NodeList childNodes = this.document.getDocumentElement().getChildNodes();
        int i = 0;
        int size = childNodes.getLength();
        while (i < size) {
            if (childNodes.item(i).getNodeName().equals("rules-activated")) {
                return childNodes.item(i);
            }
            ++i;
        }
        return null;
    }
}

