/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.dfa;

import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.IDFATransition;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DFASpec {
    protected Map<String, IDFAState> name2state = HashMapFactory.make();
    protected IDFAState initial;
    protected List<IEvent> events = new ArrayList<IEvent>();
    protected List<IDFAState> states = new ArrayList<IDFAState>();
    protected List<IDFATransition> transitions = new ArrayList<IDFATransition>();

    public List<IEvent> getEvents() {
        return this.events;
    }

    public List<IDFAState> getStates() {
        return this.states;
    }

    public List<IDFATransition> getTransitions() {
        return this.transitions;
    }

    public IDFAState initialState() {
        return this.initial;
    }

    public void setInitialState(IDFAState s) {
        this.initial = s;
    }

    public void addState(IDFAState s) {
        this.states.add(s);
        this.name2state.put(s.getName(), s);
    }

    public void addTransition(IDFATransition t) {
        this.transitions.add(t);
    }

    public void addEvent(IEvent e) {
        this.events.add(e);
    }

    private IDFAState getState(String stateName) {
        IDFAState mapValue = this.name2state.get(stateName);
        if (mapValue != null) {
            return mapValue;
        }
        for (IDFAState state : this.states) {
            if (!state.getName().equals(stateName)) continue;
            this.name2state.put(stateName, state);
            return state;
        }
        assert (false) : "State '" + stateName + "' couldn't be found among the list !";
        return null;
    }

    public NumberedGraph<Object> asGraph() {
        SlowSparseNumberedGraph result = SlowSparseNumberedGraph.make();
        for (IDFAState s : this.states) {
            result.addNode((Object)s);
        }
        for (IDFATransition t : this.transitions) {
            IDFAState src = this.getState(t.getSource());
            IDFAState dst = this.getState(t.getDestination());
            result.addEdge((Object)src, (Object)dst);
        }
        return result;
    }
}

