/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.dfa;

import com.ibm.safe.dfa.IDFA;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DFA
extends SlowSparseNumberedGraph<Object>
implements IDFA {
    private final Map<Pair<Object, Object>, Set<Object>> edgeLabels = HashMapFactory.make();
    private Object initialState;
    private Set<Object> alphabet = HashSetFactory.make();
    private Set<Object> acceptingStates = HashSetFactory.make();

    public DFA() {
    }

    public DFA(Object initialState) {
        this.initialState = initialState;
        this.addNode(initialState);
    }

    @Override
    public void addNode(Object node, boolean accepting) {
        super.addNode(node);
        if (accepting) {
            this.acceptingStates.add(node);
        }
    }

    @Override
    public void removeNode(Object node) throws UnsupportedOperationException {
        if (node == this.initialState) {
            throw new UnsupportedOperationException("Cannot remove initial state");
        }
        super.removeNode(node);
        this.acceptingStates.remove(node);
    }

    @Override
    public void removeLabeledEdge(Object src, Object dst, Object label) {
        Pair edge = Pair.make((Object)src, (Object)dst);
        Set labels = MapUtil.findOrCreateSet(this.edgeLabels, (Object)edge);
        labels.remove(label);
        if (labels.isEmpty()) {
            this.edgeLabels.remove(edge);
            super.removeEdge(src, dst);
        }
    }

    @Override
    public void removeAllEdges(Object src, Object dst) {
        Pair edge = Pair.make((Object)src, (Object)dst);
        this.edgeLabels.remove(edge);
        super.removeEdge(src, dst);
    }

    @Override
    public void addLabeledEdge(Object src, Object dest, Object label) {
        this.addNode(src);
        this.addNode(dest);
        this.addEdge(src, dest);
        this.addLabel(src, dest, label);
    }

    @Override
    public void addLabeledEdges(Object src, Object dest, Collection<Object> labels) {
        this.addNode(src);
        this.addNode(dest);
        this.addEdge(src, dest);
        Iterator<Object> it = labels.iterator();
        while (it.hasNext()) {
            this.addLabel(src, dest, it.next());
        }
    }

    @Override
    public Set<Object> acceptingStates() {
        return this.acceptingStates;
    }

    @Override
    public boolean isAccepting(Object node) {
        return this.acceptingStates.contains(node);
    }

    @Override
    public Set<Object> getLabels(Object src, Object dest) {
        Pair p = Pair.make((Object)src, (Object)dest);
        Set<Object> result = this.edgeLabels.get(p);
        return result != null ? result : Collections.emptySet();
    }

    @Override
    public Set<Object> alphabet() {
        return this.alphabet;
    }

    @Override
    public void addLabel(Object src, Object dest, Object label) {
        Pair p = Pair.make((Object)src, (Object)dest);
        Set labels = MapUtil.findOrCreateSet(this.edgeLabels, (Object)p);
        labels.add(label);
        this.alphabet.add(label);
    }

    @Override
    public Object successor(Object src, Object label) {
        Iterator it = this.getSuccNodes(src);
        while (it.hasNext()) {
            Object d = it.next();
            Set<Object> labels = this.getLabels(src, d);
            if (!labels.contains(label)) continue;
            return d;
        }
        return null;
    }

    @Override
    public Iterator<Pair<Object, Object>> iterateEdges() {
        return this.edgeLabels.keySet().iterator();
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (!this.getClass().equals(arg0.getClass())) {
            return false;
        }
        DFA other = (DFA)arg0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object node = it.next();
            if (!other.containsNode(node)) {
                return false;
            }
            if (other.isAccepting(node) == this.isAccepting(node)) continue;
            return false;
        }
        it = this.iterator();
        while (it.hasNext()) {
            Object x = it.next();
            Iterator s = this.getSuccNodes(x);
            while (s.hasNext()) {
                Object y = s.next();
                if (!other.hasEdge(x, y)) {
                    return false;
                }
                if (other.getLabels(x, y).equals(this.getLabels(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object node = it.next();
            result += 6569 * node.hashCode();
            Iterator s = this.getSuccNodes(node);
            while (s.hasNext()) {
                Object x = s.next();
                result += 6173 * x.hashCode();
                result += 5147 * this.getLabels(node, x).hashCode();
            }
        }
        return result;
    }

    @Override
    public Object clone() {
        DFA result = new DFA(this.initialState);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object node = it.next();
            result.addNode(node, this.isAccepting(node));
        }
        it = this.iterator();
        while (it.hasNext()) {
            Object x = it.next();
            Iterator s = this.getSuccNodes(x);
            while (s.hasNext()) {
                Object y = s.next();
                HashSet c = HashSetFactory.make(this.getLabels(x, y));
                result.addLabeledEdges(x, y, c);
            }
        }
        return result;
    }

    @Override
    public Object getInitialState() {
        return this.initialState;
    }

    @Override
    public int getNumberOfLabels() {
        return this.edgeLabels.size();
    }

    public String toString() {
        SlowNumberedNodeManager nodeMgr = (SlowNumberedNodeManager)this.getNodeManager();
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(super.toString()) + "\n");
        buf.append("Initial: " + this.getInitialState().toString() + "\n");
        buf.append("Labels:\n");
        for (Map.Entry<Pair<Object, Object>, Set<Object>> edge2Label : this.edgeLabels.entrySet()) {
            Pair<Object, Object> edge = edge2Label.getKey();
            Set<Object> label = edge2Label.getValue();
            buf.append("(" + nodeMgr.getNumber(edge.fst) + ", " + nodeMgr.getNumber(edge.snd) + ") " + label + "\n");
        }
        return buf.toString();
    }

    @Override
    public void setInitialState(Object init) {
        assert (init != null);
        this.initialState = init;
    }
}

