/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.controller;

import com.ibm.safe.internal.runners.AbstractSolverRunner;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.ISolverResult;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.runners.IResultObserver;
import java.util.Iterator;

public final class BasicResultObserver
implements IResultObserver {
    private final IReporter reporter;
    private int numberOfFindings;
    private AbstractSolverRunner.AnalysisStatus status = AbstractSolverRunner.AnalysisStatus.INCOMPLETE;

    public BasicResultObserver(IReporter safeReporter) {
        this.reporter = safeReporter;
    }

    @Override
    public void notify(ISolverResult result, AbstractSolverRunner.AnalysisStatus status) {
        this.reporter.reportAnalysisStatus(status);
        this.updateStatus(status);
        if (result != null) {
            Iterator<? extends Message> iter = result.getMessages().iterator();
            while (iter.hasNext()) {
                this.reporter.reportMessage(iter.next());
            }
            this.numberOfFindings += result.getMessages().size();
        }
    }

    private void updateStatus(AbstractSolverRunner.AnalysisStatus status) {
        if (this.status == AbstractSolverRunner.AnalysisStatus.INCOMPLETE) {
            this.status = status;
        } else if (this.status == AbstractSolverRunner.AnalysisStatus.NORMAL && (status == AbstractSolverRunner.AnalysisStatus.ABORT_TIMEOUT || status == AbstractSolverRunner.AnalysisStatus.ABORT_MAX_FIND)) {
            this.status = status;
        }
    }

    public int getNumberOfFindings() {
        return this.numberOfFindings;
    }

    public AbstractSolverRunner.AnalysisStatus getAnalysisStatus() {
        return this.status;
    }
}

