/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.callgraph;

import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AllMainEntryPoints
implements Iterable<Entrypoint> {
    private final Collection<Entrypoint> entryPoints = new ArrayList<Entrypoint>(10);
    private static final String MAIN_METHOD_NAME = "main";
    private static final String MAIN_DESCRIPTOR = "([Ljava/lang/String;)V";

    public AllMainEntryPoints(AnalysisScope analysisScope, IClassHierarchy classHierarchy, Pattern[] mainClassesSelector, boolean isVerboseMode) throws SetUpException {
        Atom mainMethod = Atom.findOrCreateAsciiAtom((String)MAIN_METHOD_NAME);
        Descriptor mainDescriptor = Descriptor.findOrCreateUTF8((String)MAIN_DESCRIPTOR);
        for (IClass clazz : classHierarchy) {
            if (clazz.isInterface() || clazz.isAbstract() || !this.isApplicationClass(analysisScope, clazz)) continue;
            for (IMethod method : clazz.getDeclaredMethods()) {
                if (!this.isMainMethod(method.getReference(), mainMethod, mainDescriptor)) continue;
                this.addPotentiallyMainClass(classHierarchy, mainClassesSelector, clazz, method);
            }
        }
        if (this.entryPoints.isEmpty()) {
            throw new SetUpException("No valid entry points have been detected for the analysis.");
        }
        if (isVerboseMode) {
            System.out.println("Number of entrypoints detected: " + String.valueOf(this.entryPoints.size()));
        }
    }

    @Override
    public Iterator<Entrypoint> iterator() {
        return this.entryPoints.iterator();
    }

    private void addEntryPoint(String className, MethodReference methodRef, IClassHierarchy cha) {
        System.out.println("Main class " + className + " detected as entry point.");
        this.entryPoints.add((Entrypoint)new DefaultEntrypoint(methodRef, cha));
    }

    private void addPotentiallyMainClass(IClassHierarchy classHierarchy, Pattern[] mainClassesSelector, IClass clazz, IMethod method) {
        String className = clazz.getName().toString().substring(1).replace('/', '.');
        if (mainClassesSelector.length > 0) {
            int i = 0;
            while (i < mainClassesSelector.length) {
                Matcher matcher = mainClassesSelector[i].matcher(className);
                if (matcher.matches()) {
                    this.addEntryPoint(className, method.getReference(), classHierarchy);
                }
                ++i;
            }
        } else {
            this.addEntryPoint(className, method.getReference(), classHierarchy);
        }
    }

    private boolean isApplicationClass(AnalysisScope scope, IClass clazz) {
        return scope.getApplicationLoader().equals((Object)clazz.getClassLoader().getReference());
    }

    private boolean isMainMethod(MethodReference methodRef, Atom mainMethod, Descriptor mainDescriptor) {
        return methodRef.getName().equals((Object)mainMethod) && methodRef.getDescriptor().equals((Object)mainDescriptor);
    }
}

