/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.cfg.CFGSanitizer;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import com.ibm.wala.viz.PDFViewLauncher;
import java.util.HashMap;
import java.util.Iterator;

public class PDFViewUtil {
    public static Process ghostviewIR(IClassHierarchy cha, IR ir, String pdfFile, String dotFile, String dotExe, String pdfViewExe) throws WalaException {
        return PDFViewUtil.ghostviewIR(cha, ir, pdfFile, dotFile, dotExe, pdfViewExe, null);
    }

    public static Process ghostviewIR(IClassHierarchy cha, IR ir, String pdfFile, String dotFile, String dotExe, String pdfViewExe, NodeDecorator<ISSABasicBlock> annotations) throws WalaException {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        Graph<ISSABasicBlock> g = ir.getControlFlowGraph();
        NodeDecorator<ISSABasicBlock> labels = PDFViewUtil.makeIRDecorator(ir);
        if (annotations != null) {
            labels = new ConcatenatingNodeDecorator<ISSABasicBlock>(annotations, labels);
        }
        g = CFGSanitizer.sanitize(ir, cha);
        DotUtil.dotify(g, labels, (String)dotFile, (String)pdfFile, (String)dotExe);
        return PDFViewUtil.launchPDFView(pdfFile, pdfViewExe);
    }

    public static NodeDecorator<ISSABasicBlock> makeIRDecorator(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        final HashMap labelMap = HashMapFactory.make();
        Iterator<ISSABasicBlock> it = ir.getControlFlowGraph().iterator();
        while (it.hasNext()) {
            SSACFG.BasicBlock bb = (SSACFG.BasicBlock)it.next();
            labelMap.put(bb, PDFViewUtil.getNodeLabel(ir, bb));
        }
        NodeDecorator<ISSABasicBlock> labels = new NodeDecorator<ISSABasicBlock>(){

            public String getLabel(ISSABasicBlock bb) {
                return (String)labelMap.get(bb);
            }
        };
        return labels;
    }

    private static String getNodeLabel(IR ir, SSACFG.BasicBlock bb) {
        StringBuffer result = new StringBuffer();
        int start = bb.getFirstInstructionIndex();
        int end = bb.getLastInstructionIndex();
        result.append("BB").append(bb.getNumber());
        if (bb.isEntryBlock()) {
            result.append(" (en)\\n");
        } else if (bb.isExitBlock()) {
            result.append(" (ex)\\n");
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
            result.append("<Handler>");
        }
        result.append("\\n");
        Iterator<SSAPhiInstruction> it = bb.iteratePhis();
        while (it.hasNext()) {
            SSAPhiInstruction phi = it.next();
            if (phi == null) continue;
            result.append("           " + phi.toString(ir.getSymbolTable())).append("\\l");
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
            SSACFG.ExceptionHandlerBasicBlock ebb = (SSACFG.ExceptionHandlerBasicBlock)bb;
            SSAGetCaughtExceptionInstruction s = ebb.getCatchInstruction();
            if (s != null) {
                result.append("           " + s.toString(ir.getSymbolTable())).append("\\l");
            } else {
                result.append("            No catch instruction. Unreachable?\\l");
            }
        }
        SSAInstruction[] instructions = ir.getInstructions();
        int j = start;
        while (j <= end) {
            if (instructions[j] != null) {
                StringBuffer x = new StringBuffer(String.valueOf(j) + "   " + instructions[j].toString(ir.getSymbolTable()));
                StringStuff.padWithSpaces(x, 35);
                result.append(x);
                result.append("\\l");
            }
            ++j;
        }
        Iterator<SSAPiInstruction> it2 = bb.iteratePis();
        while (it2.hasNext()) {
            SSAPiInstruction pi = it2.next();
            if (pi == null) continue;
            result.append("           " + pi.toString(ir.getSymbolTable())).append("\\l");
        }
        return result.toString();
    }

    public static Process launchPDFView(String pdfFile, String gvExe) throws WalaException {
        if (gvExe == null) {
            throw new IllegalArgumentException("null gvExe");
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException("null psFile");
        }
        PDFViewLauncher gv = new PDFViewLauncher();
        gv.setGvExe(gvExe);
        gv.setPDFFile(pdfFile);
        gv.run();
        if (gv.getProcess() == null) {
            throw new WalaException(" problem spawning process ");
        }
        return gv.getProcess();
    }

    private static final class ConcatenatingNodeDecorator<T>
    implements NodeDecorator<T> {
        private final NodeDecorator<T> A;
        private final NodeDecorator<T> B;

        ConcatenatingNodeDecorator(NodeDecorator<T> A, NodeDecorator<T> B) {
            this.A = A;
            this.B = B;
        }

        public String getLabel(T n) throws WalaException {
            return String.valueOf(this.A.getLabel(n)) + this.B.getLabel(n);
        }
    }
}

