/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StringStuff {
    private static final HashMap<String, String> primitiveClassNames = HashMapFactory.make((int)10);

    static {
        primitiveClassNames.put("int", "I");
        primitiveClassNames.put("long", "J");
        primitiveClassNames.put("short", "S");
        primitiveClassNames.put("byte", "B");
        primitiveClassNames.put("char", "C");
        primitiveClassNames.put("double", "D");
        primitiveClassNames.put("float", "F");
        primitiveClassNames.put("boolean", "Z");
        primitiveClassNames.put("void", "V");
    }

    public static void padWithSpaces(StringBuffer b, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() < length) {
            int i = b.length();
            while (i < length) {
                b.append(" ");
                ++i;
            }
        }
    }

    public static String deployment2CanonicalTypeString(String dString) {
        if (dString == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int arrayIndex = (dString = dString.replace('.', '/')).indexOf("[]");
        if (arrayIndex > -1) {
            String baseType = dString.substring(0, arrayIndex);
            int dim = (dString.length() - arrayIndex) / 2;
            baseType = StringStuff.deployment2CanonicalTypeString(baseType);
            StringBuffer result = new StringBuffer("[");
            int i = 1;
            while (i < dim) {
                result.append("[");
                ++i;
            }
            result.append(baseType);
            return result.toString();
        }
        if (primitiveClassNames.get(dString) != null) {
            return primitiveClassNames.get(dString);
        }
        return "L" + dString;
    }

    public static String deployment2CanonicalDescriptorTypeString(String dString) {
        if (dString == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int arrayIndex = (dString = dString.replace('.', '/')).indexOf("[]");
        if (arrayIndex > -1) {
            String baseType = dString.substring(0, arrayIndex);
            int dim = (dString.length() - arrayIndex) / 2;
            baseType = StringStuff.deployment2CanonicalDescriptorTypeString(baseType);
            StringBuffer result = new StringBuffer("[");
            int i = 1;
            while (i < dim) {
                result.append("[");
                ++i;
            }
            result.append(baseType);
            return result.toString();
        }
        if (primitiveClassNames.get(dString) != null) {
            return primitiveClassNames.get(dString);
        }
        return "L" + dString + ";";
    }

    public static final TypeName parseForReturnTypeName(String desc) throws IllegalArgumentException {
        return StringStuff.parseForReturnTypeName((Language)Language.JAVA, ImmutableByteArray.make(desc));
    }

    public static final TypeName parseForReturnTypeName(Language l, String desc) throws IllegalArgumentException {
        return StringStuff.parseForReturnTypeName(l, ImmutableByteArray.make(desc));
    }

    public static final TypeName parseForReturnTypeName(Language l, ImmutableByteArray b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() <= 2) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        if (b.get(0) != 40) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        int i = 0;
        while (b.get(i++) != 41) {
        }
        if (b.length() < i + 1) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        switch (b.get(i)) {
            case 86: {
                return TypeReference.Void.getName();
            }
            case 90: {
                return TypeReference.Boolean.getName();
            }
            case 66: {
                return TypeReference.Byte.getName();
            }
            case 83: {
                return TypeReference.Short.getName();
            }
            case 73: {
                return TypeReference.Int.getName();
            }
            case 74: {
                return TypeReference.Long.getName();
            }
            case 70: {
                return TypeReference.Float.getName();
            }
            case 68: {
                return TypeReference.Double.getName();
            }
            case 67: {
                return TypeReference.Char.getName();
            }
            case 80: {
                if (b.get(b.length() - 1) == 59) {
                    return l.lookupPrimitiveType(new String(b.substring(i + 1, b.length() - i - 2)));
                }
                return l.lookupPrimitiveType(new String(b.substring(i + 1, b.length() - i - 1)));
            }
            case 76: 
            case 91: {
                if (b.get(b.length() - 1) == 59) {
                    return TypeName.findOrCreate(b, i, b.length() - i - 1);
                }
                return TypeName.findOrCreate(b, i, b.length() - i);
            }
        }
        throw new IllegalArgumentException("unexpected type in descriptor " + b);
    }

    public static final TypeName[] parseForParameterNames(String descriptor) throws IllegalArgumentException {
        return StringStuff.parseForParameterNames((Language)Language.JAVA, ImmutableByteArray.make(descriptor));
    }

    public static final TypeName[] parseForParameterNames(Language l, String descriptor) throws IllegalArgumentException {
        return StringStuff.parseForParameterNames(l, ImmutableByteArray.make(descriptor));
    }

    public static final TypeName[] parseForParameterNames(Language l, ImmutableByteArray b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() <= 2) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        if (b.get(0) != 40) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        ArrayList<TypeName> sigs = new ArrayList<TypeName>(10);
        int i = 1;
        block15: while (true) {
            switch (b.get(i++)) {
                case 86: {
                    sigs.add(TypeReference.VoidName);
                    continue block15;
                }
                case 90: {
                    sigs.add(TypeReference.BooleanName);
                    continue block15;
                }
                case 66: {
                    sigs.add(TypeReference.ByteName);
                    continue block15;
                }
                case 83: {
                    sigs.add(TypeReference.ShortName);
                    continue block15;
                }
                case 73: {
                    sigs.add(TypeReference.IntName);
                    continue block15;
                }
                case 74: {
                    sigs.add(TypeReference.LongName);
                    continue block15;
                }
                case 70: {
                    sigs.add(TypeReference.FloatName);
                    continue block15;
                }
                case 68: {
                    sigs.add(TypeReference.DoubleName);
                    continue block15;
                }
                case 67: {
                    sigs.add(TypeReference.CharName);
                    continue block15;
                }
                case 80: {
                    int off = i - 1;
                    while (b.get(i++) != 59) {
                    }
                    sigs.add(l.lookupPrimitiveType(new String(b.substring(off + 1, i - off - 2))));
                    continue block15;
                }
                case 76: {
                    int off = i - 1;
                    while (b.get(i++) != 59) {
                    }
                    sigs.add(TypeName.findOrCreate(b, off, i - off - 1));
                    continue block15;
                }
                case 38: 
                case 42: 
                case 91: {
                    byte c;
                    int off = i - 1;
                    while (StringStuff.isTypeCodeChar(b, i)) {
                        ++i;
                    }
                    TypeName T = null;
                    if ((c = b.get(i++)) == 76 || c == 80) {
                        while (b.get(i++) != 59) {
                        }
                        T = TypeName.findOrCreate(b, off, i - off - 1);
                    } else {
                        T = TypeName.findOrCreate(b, off, i - off);
                    }
                    sigs.add(T);
                    continue block15;
                }
                case 41: {
                    int size = sigs.size();
                    if (size == 0) {
                        return null;
                    }
                    Iterator it = sigs.iterator();
                    TypeName[] result = new TypeName[size];
                    int j = 0;
                    while (j < size) {
                        result[j] = (TypeName)it.next();
                        ++j;
                    }
                    return result;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)("bad descriptor " + b));
    }

    public static boolean isTypeCodeChar(ImmutableByteArray name, int i) {
        return name.b[i] == 91 || name.b[i] == 42 || name.b[i] == 38;
    }

    public static ImmutableByteArray parseForPackage(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        int lastSlash;
        block7: {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            lastSlash = -1;
            int i = start;
            while (i < start + length) {
                if (name.b[i] == 47) {
                    lastSlash = i;
                }
                ++i;
            }
            if (lastSlash != -1) break block7;
            return null;
        }
        try {
            int dim = 0;
            while (StringStuff.isTypeCodeChar(name, start + dim)) {
                dim = (short)(dim + 1);
            }
            return new ImmutableByteArray(name.b, start + 1 + dim, lastSlash - start - 1 - dim);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid name " + name + " start: " + start + " length: " + length);
        }
    }

    public static ImmutableByteArray parseForPackage(ImmutableByteArray name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return StringStuff.parseForPackage(name, 0, name.length());
    }

    public static ImmutableByteArray parseForClass(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("invalid class name: zero length");
        }
        try {
            if (StringStuff.parseForPackage(name, start, length) == null) {
                while (StringStuff.isTypeCodeChar(name, start)) {
                    ++start;
                    --length;
                }
                if (name.b[start] == 76) {
                    ++start;
                    --length;
                }
                return new ImmutableByteArray(name.b, start, length);
            }
            int lastSlash = 0;
            int i = start;
            while (i < start + length) {
                if (name.b[i] == 47) {
                    lastSlash = i;
                }
                ++i;
            }
            int L = length - (lastSlash - start + 1);
            return new ImmutableByteArray(name.b, lastSlash + 1, L);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Malformed name: " + name + " " + start + " " + length);
        }
    }

    public static ImmutableByteArray parseForClass(ImmutableByteArray name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return StringStuff.parseForClass(name, 0, name.length());
    }

    public static int parseForArrayDimensionality(ImmutableByteArray b, int start, int length) throws IllegalArgumentException, IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        try {
            int code = 0;
            int i = start;
            while (i < start + length) {
                if (!StringStuff.isTypeCodeChar(b, i)) break;
                code <<= 3;
                switch (b.b[i]) {
                    case 91: {
                        code |= 1;
                        break;
                    }
                    case 42: {
                        code |= 2;
                        break;
                    }
                    case 38: {
                        code |= 3;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("ill-formed array descriptor " + b);
                    }
                }
                ++i;
            }
            return code;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("ill-formed array descriptor " + b);
        }
    }

    public static ImmutableByteArray parseForInnermostArrayElementDescriptor(ImmutableByteArray b, int start, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        try {
            int i = start;
            while (i < start + length) {
                if (!StringStuff.isTypeCodeChar(b, i)) break;
                ++i;
            }
            return new ImmutableByteArray(b.b, i, length - (i - start));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid element desciptor: " + b);
        }
    }

    public static ImmutableByteArray parseForInnermostArrayElementDescriptor(Atom a) {
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        ImmutableByteArray b = new ImmutableByteArray(a.getValArray());
        return StringStuff.parseForInnermostArrayElementDescriptor(b, 0, b.length());
    }

    /*
     * Exception decompiling
     */
    public static boolean classIsPrimitive(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MethodReference makeMethodReference(String methodSig) throws IllegalArgumentException {
        return StringStuff.makeMethodReference(Language.JAVA, methodSig);
    }

    public static MethodReference makeMethodReference(Language l, String methodSig) throws IllegalArgumentException {
        if (methodSig == null) {
            throw new IllegalArgumentException("methodSig is null");
        }
        if (methodSig.lastIndexOf(46) < 0) {
            throw new IllegalArgumentException("ill-formed sig " + methodSig);
        }
        String type = methodSig.substring(0, methodSig.lastIndexOf(46));
        type = StringStuff.deployment2CanonicalTypeString(type);
        TypeReference t = TypeReference.findOrCreate(ClassLoaderReference.Application, type);
        String methodName = methodSig.substring(methodSig.lastIndexOf(46) + 1, methodSig.indexOf(40));
        String desc = methodSig.substring(methodSig.indexOf(40));
        return MethodReference.findOrCreate(l, t, methodName, desc);
    }

    public static String jvmToReadableType(String jvmType) throws IllegalArgumentException {
        if (jvmType == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer readable = new StringBuffer();
        int numberOfDimensions = 0;
        if (jvmType.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + jvmType);
        }
        char prefix = jvmType.charAt(0);
        while (prefix == '[') {
            prefix = jvmType.charAt(++numberOfDimensions);
        }
        if (prefix == 'V') {
            readable.append("void");
        } else if (prefix == 'B') {
            readable.append("byte");
        } else if (prefix == 'C') {
            readable.append("char");
        } else if (prefix == 'D') {
            readable.append("double");
        } else if (prefix == 'F') {
            readable.append("float");
        } else if (prefix == 'I') {
            readable.append("int");
        } else if (prefix == 'J') {
            readable.append("long");
        } else if (prefix == 'S') {
            readable.append("short");
        } else if (prefix == 'Z') {
            readable.append("boolean");
        } else if (prefix == 'L') {
            readable.append(jvmType.substring(numberOfDimensions + 1, jvmType.length()));
            readable = new StringBuffer(StringStuff.slashToDot(readable.toString()));
            readable = new StringBuffer(StringStuff.dollarToDot(readable.toString()));
        }
        int i = 0;
        while (i < numberOfDimensions) {
            readable.append("[]");
            ++i;
        }
        return readable.toString();
    }

    public static String jvmToBinaryName(String jvmType) throws IllegalArgumentException {
        if (jvmType == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer readable = new StringBuffer();
        int numberOfDimensions = 0;
        if (jvmType.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + jvmType);
        }
        char prefix = jvmType.charAt(0);
        while (prefix == '[') {
            prefix = jvmType.charAt(++numberOfDimensions);
        }
        if (prefix == 'V') {
            readable.append("void");
        } else if (prefix == 'B') {
            readable.append("byte");
        } else if (prefix == 'C') {
            readable.append("char");
        } else if (prefix == 'D') {
            readable.append("double");
        } else if (prefix == 'F') {
            readable.append("float");
        } else if (prefix == 'I') {
            readable.append("int");
        } else if (prefix == 'J') {
            readable.append("long");
        } else if (prefix == 'S') {
            readable.append("short");
        } else if (prefix == 'Z') {
            readable.append("boolean");
        } else if (prefix == 'L') {
            readable.append(jvmType.substring(numberOfDimensions + 1, jvmType.length()));
            readable = new StringBuffer(StringStuff.slashToDot(readable.toString()));
        }
        int i = 0;
        while (i < numberOfDimensions) {
            readable.append("[]");
            ++i;
        }
        return readable.toString();
    }

    public static String slashToDot(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        int i = 0;
        while (i < dotForm.length()) {
            if (dotForm.charAt(i) == '/') {
                dotForm.setCharAt(i, '.');
            }
            ++i;
        }
        return dotForm.toString();
    }

    public static String dollarToDot(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        int i = 0;
        while (i < dotForm.length()) {
            if (dotForm.charAt(i) == '$') {
                dotForm.setCharAt(i, '.');
            }
            ++i;
        }
        return dotForm.toString();
    }

    public static String dotToDollar(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        int i = 0;
        while (i < dotForm.length()) {
            if (dotForm.charAt(i) == '.') {
                dotForm.setCharAt(i, '$');
            }
            ++i;
        }
        return dotForm.toString();
    }

    public static String toBasename(String typeName) {
        int start = 0;
        int stop = typeName.length() - 1;
        if (typeName.contains(".")) {
            start = typeName.lastIndexOf(".");
        } else if (typeName.contains("/")) {
            start = typeName.lastIndexOf("/");
        }
        if (typeName.endsWith(";")) {
            --stop;
        }
        return typeName.substring(start, stop);
    }
}

