/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.util.strings.Atom;

public final class Selector {
    private final Atom name;
    private final Descriptor descriptor;

    public static Selector make(String selectorStr) {
        return Selector.make(Language.JAVA, selectorStr);
    }

    public static Selector make(Language l, String selectorStr) {
        if (selectorStr == null) {
            throw new IllegalArgumentException("null selectorStr");
        }
        try {
            String methodName = selectorStr.substring(0, selectorStr.indexOf(40));
            String desc = selectorStr.substring(selectorStr.indexOf(40));
            return new Selector(Atom.findOrCreateUnicodeAtom(methodName), Descriptor.findOrCreateUTF8(l, desc));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid selectorStr: " + selectorStr);
        }
    }

    public Selector(Atom name, Descriptor descriptor) {
        this.name = name;
        this.descriptor = descriptor;
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("null descriptor");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Selector) {
            Selector other = (Selector)obj;
            return this.name.equals(other.name) && this.descriptor.equals(other.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return 19 * this.name.hashCode() + this.descriptor.hashCode();
    }

    public String toString() {
        return String.valueOf(this.name.toString()) + this.descriptor.toString();
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Atom getName() {
        return this.name;
    }
}

