/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.PhiValue;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashMap;

public class SymbolTable
implements Cloneable {
    private static final int MAX_VALUE_NUMBER = 0x1FFFFFFF;
    private final int[] parameters;
    private HashMap<ConstantValue, Integer> constants = HashMapFactory.make((int)10);
    private boolean copy = false;
    private Value[] values = new Value[5];
    private int nextFreeValueNumber = 1;
    private Object[] defaultValues;

    public SymbolTable(int numberOfParameters) {
        if (numberOfParameters < 0) {
            throw new IllegalArgumentException("Illegal numberOfParameters: " + numberOfParameters);
        }
        this.parameters = new int[numberOfParameters];
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.getNewValueNumber();
            ++i;
        }
    }

    public int newSymbol() {
        return this.getNewValueNumber();
    }

    int findOrCreateConstant(Object o) {
        ConstantValue v = new ConstantValue(o);
        Integer result = this.constants.get(v);
        if (result == null) {
            assert (!this.copy) : "making value for " + o;
            int r = this.getNewValueNumber();
            result = r;
            this.constants.put(v, result);
            assert (r < this.nextFreeValueNumber);
            this.values[r] = v;
        } else assert (this.values[result] instanceof ConstantValue);
        return result;
    }

    public void setConstantValue(int vn, ConstantValue val) {
        try {
            assert (vn < this.nextFreeValueNumber);
            this.values[vn] = val;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid vn: " + vn);
        }
    }

    public void setDefaultValue(int vn, Object defaultValue) {
        assert (vn < this.nextFreeValueNumber);
        if (this.defaultValues == null) {
            this.defaultValues = new Object[vn * 2 + 1];
        }
        if (this.defaultValues.length <= vn) {
            Object[] temp = this.defaultValues;
            this.defaultValues = new Object[vn * 2 + 1];
            System.arraycopy(temp, 0, this.defaultValues, 0, temp.length);
        }
        this.defaultValues[vn] = defaultValue;
    }

    public int getDefaultValue(int vn) {
        return this.findOrCreateConstant(this.defaultValues[vn]);
    }

    public int getNullConstant() {
        return this.findOrCreateConstant(null);
    }

    public int getConstant(boolean b) {
        return this.findOrCreateConstant(b);
    }

    public int getConstant(int i) {
        return this.findOrCreateConstant(i);
    }

    public int getConstant(long l) {
        return this.findOrCreateConstant(l);
    }

    public int getConstant(float f) {
        return this.findOrCreateConstant(new Float(f));
    }

    public int getConstant(double d) {
        return this.findOrCreateConstant(new Double(d));
    }

    public int getConstant(String s) {
        return this.findOrCreateConstant(s);
    }

    public int getParameter(int i) throws IllegalArgumentException {
        try {
            return this.parameters[i];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid i: " + i);
        }
    }

    private void expandForNewValueNumber(int vn) {
        if (vn >= this.values.length) {
            Value[] temp = this.values;
            this.values = new Value[2 * vn];
            System.arraycopy(temp, 0, this.values, 0, temp.length);
        }
    }

    private int getNewValueNumber() {
        int result = this.nextFreeValueNumber++;
        this.expandForNewValueNumber(result);
        return result;
    }

    public void ensureSymbol(int i) {
        if (i < 0 || i > 0x1FFFFFFF) {
            throw new IllegalArgumentException("Illegal i: " + i);
        }
        try {
            if (i != -1 && (i >= this.values.length || this.values[i] == null)) {
                if (this.nextFreeValueNumber <= i) {
                    this.nextFreeValueNumber = i + 1;
                }
                this.expandForNewValueNumber(i);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid i: " + i);
        }
    }

    public String getValueString(int valueNumber) {
        if (valueNumber < 0 || valueNumber > this.getMaxValueNumber() || this.values[valueNumber] == null || this.values[valueNumber] instanceof PhiValue) {
            return "v" + valueNumber;
        }
        return "v" + valueNumber + ":" + this.values[valueNumber].toString();
    }

    public boolean isConstant(int v) {
        try {
            return v < this.values.length && this.values[v] instanceof ConstantValue;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isZero(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).isZeroConstant();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isOne(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).isOneConstant();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isTrue(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).isTrueConstant();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isZeroOrFalse(int v) {
        return this.isZero(v) || this.isFalse(v);
    }

    public boolean isOneOrTrue(int v) {
        return this.isOne(v) || this.isTrue(v);
    }

    public boolean isFalse(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).isFalseConstant();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isBooleanOrZeroOneConstant(int v) {
        return this.isBooleanConstant(v) || this.isZero(v) || this.isOne(v);
    }

    public boolean isBooleanConstant(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Boolean;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isIntegerConstant(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Integer;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isLongConstant(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Long;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isFloatConstant(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Float;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isDoubleConstant(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Double;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isNumberConstant(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Number;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isStringConstant(int v) {
        try {
            return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof String;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public boolean isNullConstant(int v) {
        try {
            return this.values.length > v && this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() == null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + v);
        }
    }

    public int newPhi(int[] rhs) throws IllegalArgumentException {
        if (rhs == null) {
            throw new IllegalArgumentException("rhs is null");
        }
        int result = this.getNewValueNumber();
        SSAPhiInstruction phi = new SSAPhiInstruction(-1, result, (int[])rhs.clone());
        assert (result < this.nextFreeValueNumber);
        this.values[result] = new PhiValue(phi);
        return result;
    }

    public PhiValue getPhiValue(int valueNumber) {
        try {
            return (PhiValue)this.values[valueNumber];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid valueNumber: " + valueNumber);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid valueNumber: " + valueNumber);
        }
    }

    public int getMaxValueNumber() {
        return this.nextFreeValueNumber - 1;
    }

    public int[] getParameterValueNumbers() {
        return this.parameters;
    }

    public int getNumberOfParameters() {
        return this.parameters.length;
    }

    public String getStringValue(int v) throws IllegalArgumentException {
        if (!this.isStringConstant(v)) {
            throw new IllegalArgumentException("not a string constant: value number " + v);
        }
        return (String)((ConstantValue)this.values[v]).getValue();
    }

    public float getFloatValue(int v) throws IllegalArgumentException {
        if (!this.isNumberConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[v]).getValue()).floatValue();
    }

    public double getDoubleValue(int v) throws IllegalArgumentException {
        if (!this.isNumberConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[v]).getValue()).doubleValue();
    }

    public int getIntValue(int v) throws IllegalArgumentException {
        if (!this.isNumberConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[v]).getValue()).intValue();
    }

    public long getLongValue(int v) throws IllegalArgumentException {
        if (!this.isNumberConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[v]).getValue()).longValue();
    }

    public Object getConstantValue(int v) throws IllegalArgumentException {
        if (!this.isConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a constant.");
        }
        Object value = ((ConstantValue)this.values[v]).getValue();
        if (value == null) {
            return null;
        }
        return value;
    }

    public Value getValue(int valueNumber) {
        if (valueNumber < 1 || valueNumber >= this.values.length) {
            throw new IllegalArgumentException("Invalid value number " + valueNumber);
        }
        return this.values[valueNumber];
    }

    public boolean isParameter(int valueNumber) {
        return valueNumber <= this.getNumberOfParameters();
    }

    public SymbolTable copy() {
        try {
            SymbolTable nt = (SymbolTable)this.clone();
            nt.values = (Value[])this.values.clone();
            if (this.defaultValues != null) {
                nt.defaultValues = (Object[])this.defaultValues.clone();
            }
            nt.constants = HashMapFactory.make(this.constants);
            nt.copy = true;
            return nt;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

