/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;

public class SSAPiInstruction
extends SSAUnaryOpInstruction {
    private final SSAInstruction cause;
    private final int successorBlock;
    private final int piBlock;

    public SSAPiInstruction(int iindex, int result, int val, int piBlock, int successorBlock, SSAInstruction cause) {
        super(iindex, null, result, val);
        this.cause = cause;
        this.successorBlock = successorBlock;
        this.piBlock = piBlock;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        assert (defs == null || defs.length == 1);
        assert (uses == null || uses.length == 1);
        return insts.PiInstruction(this.iindex, defs == null ? this.result : defs[0], uses == null ? this.val : uses[0], this.piBlock, this.successorBlock, this.cause);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = pi " + this.getValueString(symbolTable, this.val) + " for BB" + this.successorBlock + ", cause " + this.cause;
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitPi(this);
    }

    public int getSuccessor() {
        return this.successorBlock;
    }

    public int getPiBlock() {
        return this.piBlock;
    }

    public SSAInstruction getCause() {
        return this.cause;
    }

    public int getVal() {
        return this.getUse(0);
    }
}

