/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;

public abstract class SSAGetInstruction
extends SSAFieldAccessInstruction {
    private final int result;

    protected SSAGetInstruction(int iindex, int result, int ref, FieldReference field) {
        super(iindex, field, ref);
        this.result = result;
    }

    protected SSAGetInstruction(int iindex, int result, FieldReference field) {
        super(iindex, field, -1);
        this.result = result;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (this.isStatic()) {
            return insts.GetInstruction(this.iindex, defs == null || defs.length == 0 ? this.result : defs[0], this.getDeclaredField());
        }
        return insts.GetInstruction(this.iindex, defs == null || defs.length == 0 ? this.result : defs[0], uses == null ? this.getRef() : uses[0], this.getDeclaredField());
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        if (this.isStatic()) {
            return String.valueOf(this.getValueString(symbolTable, this.result)) + " = getstatic " + this.getDeclaredField();
        }
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = getfield " + this.getDeclaredField() + " " + this.getValueString(symbolTable, this.getRef());
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitGet(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getNumberOfUses() {
        return this.isStatic() ? 0 : 1;
    }

    @Override
    public int getUse(int j) {
        assert (j == 0 && this.getRef() != -1);
        return this.getRef();
    }

    @Override
    public int hashCode() {
        return this.result * 2371 + 6521;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }
}

