/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.cdg.ControlDependenceGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.ExceptionPrunedCFG;
import com.ibm.wala.ipa.cfg.PrunedCFG;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCallee;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.GetCaughtExceptionStatement;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapReachingDefs;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.ParamCallee;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.PhiStatement;
import com.ibm.wala.ipa.slicer.PiStatement;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.ValueNumberCarrier;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphUtil;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.graph.labeled.SlowSparseNumberedLabeledGraph;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PDG<T extends InstanceKey>
implements NumberedGraph<Statement> {
    private final SlowSparseNumberedLabeledGraph<Statement, Dependency> delegate = new SlowSparseNumberedLabeledGraph((Object)Dependency.DATA_AND_CONTROL_DEP);
    private static final boolean VERBOSE = false;
    private final CGNode node;
    private Statement[] paramCalleeStatements;
    private Statement[] returnStatements;
    private final Map<CallSiteReference, Statement> callSite2Statement = HashMapFactory.make();
    private final Map<CallSiteReference, Set<Statement>> callerParamStatements = HashMapFactory.make();
    private final Map<CallSiteReference, Set<Statement>> callerReturnStatements = HashMapFactory.make();
    private final HeapExclusions exclusions;
    private final Collection<PointerKey> locationsHandled = HashSetFactory.make();
    private final PointerAnalysis<T> pa;
    private final ExtendedHeapModel heapModel;
    private final Map<CGNode, OrdinalSet<PointerKey>> mod;
    private final Slicer.DataDependenceOptions dOptions;
    private final Slicer.ControlDependenceOptions cOptions;
    private final CallGraph cg;
    private final ModRef modRef;
    private final Map<CGNode, OrdinalSet<PointerKey>> ref;
    private final boolean ignoreAllocHeapDefs;
    private boolean isPopulated = false;

    public PDG(CGNode node, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, Map<CGNode, OrdinalSet<PointerKey>> ref, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions, HeapExclusions exclusions, CallGraph cg, ModRef modRef) {
        this(node, pa, mod, ref, dOptions, cOptions, exclusions, cg, modRef, false);
    }

    public PDG(CGNode node, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, Map<CGNode, OrdinalSet<PointerKey>> ref, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions, HeapExclusions exclusions, CallGraph cg, ModRef modRef, boolean ignoreAllocHeapDefs) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.cg = cg;
        this.node = node;
        this.heapModel = pa != null ? modRef.makeHeapModel(pa) : null;
        this.pa = pa;
        this.dOptions = dOptions;
        this.cOptions = cOptions;
        this.mod = mod;
        this.exclusions = exclusions;
        this.modRef = modRef;
        this.ref = ref;
        this.ignoreAllocHeapDefs = ignoreAllocHeapDefs;
    }

    private void populate() {
        if (!this.isPopulated) {
            IR ir = this.node.getIR();
            this.isPopulated = true;
            Map<SSAInstruction, Integer> instructionIndices = PDG.computeInstructionIndices(ir);
            this.createNodes(this.ref, this.cOptions, ir);
            this.createScalarEdges(this.cOptions, ir, instructionIndices);
        }
    }

    private void createScalarEdges(Slicer.ControlDependenceOptions cOptions, IR ir, Map<SSAInstruction, Integer> instructionIndices) {
        this.createScalarDataDependenceEdges(ir, instructionIndices);
        this.createControlDependenceEdges(cOptions, ir, instructionIndices);
    }

    public Set<Statement> getCallerParamStatements(SSAAbstractInvokeInstruction call) throws IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        this.populate();
        return this.callerParamStatements.get(call.getCallSite());
    }

    public Set<Statement> getCallStatements(SSAAbstractInvokeInstruction call) throws IllegalArgumentException {
        Set<Statement> callerParamStatements = this.getCallerParamStatements(call);
        HashSet result = HashSetFactory.make((int)(callerParamStatements.size() + 1));
        result.addAll(callerParamStatements);
        result.add(this.callSite2Statement.get(call.getCallSite()));
        return result;
    }

    public Set<Statement> getCallerReturnStatements(SSAAbstractInvokeInstruction call) throws IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        this.populate();
        return this.callerReturnStatements.get(call.getCallSite());
    }

    private void createControlDependenceEdges(Slicer.ControlDependenceOptions cOptions, IR ir, Map<SSAInstruction, Integer> instructionIndices) {
        if (cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
            return;
        }
        if (ir == null) {
            return;
        }
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph = ir.getControlFlowGraph();
        if (cOptions.equals((Object)Slicer.ControlDependenceOptions.NO_EXCEPTIONAL_EDGES)) {
            PrunedCFG<SSAInstruction, ISSABasicBlock> prunedCFG = ExceptionPrunedCFG.make(controlFlowGraph);
            if (prunedCFG.getNumberOfNodes() == 2 && prunedCFG.containsNode((ISSABasicBlock)controlFlowGraph.entry()) && prunedCFG.containsNode((ISSABasicBlock)controlFlowGraph.exit()) && GraphUtil.countEdges(prunedCFG) == 0L) {
                return;
            }
            controlFlowGraph = prunedCFG;
        } else {
            Assertions.productionAssertion((boolean)cOptions.equals((Object)Slicer.ControlDependenceOptions.FULL));
        }
        ControlDependenceGraph<ISSABasicBlock> cdg = new ControlDependenceGraph<ISSABasicBlock>(controlFlowGraph);
        Iterator iterator = cdg.iterator();
        while (iterator.hasNext()) {
            ISSABasicBlock bb = (ISSABasicBlock)iterator.next();
            if (bb.isExitBlock()) continue;
            Statement src = null;
            if (bb.isEntryBlock()) {
                src = new MethodEntryStatement(this.node);
            } else {
                SSAInstruction s = ir.getInstructions()[bb.getLastInstructionIndex()];
                if (s != null) {
                    src = this.ssaInstruction2Statement(s, ir, instructionIndices);
                }
            }
            if (src == null) continue;
            Iterator succ = cdg.getSuccNodes(bb);
            while (succ.hasNext()) {
                ISSABasicBlock bb2 = (ISSABasicBlock)succ.next();
                for (SSAInstruction st : bb2) {
                    if (st == null) continue;
                    Statement dest = this.ssaInstruction2Statement(st, ir, instructionIndices);
                    assert (src != null);
                    this.delegate.addEdge((Object)src, (Object)dest);
                    this.delegate.addEdge((Object)src, (Object)dest, (Object)Dependency.CONTROL_DEP);
                }
            }
        }
        MethodEntryStatement methodEntry = new MethodEntryStatement(this.node);
        Dominators dom = Dominators.make((Graph)controlFlowGraph, (Object)((ISSABasicBlock)controlFlowGraph.entry()));
        for (ISSABasicBlock exitDom : Iterator2Iterable.make((Iterator)dom.dominators((Object)((ISSABasicBlock)controlFlowGraph.exit())))) {
            for (SSAInstruction st : exitDom) {
                Statement dest = this.ssaInstruction2Statement(st, ir, instructionIndices);
                this.delegate.addEdge((Object)methodEntry, (Object)dest);
                this.delegate.addEdge((Object)methodEntry, (Object)dest, (Object)Dependency.CONTROL_DEP);
            }
        }
        if (!this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
            Iterator iterator2 = cdg.iterator();
            while (iterator2.hasNext()) {
                ISSABasicBlock bb = (ISSABasicBlock)iterator2.next();
                Iterator<SSAPhiInstruction> ps = bb.iteratePhis();
                while (ps.hasNext()) {
                    SSAPhiInstruction phi = ps.next();
                    Statement phiSt = this.ssaInstruction2Statement(phi, ir, instructionIndices);
                    int phiUseIndex = 0;
                    Iterator preds = controlFlowGraph.getPredNodes(bb);
                    while (preds.hasNext()) {
                        ISSABasicBlock pb = (ISSABasicBlock)preds.next();
                        int use = phi.getUse(phiUseIndex);
                        if (use == -1) continue;
                        if (controlFlowGraph.getSuccNodeCount(pb) > 1) {
                            SSAInstruction pss = ir.getInstructions()[pb.getLastInstructionIndex()];
                            assert (pss != null);
                            Statement pst = this.ssaInstruction2Statement(pss, ir, instructionIndices);
                            this.delegate.addEdge((Object)pst, (Object)phiSt);
                            this.delegate.addEdge((Object)pst, (Object)phiSt, (Object)Dependency.CONTROL_DEP);
                        } else {
                            Iterator cdps = cdg.getPredNodes(pb);
                            while (cdps.hasNext()) {
                                ISSABasicBlock cpb = (ISSABasicBlock)cdps.next();
                                if (cpb.getLastInstructionIndex() < 0) continue;
                                SSAInstruction cps = ir.getInstructions()[cpb.getLastInstructionIndex()];
                                assert (cps != null) : "unexpected null final instruction for CDG predecessor " + cpb + " in node " + this.node;
                                Statement cpst = this.ssaInstruction2Statement(cps, ir, instructionIndices);
                                this.delegate.addEdge((Object)cpst, (Object)phiSt);
                                this.delegate.addEdge((Object)cpst, (Object)phiSt, (Object)Dependency.CONTROL_DEP);
                            }
                        }
                        ++phiUseIndex;
                    }
                }
            }
        }
    }

    private void createScalarDataDependenceEdges(IR ir, Map<SSAInstruction, Integer> instructionIndices) {
        Object st;
        if (this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
            return;
        }
        if (ir == null) {
            return;
        }
        DefUse DU = new DefUse(ir);
        SSAInstruction[] instructions = ir.getInstructions();
        if (!this.dOptions.isIgnoreExceptions()) {
            Iterator<ISSABasicBlock> iterator = ir.getControlFlowGraph().iterator();
            while (iterator.hasNext()) {
                SSACFG.ExceptionHandlerBasicBlock ehbb;
                ISSABasicBlock bb = iterator.next();
                if (!bb.isCatchBlock() || (ehbb = (SSACFG.ExceptionHandlerBasicBlock)bb).getCatchInstruction() == null) continue;
                Statement c = this.ssaInstruction2Statement(ehbb.getCatchInstruction(), ir, instructionIndices);
                for (ISSABasicBlock pb : ir.getControlFlowGraph().getExceptionalPredecessors(ehbb)) {
                    st = instructions[pb.getLastInstructionIndex()];
                    if (st instanceof SSAAbstractInvokeInstruction) {
                        this.delegate.addEdge((Object)new ExceptionalReturnCaller(this.node, pb.getLastInstructionIndex()), (Object)c);
                        continue;
                    }
                    if (!(st instanceof SSAAbstractThrowInstruction)) continue;
                    this.delegate.addEdge((Object)this.ssaInstruction2Statement((SSAInstruction)st, ir, instructionIndices), (Object)c);
                }
            }
        }
        Iterator<Statement> it = this.iterator();
        block10: while (it.hasNext()) {
            Statement s = it.next();
            switch (s.getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case CATCH: {
                    SSAInstruction statement = this.statement2SSAInstruction(instructions, s);
                    if (statement instanceof SSAAbstractInvokeInstruction || this.dOptions.isTerminateAtCast() && statement instanceof SSACheckCastInstruction || this.dOptions.isTerminateAtCast() && statement instanceof SSAInstanceofInstruction) continue block10;
                    int i = 0;
                    while (i < statement.getNumberOfDefs()) {
                        int def = statement.getDef(i);
                        Iterator<SSAInstruction> it2 = DU.getUses(def);
                        while (it2.hasNext()) {
                            SSAArrayReferenceInstruction arr;
                            int base;
                            SSAInstruction use = it2.next();
                            if (this.dOptions.isIgnoreBasePtrs() && (use instanceof SSANewInstruction || this.hasBasePointer(use) && (def == (base = this.getBasePointer(use)) || use instanceof SSAArrayReferenceInstruction && def == (arr = (SSAArrayReferenceInstruction)use).getIndex()))) continue;
                            Statement u = this.ssaInstruction2Statement(use, ir, instructionIndices);
                            this.delegate.addEdge((Object)s, (Object)u);
                        }
                        ++i;
                    }
                    continue block10;
                }
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case EXC_RET_CALLER: {
                    if (this.dOptions.isIgnoreExceptions()) assert (!s.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER));
                    ValueNumberCarrier a = (ValueNumberCarrier)((Object)s);
                    Iterator<SSAInstruction> it2 = DU.getUses(a.getValueNumber());
                    while (it2.hasNext()) {
                        SSAInstruction use = it2.next();
                        if (this.dOptions.isIgnoreBasePtrs()) {
                            if (use instanceof SSANewInstruction) continue;
                            if (this.hasBasePointer(use)) {
                                int base = this.getBasePointer(use);
                                if (a.getValueNumber() == base) continue;
                                if (use instanceof SSAArrayReferenceInstruction) {
                                    SSAArrayReferenceInstruction arr = (SSAArrayReferenceInstruction)use;
                                    if (a.getValueNumber() == arr.getIndex()) continue;
                                }
                            }
                        }
                        Statement u = this.ssaInstruction2Statement(use, ir, instructionIndices);
                        this.delegate.addEdge((Object)s, (Object)u);
                    }
                    continue block10;
                }
                case NORMAL_RET_CALLEE: {
                    for (NormalStatement ret : this.computeReturnStatements(ir)) {
                        this.delegate.addEdge((Object)ret, (Object)s);
                    }
                    continue block10;
                }
                case EXC_RET_CALLEE: {
                    if (this.dOptions.isIgnoreExceptions()) {
                        Assertions.UNREACHABLE();
                    }
                    IntIterator ii = this.getPEIs(ir).intIterator();
                    while (ii.hasNext()) {
                        int index = ii.next();
                        SSAInstruction pei = ir.getInstructions()[index];
                        if (this.dOptions.isTerminateAtCast() && pei instanceof SSACheckCastInstruction) continue;
                        if (pei instanceof SSAAbstractInvokeInstruction) {
                            if (this.dOptions.isIgnoreExceptions()) continue;
                            ExceptionalReturnCaller st2 = new ExceptionalReturnCaller(this.node, index);
                            this.delegate.addEdge((Object)st2, (Object)s);
                            continue;
                        }
                        this.delegate.addEdge((Object)new NormalStatement(this.node, index), (Object)s);
                    }
                    continue block10;
                }
                case PARAM_CALLER: {
                    ParamCaller pac = (ParamCaller)s;
                    int vn = pac.getValueNumber();
                    if (vn <= -1) continue block10;
                    if (ir.getSymbolTable().isParameter(vn)) {
                        ParamCallee a = new ParamCallee(this.node, vn);
                        this.delegate.addEdge((Object)a, (Object)pac);
                        break;
                    }
                    SSAInstruction d = DU.getDef(vn);
                    if (this.dOptions.isTerminateAtCast() && d instanceof SSACheckCastInstruction || d == null) continue block10;
                    if (d instanceof SSAAbstractInvokeInstruction) {
                        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)d;
                        if (vn == call.getException()) {
                            if (this.dOptions.isIgnoreExceptions()) continue block10;
                            st = new ExceptionalReturnCaller(this.node, instructionIndices.get(d));
                            this.delegate.addEdge(st, (Object)pac);
                            break;
                        }
                        st = new NormalReturnCaller(this.node, instructionIndices.get(d));
                        this.delegate.addEdge(st, (Object)pac);
                        break;
                    }
                    Statement ds = this.ssaInstruction2Statement(d, ir, instructionIndices);
                    this.delegate.addEdge((Object)ds, (Object)pac);
                    break;
                }
                case HEAP_PARAM_CALLER: 
                case HEAP_PARAM_CALLEE: 
                case HEAP_RET_CALLER: 
                case HEAP_RET_CALLEE: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE((String)s.toString());
                }
            }
        }
    }

    private void createHeapDataDependenceEdges(final PointerKey pk) {
        if (this.locationsHandled.contains(pk)) {
            return;
        }
        this.locationsHandled.add(pk);
        if (this.dOptions.isIgnoreHeap() || this.exclusions != null && this.exclusions.excludes(pk)) {
            return;
        }
        TypeReference t = HeapExclusions.getType(pk);
        if (t == null) {
            return;
        }
        IR ir = this.node.getIR();
        if (ir == null) {
            return;
        }
        Predicate f = new Predicate(){

            public boolean test(Object o) {
                if (o instanceof HeapStatement) {
                    HeapStatement h = (HeapStatement)o;
                    return h.getLocation().equals(pk);
                }
                return true;
            }
        };
        Iterator2Set relevantStatements = Iterator2Collection.toSet((Iterator)new FilterIterator(this.iterator(), f));
        Map<Statement, OrdinalSet<Statement>> heapReachingDefs = new HeapReachingDefs<T>(this.modRef, this.heapModel).computeReachingDefs(this.node, ir, this.pa, this.mod, (Collection<Statement>)relevantStatements, new HeapExclusions(SetComplement.complement(new SingletonSet(t))), this.cg);
        block6: for (Statement st : heapReachingDefs.keySet()) {
            switch (st.getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case CATCH: {
                    OrdinalSet<Statement> defs = heapReachingDefs.get(st);
                    if (defs == null) continue block6;
                    for (Statement def : defs) {
                        this.delegate.addEdge((Object)def, (Object)st);
                    }
                    continue block6;
                }
                case PARAM_CALLER: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLER: 
                case EXC_RET_CALLEE: {
                    break;
                }
                case HEAP_PARAM_CALLER: 
                case HEAP_RET_CALLER: 
                case HEAP_RET_CALLEE: {
                    OrdinalSet<Statement> defs = heapReachingDefs.get(st);
                    if (defs == null) continue block6;
                    for (Statement def : defs) {
                        this.delegate.addEdge((Object)def, (Object)st);
                    }
                    continue block6;
                }
                case HEAP_PARAM_CALLEE: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE((String)st.toString());
                }
            }
        }
    }

    private boolean hasBasePointer(SSAInstruction use) {
        if (use instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction f = (SSAFieldAccessInstruction)use;
            return !f.isStatic();
        }
        if (use instanceof SSAArrayReferenceInstruction) {
            return true;
        }
        return use instanceof SSAArrayLengthInstruction;
    }

    private int getBasePointer(SSAInstruction use) {
        if (use instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction f = (SSAFieldAccessInstruction)use;
            return f.getRef();
        }
        if (use instanceof SSAArrayReferenceInstruction) {
            SSAArrayReferenceInstruction a = (SSAArrayReferenceInstruction)use;
            return a.getArrayRef();
        }
        if (use instanceof SSAArrayLengthInstruction) {
            SSAArrayLengthInstruction s = (SSAArrayLengthInstruction)use;
            return s.getArrayRef();
        }
        Assertions.UNREACHABLE((String)"BOOM");
        return -1;
    }

    private Collection<NormalStatement> computeReturnStatements(final IR ir) {
        Predicate filter = new Predicate(){

            public boolean test(Object o) {
                if (o instanceof NormalStatement) {
                    NormalStatement s = (NormalStatement)o;
                    SSAInstruction st = ir.getInstructions()[s.getInstructionIndex()];
                    return st instanceof SSAReturnInstruction;
                }
                return false;
            }
        };
        return Iterator2Collection.toSet((Iterator)new FilterIterator(this.iterator(), filter));
    }

    private IntSet getPEIs(IR ir) {
        BitVectorIntSet result = new BitVectorIntSet();
        int i = 0;
        while (i < ir.getInstructions().length) {
            if (ir.getInstructions()[i] != null && ir.getInstructions()[i].isPEI()) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    private Statement ssaInstruction2Statement(SSAInstruction s, IR ir, Map<SSAInstruction, Integer> instructionIndices) {
        return PDG.ssaInstruction2Statement(this.node, s, instructionIndices, ir);
    }

    public static synchronized Statement ssaInstruction2Statement(CGNode node, SSAInstruction s, Map<SSAInstruction, Integer> instructionIndices, IR ir) {
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        if (s == null) {
            throw new IllegalArgumentException("null s");
        }
        if (s instanceof SSAPhiInstruction) {
            SSAPhiInstruction phi = (SSAPhiInstruction)s;
            return new PhiStatement(node, phi);
        }
        if (s instanceof SSAPiInstruction) {
            SSAPiInstruction pi = (SSAPiInstruction)s;
            return new PiStatement(node, pi);
        }
        if (s instanceof SSAGetCaughtExceptionInstruction) {
            return new GetCaughtExceptionStatement(node, (SSAGetCaughtExceptionInstruction)s);
        }
        Integer x = instructionIndices.get(s);
        if (x == null) {
            Assertions.UNREACHABLE((String)(String.valueOf(s.toString()) + "\nnot found in map of\n" + ir));
        }
        return new NormalStatement(node, x);
    }

    public static Map<SSAInstruction, Integer> computeInstructionIndices(IR ir) {
        HashMap result = HashMapFactory.make();
        if (ir != null) {
            SSAInstruction[] instructions = ir.getInstructions();
            int i = 0;
            while (i < instructions.length) {
                SSAInstruction s = instructions[i];
                if (s != null) {
                    result.put(s, new Integer(i));
                }
                ++i;
            }
        }
        return result;
    }

    private SSAInstruction statement2SSAInstruction(SSAInstruction[] instructions, Statement s) {
        SSAInstruction statement = null;
        switch (s.getKind()) {
            case NORMAL: {
                NormalStatement n = (NormalStatement)s;
                statement = instructions[n.getInstructionIndex()];
                break;
            }
            case PHI: {
                PhiStatement p = (PhiStatement)s;
                statement = p.getPhi();
                break;
            }
            case PI: {
                PiStatement ps = (PiStatement)s;
                statement = ps.getPi();
                break;
            }
            case CATCH: {
                GetCaughtExceptionStatement g = (GetCaughtExceptionStatement)s;
                statement = g.getInstruction();
                break;
            }
            default: {
                Assertions.UNREACHABLE((String)s.toString());
            }
        }
        return statement;
    }

    private void createNodes(Map<CGNode, OrdinalSet<PointerKey>> ref, Slicer.ControlDependenceOptions cOptions, IR ir) {
        if (ir != null) {
            this.createNormalStatements(ir, ref);
            this.createSpecialStatements(ir);
        }
        this.createCalleeParams();
        this.createReturnStatements();
        this.delegate.addNode((Object)new MethodEntryStatement(this.node));
        this.delegate.addNode((Object)new MethodExitStatement(this.node));
    }

    private void createReturnStatements() {
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (!this.node.getMethod().getReturnType().equals(TypeReference.Void)) {
            NormalReturnCallee n = new NormalReturnCallee(this.node);
            this.delegate.addNode((Object)n);
            list.add(n);
        }
        if (!this.dOptions.isIgnoreExceptions()) {
            ExceptionalReturnCallee e = new ExceptionalReturnCallee(this.node);
            this.delegate.addNode((Object)e);
            list.add(e);
        }
        if (!this.dOptions.isIgnoreHeap()) {
            for (PointerKey p : this.mod.get(this.node)) {
                HeapStatement.HeapReturnCallee h = new HeapStatement.HeapReturnCallee(this.node, p);
                this.delegate.addNode((Object)h);
                list.add(h);
            }
        }
        this.returnStatements = new Statement[list.size()];
        list.toArray(this.returnStatements);
    }

    private void createCalleeParams() {
        if (this.paramCalleeStatements == null) {
            ArrayList<Statement> list = new ArrayList<Statement>();
            int paramCount = this.node.getMethod().getNumberOfParameters();
            Iterator callers = this.cg.getPredNodes(this.node);
            while (callers.hasNext()) {
                CGNode caller = (CGNode)callers.next();
                IR callerIR = caller.getIR();
                Iterator<CallSiteReference> sites = this.cg.getPossibleSites(caller, this.node);
                while (sites.hasNext()) {
                    SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = callerIR.getCalls(sites.next());
                    int n = sSAAbstractInvokeInstructionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SSAAbstractInvokeInstruction inst = sSAAbstractInvokeInstructionArray[n2];
                        paramCount = Math.max(paramCount, inst.getNumberOfParameters() - 1);
                        ++n2;
                    }
                }
            }
            int i = 1;
            while (i <= paramCount) {
                ParamCallee s = new ParamCallee(this.node, i);
                this.delegate.addNode((Object)s);
                list.add(s);
                ++i;
            }
            if (!this.dOptions.isIgnoreHeap()) {
                for (PointerKey p : this.ref.get(this.node)) {
                    HeapStatement.HeapParamCallee h = new HeapStatement.HeapParamCallee(this.node, p);
                    this.delegate.addNode((Object)h);
                    list.add(h);
                }
            }
            this.paramCalleeStatements = new Statement[list.size()];
            list.toArray(this.paramCalleeStatements);
        }
    }

    private void createSpecialStatements(IR ir) {
        Iterator<SSAInstruction> it = ir.iterateAllInstructions();
        while (it.hasNext()) {
            SSAInstruction s = it.next();
            if (s instanceof SSAPhiInstruction) {
                this.delegate.addNode((Object)new PhiStatement(this.node, (SSAPhiInstruction)s));
                continue;
            }
            if (s instanceof SSAGetCaughtExceptionInstruction) {
                this.delegate.addNode((Object)new GetCaughtExceptionStatement(this.node, (SSAGetCaughtExceptionInstruction)s));
                continue;
            }
            if (!(s instanceof SSAPiInstruction)) continue;
            this.delegate.addNode((Object)new PiStatement(this.node, (SSAPiInstruction)s));
        }
    }

    private void createNormalStatements(IR ir, Map<CGNode, OrdinalSet<PointerKey>> ref) {
        SSAInstruction[] instructions = ir.getInstructions();
        int i = 0;
        while (i < instructions.length) {
            SSAInstruction s = instructions[i];
            if (!(s instanceof SSAGetCaughtExceptionInstruction) && s != null) {
                NormalStatement statement = new NormalStatement(this.node, i);
                this.delegate.addNode((Object)statement);
                if (s instanceof SSAAbstractInvokeInstruction) {
                    this.callSite2Statement.put(((SSAAbstractInvokeInstruction)s).getCallSite(), statement);
                    this.addParamPassingStatements(i, ref, ir);
                }
            }
            ++i;
        }
    }

    private void addParamPassingStatements(int callIndex, Map<CGNode, OrdinalSet<PointerKey>> ref, IR ir) {
        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ir.getInstructions()[callIndex];
        Set params = MapUtil.findOrCreateSet(this.callerParamStatements, (Object)call.getCallSite());
        Set rets = MapUtil.findOrCreateSet(this.callerReturnStatements, (Object)call.getCallSite());
        int j = 0;
        while (j < call.getNumberOfUses()) {
            ParamCaller st = new ParamCaller(this.node, callIndex, call.getUse(j));
            this.delegate.addNode((Object)st);
            params.add(st);
            ++j;
        }
        if (!call.getDeclaredResultType().equals(TypeReference.Void)) {
            NormalReturnCaller st = new NormalReturnCaller(this.node, callIndex);
            this.delegate.addNode((Object)st);
            rets.add(st);
        }
        if (!this.dOptions.isIgnoreExceptions()) {
            ExceptionalReturnCaller st = new ExceptionalReturnCaller(this.node, callIndex);
            this.delegate.addNode((Object)st);
            rets.add(st);
        }
        if (!this.dOptions.isIgnoreHeap()) {
            OrdinalSet<PointerKey> uref = this.unionHeapLocations(this.cg, this.node, call, ref);
            for (PointerKey p : uref) {
                HeapStatement.HeapParamCaller st = new HeapStatement.HeapParamCaller(this.node, callIndex, p);
                this.delegate.addNode((Object)st);
                params.add(st);
            }
            OrdinalSet<PointerKey> umod = this.unionHeapLocations(this.cg, this.node, call, this.mod);
            for (PointerKey p : umod) {
                HeapStatement.HeapReturnCaller st = new HeapStatement.HeapReturnCaller(this.node, callIndex, p);
                this.delegate.addNode((Object)st);
                rets.add(st);
            }
        }
    }

    private OrdinalSet<PointerKey> unionHeapLocations(CallGraph cg, CGNode n, SSAAbstractInvokeInstruction call, Map<CGNode, OrdinalSet<PointerKey>> loc) {
        BitVectorIntSet bv = new BitVectorIntSet();
        for (CGNode t : cg.getPossibleTargets(n, call.getCallSite())) {
            bv.addAll(loc.get(t).getBackingSet());
        }
        return new OrdinalSet((IntSet)bv, loc.get(n).getMapping());
    }

    public String toString() {
        this.populate();
        StringBuffer result = new StringBuffer("PDG for " + this.node + ":\n");
        result.append(super.toString());
        return result.toString();
    }

    public Statement[] getParamCalleeStatements() {
        if (this.paramCalleeStatements == null) {
            this.createCalleeParams();
        }
        Statement[] result = new Statement[this.paramCalleeStatements.length];
        System.arraycopy(this.paramCalleeStatements, 0, result, 0, result.length);
        return result;
    }

    public Statement[] getReturnStatements() {
        this.populate();
        Statement[] result = new Statement[this.returnStatements.length];
        System.arraycopy(this.returnStatements, 0, result, 0, result.length);
        return result;
    }

    public CGNode getCallGraphNode() {
        return this.node;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            return this.node.equals(((PDG)obj).node);
        }
        return false;
    }

    public int hashCode() {
        return 103 * this.node.hashCode();
    }

    public int getPredNodeCount(Statement N) throws UnimplementedError {
        this.populate();
        Assertions.UNREACHABLE();
        return this.delegate.getPredNodeCount((Object)N);
    }

    public Iterator<Statement> getPredNodes(Statement N) {
        this.populate();
        if (!this.dOptions.isIgnoreHeap()) {
            this.computeIncomingHeapDependencies(N);
        }
        return this.delegate.getPredNodes((Object)N);
    }

    private void computeIncomingHeapDependencies(Statement N) {
        switch (N.getKind()) {
            case NORMAL: {
                NormalStatement st = (NormalStatement)N;
                if (this.ignoreAllocHeapDefs && st.getInstruction() instanceof SSANewInstruction) break;
                Set<PointerKey> ref = this.modRef.getRef(this.node, this.heapModel, this.pa, st.getInstruction(), this.exclusions);
                for (PointerKey pk : ref) {
                    this.createHeapDataDependenceEdges(pk);
                }
                break;
            }
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: {
                HeapStatement h = (HeapStatement)N;
                this.createHeapDataDependenceEdges(h.getLocation());
            }
        }
    }

    private void computeOutgoingHeapDependencies(Statement N) {
        switch (N.getKind()) {
            case NORMAL: {
                NormalStatement st = (NormalStatement)N;
                if (this.ignoreAllocHeapDefs && st.getInstruction() instanceof SSANewInstruction) break;
                Set<PointerKey> mod = this.modRef.getMod(this.node, this.heapModel, this.pa, st.getInstruction(), this.exclusions);
                for (PointerKey pk : mod) {
                    this.createHeapDataDependenceEdges(pk);
                }
                break;
            }
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: {
                HeapStatement h = (HeapStatement)N;
                this.createHeapDataDependenceEdges(h.getLocation());
            }
        }
    }

    public int getSuccNodeCount(Statement N) throws UnimplementedError {
        this.populate();
        Assertions.UNREACHABLE();
        return this.delegate.getSuccNodeCount((Object)N);
    }

    public Iterator<Statement> getSuccNodes(Statement N) {
        this.populate();
        if (!this.dOptions.isIgnoreHeap()) {
            this.computeOutgoingHeapDependencies(N);
        }
        return this.delegate.getSuccNodes((Object)N);
    }

    public boolean hasEdge(Statement src, Statement dst) throws UnimplementedError {
        this.populate();
        return this.delegate.hasEdge((Object)src, (Object)dst);
    }

    public void removeNodeAndEdges(Statement N) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void addNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    public boolean containsNode(Statement N) {
        this.populate();
        return this.delegate.containsNode((Object)N);
    }

    public int getNumberOfNodes() {
        this.populate();
        return this.delegate.getNumberOfNodes();
    }

    public Iterator<Statement> iterator() {
        this.populate();
        return this.delegate.iterator();
    }

    public void removeNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    public void addEdge(Statement src, Statement dst) {
        Assertions.UNREACHABLE();
    }

    public void removeAllIncidentEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeEdge(Statement src, Statement dst) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeIncomingEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeOutgoingEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public int getMaxNumber() {
        this.populate();
        return this.delegate.getMaxNumber();
    }

    public Statement getNode(int number) {
        this.populate();
        return (Statement)this.delegate.getNode(number);
    }

    public int getNumber(Statement N) {
        this.populate();
        return this.delegate.getNumber((Object)N);
    }

    public Iterator<Statement> iterateNodes(IntSet s) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getPredNodeNumbers(Statement node) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getSuccNodeNumbers(Statement node) {
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean isControlDependend(Statement from, Statement to) {
        return this.delegate.hasEdge((Object)from, (Object)to, (Object)Dependency.CONTROL_DEP);
    }

    public static enum Dependency {
        CONTROL_DEP,
        DATA_AND_CONTROL_DEP;

    }

    private static class SetComplement
    extends SetOfClasses
    implements Serializable {
        private static final long serialVersionUID = -3256390509887654323L;
        private final SetOfClasses set;

        SetComplement(SetOfClasses set) {
            this.set = set;
        }

        static SetComplement complement(SetOfClasses set) {
            return new SetComplement(set);
        }

        public void add(String klass) {
            Assertions.UNREACHABLE();
        }

        public boolean contains(String klassName) {
            return !this.set.contains(klassName);
        }
    }

    private static class SingletonSet
    extends SetOfClasses
    implements Serializable {
        private static final long serialVersionUID = -3256390509887654324L;
        private final TypeReference t;

        SingletonSet(TypeReference t) {
            this.t = t;
        }

        public void add(String klass) {
            Assertions.UNREACHABLE();
        }

        public boolean contains(String klassName) {
            return this.t.getName().toString().substring(1).equals(klassName);
        }
    }
}

