/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.modref;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphTransitiveClosure;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ModRef<T extends InstanceKey> {
    public static <T extends InstanceKey> ModRef<T> make() {
        return new ModRef<T>();
    }

    protected ModRef() {
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeMod(CallGraph cg, PointerAnalysis<T> pa, HeapExclusions heapExclude) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Map scan = this.scanForMod(cg, pa, heapExclude);
        return CallGraphTransitiveClosure.transitiveClosure(cg, scan);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeRef(CallGraph cg, PointerAnalysis<T> pa, HeapExclusions heapExclude) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Map scan = this.scanForRef(cg, pa, heapExclude);
        return CallGraphTransitiveClosure.transitiveClosure(cg, scan);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeMod(CallGraph cg, PointerAnalysis<T> pa) {
        return this.computeMod(cg, pa, null);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeRef(CallGraph cg, PointerAnalysis<T> pa) {
        return this.computeRef(cg, pa, null);
    }

    private Map<CGNode, Collection<PointerKey>> scanForMod(CallGraph cg, final PointerAnalysis<T> pa, final HeapExclusions heapExclude) {
        return CallGraphTransitiveClosure.collectNodeResults(cg, new Function<CGNode, Collection<PointerKey>>(){

            public Collection<PointerKey> apply(CGNode n) {
                return ModRef.this.scanNodeForMod(n, pa, heapExclude);
            }
        });
    }

    private Map<CGNode, Collection<PointerKey>> scanForRef(CallGraph cg, final PointerAnalysis<T> pa, final HeapExclusions heapExclude) {
        return CallGraphTransitiveClosure.collectNodeResults(cg, new Function<CGNode, Collection<PointerKey>>(){

            public Collection<PointerKey> apply(CGNode n) {
                return ModRef.this.scanNodeForRef(n, pa, heapExclude);
            }
        });
    }

    public ExtendedHeapModel makeHeapModel(PointerAnalysis<T> pa) {
        return new DelegatingExtendedHeapModel(pa.getHeapModel());
    }

    private Collection<PointerKey> scanNodeForMod(CGNode n, PointerAnalysis<T> pa, HeapExclusions heapExclude) {
        Set<Object> result = HashSetFactory.make();
        ExtendedHeapModel h = this.makeHeapModel(pa);
        ModVisitor v = this.makeModVisitor(n, (Collection<PointerKey>)result, pa, h);
        IR ir = n.getIR();
        if (ir != null) {
            Iterator<SSAInstruction> it = ir.iterateNormalInstructions();
            while (it.hasNext()) {
                it.next().visit(v);
                assert (!result.contains(null));
            }
        }
        if (heapExclude != null) {
            result = heapExclude.filter((Collection<PointerKey>)result);
        }
        return result;
    }

    private Collection<PointerKey> scanNodeForRef(CGNode n, PointerAnalysis<T> pa, HeapExclusions heapExclude) {
        Set<Object> result = HashSetFactory.make();
        ExtendedHeapModel h = this.makeHeapModel(pa);
        RefVisitor<T, ExtendedHeapModel> v = this.makeRefVisitor(n, (Collection<PointerKey>)result, pa, h);
        IR ir = n.getIR();
        if (ir != null) {
            Iterator<SSAInstruction> it = ir.iterateNormalInstructions();
            while (it.hasNext()) {
                SSAInstruction x = it.next();
                x.visit(v);
                assert (!result.contains(null)) : x;
            }
        }
        if (heapExclude != null) {
            result = heapExclude.filter((Collection<PointerKey>)result);
        }
        return result;
    }

    protected ModVisitor makeModVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis<T> pa, ExtendedHeapModel h) {
        return this.makeModVisitor(n, result, pa, h, false);
    }

    protected ModVisitor<T, ? extends ExtendedHeapModel> makeModVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis<T> pa, ExtendedHeapModel h, boolean ignoreAllocHeapDefs) {
        return new ModVisitor<T, ExtendedHeapModel>(n, result, h, pa, ignoreAllocHeapDefs);
    }

    public Set<PointerKey> getMod(CGNode n, ExtendedHeapModel h, PointerAnalysis<T> pa, SSAInstruction s, HeapExclusions hexcl) {
        return this.getMod(n, h, pa, s, hexcl, false);
    }

    public Set<PointerKey> getMod(CGNode n, ExtendedHeapModel h, PointerAnalysis<T> pa, SSAInstruction s, HeapExclusions hexcl, boolean ignoreAllocHeapDefs) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet result = HashSetFactory.make((int)2);
        ModVisitor<T, ExtendedHeapModel> v = this.makeModVisitor(n, result, pa, h, ignoreAllocHeapDefs);
        s.visit(v);
        return hexcl == null ? result : hexcl.filter(result);
    }

    protected RefVisitor<T, ExtendedHeapModel> makeRefVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis<T> pa, ExtendedHeapModel h) {
        return new RefVisitor<T, ExtendedHeapModel>(n, result, pa, h);
    }

    public Set<PointerKey> getRef(CGNode n, ExtendedHeapModel h, PointerAnalysis<T> pa, SSAInstruction s, HeapExclusions hexcl) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet result = HashSetFactory.make((int)2);
        RefVisitor<T, ExtendedHeapModel> v = this.makeRefVisitor(n, result, pa, h);
        s.visit(v);
        return hexcl == null ? result : hexcl.filter(result);
    }

    protected static class ModVisitor<T extends InstanceKey, H extends ExtendedHeapModel>
    extends SSAInstruction.Visitor {
        protected final CGNode n;
        protected final Collection<PointerKey> result;
        protected final H h;
        protected final PointerAnalysis<T> pa;
        private final boolean ignoreAllocHeapDefs;

        protected ModVisitor(CGNode n, Collection<PointerKey> result, H h, PointerAnalysis<T> pa, boolean ignoreAllocHeapDefs) {
            this.n = n;
            this.result = result;
            this.h = h;
            this.pa = pa;
            this.ignoreAllocHeapDefs = ignoreAllocHeapDefs;
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            block15: {
                InstanceKey i;
                block13: {
                    PointerKey pk;
                    block14: {
                        if (!instruction.getConcreteType().isArrayType()) break block13;
                        int dim = instruction.getConcreteType().getDimensionality();
                        if (dim <= 1) break block14;
                        InstanceKey ik = this.h.getInstanceKeyForAllocation(this.n, instruction.getNewSite());
                        if (ik != null) {
                            PointerKey pk2 = this.h.getPointerKeyForArrayContents(ik);
                            assert (pk2 != null);
                            this.result.add(pk2);
                            pk2 = this.h.getPointerKeyForArrayLength(ik);
                            assert (pk2 != null);
                            this.result.add(pk2);
                        }
                        int d = 0;
                        while (d < dim - 1) {
                            InstanceKey i2 = this.h.getInstanceKeyForMultiNewArray(this.n, instruction.getNewSite(), d);
                            if (i2 != null) {
                                PointerKey pk3 = this.h.getPointerKeyForArrayContents(i2);
                                assert (pk3 != null);
                                this.result.add(pk3);
                                pk3 = this.h.getPointerKeyForArrayLength(i2);
                                assert (pk3 != null);
                                this.result.add(pk3);
                            }
                            ++d;
                        }
                        break block15;
                    }
                    InstanceKey i3 = this.h.getInstanceKeyForAllocation(this.n, instruction.getNewSite());
                    if (i3 == null) break block15;
                    if (!this.ignoreAllocHeapDefs) {
                        pk = this.h.getPointerKeyForArrayContents(i3);
                        assert (pk != null);
                        this.result.add(pk);
                    }
                    pk = this.h.getPointerKeyForArrayLength(i3);
                    assert (pk != null);
                    this.result.add(pk);
                    break block15;
                }
                if (!this.ignoreAllocHeapDefs && (i = this.h.getInstanceKeyForAllocation(this.n, instruction.getNewSite())) != null) {
                    IClass type = i.getConcreteType();
                    for (IField f : type.getAllInstanceFields()) {
                        PointerKey pk = this.h.getPointerKeyForInstanceField(i, f);
                        assert (pk != null);
                        this.result.add(pk);
                    }
                }
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayContents(i));
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            IField f = this.pa.getClassHierarchy().resolveField(instruction.getDeclaredField());
            if (f != null) {
                if (instruction.isStatic()) {
                    this.result.add(this.h.getPointerKeyForStaticField(f));
                } else {
                    PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getRef());
                    if (ref != null) {
                        for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                            this.result.add(this.h.getPointerKeyForInstanceField(i, f));
                        }
                    }
                }
            }
        }
    }

    protected static class RefVisitor<T extends InstanceKey, H extends ExtendedHeapModel>
    extends SSAInstruction.Visitor {
        protected final CGNode n;
        protected final Collection<PointerKey> result;
        protected final PointerAnalysis<T> pa;
        protected final H h;

        protected RefVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis<T> pa2, H h) {
            this.n = n;
            this.result = result;
            this.pa = pa2;
            this.h = h;
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayLength(i));
            }
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getArrayRef());
            for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                this.result.add(this.h.getPointerKeyForArrayContents(i));
            }
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            IField f = this.pa.getClassHierarchy().resolveField(instruction.getDeclaredField());
            if (f != null) {
                if (instruction.isStatic()) {
                    this.result.add(this.h.getPointerKeyForStaticField(f));
                } else {
                    PointerKey ref = this.h.getPointerKeyForLocal(this.n, instruction.getRef());
                    for (InstanceKey i : this.pa.getPointsToSet(ref)) {
                        PointerKey x = this.h.getPointerKeyForInstanceField(i, f);
                        if (x == null) continue;
                        this.result.add(x);
                    }
                }
            }
        }
    }
}

