/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg.exceptionpruning;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.ipa.cfg.EdgeFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.ExceptionFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.ExceptionMatcher;
import com.ibm.wala.ipa.cfg.exceptionpruning.FilteredException;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;

public class ExceptionFilter2EdgeFilter<Block extends ISSABasicBlock>
implements EdgeFilter<Block> {
    private final ExceptionFilter<SSAInstruction> filter;
    private final ClassHierarchy cha;
    private final ControlFlowGraph<SSAInstruction, Block> cfg;

    public ExceptionFilter2EdgeFilter(ExceptionFilter<SSAInstruction> filter, ClassHierarchy cha, ControlFlowGraph<SSAInstruction, Block> cfg) {
        this.cfg = cfg;
        this.filter = filter;
        this.cha = cha;
    }

    @Override
    public boolean hasExceptionalEdge(Block src, Block dst) {
        boolean hasExceptionalEdge = this.cfg.getExceptionalSuccessors(src).contains(dst);
        SSAInstruction relevantInstruction = src.getLastInstruction();
        if (hasExceptionalEdge && relevantInstruction != null && this.weKnowAllExceptions(relevantInstruction)) {
            Collection<FilteredException> filteredExceptions;
            Collection<TypeReference> thrownExceptions = relevantInstruction.getExceptionTypes();
            boolean isFiltered = ExceptionMatcher.isFiltered(thrownExceptions, filteredExceptions = this.filter.filteredExceptions(relevantInstruction), this.cha);
            hasExceptionalEdge = !isFiltered;
        }
        return hasExceptionalEdge;
    }

    @Override
    public boolean hasNormalEdge(Block src, Block dst) {
        SSAInstruction relevantInstruction;
        boolean result = true;
        if (src.getLastInstructionIndex() >= 0 && (relevantInstruction = src.getLastInstruction()) != null && this.filter.alwaysThrowsException(relevantInstruction)) {
            result = false;
        }
        return result && this.cfg.getNormalSuccessors(src).contains(dst);
    }

    private boolean weKnowAllExceptions(SSAInstruction instruction) {
        return !(instruction instanceof SSAAbstractInvokeInstruction) && !(instruction instanceof SSAAbstractThrowInstruction);
    }
}

