/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.fixedpoint.impl.GeneralStatement;
import com.ibm.wala.fixpoint.AbstractOperator;
import com.ibm.wala.fixpoint.AbstractStatement;
import com.ibm.wala.fixpoint.IFixedPointStatement;
import com.ibm.wala.fixpoint.IFixedPointSystem;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.fixpoint.UnaryStatement;
import com.ibm.wala.ipa.callgraph.propagation.AssignEquation;
import com.ibm.wala.ipa.callgraph.propagation.AssignOperator;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.SmallMap;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import com.ibm.wala.util.graph.traverse.Topological;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class PropagationGraph
implements IFixedPointSystem<PointsToSetVariable> {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private final NumberedNodeManager<INodeWithNumber> nodeManager = new DelegatingNumberedNodeManager();
    private final NumberedEdgeManager<INodeWithNumber> edgeManager = new SparseNumberedEdgeManager(this.nodeManager, 2, 0);
    private final DelegateGraph delegateGraph = new DelegateGraph();
    private final HashSet<AbstractStatement> delegateStatements = HashSetFactory.make();
    private final SmallMap<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation> implicitUnaryMap = new SmallMap();
    private final SmallMap<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation> invImplicitUnaryMap = new SmallMap();
    private int implicitUnaryCount = 0;

    private IBinaryNaturalRelation findOrCreateRelation(Map<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation> m, UnaryOperator<PointsToSetVariable> key) {
        IBinaryNaturalRelation result = m.get(key);
        if (result == null) {
            result = this.makeRelation((AbstractOperator)key);
            m.put(key, result);
        }
        return result;
    }

    private IBinaryNaturalRelation makeRelation(AbstractOperator op) {
        byte[] implementation = null;
        implementation = op instanceof AssignOperator ? new byte[]{2, 2} : new byte[]{2};
        return new BasicNaturalRelation(implementation, 0);
    }

    public void addStatement(GeneralStatement<PointsToSetVariable> eq) {
        if (eq == null) {
            throw new IllegalArgumentException("eq is null");
        }
        PointsToSetVariable lhs = (PointsToSetVariable)eq.getLHS();
        this.delegateGraph.addEquation((AbstractStatement<PointsToSetVariable, ?>)eq);
        this.delegateStatements.add((AbstractStatement)eq);
        if (lhs != null) {
            this.delegateGraph.addVariable(lhs);
            this.delegateGraph.addEdge(eq, (Object)lhs);
        }
        int i = 0;
        while (i < ((PointsToSetVariable[])eq.getRHS()).length) {
            PointsToSetVariable v = ((PointsToSetVariable[])eq.getRHS())[i];
            if (v != null) {
                this.delegateGraph.addVariable(v);
                this.delegateGraph.addEdge((Object)v, eq);
            }
            ++i;
        }
    }

    public void addStatement(UnaryStatement<PointsToSetVariable> eq) throws IllegalArgumentException {
        if (eq == null) {
            throw new IllegalArgumentException("eq == null");
        }
        if (this.useImplicitRepresentation((IFixedPointStatement)eq)) {
            this.addImplicitStatement(eq);
        } else {
            PointsToSetVariable lhs = (PointsToSetVariable)eq.getLHS();
            PointsToSetVariable rhs = (PointsToSetVariable)eq.getRightHandSide();
            this.delegateGraph.addEquation((AbstractStatement<PointsToSetVariable, ?>)eq);
            this.delegateStatements.add((AbstractStatement)eq);
            if (lhs != null) {
                this.delegateGraph.addVariable(lhs);
                this.delegateGraph.addEdge(eq, (Object)lhs);
            }
            this.delegateGraph.addVariable(rhs);
            this.delegateGraph.addEdge((Object)rhs, eq);
        }
    }

    private boolean useImplicitRepresentation(IFixedPointStatement s) {
        AbstractStatement eq = (AbstractStatement)s;
        AbstractOperator op = eq.getOperator();
        return op instanceof AssignOperator || op instanceof PropagationCallGraphBuilder.FilterOperator;
    }

    public void removeVariable(PointsToSetVariable p) {
        assert (this.getNumberOfStatementsThatDef(p) == 0);
        assert (this.getNumberOfStatementsThatUse(p) == 0);
        this.delegateGraph.removeNode((Object)p);
    }

    private void addImplicitStatement(UnaryStatement<PointsToSetVariable> eq) {
        this.delegateGraph.addVariable((PointsToSetVariable)eq.getLHS());
        this.delegateGraph.addVariable((PointsToSetVariable)eq.getRightHandSide());
        int lhs = ((PointsToSetVariable)eq.getLHS()).getGraphNodeId();
        int rhs = ((PointsToSetVariable)eq.getRightHandSide()).getGraphNodeId();
        IBinaryNaturalRelation R = this.findOrCreateRelation((Map<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation>)this.implicitUnaryMap, (UnaryOperator<PointsToSetVariable>)((UnaryOperator)eq.getOperator()));
        boolean b = R.add(lhs, rhs);
        if (b) {
            ++this.implicitUnaryCount;
            IBinaryNaturalRelation iR = this.findOrCreateRelation((Map<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation>)this.invImplicitUnaryMap, (UnaryOperator<PointsToSetVariable>)((UnaryOperator)eq.getOperator()));
            iR.add(rhs, lhs);
        }
    }

    private void removeImplicitStatement(UnaryStatement<PointsToSetVariable> eq) {
        int lhs = ((PointsToSetVariable)eq.getLHS()).getGraphNodeId();
        int rhs = ((PointsToSetVariable)eq.getRightHandSide()).getGraphNodeId();
        IBinaryNaturalRelation R = this.findOrCreateRelation((Map<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation>)this.implicitUnaryMap, (UnaryOperator<PointsToSetVariable>)((UnaryOperator)eq.getOperator()));
        R.remove(lhs, rhs);
        IBinaryNaturalRelation iR = this.findOrCreateRelation((Map<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation>)this.invImplicitUnaryMap, (UnaryOperator<PointsToSetVariable>)((UnaryOperator)eq.getOperator()));
        iR.remove(rhs, lhs);
        --this.implicitUnaryCount;
    }

    public Iterator<AbstractStatement> getStatements() {
        FilterIterator it = new FilterIterator(this.delegateGraph.iterator(), new Predicate(){

            public boolean test(Object x) {
                return x instanceof AbstractStatement;
            }
        });
        return new CompoundIterator((Iterator)it, (Iterator)new GlobalImplicitIterator());
    }

    public void removeStatement(IFixedPointStatement<PointsToSetVariable> eq) throws IllegalArgumentException {
        if (eq == null) {
            throw new IllegalArgumentException("eq == null");
        }
        if (this.useImplicitRepresentation(eq)) {
            this.removeImplicitStatement((UnaryStatement<PointsToSetVariable>)((UnaryStatement)eq));
        } else {
            this.delegateStatements.remove(eq);
            this.delegateGraph.removeNodeAndEdges(eq);
        }
    }

    public void reorder() {
        VariableGraphView graph = new VariableGraphView();
        Iterator order = Topological.makeTopologicalIter((Graph)graph).iterator();
        int number = 0;
        while (order.hasNext()) {
            Object elt = order.next();
            if (!(elt instanceof IVariable)) continue;
            IVariable v = (IVariable)elt;
            v.setOrderNumber(number++);
        }
    }

    public Iterator<AbstractStatement> getStatementsThatUse(PointsToSetVariable v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        int number = v.getGraphNodeId();
        if (number == -1) {
            return EmptyIterator.instance();
        }
        Iterator result = this.delegateGraph.getSuccNodes((Object)v);
        int i = 0;
        while (i < this.invImplicitUnaryMap.size()) {
            UnaryOperator op = (UnaryOperator)this.invImplicitUnaryMap.getKey(i);
            IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.invImplicitUnaryMap.getValue(i);
            IntSet s = R.getRelated(number);
            if (s != null) {
                result = new CompoundIterator((Iterator)new ImplicitUseIterator((UnaryOperator<PointsToSetVariable>)op, v, s), result);
            }
            ++i;
        }
        ArrayList<AbstractStatement> list = new ArrayList<AbstractStatement>();
        while (result.hasNext()) {
            list.add((AbstractStatement)result.next());
        }
        return list.iterator();
    }

    public Iterator<AbstractStatement> getStatementsThatDef(PointsToSetVariable v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        int number = v.getGraphNodeId();
        if (number == -1) {
            return EmptyIterator.instance();
        }
        Iterator result = this.delegateGraph.getPredNodes((Object)v);
        int i = 0;
        while (i < this.implicitUnaryMap.size()) {
            UnaryOperator op = (UnaryOperator)this.implicitUnaryMap.getKey(i);
            IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.implicitUnaryMap.getValue(i);
            IntSet s = R.getRelated(number);
            if (s != null) {
                result = new CompoundIterator((Iterator)new ImplicitDefIterator((UnaryOperator<PointsToSetVariable>)op, s, v), result);
            }
            ++i;
        }
        ArrayList<AbstractStatement> list = new ArrayList<AbstractStatement>();
        while (result.hasNext()) {
            list.add((AbstractStatement)result.next());
        }
        return list.iterator();
    }

    public int getNumberOfStatementsThatUse(PointsToSetVariable v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        int number = v.getGraphNodeId();
        if (number == -1) {
            return 0;
        }
        int result = this.delegateGraph.getSuccNodeCount((Object)v);
        for (UnaryOperator op : this.invImplicitUnaryMap.keySet()) {
            IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.invImplicitUnaryMap.get((Object)op);
            IntSet s = R.getRelated(number);
            if (s == null) continue;
            result += s.size();
        }
        return result;
    }

    public int getNumberOfStatementsThatDef(PointsToSetVariable v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        int number = v.getGraphNodeId();
        if (number == -1) {
            return 0;
        }
        int result = this.delegateGraph.getPredNodeCount((Object)v);
        for (UnaryOperator op : this.implicitUnaryMap.keySet()) {
            IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.implicitUnaryMap.get((Object)op);
            IntSet s = R.getRelated(number);
            if (s == null) continue;
            result += s.size();
        }
        return result;
    }

    public Iterator<PointsToSetVariable> getVariables() {
        FilterIterator it = new FilterIterator(this.delegateGraph.iterator(), new Predicate(){

            public boolean test(Object x) {
                return x instanceof IVariable;
            }
        });
        return it;
    }

    public void performVerboseAction() {
    }

    public boolean containsStatement(IFixedPointStatement<PointsToSetVariable> eq) throws IllegalArgumentException {
        if (eq == null) {
            throw new IllegalArgumentException("eq == null");
        }
        if (this.useImplicitRepresentation(eq)) {
            UnaryStatement ueq = (UnaryStatement)eq;
            return this.containsImplicitStatement((UnaryStatement<PointsToSetVariable>)ueq);
        }
        return this.delegateStatements.contains(eq);
    }

    private boolean containsImplicitStatement(UnaryStatement<PointsToSetVariable> eq) {
        if (!this.containsVariable((PointsToSetVariable)eq.getLHS())) {
            return false;
        }
        if (!this.containsVariable((PointsToSetVariable)eq.getRightHandSide())) {
            return false;
        }
        int lhs = ((PointsToSetVariable)eq.getLHS()).getGraphNodeId();
        int rhs = ((PointsToSetVariable)eq.getRightHandSide()).getGraphNodeId();
        UnaryOperator op = (UnaryOperator)eq.getOperator();
        IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.implicitUnaryMap.get((Object)op);
        if (R != null) {
            return R.contains(lhs, rhs);
        }
        return false;
    }

    public boolean containsVariable(PointsToSetVariable v) {
        return this.delegateGraph.containsNode((Object)v);
    }

    public void addStatement(IFixedPointStatement<PointsToSetVariable> statement) throws IllegalArgumentException, UnimplementedError {
        if (statement == null) {
            throw new IllegalArgumentException("statement == null");
        }
        if (statement instanceof UnaryStatement) {
            this.addStatement((UnaryStatement<PointsToSetVariable>)((UnaryStatement)statement));
        } else if (statement instanceof GeneralStatement) {
            this.addStatement((GeneralStatement<PointsToSetVariable>)((GeneralStatement)statement));
        } else {
            Assertions.UNREACHABLE((String)("unexpected: " + statement.getClass()));
        }
    }

    public NumberedGraph<PointsToSetVariable> getAssignmentGraph() {
        return new FilteredConstraintGraphView(this){

            @Override
            boolean isInteresting(AbstractStatement eq) {
                return eq instanceof AssignEquation;
            }
        };
    }

    public Graph<PointsToSetVariable> getFilterAssignmentGraph() {
        return new FilteredConstraintGraphView(this){

            @Override
            boolean isInteresting(AbstractStatement eq) {
                return eq instanceof AssignEquation || eq.getOperator() instanceof PropagationCallGraphBuilder.FilterOperator;
            }
        };
    }

    public Graph<PointsToSetVariable> getFlowGraphIncludingImplicitConstraints() {
        return new VariableGraphView();
    }

    public String spaceReport() {
        StringBuffer result = new StringBuffer("PropagationGraph\n");
        result.append("ImplicitEdges:" + this.countImplicitEdges() + "\n");
        return result.toString();
    }

    private int countImplicitEdges() {
        int result = 0;
        GlobalImplicitIterator it = new GlobalImplicitIterator();
        while (it.hasNext()) {
            it.next();
            ++result;
        }
        return result;
    }

    private class DelegateGraph
    extends AbstractNumberedGraph<INodeWithNumber> {
        private int equationCount = 0;
        private int varCount = 0;

        private DelegateGraph() {
        }

        public void addNode(INodeWithNumber o) {
            Assertions.UNREACHABLE((String)"Don't call me");
        }

        public void addEquation(AbstractStatement<PointsToSetVariable, ?> eq) {
            assert (!PropagationGraph.this.containsStatement((IFixedPointStatement<PointsToSetVariable>)eq));
            ++this.equationCount;
            super.addNode(eq);
        }

        public void addVariable(PointsToSetVariable v) {
            if (!PropagationGraph.this.containsVariable(v)) {
                ++this.varCount;
                super.addNode((Object)v);
            }
        }

        protected NumberedNodeManager<INodeWithNumber> getNodeManager() {
            return PropagationGraph.this.nodeManager;
        }

        protected NumberedEdgeManager<INodeWithNumber> getEdgeManager() {
            return PropagationGraph.this.edgeManager;
        }

        protected int getEquationCount() {
            return this.equationCount;
        }

        protected int getVarCount() {
            return this.varCount;
        }
    }

    private abstract class FilteredConstraintGraphView
    extends AbstractNumberedGraph<PointsToSetVariable> {
        private FilteredConstraintGraphView() {
        }

        abstract boolean isInteresting(AbstractStatement var1);

        public void removeNodeAndEdges(PointsToSetVariable N) {
            Assertions.UNREACHABLE();
        }

        public Iterator<PointsToSetVariable> iterator() {
            return PropagationGraph.this.getVariables();
        }

        public int getNumberOfNodes() {
            return PropagationGraph.this.delegateGraph.getVarCount();
        }

        public void addNode(PointsToSetVariable n) {
            Assertions.UNREACHABLE();
        }

        public void removeNode(PointsToSetVariable n) {
            Assertions.UNREACHABLE();
        }

        public boolean containsNode(PointsToSetVariable N) {
            Assertions.UNREACHABLE();
            return false;
        }

        public Iterator<PointsToSetVariable> getPredNodes(PointsToSetVariable v) {
            final Iterator<AbstractStatement> eqs = PropagationGraph.this.getStatementsThatDef(v);
            return new Iterator<PointsToSetVariable>(){
                PointsToSetVariable nextResult;
                {
                    this.advance();
                }

                @Override
                public boolean hasNext() {
                    return this.nextResult != null;
                }

                @Override
                public PointsToSetVariable next() {
                    PointsToSetVariable result = this.nextResult;
                    this.advance();
                    return result;
                }

                private void advance() {
                    this.nextResult = null;
                    while (eqs.hasNext() && this.nextResult == null) {
                        AbstractStatement eq = (AbstractStatement)eqs.next();
                        if (!FilteredConstraintGraphView.this.isInteresting(eq)) continue;
                        this.nextResult = (PointsToSetVariable)((UnaryStatement)eq).getRightHandSide();
                    }
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        public int getPredNodeCount(PointsToSetVariable v) {
            int result = 0;
            Iterator<AbstractStatement> eqs = PropagationGraph.this.getStatementsThatDef(v);
            while (eqs.hasNext()) {
                AbstractStatement eq = eqs.next();
                if (!this.isInteresting(eq)) continue;
                ++result;
            }
            return result;
        }

        public Iterator<PointsToSetVariable> getSuccNodes(PointsToSetVariable v) {
            final Iterator<AbstractStatement> eqs = PropagationGraph.this.getStatementsThatUse(v);
            return new Iterator<PointsToSetVariable>(){
                PointsToSetVariable nextResult;
                {
                    this.advance();
                }

                @Override
                public boolean hasNext() {
                    return this.nextResult != null;
                }

                @Override
                public PointsToSetVariable next() {
                    PointsToSetVariable result = this.nextResult;
                    this.advance();
                    return result;
                }

                private void advance() {
                    this.nextResult = null;
                    while (eqs.hasNext() && this.nextResult == null) {
                        AbstractStatement eq = (AbstractStatement)eqs.next();
                        if (!FilteredConstraintGraphView.this.isInteresting(eq)) continue;
                        this.nextResult = (PointsToSetVariable)((UnaryStatement)eq).getLHS();
                    }
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        public int getSuccNodeCount(PointsToSetVariable v) {
            int result = 0;
            Iterator<AbstractStatement> eqs = PropagationGraph.this.getStatementsThatUse(v);
            while (eqs.hasNext()) {
                AbstractStatement eq = eqs.next();
                if (!this.isInteresting(eq)) continue;
                ++result;
            }
            return result;
        }

        public void addEdge(PointsToSetVariable src, PointsToSetVariable dst) {
            Assertions.UNREACHABLE();
        }

        public void removeAllIncidentEdges(PointsToSetVariable node) {
            Assertions.UNREACHABLE();
        }

        protected NumberedNodeManager getNodeManager() {
            return PropagationGraph.this.nodeManager;
        }

        protected NumberedEdgeManager<PointsToSetVariable> getEdgeManager() {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    private class GlobalImplicitIterator
    implements Iterator<AbstractStatement> {
        private final Iterator<UnaryOperator<PointsToSetVariable>> outerKeyDelegate;
        private Iterator innerDelegate;
        private UnaryOperator<PointsToSetVariable> currentOperator;

        GlobalImplicitIterator() {
            this.outerKeyDelegate = PropagationGraph.this.implicitUnaryMap.keySet().iterator();
            this.advanceOuter();
        }

        private void advanceOuter() {
            this.innerDelegate = null;
            while (this.outerKeyDelegate.hasNext()) {
                this.currentOperator = this.outerKeyDelegate.next();
                IBinaryNaturalRelation R = (IBinaryNaturalRelation)PropagationGraph.this.implicitUnaryMap.get(this.currentOperator);
                Iterator it = R.iterator();
                if (!it.hasNext()) continue;
                this.innerDelegate = it;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.innerDelegate != null;
        }

        @Override
        public AbstractStatement next() {
            IntPair p = (IntPair)this.innerDelegate.next();
            int lhs = p.getX();
            int rhs = p.getY();
            UnaryStatement result = this.currentOperator.makeEquation((IVariable)((PointsToSetVariable)((Object)PropagationGraph.this.delegateGraph.getNode(lhs))), (IVariable)((PointsToSetVariable)((Object)PropagationGraph.this.delegateGraph.getNode(rhs))));
            if (!this.innerDelegate.hasNext()) {
                this.advanceOuter();
            }
            return result;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }

    private final class ImplicitDefIterator
    implements Iterator<AbstractStatement> {
        final PointsToSetVariable def;
        final IntIterator uses;
        final UnaryOperator<PointsToSetVariable> op;

        ImplicitDefIterator(UnaryOperator<PointsToSetVariable> op, IntSet uses, PointsToSetVariable def) {
            this.op = op;
            this.def = def;
            this.uses = uses.intIterator();
        }

        @Override
        public boolean hasNext() {
            return this.uses.hasNext();
        }

        @Override
        public AbstractStatement next() {
            int r = this.uses.next();
            PointsToSetVariable rhs = (PointsToSetVariable)((Object)PropagationGraph.this.delegateGraph.getNode(r));
            UnaryStatement temp = this.op.makeEquation((IVariable)this.def, (IVariable)rhs);
            return temp;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }

    private final class ImplicitUseIterator
    implements Iterator<AbstractStatement> {
        final PointsToSetVariable use;
        final IntIterator defs;
        final UnaryOperator<PointsToSetVariable> op;

        ImplicitUseIterator(UnaryOperator<PointsToSetVariable> op, PointsToSetVariable use, IntSet defs) {
            this.op = op;
            this.use = use;
            this.defs = defs.intIterator();
        }

        @Override
        public boolean hasNext() {
            return this.defs.hasNext();
        }

        @Override
        public AbstractStatement next() {
            int l = this.defs.next();
            PointsToSetVariable lhs = (PointsToSetVariable)((Object)PropagationGraph.this.delegateGraph.getNode(l));
            UnaryStatement temp = this.op.makeEquation((IVariable)lhs, (IVariable)this.use);
            return temp;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }

    private class VariableGraphView
    extends AbstractNumberedGraph<PointsToSetVariable> {
        private VariableGraphView() {
        }

        public void removeNodeAndEdges(PointsToSetVariable N) {
            Assertions.UNREACHABLE();
        }

        public Iterator<PointsToSetVariable> iterator() {
            return PropagationGraph.this.getVariables();
        }

        public int getNumberOfNodes() {
            return PropagationGraph.this.delegateGraph.getVarCount();
        }

        public void addNode(PointsToSetVariable n) {
            Assertions.UNREACHABLE();
        }

        public void removeNode(PointsToSetVariable n) {
            Assertions.UNREACHABLE();
        }

        public boolean containsNode(PointsToSetVariable N) {
            return PropagationGraph.this.delegateGraph.containsNode((Object)N);
        }

        public Iterator<PointsToSetVariable> getPredNodes(PointsToSetVariable v) {
            final Iterator<AbstractStatement> eqs = PropagationGraph.this.getStatementsThatDef(v);
            return new Iterator<PointsToSetVariable>(){
                Iterator<INodeWithNumber> inner;

                @Override
                public boolean hasNext() {
                    return eqs.hasNext() || this.inner != null;
                }

                @Override
                public PointsToSetVariable next() {
                    if (this.inner != null) {
                        PointsToSetVariable result = (PointsToSetVariable)this.inner.next();
                        if (!this.inner.hasNext()) {
                            this.inner = null;
                        }
                        return result;
                    }
                    AbstractStatement eq = (AbstractStatement)eqs.next();
                    if (PropagationGraph.this.useImplicitRepresentation((IFixedPointStatement)eq)) {
                        return (PointsToSetVariable)((UnaryStatement)eq).getRightHandSide();
                    }
                    this.inner = PropagationGraph.this.delegateGraph.getPredNodes(eq);
                    return this.next();
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        public int getPredNodeCount(INodeWithNumber N) {
            PointsToSetVariable v = (PointsToSetVariable)N;
            int result = 0;
            Iterator<AbstractStatement> eqs = PropagationGraph.this.getStatementsThatDef(v);
            while (eqs.hasNext()) {
                AbstractStatement eq = eqs.next();
                if (PropagationGraph.this.useImplicitRepresentation((IFixedPointStatement)eq)) {
                    ++result;
                    continue;
                }
                result += PropagationGraph.this.delegateGraph.getPredNodeCount(N);
            }
            return result;
        }

        public Iterator<PointsToSetVariable> getSuccNodes(PointsToSetVariable v) {
            final Iterator<AbstractStatement> eqs = PropagationGraph.this.getStatementsThatUse(v);
            return new Iterator<PointsToSetVariable>(){
                PointsToSetVariable nextResult;
                {
                    this.advance();
                }

                @Override
                public boolean hasNext() {
                    return this.nextResult != null;
                }

                @Override
                public PointsToSetVariable next() {
                    PointsToSetVariable result = this.nextResult;
                    this.advance();
                    return result;
                }

                private void advance() {
                    this.nextResult = null;
                    while (eqs.hasNext() && this.nextResult == null) {
                        AbstractStatement eq = (AbstractStatement)eqs.next();
                        this.nextResult = (PointsToSetVariable)eq.getLHS();
                    }
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        public int getSuccNodeCount(PointsToSetVariable v) {
            int result = 0;
            Iterator<AbstractStatement> eqs = PropagationGraph.this.getStatementsThatUse(v);
            while (eqs.hasNext()) {
                AbstractStatement eq = eqs.next();
                IVariable lhs = eq.getLHS();
                if (lhs == null) continue;
                ++result;
            }
            return result;
        }

        public void addEdge(PointsToSetVariable src, PointsToSetVariable dst) {
            Assertions.UNREACHABLE();
        }

        public void removeAllIncidentEdges(PointsToSetVariable node) {
            Assertions.UNREACHABLE();
        }

        protected NumberedNodeManager getNodeManager() {
            return PropagationGraph.this.nodeManager;
        }

        protected NumberedEdgeManager getEdgeManager() {
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

