/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import java.util.Arrays;

public class DefaultEntrypoint
extends Entrypoint {
    private final TypeReference[][] paramTypes;
    private final IClassHierarchy cha;

    public DefaultEntrypoint(IMethod method, IClassHierarchy cha) {
        super(method);
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.cha = cha;
        this.paramTypes = this.makeParameterTypes(method);
        assert (this.paramTypes != null) : method.toString();
    }

    public DefaultEntrypoint(MethodReference method, IClassHierarchy cha) {
        super(method, cha);
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.cha = cha;
        this.paramTypes = this.makeParameterTypes(this.getMethod());
        assert (this.paramTypes != null) : method.toString();
    }

    protected TypeReference[][] makeParameterTypes(IMethod method) {
        TypeReference[][] result = new TypeReference[method.getNumberOfParameters()][];
        int i = 0;
        while (i < result.length) {
            result[i] = this.makeParameterTypes(method, i);
            ++i;
        }
        return result;
    }

    protected TypeReference[] makeParameterTypes(IMethod method, int i) {
        return new TypeReference[]{method.getParameterType(i)};
    }

    @Override
    public TypeReference[] getParameterTypes(int i) {
        return this.paramTypes[i];
    }

    public void setParameterTypes(int i, TypeReference[] types) {
        this.paramTypes[i] = types;
    }

    @Override
    public int getNumberOfParameters() {
        return this.paramTypes.length;
    }

    public IClassHierarchy getCha() {
        return this.cha;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode((Object[])this.paramTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultEntrypoint other = (DefaultEntrypoint)obj;
        return Arrays.equals((Object[])this.paramTypes, (Object[])other.paramTypes);
    }
}

