/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Arrays;

public abstract class Entrypoint
implements BytecodeConstants {
    protected final IMethod method;

    protected Entrypoint(IMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.method = method;
        assert (method.getDeclaringClass() != null) : "null declaring class";
    }

    protected Entrypoint(MethodReference method, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        IMethod m = cha.resolveMethod(method);
        if (m == null) {
            Assertions.UNREACHABLE((String)("could not resolve " + method));
        }
        this.method = m;
    }

    public CallSiteReference makeSite(int programCounter) {
        if (this.method.getSelector().equals(MethodReference.clinitSelector)) {
            assert (this.method.isStatic());
            return CallSiteReference.make(programCounter, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
        }
        if (this.method.getSelector().equals(MethodReference.initSelector)) {
            assert (!this.method.isStatic());
            return CallSiteReference.make(programCounter, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        }
        if (this.method.getDeclaringClass().isInterface()) {
            return CallSiteReference.make(programCounter, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.INTERFACE);
        }
        if (this.method.isStatic()) {
            return CallSiteReference.make(programCounter, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
        }
        return CallSiteReference.make(programCounter, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
    }

    protected int makeArgument(AbstractRootMethod m, int i) {
        TypeReference[] p = this.getParameterTypes(i);
        if (p.length == 0) {
            return -1;
        }
        if (p.length == 1) {
            if (p[0].isPrimitiveType()) {
                return m.addLocal();
            }
            SSANewInstruction n = m.addAllocation(p[0]);
            return n == null ? -1 : n.getDef();
        }
        int[] values = new int[p.length];
        int countErrors = 0;
        int j = 0;
        while (j < p.length) {
            int value;
            SSANewInstruction n = m.addAllocation(p[j]);
            int n2 = value = n == null ? -1 : n.getDef();
            if (value == -1) {
                ++countErrors;
            } else {
                values[j - countErrors] = value;
            }
            ++j;
        }
        if (countErrors > 0) {
            int[] oldValues = values;
            values = new int[oldValues.length - countErrors];
            System.arraycopy(oldValues, 0, values, 0, values.length);
        }
        if (p[0].isPrimitiveType()) {
            TypeAbstraction a = PrimitiveType.getPrimitive(p[0]);
            i = 1;
            while (i < p.length) {
                a = ((TypeAbstraction)a).meet(PrimitiveType.getPrimitive(p[i]));
                ++i;
            }
        } else {
            IClassHierarchy cha = m.getClassHierarchy();
            IClass p0 = cha.lookupClass(p[0]);
            TypeAbstraction a = new ConeType(p0);
            i = 1;
            while (i < p.length) {
                IClass pi = cha.lookupClass(p[i]);
                a = ((TypeAbstraction)a).meet(new ConeType(pi));
                ++i;
            }
        }
        return m.addPhi(values);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public SSAAbstractInvokeInstruction addCall(AbstractRootMethod m) {
        CallSiteReference site = this.makeSite(0);
        if (site == null) {
            return null;
        }
        int[] paramValues = new int[this.getNumberOfParameters()];
        int j = 0;
        while (j < paramValues.length) {
            paramValues[j] = this.makeArgument(m, j);
            if (paramValues[j] == -1) {
                return null;
            }
            ++j;
        }
        return m.addInvocation(paramValues, site);
    }

    public IMethod getMethod() {
        return this.method;
    }

    public abstract TypeReference[] getParameterTypes(int var1);

    public abstract int getNumberOfParameters();

    public String toString() {
        StringBuffer result = new StringBuffer(this.method.toString());
        result.append("(");
        int i = 0;
        while (i < this.getNumberOfParameters() - 1) {
            result.append(Arrays.toString(this.getParameterTypes(i)));
            result.append(",");
            ++i;
        }
        if (this.getNumberOfParameters() > 0) {
            result.append(Arrays.toString(this.getParameterTypes(this.getNumberOfParameters() - 1)));
        }
        result.append(")");
        return result.toString();
    }

    public int hashCode() {
        return this.method.hashCode() * 1009;
    }
}

