/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.thin.CISlicer;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PABasedMemoryAccessMap
implements MemoryAccessMap {
    private static final boolean DEBUG = false;
    private final PointerAnalysis<InstanceKey> pa;
    private final HeapModel heapModel;
    private final Map<PointerKey, Set<Statement>> invMod;
    private final Map<PointerKey, Set<Statement>> invRef;

    public PABasedMemoryAccessMap(CallGraph cg, PointerAnalysis<InstanceKey> pa) {
        this(cg, pa, new SDG<InstanceKey>(cg, pa, Slicer.DataDependenceOptions.NO_BASE_NO_HEAP_NO_EXCEPTIONS, Slicer.ControlDependenceOptions.NONE));
    }

    public PABasedMemoryAccessMap(CallGraph cg, PointerAnalysis<InstanceKey> pa, SDG sdg) {
        this(cg, pa, CISlicer.scanForMod(sdg, pa, true, ModRef.make()), CISlicer.scanForRef(sdg, pa));
    }

    public PABasedMemoryAccessMap(CallGraph cg, PointerAnalysis<InstanceKey> pa, Map<Statement, Set<PointerKey>> mod, Map<Statement, Set<PointerKey>> ref) {
        if (pa == null) {
            throw new IllegalArgumentException("null pa");
        }
        this.pa = pa;
        this.heapModel = pa.getHeapModel();
        this.invMod = MapUtil.inverseMap(mod);
        this.invRef = MapUtil.inverseMap(ref);
    }

    @Override
    public Collection<MemoryAccess> getArrayReads(PointerKey arrayRef) {
        ArrayList<MemoryAccess> memAccesses = new ArrayList<MemoryAccess>();
        for (InstanceKey ik : this.pa.getPointsToSet(arrayRef)) {
            PointerKey ack = this.heapModel.getPointerKeyForArrayContents(ik);
            this.convertStmtsToMemoryAccess((Collection<Statement>)this.invRef.get(ack), memAccesses);
        }
        return memAccesses;
    }

    @Override
    public Collection<MemoryAccess> getArrayWrites(PointerKey arrayRef) {
        ArrayList<MemoryAccess> memAccesses = new ArrayList<MemoryAccess>();
        for (InstanceKey ik : this.pa.getPointsToSet(arrayRef)) {
            PointerKey ack = this.heapModel.getPointerKeyForArrayContents(ik);
            this.convertStmtsToMemoryAccess((Collection<Statement>)this.invMod.get(ack), memAccesses);
        }
        return memAccesses;
    }

    @Override
    public Collection<MemoryAccess> getFieldReads(PointerKey baseRef, IField field) {
        ArrayList<MemoryAccess> memAccesses = new ArrayList<MemoryAccess>();
        for (InstanceKey ik : this.pa.getPointsToSet(baseRef)) {
            PointerKey ifk = this.heapModel.getPointerKeyForInstanceField(ik, field);
            this.convertStmtsToMemoryAccess((Collection<Statement>)this.invRef.get(ifk), memAccesses);
        }
        return memAccesses;
    }

    @Override
    public Collection<MemoryAccess> getFieldWrites(PointerKey baseRef, IField field) {
        ArrayList<MemoryAccess> memAccesses = new ArrayList<MemoryAccess>();
        for (InstanceKey ik : this.pa.getPointsToSet(baseRef)) {
            PointerKey ifk = this.heapModel.getPointerKeyForInstanceField(ik, field);
            this.convertStmtsToMemoryAccess((Collection<Statement>)this.invMod.get(ifk), memAccesses);
        }
        return memAccesses;
    }

    @Override
    public Collection<MemoryAccess> getStaticFieldReads(IField field) {
        ArrayList<MemoryAccess> result = new ArrayList<MemoryAccess>();
        this.convertStmtsToMemoryAccess((Collection<Statement>)this.invRef.get(this.heapModel.getPointerKeyForStaticField(field)), result);
        return result;
    }

    @Override
    public Collection<MemoryAccess> getStaticFieldWrites(IField field) {
        ArrayList<MemoryAccess> result = new ArrayList<MemoryAccess>();
        this.convertStmtsToMemoryAccess((Collection<Statement>)this.invMod.get(this.heapModel.getPointerKeyForStaticField(field)), result);
        return result;
    }

    private void convertStmtsToMemoryAccess(Collection<Statement> stmts, Collection<MemoryAccess> result) {
        if (stmts == null) {
            return;
        }
        for (Statement s : stmts) {
            switch (s.getKind()) {
                case NORMAL: {
                    NormalStatement normStmt = (NormalStatement)s;
                    result.add(new MemoryAccess(normStmt.getInstructionIndex(), normStmt.getNode()));
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                }
            }
        }
    }

    @Override
    public HeapModel getHeapModel() {
        return this.heapModel;
    }
}

