/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleDemandPointerFlowGraph
extends SlowSparseNumberedGraph<Object> {
    private static final boolean DEBUG = false;
    private static int wipeCount = 0;
    private final CallGraph cg;
    private final HeapModel heapModel;
    private final MemoryAccessMap fam;
    private final IClassHierarchy cha;
    final BitVectorIntSet cgNodesVisited = new BitVectorIntSet();
    final Map<PointerKey, IField> getFieldDefs = HashMapFactory.make();
    final Collection<PointerKey> arrayDefs = HashSetFactory.make();
    final Map<PointerKey, SSAInvokeInstruction> callDefs = HashMapFactory.make();
    final Map<PointerKey, CGNode> params = HashMapFactory.make();

    public SimpleDemandPointerFlowGraph(CallGraph cg, HeapModel heapModel, MemoryAccessMap fam, IClassHierarchy cha) {
        if (cg == null) {
            throw new IllegalArgumentException("null cg");
        }
        this.cg = cg;
        this.heapModel = heapModel;
        this.fam = fam;
        this.cha = cha;
    }

    public void addSubgraphForNode(CGNode node) {
        int n = this.cg.getNumber(node);
        if (!this.cgNodesVisited.contains(n)) {
            this.cgNodesVisited.add(n);
            this.unconditionallyAddConstraintsFromNode(node);
            this.addNodesForParameters(node);
        }
    }

    private void addNodesForParameters(CGNode node) {
        IR ir = node.getIR();
        TypeInference ti = TypeInference.make(ir, false);
        SymbolTable symbolTable = ir.getSymbolTable();
        int i = 0;
        while (i < symbolTable.getNumberOfParameters()) {
            int parameter = symbolTable.getParameter(i);
            TypeAbstraction t = ti.getType(parameter);
            if (t != null) {
                PointerKey paramPk = this.heapModel.getPointerKeyForLocal(node, parameter);
                this.addNode(paramPk);
                this.params.put(paramPk, node);
            }
            ++i;
        }
        this.addNode(this.heapModel.getPointerKeyForReturnValue(node));
        this.addNode(this.heapModel.getPointerKeyForExceptionalReturnValue(node));
    }

    protected HeapModel getHeapModel() {
        return this.heapModel;
    }

    public IntSet getPredNodeNumbers(Object node) throws UnimplementedError {
        if (node instanceof StaticFieldKey) {
            Assertions.UNREACHABLE();
            return null;
        }
        return super.getPredNodeNumbers(node);
    }

    public IntSet getSuccNodeNumbers(Object node) throws IllegalArgumentException {
        if (node instanceof StaticFieldKey) {
            throw new IllegalArgumentException("node instanceof com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey");
        }
        return super.getSuccNodeNumbers(node);
    }

    public int getPredNodeCount(Object N) throws UnimplementedError {
        if (N instanceof StaticFieldKey) {
            Assertions.UNREACHABLE();
            return -1;
        }
        return super.getPredNodeCount(N);
    }

    public Iterator<Object> getPredNodes(Object N) throws IllegalArgumentException {
        if (N instanceof StaticFieldKey) {
            throw new IllegalArgumentException("N instanceof com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey");
        }
        return super.getPredNodes(N);
    }

    public int getSuccNodeCount(Object N) throws UnimplementedError {
        if (N instanceof StaticFieldKey) {
            Assertions.UNREACHABLE();
            return -1;
        }
        return super.getSuccNodeCount(N);
    }

    public Iterator<Object> getSuccNodes(Object N) {
        if (N instanceof StaticFieldKey) {
            this.addNodesThatWriteToStaticField(((StaticFieldKey)N).getField());
        } else {
            IField f = this.getFieldDefs.get(N);
            if (f != null) {
                this.addMatchEdges((LocalPointerKey)N, f);
            } else {
                SSAInvokeInstruction callInstr = this.callDefs.get(N);
                if (callInstr != null) {
                    this.addReturnEdges((LocalPointerKey)N, callInstr);
                } else {
                    CGNode node = this.params.get(N);
                    if (node != null) {
                        this.addParamEdges((LocalPointerKey)N, node);
                    } else if (this.arrayDefs.contains(N)) {
                        this.addArrayMatchEdges((LocalPointerKey)N);
                    }
                }
            }
        }
        return super.getSuccNodes(N);
    }

    private void addArrayMatchEdges(LocalPointerKey pk) {
        Collection<MemoryAccess> arrayWrites = this.fam.getArrayWrites(null);
        for (MemoryAccess a : arrayWrites) {
            this.addSubgraphForNode(a.getNode());
        }
        for (MemoryAccess a : arrayWrites) {
            IR ir = a.getNode().getIR();
            SSAArrayStoreInstruction s = (SSAArrayStoreInstruction)ir.getInstructions()[a.getInstructionIndex()];
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getValue());
            assert (this.containsNode(r));
            assert (this.containsNode(pk));
            this.addMatchEdge(pk, r);
        }
    }

    private void addParamEdges(LocalPointerKey pk, CGNode node) {
        int paramPos = pk.getValueNumber() - 1;
        Iterator iterator = this.cg.iterator();
        while (iterator.hasNext()) {
            CGNode caller = (CGNode)iterator.next();
            this.addSubgraphForNode(caller);
            IR ir = caller.getIR();
            Iterator<CallSiteReference> iterator2 = ir.iterateCallSites();
            while (iterator2.hasNext()) {
                CallSiteReference call = iterator2.next();
                if (!this.cg.getPossibleTargets(caller, call).contains(node)) continue;
                SSAAbstractInvokeInstruction[] callInstrs = ir.getCalls(call);
                int i = 0;
                while (i < callInstrs.length) {
                    SSAAbstractInvokeInstruction callInstr = callInstrs[i];
                    PointerKey actualPk = this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                    assert (this.containsNode(actualPk));
                    assert (this.containsNode(pk));
                    this.addEdge(pk, actualPk);
                    ++i;
                }
            }
        }
    }

    private void addReturnEdges(LocalPointerKey pk, SSAInvokeInstruction callInstr) {
        boolean isExceptional = pk.getValueNumber() == callInstr.getException();
        Set<CGNode> possibleCallees = this.cg.getPossibleTargets(pk.getNode(), callInstr.getCallSite());
        for (CGNode callee : possibleCallees) {
            PointerKey retVal;
            this.addSubgraphForNode(callee);
            PointerKey pointerKey = retVal = isExceptional ? this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : this.heapModel.getPointerKeyForReturnValue(callee);
            assert (this.containsNode(retVal));
            this.addEdge(pk, retVal);
        }
    }

    private void addMatchEdges(LocalPointerKey pk, IField f) {
        Collection<MemoryAccess> fieldWrites = this.fam.getFieldWrites(null, f);
        this.addMatchHelper(pk, fieldWrites);
    }

    private void addMatchHelper(LocalPointerKey pk, Collection<MemoryAccess> writes) {
        for (MemoryAccess a : writes) {
            this.addSubgraphForNode(a.getNode());
        }
        for (MemoryAccess a : writes) {
            IR ir = a.getNode().getIR();
            SSAPutInstruction s = (SSAPutInstruction)ir.getInstructions()[a.getInstructionIndex()];
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getVal());
            assert (this.containsNode(r));
            assert (this.containsNode(pk));
            this.addMatchEdge(pk, r);
        }
    }

    private void addMatchEdge(LocalPointerKey pk, PointerKey r) {
        this.addEdge(pk, r);
    }

    private void addNodesThatWriteToStaticField(IField field) {
        Collection<MemoryAccess> fieldWrites = this.fam.getStaticFieldWrites(field);
        for (MemoryAccess a : fieldWrites) {
            this.addSubgraphForNode(a.getNode());
        }
    }

    public boolean hasEdge(PointerKey src, PointerKey dst) {
        return super.hasEdge((Object)src, (Object)dst);
    }

    protected void unconditionallyAddConstraintsFromNode(CGNode node) {
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        IR ir = node.getIR();
        this.debugPrintIR(ir);
        if (ir == null) {
            return;
        }
        DefUse du = node.getDU();
        this.addNodeInstructionConstraints(node, ir, du);
        this.addNodePassthruExceptionConstraints(node, ir);
    }

    protected void addNodePassthruExceptionConstraints(CGNode node, IR ir) {
        List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(ir, ir.getExitBlock());
        PointerKey exception = this.heapModel.getPointerKeyForExceptionalReturnValue(node);
        IClass c = node.getClassHierarchy().lookupClass(TypeReference.JavaLangThrowable);
        this.addExceptionDefConstraints(ir, node, peis, exception, Collections.singleton(c));
    }

    private void addExceptionDefConstraints(IR ir, CGNode node, List<ProgramCounter> peis, PointerKey exceptionVar, Set<IClass> catchClasses) {
        for (ProgramCounter peiLoc : peis) {
            PointerKey e;
            SSAInstruction s;
            SSAInstruction pei = ir.getPEI(peiLoc);
            if (pei instanceof SSAAbstractInvokeInstruction) {
                s = (SSAAbstractInvokeInstruction)pei;
                e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
                this.addNode(exceptionVar);
                this.addNode(e);
                this.addEdge(exceptionVar, e);
            } else if (pei instanceof SSAAbstractThrowInstruction) {
                s = (SSAAbstractThrowInstruction)pei;
                e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
                this.addNode(exceptionVar);
                this.addNode(e);
                this.addEdge(exceptionVar, e);
            }
            Collection<TypeReference> types = pei.getExceptionTypes();
            if (types == null) continue;
            for (TypeReference type : types) {
                if (type == null) continue;
                InstanceKey ik = this.heapModel.getInstanceKeyForPEI(node, peiLoc, type);
                assert (ik instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + ik;
                ConcreteTypeKey ck = (ConcreteTypeKey)ik;
                IClass klass = ck.getType();
                if (!PropagationCallGraphBuilder.catches(catchClasses, klass, this.cha)) continue;
                this.addNode(exceptionVar);
                this.addNode(ik);
                this.addEdge(exceptionVar, ik);
            }
        }
    }

    protected void addNodeInstructionConstraints(CGNode node, IR ir, DefUse du) {
        StatementVisitor v = this.makeVisitor((ExplicitCallGraph.ExplicitNode)node, ir, du);
        SSACFG cfg = ir.getControlFlowGraph();
        Iterator iterator = cfg.iterator();
        while (iterator.hasNext()) {
            ISSABasicBlock b = (ISSABasicBlock)iterator.next();
            this.addBlockInstructionConstraints(node, cfg, b, v);
        }
    }

    protected void addBlockInstructionConstraints(CGNode node, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, ISSABasicBlock b, StatementVisitor v) {
        v.setBasicBlock(b);
        for (SSAInstruction s : b) {
            if (s == null) continue;
            s.visit(v);
        }
        this.addPhiConstraints(node, cfg, b);
    }

    private void addPhiConstraints(CGNode node, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, ISSABasicBlock b) {
        Iterator sbs = cfg.getSuccNodes(b);
        while (sbs.hasNext()) {
            ISSABasicBlock sb = (ISSABasicBlock)sbs.next();
            if (sb.isExitBlock()) continue;
            int n = 0;
            Iterator back = cfg.getPredNodes(sb);
            while (back.hasNext()) {
                if (back.next() == b) break;
                ++n;
            }
            assert (n < cfg.getPredNodeCount(sb));
            Iterator<SSAPhiInstruction> phis = sb.iteratePhis();
            while (phis.hasNext()) {
                SSAPhiInstruction phi = phis.next();
                if (phi == null) continue;
                PointerKey def = this.heapModel.getPointerKeyForLocal(node, phi.getDef());
                if (phi.getUse(n) <= 0) continue;
                PointerKey use = this.heapModel.getPointerKeyForLocal(node, phi.getUse(n));
                this.addNode(def);
                this.addNode(use);
                this.addEdge(def, use);
            }
        }
    }

    protected StatementVisitor makeVisitor(ExplicitCallGraph.ExplicitNode node, IR ir, DefUse du) {
        return new StatementVisitor(node, ir, du);
    }

    private void debugPrintIR(IR ir) {
    }

    protected class StatementVisitor
    extends SSAInstruction.Visitor {
        protected final CGNode node;
        protected final IR ir;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public StatementVisitor(CGNode node, IR ir, DefUse du) {
            this.node = node;
            this.ir = ir;
            this.symbolTable = ir.getSymbolTable();
            assert (this.symbolTable != null);
            this.du = du;
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            PointerKey result = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            SimpleDemandPointerFlowGraph.this.arrayDefs.add(result);
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            PointerKey value = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getValue());
            SimpleDemandPointerFlowGraph.this.addNode(value);
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            HashSet types = HashSetFactory.make();
            TypeReference[] typeReferenceArray = instruction.getDeclaredResultTypes();
            int n = typeReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeReference t = typeReferenceArray[n2];
                IClass cls = SimpleDemandPointerFlowGraph.this.cha.lookupClass(t);
                if (cls == null) {
                    return;
                }
                types.add(cls);
                ++n2;
            }
            FilteredPointerKey result = SimpleDemandPointerFlowGraph.this.heapModel.getFilteredPointerKeyForLocal(this.node, instruction.getResult(), new FilteredPointerKey.MultipleClassesFilter(types.toArray(new IClass[types.size()])));
            PointerKey value = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getVal());
            SimpleDemandPointerFlowGraph.this.addNode(result);
            SimpleDemandPointerFlowGraph.this.addNode(value);
            SimpleDemandPointerFlowGraph.this.addEdge(result, value);
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            if (instruction.returnsPrimitiveType() || instruction.returnsVoid()) {
                return;
            }
            PointerKey def = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getResult());
            SimpleDemandPointerFlowGraph.this.addNode(def);
            PointerKey returnValue = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForReturnValue(this.node);
            SimpleDemandPointerFlowGraph.this.addNode(returnValue);
            SimpleDemandPointerFlowGraph.this.addEdge(returnValue, def);
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            this.visitGetInternal(instruction.getDef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        protected void visitGetInternal(int lval, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = SimpleDemandPointerFlowGraph.this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                return;
            }
            PointerKey def = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, lval);
            assert (def != null);
            if (isStatic) {
                PointerKey fKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForStaticField(f);
                SimpleDemandPointerFlowGraph.this.addNode(def);
                SimpleDemandPointerFlowGraph.this.addNode(fKey);
                SimpleDemandPointerFlowGraph.this.addEdge(def, fKey);
            } else {
                SimpleDemandPointerFlowGraph.this.addNode(def);
                SimpleDemandPointerFlowGraph.this.getFieldDefs.put(def, f);
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            this.visitPutInternal(instruction.getVal(), instruction.isStatic(), instruction.getDeclaredField());
        }

        public void visitPutInternal(int rval, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = SimpleDemandPointerFlowGraph.this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                return;
            }
            PointerKey use = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, rval);
            assert (use != null);
            if (isStatic) {
                PointerKey fKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForStaticField(f);
                SimpleDemandPointerFlowGraph.this.addNode(use);
                SimpleDemandPointerFlowGraph.this.addNode(fKey);
                SimpleDemandPointerFlowGraph.this.addEdge(fKey, use);
            } else {
                SimpleDemandPointerFlowGraph.this.addNode(use);
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            int i = 0;
            while (i < instruction.getNumberOfUses()) {
                PointerKey use = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getUse(i));
                SimpleDemandPointerFlowGraph.this.addNode(use);
                ++i;
            }
            if (instruction.hasDef()) {
                PointerKey def = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
                SimpleDemandPointerFlowGraph.this.addNode(def);
                SimpleDemandPointerFlowGraph.this.callDefs.put(def, instruction);
            }
            PointerKey exc = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getException());
            SimpleDemandPointerFlowGraph.this.addNode(exc);
            SimpleDemandPointerFlowGraph.this.callDefs.put(exc, instruction);
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            InstanceKey iKey = SimpleDemandPointerFlowGraph.this.heapModel.getInstanceKeyForAllocation(this.node, instruction.getNewSite());
            if (iKey == null) {
                return;
            }
            PointerKey def = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            SimpleDemandPointerFlowGraph.this.addNode(iKey);
            SimpleDemandPointerFlowGraph.this.addNode(def);
            SimpleDemandPointerFlowGraph.this.addEdge(def, iKey);
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey def = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            Set<IClass> types = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(instruction, this.ir);
            SimpleDemandPointerFlowGraph.this.addExceptionDefConstraints(this.ir, this.node, peis, def, types);
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            Assertions.UNREACHABLE();
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(ISSABasicBlock block) {
            this.basicBlock = block;
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
            Assertions.UNREACHABLE();
        }
    }
}

