/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

public class ICFGSupergraph
implements ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> {
    private final IAnalysisCacheView analysisCache;
    private final ExplodedInterproceduralCFG icfg;

    protected ICFGSupergraph(ExplodedInterproceduralCFG icfg, IAnalysisCacheView cache) {
        this.icfg = icfg;
        this.analysisCache = cache;
    }

    public static ICFGSupergraph make(CallGraph cg, IAnalysisCacheView cache) {
        ICFGSupergraph w = new ICFGSupergraph(ExplodedInterproceduralCFG.make(cg), cache);
        return w;
    }

    @Override
    public Graph<? extends CGNode> getProcedureGraph() {
        return this.icfg.getCallGraph();
    }

    public IClassHierarchy getClassHierarchy() {
        return this.icfg.getCallGraph().getClassHierarchy();
    }

    @Override
    public byte classifyEdge(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (this.isCall(src)) {
            if (this.isEntry(dest)) {
                return 0;
            }
            return 2;
        }
        if (this.isExit(src)) {
            return 1;
        }
        return 3;
    }

    @Override
    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> getCallSites(BasicBlockInContext<IExplodedBasicBlock> r, CGNode callee) {
        return this.icfg.getCallSites(r, callee);
    }

    @Override
    public Iterator<? extends BasicBlockInContext<IExplodedBasicBlock>> getCalledNodes(BasicBlockInContext<IExplodedBasicBlock> call) {
        Predicate<BasicBlockInContext<IExplodedBasicBlock>> isEntryFilter = new Predicate<BasicBlockInContext<IExplodedBasicBlock>>(){

            public boolean test(BasicBlockInContext<IExplodedBasicBlock> o) {
                return o.isEntryBlock();
            }
        };
        return new FilterIterator(this.getSuccNodes(call), (Predicate)isEntryFilter);
    }

    public BasicBlockInContext<IExplodedBasicBlock>[] getEntriesForProcedure(CGNode procedure) {
        return new BasicBlockInContext[]{this.icfg.getEntry(procedure)};
    }

    public BasicBlockInContext<IExplodedBasicBlock>[] getExitsForProcedure(CGNode procedure) {
        return new BasicBlockInContext[]{this.icfg.getExit(procedure)};
    }

    @Override
    public BasicBlockInContext<IExplodedBasicBlock> getLocalBlock(CGNode procedure, int i) {
        IExplodedBasicBlock b = (IExplodedBasicBlock)this.icfg.getCFG(procedure).getNode(i);
        return new BasicBlockInContext<IExplodedBasicBlock>(procedure, b);
    }

    @Override
    public int getLocalBlockNumber(BasicBlockInContext<IExplodedBasicBlock> n) {
        return n.getDelegate().getNumber();
    }

    public BasicBlockInContext<IExplodedBasicBlock> getMainEntry() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> getNormalSuccessors(BasicBlockInContext<IExplodedBasicBlock> call) {
        return EmptyIterator.instance();
    }

    @Override
    public int getNumberOfBlocks(CGNode procedure) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public CGNode getProcOf(BasicBlockInContext<IExplodedBasicBlock> n) {
        return this.icfg.getCGNode(n);
    }

    @Override
    public Iterator<? extends BasicBlockInContext<IExplodedBasicBlock>> getReturnSites(BasicBlockInContext<IExplodedBasicBlock> call, CGNode callee) {
        return this.icfg.getReturnSites(call);
    }

    @Override
    public boolean isCall(BasicBlockInContext<IExplodedBasicBlock> n) {
        return n.getDelegate().getInstruction() instanceof SSAAbstractInvokeInstruction;
    }

    @Override
    public boolean isEntry(BasicBlockInContext<IExplodedBasicBlock> n) {
        return n.getDelegate().isEntryBlock();
    }

    @Override
    public boolean isExit(BasicBlockInContext<IExplodedBasicBlock> n) {
        return n.getDelegate().isExitBlock();
    }

    @Override
    public boolean isReturn(BasicBlockInContext<IExplodedBasicBlock> n) {
        return this.icfg.isReturn(n);
    }

    public void removeNodeAndEdges(BasicBlockInContext<IExplodedBasicBlock> N) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void addNode(BasicBlockInContext<IExplodedBasicBlock> n) {
        Assertions.UNREACHABLE();
    }

    public boolean containsNode(BasicBlockInContext<IExplodedBasicBlock> N) {
        return this.icfg.containsNode(N);
    }

    public int getNumberOfNodes() {
        return this.icfg.getNumberOfNodes();
    }

    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> iterator() {
        return this.icfg.iterator();
    }

    public void removeNode(BasicBlockInContext<IExplodedBasicBlock> n) {
        Assertions.UNREACHABLE();
    }

    public void addEdge(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) {
        Assertions.UNREACHABLE();
    }

    public int getPredNodeCount(BasicBlockInContext<IExplodedBasicBlock> N) {
        return this.icfg.getPredNodeCount(N);
    }

    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> getPredNodes(BasicBlockInContext<IExplodedBasicBlock> N) {
        return this.icfg.getPredNodes(N);
    }

    public int getSuccNodeCount(BasicBlockInContext<IExplodedBasicBlock> N) {
        return this.icfg.getSuccNodeCount(N);
    }

    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> getSuccNodes(BasicBlockInContext<IExplodedBasicBlock> N) {
        return this.icfg.getSuccNodes(N);
    }

    public boolean hasEdge(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) {
        return this.icfg.hasEdge(src, dst);
    }

    public void removeAllIncidentEdges(BasicBlockInContext<IExplodedBasicBlock> node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeEdge(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeIncomingEdges(BasicBlockInContext<IExplodedBasicBlock> node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeOutgoingEdges(BasicBlockInContext<IExplodedBasicBlock> node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public int getMaxNumber() {
        return this.icfg.getMaxNumber();
    }

    public BasicBlockInContext<IExplodedBasicBlock> getNode(int number) {
        return this.icfg.getNode(number);
    }

    public int getNumber(BasicBlockInContext<IExplodedBasicBlock> N) {
        return this.icfg.getNumber(N);
    }

    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> iterateNodes(IntSet s) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getPredNodeNumbers(BasicBlockInContext<IExplodedBasicBlock> node) {
        return this.icfg.getPredNodeNumbers(node);
    }

    public IntSet getSuccNodeNumbers(BasicBlockInContext<IExplodedBasicBlock> node) {
        return this.icfg.getSuccNodeNumbers(node);
    }

    public ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> getCFG(BasicBlockInContext<IExplodedBasicBlock> node) {
        return this.icfg.getCFG(node);
    }

    public ExplodedInterproceduralCFG getICFG() {
        return this.icfg;
    }

    public String toString() {
        return this.icfg.toString();
    }
}

