/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import java.util.ArrayList;
import java.util.Iterator;

class NullPointerTransferFunctionProvider<T extends ISSABasicBlock>
implements ITransferFunctionProvider<T, NullPointerState> {
    private final AbstractMeetOperator<NullPointerState> meet = NullPointerState.meetOperator();
    private final TransferFunctionSSAVisitor visitor;
    private final ControlFlowGraph<SSAInstruction, T> cfg;

    NullPointerTransferFunctionProvider(ControlFlowGraph<SSAInstruction, T> cfg, IR ir) {
        this.visitor = new TransferFunctionSSAVisitor(ir);
        this.cfg = cfg;
    }

    static <T extends ISSABasicBlock> SSAInstruction getRelevantInstruction(T block) {
        SSAInstruction instr = null;
        if (block.getLastInstructionIndex() >= 0) {
            instr = block.getLastInstruction();
        }
        if (instr == null && block.isCatchBlock()) {
            if (block instanceof IExplodedBasicBlock) {
                instr = ((IExplodedBasicBlock)block).getCatchInstruction();
            } else if (block instanceof SSACFG.ExceptionHandlerBasicBlock) {
                instr = ((SSACFG.ExceptionHandlerBasicBlock)block).getCatchInstruction();
            } else {
                throw new IllegalStateException("Unable to get catch instruction from unknown ISSABasicBlock implementation.");
            }
        }
        return instr;
    }

    public UnaryOperator<NullPointerState> getEdgeTransferFunction(T src, T dst) {
        SSAInstruction instr = NullPointerTransferFunctionProvider.getRelevantInstruction(src);
        assert (!(instr instanceof SSAPhiInstruction));
        if (instr != null && this.cfg.hasEdge(src, dst)) {
            instr.visit(this.visitor);
            if (this.visitor.noIdentity) {
                if (Util.endsWithConditionalBranch(this.cfg, src)) {
                    if (Util.getTakenSuccessor(this.cfg, src) == dst) {
                        return this.visitor.transfer1;
                    }
                    if (Util.getNotTakenSuccessor(this.cfg, src) == dst) {
                        return this.visitor.transfer2;
                    }
                    throw new IllegalStateException("Successor of if clause is neither true nor false case.");
                }
                if (this.cfg.getNormalSuccessors(src).contains(dst)) {
                    return this.visitor.transfer1;
                }
                if (this.cfg.getExceptionalSuccessors(src).contains(dst)) {
                    return this.visitor.transfer2;
                }
                throw new IllegalStateException("Successor not found.");
            }
        }
        return NullPointerState.identityFunction();
    }

    public AbstractMeetOperator<NullPointerState> getMeetOperator() {
        return this.meet;
    }

    public UnaryOperator<NullPointerState> getNodeTransferFunction(T node) {
        ArrayList<UnaryOperator<NullPointerState>> phiTransferFunctions = new ArrayList<UnaryOperator<NullPointerState>>(1);
        Iterator<SSAPhiInstruction> phiIterator = node.iteratePhis();
        while (phiIterator.hasNext()) {
            SSAPhiInstruction phi = phiIterator.next();
            int[] uses = new int[phi.getNumberOfUses()];
            int i = 0;
            while (i < uses.length) {
                uses[i] = phi.getUse(i);
                ++i;
            }
            phiTransferFunctions.add(NullPointerState.phiValueMeetFunction(phi.getDef(), uses));
        }
        if (phiTransferFunctions.size() > 0) {
            return NullPointerState.phisFunction(phiTransferFunctions);
        }
        return NullPointerState.identityFunction();
    }

    public boolean hasEdgeTransferFunctions() {
        return true;
    }

    public boolean hasNodeTransferFunctions() {
        return true;
    }

    private static class TransferFunctionSSAVisitor
    implements SSAInstruction.IVisitor {
        private final SymbolTable sym;
        private UnaryOperator<NullPointerState> transfer1 = NullPointerState.identityFunction();
        private UnaryOperator<NullPointerState> transfer2 = NullPointerState.identityFunction();
        private boolean noIdentity = false;

        private TransferFunctionSSAVisitor(IR ir) {
            this.sym = ir.getSymbolTable();
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.noIdentity = true;
            this.transfer1 = NullPointerState.denullifyFunction(instruction.getArrayRef());
            this.transfer2 = NullPointerState.nullifyFunction(instruction.getArrayRef());
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            this.noIdentity = true;
            this.transfer1 = NullPointerState.denullifyFunction(instruction.getArrayRef());
            this.transfer2 = NullPointerState.nullifyFunction(instruction.getArrayRef());
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            this.noIdentity = true;
            this.transfer1 = NullPointerState.denullifyFunction(instruction.getArrayRef());
            this.transfer2 = NullPointerState.nullifyFunction(instruction.getArrayRef());
        }

        @Override
        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitComparison(SSAComparisonInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
            block10: {
                block11: {
                    IConditionalBranchInstruction.Operator op;
                    int arg2;
                    int arg1;
                    block9: {
                        arg1 = instruction.getUse(0);
                        arg2 = instruction.getUse(1);
                        IConditionalBranchInstruction.IOperator testOp = instruction.getOperator();
                        if (!(testOp instanceof IConditionalBranchInstruction.Operator)) {
                            throw new IllegalStateException("Conditional operator of unknown type: " + testOp.getClass());
                        }
                        op = (IConditionalBranchInstruction.Operator)testOp;
                        if (!this.sym.isNullConstant(arg1)) break block9;
                        switch (op) {
                            case EQ: {
                                this.noIdentity = true;
                                this.transfer1 = NullPointerState.nullifyFunction(arg2);
                                this.transfer2 = NullPointerState.denullifyFunction(arg2);
                                break block10;
                            }
                            case NE: {
                                this.noIdentity = true;
                                this.transfer1 = NullPointerState.denullifyFunction(arg2);
                                this.transfer2 = NullPointerState.nullifyFunction(arg2);
                                break block10;
                            }
                            default: {
                                throw new IllegalStateException("Comparision to a null constant using " + op);
                            }
                        }
                    }
                    if (!this.sym.isNullConstant(arg2)) break block11;
                    switch (op) {
                        case EQ: {
                            this.noIdentity = true;
                            this.transfer1 = NullPointerState.nullifyFunction(arg1);
                            this.transfer2 = NullPointerState.denullifyFunction(arg1);
                            break block10;
                        }
                        case NE: {
                            this.noIdentity = true;
                            this.transfer1 = NullPointerState.denullifyFunction(arg1);
                            this.transfer2 = NullPointerState.nullifyFunction(arg1);
                            break block10;
                        }
                        default: {
                            throw new IllegalStateException("Comparision to a null constant using " + op);
                        }
                    }
                }
                this.noIdentity = false;
                this.transfer1 = NullPointerState.identityFunction();
                this.transfer2 = NullPointerState.identityFunction();
            }
        }

        @Override
        public void visitConversion(SSAConversionInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            if (!instruction.isStatic()) {
                int ssaVar = instruction.getRef();
                this.noIdentity = true;
                this.transfer1 = NullPointerState.denullifyFunction(ssaVar);
                this.transfer2 = NullPointerState.nullifyFunction(ssaVar);
            } else {
                this.noIdentity = false;
                this.transfer1 = NullPointerState.identityFunction();
                this.transfer2 = NullPointerState.identityFunction();
            }
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitGoto(SSAGotoInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitInstanceof(SSAInstanceofInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            if (!instruction.isStatic()) {
                this.noIdentity = true;
                this.transfer1 = NullPointerState.denullifyFunction(instruction.getReceiver());
                this.transfer2 = NullPointerState.identityFunction();
            } else {
                this.noIdentity = false;
                this.transfer1 = NullPointerState.identityFunction();
                this.transfer2 = NullPointerState.identityFunction();
            }
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitMonitor(SSAMonitorInstruction instruction) {
            this.noIdentity = true;
            this.transfer1 = NullPointerState.denullifyFunction(instruction.getRef());
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            this.noIdentity = true;
            this.transfer1 = NullPointerState.denullifyFunction(instruction.getDef());
            this.transfer2 = NullPointerState.nullifyFunction(instruction.getDef());
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
            this.noIdentity = true;
            int[] uses = new int[instruction.getNumberOfUses()];
            int i = 0;
            while (i < uses.length) {
                uses[i] = instruction.getUse(i);
                ++i;
            }
            this.transfer1 = NullPointerState.phiValueMeetFunction(instruction.getDef(), uses);
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            if (!instruction.isStatic()) {
                int ssaVar = instruction.getRef();
                this.noIdentity = true;
                this.transfer1 = NullPointerState.denullifyFunction(ssaVar);
                this.transfer2 = NullPointerState.nullifyFunction(ssaVar);
            } else {
                this.noIdentity = false;
                this.transfer1 = NullPointerState.identityFunction();
                this.transfer2 = NullPointerState.identityFunction();
            }
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitSwitch(SSASwitchInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }

        @Override
        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            this.noIdentity = false;
            this.transfer1 = NullPointerState.identityFunction();
            this.transfer2 = NullPointerState.identityFunction();
        }
    }
}

