/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.stackMachine;

import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BasicFramework;
import com.ibm.wala.dataflow.graph.DataflowSolver;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.AbstractStatement;
import com.ibm.wala.fixpoint.AbstractVariable;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.shrike.ShrikeUtil;
import java.util.Iterator;

public abstract class AbstractIntStackMachine
implements FixedPointConstants {
    private static final boolean DEBUG = false;
    public static final int TOP = -1;
    public static final int BOTTOM = -2;
    public static final int UNANALYZED = -3;
    public static final int IGNORE = -4;
    private DataflowSolver<ShrikeCFG.BasicBlock, MachineState> solver;
    private final ShrikeCFG cfg;
    public static final boolean OPTIMISTIC = true;

    protected AbstractIntStackMachine(ShrikeCFG G) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.cfg = G;
    }

    protected void init(Meeter meeter, final FlowProvider flow) {
        final MeetOperator meet = new MeetOperator(meeter);
        ITransferFunctionProvider<ShrikeCFG.BasicBlock, MachineState> xferFunctions = new ITransferFunctionProvider<ShrikeCFG.BasicBlock, MachineState>(){

            public boolean hasNodeTransferFunctions() {
                return flow.needsNodeFlow();
            }

            public boolean hasEdgeTransferFunctions() {
                return flow.needsEdgeFlow();
            }

            public UnaryOperator<MachineState> getNodeTransferFunction(final ShrikeCFG.BasicBlock node) {
                return new UnaryOperator<MachineState>(){

                    public byte evaluate(MachineState lhs, MachineState rhs) {
                        MachineState exit = lhs;
                        MachineState entry = rhs;
                        MachineState newExit = flow.flow(entry, node);
                        if (newExit.stateEquals(exit)) {
                            return 0;
                        }
                        exit.copyState(newExit);
                        return 1;
                    }

                    public String toString() {
                        return "NODE-FLOW";
                    }

                    public int hashCode() {
                        return 9973 * node.hashCode();
                    }

                    public boolean equals(Object o) {
                        return this == o;
                    }
                };
            }

            public UnaryOperator<MachineState> getEdgeTransferFunction(final ShrikeCFG.BasicBlock from, final ShrikeCFG.BasicBlock to) {
                return new UnaryOperator<MachineState>(){

                    public byte evaluate(MachineState lhs, MachineState rhs) {
                        MachineState exit = lhs;
                        MachineState entry = rhs;
                        MachineState newExit = flow.flow(entry, from, to);
                        if (newExit.stateEquals(exit)) {
                            return 0;
                        }
                        exit.copyState(newExit);
                        return 1;
                    }

                    public String toString() {
                        return "EDGE-FLOW";
                    }

                    public int hashCode() {
                        return 9973 * (from.hashCode() ^ to.hashCode());
                    }

                    public boolean equals(Object o) {
                        return this == o;
                    }
                };
            }

            public AbstractMeetOperator<MachineState> getMeetOperator() {
                return meet;
            }
        };
        BasicFramework problem = new BasicFramework((Graph)this.cfg, (ITransferFunctionProvider)xferFunctions);
        this.solver = new DataflowSolver<ShrikeCFG.BasicBlock, MachineState>((IKilldallFramework)problem){
            private MachineState entry;

            protected MachineState makeNodeVariable(ShrikeCFG.BasicBlock n, boolean IN) {
                if (!$assertionsDisabled && n == null) {
                    throw new AssertionError();
                }
                MachineState result = new MachineState(n);
                if (IN && n.equals(AbstractIntStackMachine.this.cfg.entry())) {
                    this.entry = result;
                }
                return result;
            }

            protected MachineState makeEdgeVariable(ShrikeCFG.BasicBlock from, ShrikeCFG.BasicBlock to) {
                if (!$assertionsDisabled && from == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && to == null) {
                    throw new AssertionError();
                }
                MachineState result = new MachineState(from);
                return result;
            }

            protected void initializeWorkList() {
                super.buildEquations(false, false);
                Iterator it = this.getFixedPointSystem().getStatementsThatUse((IVariable)this.entry);
                while (it.hasNext()) {
                    AbstractStatement s = (AbstractStatement)it.next();
                    this.addToWorkList(s);
                }
            }

            protected void initializeVariables() {
                super.initializeVariables();
                AbstractIntStackMachine.this.initializeVariables();
            }

            protected MachineState[] makeStmtRHS(int size) {
                return new MachineState[size];
            }
        };
    }

    public boolean solve() {
        try {
            return this.solver.solve(null);
        }
        catch (CancelException e) {
            throw new CancelRuntimeException((Exception)((Object)e));
        }
    }

    protected void initializeVariables() {
    }

    public MachineState getEntryState() {
        return (MachineState)this.solver.getIn(this.cfg.entry());
    }

    public MachineState getIn(ShrikeCFG.BasicBlock bb) {
        return (MachineState)this.solver.getIn((Object)bb);
    }

    private boolean meet(IVariable lhs, IVariable[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = this.meetStacks(lhs, rhs, bb, meeter);
        return changed |= this.meetLocals(lhs, rhs, bb, meeter);
    }

    private boolean meetForCatchBlock(IVariable lhs, IVariable[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = this.meetStacksAtCatchBlock(lhs, bb, meeter);
        return changed |= this.meetLocals(lhs, rhs, bb, meeter);
    }

    private boolean meetStacksAtCatchBlock(IVariable lhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        MachineState L = (MachineState)lhs;
        if (L.stack == null) {
            L.allocateStack(1);
            L.stackHeight = 1;
        }
        int meet = meeter.meetStackAtCatchBlock(bb);
        if (L.stack[0] == -1) {
            if (meet != -1) {
                changed = true;
                ((MachineState)L).stack[0] = meet;
            }
        } else if (meet != L.stack[0]) {
            changed = true;
            ((MachineState)L).stack[0] = meet;
        }
        return changed;
    }

    private boolean meetStacks(IVariable lhs, IVariable[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        MachineState L = (MachineState)lhs;
        int height = AbstractIntStackMachine.computeMeetStackHeight(rhs);
        if (height > -1 && (L.stack == null || L.stack.length < height)) {
            L.allocateStack(height);
            L.stackHeight = height;
            changed = true;
        }
        int i = 0;
        while (i < height) {
            int[] R = new int[rhs.length];
            int j = 0;
            while (j < R.length) {
                MachineState m = (MachineState)rhs[j];
                if (m.stack == null || m.stack.length < i + 1) {
                    R[j] = -1;
                } else {
                    R[j] = m.stack[i];
                    if (R[j] == 0) {
                        R[j] = -1;
                    }
                }
                ++j;
            }
            int meet = meeter.meetStack(i, R, bb);
            if (L.stack[i] == -1) {
                if (meet != -1) {
                    changed = true;
                    ((MachineState)L).stack[i] = meet;
                }
            } else if (meet != L.stack[i]) {
                changed = true;
                ((MachineState)L).stack[i] = meet;
            }
            ++i;
        }
        return changed;
    }

    private boolean meetLocals(IVariable lhs, IVariable[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        MachineState L = (MachineState)lhs;
        int nLocals = AbstractIntStackMachine.computeMeetNLocals(rhs);
        if (nLocals > -1 && (L.locals == null || L.locals.length < nLocals)) {
            L.allocateLocals(nLocals);
        }
        int i = 0;
        while (i < nLocals) {
            int[] R = new int[rhs.length];
            int j = 0;
            while (j < rhs.length) {
                R[j] = ((MachineState)rhs[j]).getLocal(i);
                ++j;
            }
            int meet = meeter.meetLocal(i, R, bb);
            if (L.locals[i] == -1) {
                if (meet != -1) {
                    changed = true;
                    ((MachineState)L).locals[i] = meet;
                }
            } else if (meet != L.locals[i]) {
                changed = true;
                ((MachineState)L).locals[i] = meet;
            }
            ++i;
        }
        return changed;
    }

    private static int computeMeetNLocals(IVariable[] operands) {
        MachineState lhs = (MachineState)operands[0];
        int nLocals = -1;
        if (lhs.locals != null) {
            nLocals = lhs.locals.length;
        } else {
            int i = 1;
            while (i < operands.length) {
                MachineState rhs = (MachineState)operands[i];
                if (rhs.locals != null) {
                    nLocals = rhs.locals.length;
                    break;
                }
                ++i;
            }
        }
        return nLocals;
    }

    private static int computeMeetStackHeight(IVariable[] operands) {
        MachineState lhs = (MachineState)operands[0];
        int height = -1;
        if (lhs.stack != null) {
            height = lhs.stackHeight;
        } else {
            int i = 1;
            while (i < operands.length) {
                MachineState rhs = (MachineState)operands[i];
                if (rhs.stack != null) {
                    height = rhs.stackHeight;
                    break;
                }
                ++i;
            }
        }
        return height;
    }

    protected static abstract class BasicStackFlowProvider
    implements FlowProvider,
    Constants {
        private final ShrikeCFG cfg;
        protected MachineState workingState;
        private BasicStackMachineVisitor visitor;
        private IInstruction.Visitor edgeVisitor;
        private int currentInstructionIndex = 0;
        private ShrikeCFG.BasicBlock currentBlock;
        private ShrikeCFG.BasicBlock currentSuccessorBlock;

        protected BasicStackFlowProvider(ShrikeCFG cfg) {
            this.cfg = cfg;
        }

        protected void init(BasicStackMachineVisitor v, IInstruction.Visitor ev) {
            this.visitor = v;
            this.edgeVisitor = ev;
        }

        @Override
        public boolean needsNodeFlow() {
            return true;
        }

        @Override
        public boolean needsEdgeFlow() {
            return false;
        }

        @Override
        public MachineState flow(MachineState entry, ShrikeCFG.BasicBlock basicBlock) {
            this.workingState = entry.duplicate();
            this.currentBlock = basicBlock;
            this.currentSuccessorBlock = null;
            IInstruction[] instructions = this.getInstructions();
            int i = basicBlock.getFirstInstructionIndex();
            while (i <= basicBlock.getLastInstructionIndex()) {
                this.currentInstructionIndex = i;
                instructions[i].visit((IInstruction.Visitor)this.visitor);
                ++i;
            }
            return this.workingState;
        }

        @Override
        public MachineState flow(MachineState entry, ShrikeCFG.BasicBlock from, ShrikeCFG.BasicBlock to) {
            this.workingState = entry.duplicate();
            this.currentBlock = from;
            this.currentSuccessorBlock = to;
            IInstruction[] instructions = this.getInstructions();
            int i = from.getFirstInstructionIndex();
            while (i <= from.getLastInstructionIndex()) {
                this.currentInstructionIndex = i;
                instructions[i].visit(this.edgeVisitor);
                ++i;
            }
            return this.workingState;
        }

        protected int getCurrentInstructionIndex() {
            return this.currentInstructionIndex;
        }

        protected int getCurrentProgramCounter() {
            return this.cfg.getProgramCounter(this.currentInstructionIndex);
        }

        protected ShrikeCFG.BasicBlock getCurrentBlock() {
            return this.currentBlock;
        }

        protected ShrikeCFG.BasicBlock getCurrentSuccessor() {
            return this.currentSuccessorBlock;
        }

        public abstract IInstruction[] getInstructions();

        protected class BasicStackMachineVisitor
        extends IInstruction.Visitor {
            protected BasicStackMachineVisitor() {
            }

            public void visitArrayLength(ArrayLengthInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitArrayLoad(IArrayLoadInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitArrayStore(IArrayStoreInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitBinaryOp(IBinaryOpInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitComparison(IComparisonInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitConstant(ConstantInstruction instruction) {
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitConversion(IConversionInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitDup(DupInstruction instruction) {
                int v4;
                int size = instruction.getSize();
                int delta = instruction.getDelta();
                assert (size == 1 || size == 2);
                assert (delta == 0 || delta == 1 || delta == 2);
                int toPop = size + delta;
                int v1 = BasicStackFlowProvider.this.workingState.pop();
                int v2 = toPop > 1 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                int v3 = toPop > 2 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                int n = v4 = toPop > 3 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                if (size > 1) {
                    BasicStackFlowProvider.this.workingState.push(v2);
                }
                BasicStackFlowProvider.this.workingState.push(v1);
                if (v4 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v4);
                }
                if (v3 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v3);
                }
                if (v2 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v2);
                }
                BasicStackFlowProvider.this.workingState.push(v1);
            }

            public void visitGet(IGetInstruction instruction) {
                this.popN((IInstruction)instruction);
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            protected void popN(IInstruction instruction) {
                int i = 0;
                while (i < instruction.getPoppedCount()) {
                    BasicStackFlowProvider.this.workingState.pop();
                    ++i;
                }
            }

            public void visitInstanceof(IInstanceofInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitInvoke(IInvokeInstruction instruction) {
                this.popN((IInstruction)instruction);
                ClassLoaderReference loader = BasicStackFlowProvider.this.cfg.getMethod().getDeclaringClass().getClassLoader().getReference();
                TypeReference returnType = ShrikeUtil.makeTypeReference(loader, Util.getReturnType((String)instruction.getMethodSignature()));
                if (!returnType.equals(TypeReference.Void)) {
                    BasicStackFlowProvider.this.workingState.push(-3);
                }
            }

            public void visitMonitor(MonitorInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitLocalLoad(ILoadInstruction instruction) {
                int t = BasicStackFlowProvider.this.workingState.getLocal(instruction.getVarIndex());
                BasicStackFlowProvider.this.workingState.push(t);
            }

            public void visitLocalStore(IStoreInstruction instruction) {
                int index = instruction.getVarIndex();
                BasicStackFlowProvider.this.workingState.setLocal(index, BasicStackFlowProvider.this.workingState.pop());
            }

            public void visitNew(NewInstruction instruction) {
                this.popN((IInstruction)instruction);
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitPop(PopInstruction instruction) {
                if (instruction.getPoppedCount() > 0) {
                    BasicStackFlowProvider.this.workingState.pop();
                }
            }

            public void visitPut(IPutInstruction instruction) {
                this.popN((IInstruction)instruction);
            }

            public void visitShift(IShiftInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitSwap(SwapInstruction instruction) {
                BasicStackFlowProvider.this.workingState.swap();
            }

            public void visitSwitch(SwitchInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitThrow(ThrowInstruction instruction) {
                int exceptionType = BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.clearStack();
                BasicStackFlowProvider.this.workingState.push(exceptionType);
            }

            public void visitUnaryOp(IUnaryOpInstruction instruction) {
            }
        }
    }

    public static interface FlowProvider {
        public boolean needsNodeFlow();

        public boolean needsEdgeFlow();

        public MachineState flow(MachineState var1, ShrikeCFG.BasicBlock var2);

        public MachineState flow(MachineState var1, ShrikeCFG.BasicBlock var2, ShrikeCFG.BasicBlock var3);
    }

    public class MachineState
    extends AbstractVariable<MachineState> {
        private int[] stack;
        private int[] locals;
        private int stackHeight;
        private final ShrikeCFG.BasicBlock bb;

        public MachineState duplicate() {
            MachineState result = new MachineState(this.bb);
            result.copyState(this);
            return result;
        }

        public MachineState(ShrikeCFG.BasicBlock bb) {
            this.setTOP();
            this.bb = bb;
        }

        public ShrikeCFG.BasicBlock getBasicBlock() {
            return this.bb;
        }

        void setTOP() {
            this.stackHeight = -1;
            this.stack = null;
        }

        boolean isTOP() {
            return this.stackHeight == -1;
        }

        public void push(int i) {
            if (this.stack == null || this.stackHeight >= this.stack.length) {
                this.allocateStack(this.stackHeight + 1);
            }
            this.stack[this.stackHeight++] = i;
        }

        public int pop() {
            if (this.stackHeight <= 0) assert (this.stackHeight > 0) : "can't pop stack of height " + this.stackHeight;
            --this.stackHeight;
            return this.stack[this.stackHeight];
        }

        public int peek() {
            return this.stack[this.stackHeight - 1];
        }

        public void swap() {
            int temp = this.stack[this.stackHeight - 1];
            this.stack[this.stackHeight - 1] = this.stack[this.stackHeight - 2];
            this.stack[this.stackHeight - 2] = temp;
        }

        private void allocateStack(int stackHeight) {
            if (this.stack == null) {
                this.stack = new int[stackHeight + 1];
                this.stackHeight = 0;
            } else {
                int[] newStack = new int[Math.max(this.stack.length, stackHeight) * 2 + 1];
                System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
                this.stack = newStack;
            }
        }

        private void allocateLocals(int maxLocals) {
            int[] result = new int[maxLocals];
            int start = 0;
            if (this.locals != null) {
                System.arraycopy(this.locals, 0, result, 0, this.locals.length);
                start = this.locals.length;
            }
            int i = start;
            while (i < maxLocals) {
                result[i] = -1;
                ++i;
            }
            this.locals = result;
        }

        public void clearStack() {
            this.stackHeight = 0;
        }

        public void setLocal(int i, int j) {
            if (this.locals == null || this.locals.length < i + 1) {
                if (j == -1) {
                    return;
                }
                this.allocateLocals(i + 1);
            }
            this.locals[i] = j;
        }

        public int getLocal(int i) {
            if (this.locals == null || this.locals.length < i + 1) {
                return -1;
            }
            return this.locals[i];
        }

        public void replaceValue(int from, int to) {
            int i;
            if (this.stack != null) {
                i = 0;
                while (i < this.stackHeight) {
                    if (this.stack[i] == from) {
                        this.stack[i] = to;
                    }
                    ++i;
                }
            }
            if (this.locals != null) {
                i = 0;
                while (i < this.locals.length) {
                    if (this.locals[i] == from) {
                        this.locals[i] = to;
                    }
                    ++i;
                }
            }
        }

        public boolean hasValue(int val) {
            int i;
            if (this.stack != null) {
                i = 0;
                while (i < this.stackHeight) {
                    if (this.stack[i] == val) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.locals != null) {
                i = 0;
                while (i < this.locals.length) {
                    if (this.locals[i] == val) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public String toString() {
            if (this.isTOP()) {
                return "<TOP>@" + System.identityHashCode((Object)this);
            }
            StringBuffer result = new StringBuffer("<");
            result.append("S");
            if (this.stackHeight == 0) {
                result.append("[empty]");
            } else {
                result.append(this.array2StringBuffer(this.stack, this.stackHeight));
            }
            result.append("L");
            result.append(this.array2StringBuffer(this.locals, this.locals == null ? 0 : this.locals.length));
            result.append(">");
            return result.toString();
        }

        private StringBuffer array2StringBuffer(int[] array, int n) {
            StringBuffer result = new StringBuffer("[");
            if (array == null) {
                result.append("TOP");
            } else {
                int i = 0;
                while (i < n - 1) {
                    result.append(array[i]).append(",");
                    ++i;
                }
                result.append(array[n - 1]);
            }
            result.append("]");
            return result;
        }

        public void copyState(MachineState other) {
            if (other.stack == null) {
                this.stack = null;
            } else {
                this.stack = new int[other.stack.length];
                System.arraycopy(other.stack, 0, this.stack, 0, other.stack.length);
            }
            if (other.locals == null) {
                this.locals = null;
            } else {
                this.locals = new int[other.locals.length];
                System.arraycopy(other.locals, 0, this.locals, 0, other.locals.length);
            }
            this.stackHeight = other.stackHeight;
        }

        boolean stateEquals(MachineState exit) {
            if (this.stackHeight != exit.stackHeight) {
                return false;
            }
            if (this.locals == null) {
                if (exit.locals != null) {
                    return false;
                }
            } else {
                if (exit.locals == null) {
                    return false;
                }
                if (this.locals.length != exit.locals.length) {
                    return false;
                }
            }
            int i = 0;
            while (i < this.stackHeight) {
                if (this.stack[i] != exit.stack[i]) {
                    return false;
                }
                ++i;
            }
            if (this.locals != null) {
                i = 0;
                while (i < this.locals.length) {
                    if (this.locals[i] == -1 && exit.locals[i] != -1) {
                        return false;
                    }
                    if (this.locals[i] != exit.locals[i]) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        public int getStackHeight() {
            return this.stackHeight;
        }

        public int[] getLocals() {
            return this.locals;
        }
    }

    private class MeetOperator
    extends AbstractMeetOperator<MachineState> {
        private final Meeter meeter;

        MeetOperator(Meeter meeter) {
            this.meeter = meeter;
        }

        public boolean isUnaryNoOp() {
            return false;
        }

        public byte evaluate(MachineState lhs, MachineState[] rhs) {
            ShrikeCFG.BasicBlock bb = lhs.getBasicBlock();
            if (!bb.isCatchBlock()) {
                return AbstractIntStackMachine.this.meet((IVariable)lhs, (IVariable[])rhs, bb, this.meeter) ? (byte)1 : 0;
            }
            return AbstractIntStackMachine.this.meetForCatchBlock((IVariable)lhs, (IVariable[])rhs, bb, this.meeter) ? (byte)1 : 0;
        }

        public int hashCode() {
            return 72223 * this.meeter.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof MeetOperator) {
                MeetOperator other = (MeetOperator)((Object)o);
                return this.meeter.equals(other.meeter);
            }
            return false;
        }

        public String toString() {
            return "MEETER";
        }
    }

    protected static interface Meeter {
        public int meetStack(int var1, int[] var2, ShrikeCFG.BasicBlock var3);

        public int meetStackAtCatchBlock(ShrikeCFG.BasicBlock var1);

        public int meetLocal(int var1, int[] var2, ShrikeCFG.BasicBlock var3);
    }
}

