/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.arraybounds.hypergraph.algorithms;

import com.ibm.wala.analysis.arraybounds.hypergraph.DirectedHyperEdge;
import com.ibm.wala.analysis.arraybounds.hypergraph.DirectedHyperGraph;
import com.ibm.wala.analysis.arraybounds.hypergraph.HyperNode;
import com.ibm.wala.analysis.arraybounds.hypergraph.weight.Weight;
import com.ibm.wala.analysis.arraybounds.hypergraph.weight.edgeweights.EdgeWeight;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class ShortestPath<T> {
    private Set<DirectedHyperEdge<T>> updatedEdges;
    private final Comparator<Weight> comparator;
    private final DirectedHyperGraph<T> graph;
    private boolean setUnlimitedOnChange = false;
    private boolean hasNegativeCycle = false;

    public static <NodeValueType> void compute(DirectedHyperGraph<NodeValueType> graph, HyperNode<NodeValueType> source, Comparator<Weight> comparator) {
        graph.reset();
        source.setWeight(Weight.ZERO);
        new ShortestPath<NodeValueType>(graph, comparator);
    }

    private ShortestPath(DirectedHyperGraph<T> graph, Comparator<Weight> comparator) {
        this.comparator = comparator;
        this.graph = graph;
        this.computeShortestPaths();
        boolean bl = this.hasNegativeCycle = this.updatedEdges.size() > 0;
        if (this.hasNegativeCycle) {
            this.setUnlimitedOnChange = true;
            this.computeShortestPaths();
        }
    }

    private void computeShortestPaths() {
        this.updatedEdges = this.graph.getEdges();
        int nodeCount = this.graph.getNodes().size();
        int i = 0;
        while (i < nodeCount - 1) {
            this.updateAllEdges();
            if (this.updatedEdges.size() == 0) break;
            ++i;
        }
    }

    private boolean greaterThen(Weight weight, Weight otherWeight) {
        return otherWeight.getType() == Weight.Type.NOT_SET || this.comparator.compare(weight, otherWeight) > 0;
    }

    private boolean lessThen(Weight weight, Weight otherWeight) {
        return otherWeight.getType() == Weight.Type.NOT_SET || this.comparator.compare(weight, otherWeight) < 0;
    }

    private Weight maxOfSources(DirectedHyperEdge<T> edge) {
        EdgeWeight edgeValue = edge.getWeight();
        Weight newWeight = Weight.NOT_SET;
        for (HyperNode<T> node : edge.getSource()) {
            Weight nodeWeight = node.getWeight();
            if (nodeWeight.getType() != Weight.Type.NOT_SET) {
                Weight temp = edgeValue.newValue(nodeWeight);
                if (!this.greaterThen(temp, newWeight)) continue;
                newWeight = temp;
                continue;
            }
            newWeight = Weight.NOT_SET;
            break;
        }
        return newWeight;
    }

    private HashSet<DirectedHyperEdge<T>> selectEdgesToIterate() {
        HashSet<DirectedHyperEdge<T>> edgesToIterate = new HashSet<DirectedHyperEdge<T>>();
        for (DirectedHyperEdge<T> edge : this.updatedEdges) {
            for (HyperNode<T> node : edge.getDestination()) {
                edgesToIterate.addAll(node.getInEdges());
            }
        }
        return edgesToIterate;
    }

    private void updateAllEdges() {
        for (DirectedHyperEdge<T> edge : this.selectEdgesToIterate()) {
            Weight maxOfSources = this.maxOfSources(edge);
            if (maxOfSources.getType() == Weight.Type.NOT_SET) continue;
            this.updateDestinationsWithMin(edge, maxOfSources);
        }
        this.writeChanges();
    }

    private void updateDestinationsWithMin(DirectedHyperEdge<T> edge, Weight newWeight) {
        if (!newWeight.equals(Weight.NOT_SET)) {
            for (HyperNode<T> node : edge.getDestination()) {
                if (!this.lessThen(newWeight, node.getNewWeight())) continue;
                node.setNewWeight(newWeight);
            }
        }
    }

    private void writeChanges() {
        HashSet<DirectedHyperEdge<T>> newUpdatedEdges = new HashSet<DirectedHyperEdge<T>>();
        for (HyperNode<T> node : this.graph.getNodes().values()) {
            Weight oldWeight = node.getWeight();
            Weight newWeight = node.getNewWeight();
            if (!newWeight.equals(Weight.NOT_SET) && !oldWeight.equals(newWeight)) {
                newUpdatedEdges.addAll(node.getOutEdges());
                if (this.setUnlimitedOnChange) {
                    node.setWeight(Weight.UNLIMITED);
                } else {
                    node.setWeight(node.getNewWeight());
                }
            }
            node.setNewWeight(Weight.NOT_SET);
        }
        this.updatedEdges = newUpdatedEdges;
    }
}

