/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.util;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;

public final class JdtPosition
implements CAstSourcePositionMap.Position {
    private final int firstOffset;
    private final int lastOffset;
    private final int firstLine;
    private final int lastLine;
    private final String path;
    private final IFile eclipseFile;

    public JdtPosition(int start, int end, int startLine, int endLine, IFile eclipseFile, String path) {
        this.firstOffset = start;
        this.lastOffset = end;
        this.firstLine = startLine;
        this.lastLine = endLine;
        this.path = path;
        this.eclipseFile = eclipseFile;
    }

    public int getFirstCol() {
        return -1;
    }

    public int getFirstLine() {
        return this.firstLine;
    }

    public Reader getReader() throws IOException {
        return null;
    }

    public int getLastCol() {
        return -1;
    }

    public int getLastLine() {
        return this.lastLine;
    }

    public URL getURL() {
        try {
            return new URL("file:" + this.path);
        }
        catch (MalformedURLException e) {
            Assertions.UNREACHABLE((String)e.toString());
            return null;
        }
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof JdtPosition) {
            if (this.firstOffset != ((JdtPosition)arg0).firstOffset) {
                return this.firstOffset - ((JdtPosition)arg0).firstOffset;
            }
            if (this.lastOffset != ((JdtPosition)arg0).lastOffset) {
                return this.lastOffset - ((JdtPosition)arg0).lastOffset;
            }
        }
        return 0;
    }

    public int getFirstOffset() {
        return this.firstOffset;
    }

    public int getLastOffset() {
        return this.lastOffset;
    }

    public String toString() {
        return "[offset " + this.firstOffset + ":" + this.lastOffset + "]";
    }

    public IFile getEclipseFile() {
        return this.eclipseFile;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JdtPosition) {
            JdtPosition jp = (JdtPosition)obj;
            return jp.getEclipseFile().equals((Object)this.eclipseFile) && jp.getFirstOffset() == this.firstOffset && jp.getLastOffset() == this.lastOffset;
        }
        return false;
    }

    public int hashCode() {
        return this.firstOffset + 12432 * this.lastOffset;
    }

    public String getFileName() {
        return this.eclipseFile.getName();
    }
}

